/*
 * Decompiled with CFR 0.152.
 */
package com.ruslan.growsseth.commands;

import com.filloax.fxlib.api.UtilsKt;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.ruslan.growsseth.entity.GrowssethEntities;
import com.ruslan.growsseth.quests.QuestComponent;
import com.ruslan.growsseth.quests.QuestOwner;
import com.ruslan.growsseth.quests.QuestStage;
import com.ruslan.growsseth.quests.QuestUpdateEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001)B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ]\u0010\u000f\u001a\u00020\u0007\"\u0014\b\u0000\u0010\u0010*\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u0002H\u00100\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u0002H\u00100\u00112)\u0010\u0013\u001a%\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\n0\u0015\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u0014H\u0002J(\u0010\u001a\u001a\u00020\u001b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u00152\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u0005H\u0002J(\u0010\u001f\u001a\u00020\u001b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u00152\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010 \u001a\u00020!H\u0002J \u0010\"\u001a\u00020\u001b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u00152\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002J \u0010#\u001a\u00020\u001b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u00152\b\u0010\u001c\u001a\u0004\u0018\u00010\u0019H\u0002J*\u0010$\u001a\u00020\u001b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u00152\b\u0010\u001c\u001a\u0004\u0018\u00010\u00192\b\b\u0002\u0010%\u001a\u00020&H\u0002J&\u0010'\u001a\b\u0012\u0002\b\u0003\u0018\u00010(2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u00152\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/ruslan/growsseth/commands/QuestCommand;", "", "<init>", "()V", "LANG_PREFIX", "", "register", "", "dispatcher", "Lcom/mojang/brigadier/CommandDispatcher;", "Lnet/minecraft/commands/CommandSourceStack;", "registryAccess", "Lnet/minecraft/commands/CommandBuildContext;", "environment", "Lnet/minecraft/commands/Commands$CommandSelection;", "registerEntityArgs", "T", "Lcom/mojang/brigadier/builder/ArgumentBuilder;", "builder", "getEnt", "Lkotlin/Function1;", "Lcom/mojang/brigadier/context/CommandContext;", "Lkotlin/ParameterName;", "name", "ctx", "Lnet/minecraft/world/entity/LivingEntity;", "setStage", "", "targetEntity", "Lnet/minecraft/world/entity/Entity;", "stage", "backStage", "activate", "", "listQuestStages", "showQuestInfo", "showStageTriggers", "questUpdateEvent", "Lcom/ruslan/growsseth/quests/QuestUpdateEvent;", "getQuest", "Lcom/ruslan/growsseth/quests/QuestComponent;", "QuestUpdateEventArgument", "ruins-of-growsseth"})
@SourceDebugExtension(value={"SMAP\nQuestCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QuestCommand.kt\ncom/ruslan/growsseth/commands/QuestCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,187:1\n1557#2:188\n1628#2,3:189\n2669#2,7:192\n*S KotlinDebug\n*F\n+ 1 QuestCommand.kt\ncom/ruslan/growsseth/commands/QuestCommand\n*L\n134#1:188\n134#1:189,3\n141#1:192,7\n*E\n"})
public final class QuestCommand {
    @NotNull
    public static final QuestCommand INSTANCE = new QuestCommand();
    @NotNull
    private static final String LANG_PREFIX = "growsseth.commands.gquest";

    private QuestCommand() {
    }

    public final void register(@NotNull CommandDispatcher<CommandSourceStack> dispatcher, @NotNull CommandBuildContext registryAccess, @NotNull Commands.CommandSelection environment) {
        RequiredArgumentBuilder arg;
        RequiredArgumentBuilder requiredArgumentBuilder;
        Intrinsics.checkNotNullParameter(dispatcher, (String)"dispatcher");
        Intrinsics.checkNotNullParameter((Object)registryAccess, (String)"registryAccess");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        RequiredArgumentBuilder requiredArgumentBuilder2 = requiredArgumentBuilder = Commands.argument((String)"entity", (ArgumentType)((ArgumentType)EntityArgument.entity()));
        LiteralArgumentBuilder literalArgumentBuilder = Commands.literal((String)"ent");
        LiteralArgumentBuilder literalArgumentBuilder2 = (LiteralArgumentBuilder)Commands.literal((String)"gquest").requires(QuestCommand::register$lambda$0);
        CommandDispatcher<CommandSourceStack> commandDispatcher = dispatcher;
        boolean bl = false;
        Intrinsics.checkNotNull((Object)arg);
        INSTANCE.registerEntityArgs((ArgumentBuilder)arg, (Function1<? super CommandContext<CommandSourceStack>, ? extends LivingEntity>)((Function1)QuestCommand::register$lambda$2$lambda$1));
        Unit unit = Unit.INSTANCE;
        LiteralArgumentBuilder literalArgumentBuilder3 = (LiteralArgumentBuilder)literalArgumentBuilder2.then(literalArgumentBuilder.then((ArgumentBuilder)requiredArgumentBuilder));
        arg = requiredArgumentBuilder = Commands.literal((String)"researcher");
        literalArgumentBuilder2 = literalArgumentBuilder3;
        boolean bl2 = false;
        Intrinsics.checkNotNull((Object)arg);
        INSTANCE.registerEntityArgs((ArgumentBuilder)arg, (Function1<? super CommandContext<CommandSourceStack>, ? extends LivingEntity>)((Function1)QuestCommand::register$lambda$5$lambda$4));
        literalArgumentBuilder = Unit.INSTANCE;
        commandDispatcher.register((LiteralArgumentBuilder)literalArgumentBuilder2.then((ArgumentBuilder)requiredArgumentBuilder));
    }

    private final <T extends ArgumentBuilder<CommandSourceStack, T>> void registerEntityArgs(ArgumentBuilder<CommandSourceStack, T> builder, Function1<? super CommandContext<CommandSourceStack>, ? extends LivingEntity> getEnt) {
        builder.then(Commands.literal((String)"stage").then(Commands.argument((String)"stageId", (ArgumentType)((ArgumentType)StringArgumentType.word())).executes(arg_0 -> QuestCommand.registerEntityArgs$lambda$6(getEnt, arg_0)))).then(((LiteralArgumentBuilder)Commands.literal((String)"back").executes(arg_0 -> QuestCommand.registerEntityArgs$lambda$7(getEnt, arg_0))).then(Commands.literal((String)"activate").then(Commands.argument((String)"doActivate", (ArgumentType)((ArgumentType)BoolArgumentType.bool())).executes(arg_0 -> QuestCommand.registerEntityArgs$lambda$8(getEnt, arg_0))))).then(Commands.literal((String)"list_stages").executes(arg_0 -> QuestCommand.registerEntityArgs$lambda$9(getEnt, arg_0))).then(((LiteralArgumentBuilder)Commands.literal((String)"info").then(((LiteralArgumentBuilder)Commands.literal((String)"triggers").then(Commands.argument((String)"event", (ArgumentType)QuestUpdateEventArgument.Companion.get()).executes(arg_0 -> QuestCommand.registerEntityArgs$lambda$10(getEnt, arg_0)))).executes(arg_0 -> QuestCommand.registerEntityArgs$lambda$11(getEnt, arg_0)))).executes(arg_0 -> QuestCommand.registerEntityArgs$lambda$12(getEnt, arg_0)));
    }

    private final int setStage(CommandContext<CommandSourceStack> ctx, Entity targetEntity, String stage) {
        int n;
        QuestComponent<?> questComponent = this.getQuest(ctx, targetEntity);
        if (questComponent == null) {
            return 0;
        }
        QuestComponent<?> quest = questComponent;
        try {
            QuestComponent.activateStageId$default(quest, stage, null, null, 6, null);
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> QuestCommand.setStage$lambda$13(stage, targetEntity, quest), true);
            n = 1;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Object[] objectArray = new Object[3];
            objectArray[0] = stage;
            Entity entity = targetEntity;
            objectArray[1] = entity != null ? entity.getName() : null;
            objectArray[2] = CollectionsKt.joinToString$default((Iterable)quest.getAvailableStages(), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.translatable((String)"growsseth.commands.gquest.stage.notFound", (Object[])objectArray));
            n = 0;
        }
        catch (Exception e) {
            CommandSourceStack commandSourceStack = (CommandSourceStack)ctx.getSource();
            String string = e.getMessage();
            if (string == null) {
                string = "growsseth.commands.gquest.stage.failure";
            }
            Object[] objectArray = new Object[]{stage, String.valueOf(targetEntity)};
            commandSourceStack.sendFailure((Component)Component.translatable((String)string, (Object[])objectArray));
            n = 0;
        }
        return n;
    }

    private final int backStage(CommandContext<CommandSourceStack> ctx, Entity targetEntity, boolean activate) {
        int n;
        QuestComponent<?> questComponent = this.getQuest(ctx, targetEntity);
        if (questComponent == null) {
            return 0;
        }
        QuestComponent<?> quest = questComponent;
        if (quest.getData().getStageHistory().size() <= 1) {
            Object[] objectArray = new Object[1];
            Entity entity = targetEntity;
            objectArray[0] = entity != null ? entity.getName() : null;
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.translatable((String)"growsseth.commands.gquest.back.notAllowed", (Object[])objectArray));
            n = 0;
        } else if (quest.backOneStage(activate)) {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> QuestCommand.backStage$lambda$14(quest, targetEntity), true);
            n = 1;
        } else {
            Object[] objectArray = new Object[]{String.valueOf(targetEntity)};
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.translatable((String)"growsseth.commands.gquest.back.failure", (Object[])objectArray));
            n = 0;
        }
        return n;
    }

    private final int listQuestStages(CommandContext<CommandSourceStack> ctx, Entity targetEntity) {
        QuestComponent<?> questComponent = this.getQuest(ctx, targetEntity);
        if (questComponent == null) {
            return 0;
        }
        QuestComponent<?> quest = questComponent;
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> QuestCommand.listQuestStages$lambda$15(targetEntity, quest), true);
        return 1;
    }

    private final int showQuestInfo(CommandContext<CommandSourceStack> ctx, LivingEntity targetEntity) {
        QuestComponent<?> questComponent = this.getQuest(ctx, (Entity)targetEntity);
        if (questComponent == null) {
            return 0;
        }
        QuestComponent<?> quest = questComponent;
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> QuestCommand.showQuestInfo$lambda$16(targetEntity, quest), true);
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    private final int showStageTriggers(CommandContext<CommandSourceStack> ctx, LivingEntity targetEntity, QuestUpdateEvent questUpdateEvent) {
        void $this$reduce$iv;
        void $this$mapTo$iv$iv;
        QuestComponent<?> questComponent = this.getQuest(ctx, (Entity)targetEntity);
        if (questComponent == null) {
            return 0;
        }
        QuestComponent<?> quest = questComponent;
        if (targetEntity == null) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.translatable((String)"growsseth.commands.gquest.triggers.noent"));
            return 0;
        }
        List<QuestComponent.QuestNode<?>> nextStages = quest.getCurrentNode().getLeadsTo();
        Iterable $this$map$iv = nextStages;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            QuestStage<LivingEntity> stage;
            void node;
            QuestComponent.QuestNode questNode = (QuestComponent.QuestNode)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(node.getStage(), (String)"null cannot be cast to non-null type com.ruslan.growsseth.quests.QuestStage<net.minecraft.world.entity.LivingEntity>");
            CharSequence charSequence = StringsKt.replace$default((String)stage.getTriggerStatusTree(targetEntity, questUpdateEvent).toString(), (String)"\n", (String)"\n  ", (boolean)false, (int)4, null);
            Regex regex = new Regex("^.");
            String string = "  $0";
            String stageTriggerTreeStr = regex.replace(charSequence, string);
            collection.add(Component.literal((String)(node.getId() + ":\n")).append(stageTriggerTreeStr));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void c2;
            MutableComponent $i$f$mapTo2 = (MutableComponent)iterator$iv.next();
            MutableComponent c = (MutableComponent)accumulator$iv;
            boolean bl = false;
            MutableComponent mutableComponent = c;
            accumulator$iv = mutableComponent == null ? c2 : mutableComponent.append("\n").append((Component)c2);
        }
        MutableComponent nextStagesInfo = (MutableComponent)accumulator$iv;
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> QuestCommand.showStageTriggers$lambda$19(targetEntity, quest, questUpdateEvent, nextStagesInfo), true);
        return 1;
    }

    static /* synthetic */ int showStageTriggers$default(QuestCommand questCommand, CommandContext commandContext, LivingEntity livingEntity, QuestUpdateEvent questUpdateEvent, int n, Object object) {
        if ((n & 4) != 0) {
            questUpdateEvent = QuestUpdateEvent.TICK;
        }
        return questCommand.showStageTriggers((CommandContext<CommandSourceStack>)commandContext, livingEntity, questUpdateEvent);
    }

    private final QuestComponent<?> getQuest(CommandContext<CommandSourceStack> ctx, Entity targetEntity) {
        if (targetEntity == null) {
            return null;
        }
        if (!(targetEntity instanceof QuestOwner) || ((QuestOwner)targetEntity).getQuest() == null) {
            Object[] objectArray = new Object[]{targetEntity.toString()};
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.translatable((String)"growsseth.commands.gquest.noQuest", (Object[])objectArray));
            return null;
        }
        return ((QuestOwner)targetEntity).getQuest();
    }

    private static final boolean register$lambda$0(CommandSourceStack it) {
        return it.hasPermission(2);
    }

    private static final LivingEntity register$lambda$2$lambda$1(CommandContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Entity entity = EntityArgument.getEntity((CommandContext)ctx, (String)"entity");
        Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type net.minecraft.world.entity.LivingEntity");
        return (LivingEntity)entity;
    }

    private static final boolean register$lambda$5$lambda$4$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final LivingEntity register$lambda$5$lambda$4(CommandContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        ServerLevel level = ((CommandSourceStack)ctx.getSource()).getLevel();
        Vec3 pos = ((CommandSourceStack)ctx.getSource()).getPosition();
        return level.getNearestEntity(level.getEntities((EntityTypeTest)GrowssethEntities.INSTANCE.getRESEARCHER(), arg_0 -> QuestCommand.register$lambda$5$lambda$4$lambda$3(UtilsKt.alwaysTruePredicate(), arg_0)), TargetingConditions.forNonCombat().ignoreLineOfSight().ignoreInvisibilityTesting(), null, pos.x, pos.y, pos.z);
    }

    private static final int registerEntityArgs$lambda$6(Function1 $getEnt, CommandContext ctx) {
        Intrinsics.checkNotNull((Object)ctx);
        Entity entity = (Entity)$getEnt.invoke((Object)ctx);
        String string = StringArgumentType.getString((CommandContext)ctx, (String)"stageId");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        return INSTANCE.setStage((CommandContext<CommandSourceStack>)ctx, entity, string);
    }

    private static final int registerEntityArgs$lambda$7(Function1 $getEnt, CommandContext ctx) {
        Intrinsics.checkNotNull((Object)ctx);
        return INSTANCE.backStage((CommandContext<CommandSourceStack>)ctx, (Entity)$getEnt.invoke((Object)ctx), false);
    }

    private static final int registerEntityArgs$lambda$8(Function1 $getEnt, CommandContext ctx) {
        Intrinsics.checkNotNull((Object)ctx);
        return INSTANCE.backStage((CommandContext<CommandSourceStack>)ctx, (Entity)$getEnt.invoke((Object)ctx), BoolArgumentType.getBool((CommandContext)ctx, (String)"doActivate"));
    }

    private static final int registerEntityArgs$lambda$9(Function1 $getEnt, CommandContext ctx) {
        Intrinsics.checkNotNull((Object)ctx);
        return INSTANCE.listQuestStages((CommandContext<CommandSourceStack>)ctx, (Entity)$getEnt.invoke((Object)ctx));
    }

    private static final int registerEntityArgs$lambda$10(Function1 $getEnt, CommandContext ctx) {
        Intrinsics.checkNotNull((Object)ctx);
        return INSTANCE.showStageTriggers((CommandContext<CommandSourceStack>)ctx, (LivingEntity)$getEnt.invoke((Object)ctx), QuestUpdateEventArgument.Companion.getEvent((CommandContext<CommandSourceStack>)ctx, "event"));
    }

    private static final int registerEntityArgs$lambda$11(Function1 $getEnt, CommandContext ctx) {
        Intrinsics.checkNotNull((Object)ctx);
        return QuestCommand.showStageTriggers$default(INSTANCE, ctx, (LivingEntity)$getEnt.invoke((Object)ctx), null, 4, null);
    }

    private static final int registerEntityArgs$lambda$12(Function1 $getEnt, CommandContext ctx) {
        Intrinsics.checkNotNull((Object)ctx);
        return INSTANCE.showQuestInfo((CommandContext<CommandSourceStack>)ctx, (LivingEntity)$getEnt.invoke((Object)ctx));
    }

    private static final Component setStage$lambda$13(String $stage, Entity $targetEntity, QuestComponent $quest) {
        Object[] objectArray = new Object[3];
        objectArray[0] = $stage;
        Entity entity = $targetEntity;
        objectArray[1] = entity != null ? entity.getName() : null;
        objectArray[2] = $quest.toString();
        return (Component)Component.translatable((String)"growsseth.commands.gquest.stage.success", (Object[])objectArray);
    }

    private static final Component backStage$lambda$14(QuestComponent $quest, Entity $targetEntity) {
        Object[] objectArray = new Object[3];
        objectArray[0] = $quest.getData().getCurrentStageId();
        Entity entity = $targetEntity;
        objectArray[1] = entity != null ? entity.getName() : null;
        objectArray[2] = $quest.toString();
        return (Component)Component.translatable((String)"growsseth.commands.gquest.back.success", (Object[])objectArray);
    }

    private static final Component listQuestStages$lambda$15(Entity $targetEntity, QuestComponent $quest) {
        Object[] objectArray = new Object[2];
        Entity entity = $targetEntity;
        objectArray[0] = entity != null ? entity.getName() : null;
        objectArray[1] = CollectionsKt.joinToString$default((Iterable)$quest.getAvailableStages(), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
        return (Component)Component.translatable((String)"growsseth.commands.gquest.list_stages", (Object[])objectArray);
    }

    private static final Component showQuestInfo$lambda$16(LivingEntity $targetEntity, QuestComponent $quest) {
        Object[] objectArray = new Object[]{String.valueOf($targetEntity), $quest.getData().getCurrentStageId(), $quest.toString()};
        return (Component)Component.translatable((String)"growsseth.commands.gquest.info", (Object[])objectArray);
    }

    private static final Component showStageTriggers$lambda$19(LivingEntity $targetEntity, QuestComponent $quest, QuestUpdateEvent $questUpdateEvent, MutableComponent $nextStagesInfo) {
        Object[] objectArray = new Object[]{$targetEntity.toString(), $quest.getData().getCurrentStageId(), $quest.toString()};
        MutableComponent mutableComponent = Component.translatable((String)"growsseth.commands.gquest.info", (Object[])objectArray).append("\n");
        objectArray = new Object[]{$questUpdateEvent.toString()};
        return (Component)mutableComponent.append((Component)Component.translatable((String)"growsseth.commands.gquest.info.triggers", (Object[])objectArray)).append("\n").append((Component)$nextStagesInfo);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0010B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J*\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\"\u0004\b\u0000\u0010\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u000b0\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/ruslan/growsseth/commands/QuestCommand$QuestUpdateEventArgument;", "Lcom/mojang/brigadier/arguments/ArgumentType;", "Lcom/ruslan/growsseth/quests/QuestUpdateEvent;", "<init>", "()V", "parse", "reader", "Lcom/mojang/brigadier/StringReader;", "listSuggestions", "Ljava/util/concurrent/CompletableFuture;", "Lcom/mojang/brigadier/suggestion/Suggestions;", "S", "context", "Lcom/mojang/brigadier/context/CommandContext;", "builder", "Lcom/mojang/brigadier/suggestion/SuggestionsBuilder;", "Companion", "ruins-of-growsseth"})
    @SourceDebugExtension(value={"SMAP\nQuestCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QuestCommand.kt\ncom/ruslan/growsseth/commands/QuestCommand$QuestUpdateEventArgument\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,187:1\n1557#2:188\n1628#2,3:189\n*S KotlinDebug\n*F\n+ 1 QuestCommand.kt\ncom/ruslan/growsseth/commands/QuestCommand$QuestUpdateEventArgument\n*L\n183#1:188\n183#1:189,3\n*E\n"})
    public static final class QuestUpdateEventArgument
    implements ArgumentType<QuestUpdateEvent> {
        @NotNull
        public static final Companion Companion = new Companion(null);

        private QuestUpdateEventArgument() {
        }

        @NotNull
        public QuestUpdateEvent parse(@NotNull StringReader reader) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            String string = reader.readString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readString(...)");
            String input = ((Object)StringsKt.trim((CharSequence)string)).toString();
            return Companion.getFromInput(input);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public <S> CompletableFuture<Suggestions> listSuggestions(@NotNull CommandContext<S> context, @NotNull SuggestionsBuilder builder) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            Iterable $this$map$iv = (Iterable)QuestUpdateEvent.getEntries();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                QuestUpdateEvent questUpdateEvent = (QuestUpdateEvent)((Object)item$iv$iv);
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.toString());
            }
            CompletableFuture completableFuture = SharedSuggestionProvider.suggest((Iterable)((List)destination$iv$iv), (SuggestionsBuilder)builder);
            Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"suggest(...)");
            return completableFuture;
        }

        public /* synthetic */ QuestUpdateEventArgument(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u001c\u0010\b\u001a\u00020\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u0007J\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u000f"}, d2={"Lcom/ruslan/growsseth/commands/QuestCommand$QuestUpdateEventArgument$Companion;", "", "<init>", "()V", "getFromInput", "Lcom/ruslan/growsseth/quests/QuestUpdateEvent;", "input", "", "getEvent", "context", "Lcom/mojang/brigadier/context/CommandContext;", "Lnet/minecraft/commands/CommandSourceStack;", "name", "get", "Lcom/ruslan/growsseth/commands/QuestCommand$QuestUpdateEventArgument;", "ruins-of-growsseth"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final QuestUpdateEvent getFromInput(@NotNull String input) {
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                return QuestUpdateEvent.valueOf(input);
            }

            @NotNull
            public final QuestUpdateEvent getEvent(@NotNull CommandContext<CommandSourceStack> context, @NotNull String name) {
                Intrinsics.checkNotNullParameter(context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Object object = context.getArgument(name, QuestUpdateEvent.class);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getArgument(...)");
                return (QuestUpdateEvent)((Object)object);
            }

            @NotNull
            public final QuestUpdateEventArgument get() {
                return new QuestUpdateEventArgument(null);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

