/*
 * Decompiled with CFR 0.152.
 */
package com.ruslan.growsseth.commands;

import com.filloax.fxlib.api.UtilsKt;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.ruslan.growsseth.advancements.StructureAdvancements;
import com.ruslan.growsseth.config.ResearcherConfig;
import com.ruslan.growsseth.entity.GrowssethEntities;
import com.ruslan.growsseth.entity.researcher.Researcher;
import com.ruslan.growsseth.entity.researcher.ResearcherSavedData;
import com.ruslan.growsseth.entity.researcher.trades.ProgressResearcherTradesProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.entity.EntityTypeTest;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ6\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u00102\u001e\u0010\u0011\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00050\u0012H\u0002J\u001e\u0010\u0014\u001a\u00020\u00052\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u00102\u0006\u0010\u0015\u001a\u00020\u0013H\u0002J\u001e\u0010\u0016\u001a\u00020\u00052\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u00102\u0006\u0010\u0015\u001a\u00020\u0013H\u0002J&\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u00132\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0010H\u0002J\u001e\u0010\u001a\u001a\u00020\u00052\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u00102\u0006\u0010\u0015\u001a\u00020\u0013H\u0002J\u001e\u0010\u001b\u001a\u00020\u00052\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u00102\u0006\u0010\u0015\u001a\u00020\u0013H\u0002\u00a8\u0006\u001c"}, d2={"Lcom/ruslan/growsseth/commands/ResearcherResetCommand;", "", "<init>", "()V", "register", "", "dispatcher", "Lcom/mojang/brigadier/CommandDispatcher;", "Lnet/minecraft/commands/CommandSourceStack;", "registryAccess", "Lnet/minecraft/commands/CommandBuildContext;", "environment", "Lnet/minecraft/commands/Commands$CommandSelection;", "runResetFunction", "", "ctx", "Lcom/mojang/brigadier/context/CommandContext;", "resetFunction", "Lkotlin/Function2;", "Lnet/minecraft/server/MinecraftServer;", "resetResearcherData", "server", "resetResearcherDataKeepDialogues", "updateResearcherData", "savedData", "Lcom/ruslan/growsseth/entity/researcher/ResearcherSavedData;", "resetStructureProgress", "resetAll", "ruins-of-growsseth"})
@SourceDebugExtension(value={"SMAP\nResearcherResetCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResearcherResetCommand.kt\ncom/ruslan/growsseth/commands/ResearcherResetCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,122:1\n1863#2:123\n1863#2,2:124\n1864#2:126\n1557#2:127\n1628#2,3:128\n1863#2,2:131\n*S KotlinDebug\n*F\n+ 1 ResearcherResetCommand.kt\ncom/ruslan/growsseth/commands/ResearcherResetCommand\n*L\n83#1:123\n84#1:124,2\n83#1:126\n100#1:127\n100#1:128,3\n106#1:131,2\n*E\n"})
public final class ResearcherResetCommand {
    @NotNull
    public static final ResearcherResetCommand INSTANCE = new ResearcherResetCommand();

    private ResearcherResetCommand() {
    }

    public final void register(@NotNull CommandDispatcher<CommandSourceStack> dispatcher, @NotNull CommandBuildContext registryAccess, @NotNull Commands.CommandSelection environment) {
        Intrinsics.checkNotNullParameter(dispatcher, (String)"dispatcher");
        Intrinsics.checkNotNullParameter((Object)registryAccess, (String)"registryAccess");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"greset").requires(ResearcherResetCommand::register$lambda$0)).then(((LiteralArgumentBuilder)Commands.literal((String)"researcher").then(Commands.literal((String)"keep_dialogue_history").executes(ResearcherResetCommand::register$lambda$1))).executes(ResearcherResetCommand::register$lambda$2))).then(Commands.literal((String)"structures").executes(ResearcherResetCommand::register$lambda$3))).then(Commands.literal((String)"all").executes(ResearcherResetCommand::register$lambda$4))).executes(ResearcherResetCommand::register$lambda$5));
    }

    private final int runResetFunction(CommandContext<CommandSourceStack> ctx, Function2<? super CommandContext<CommandSourceStack>, ? super MinecraftServer, Unit> resetFunction) {
        int n;
        if (ResearcherConfig.singleResearcher) {
            MinecraftServer minecraftServer = ((CommandSourceStack)ctx.getSource()).getServer();
            Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
            resetFunction.invoke(ctx, (Object)minecraftServer);
            ((CommandSourceStack)ctx.getSource()).sendSuccess(ResearcherResetCommand::runResetFunction$lambda$6, true);
            n = 1;
        } else {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.translatable((String)"growsseth.commands.greset.nop"));
            n = 0;
        }
        return n;
    }

    private final void resetResearcherData(CommandContext<CommandSourceStack> ctx, MinecraftServer server) {
        ResearcherSavedData savedData = ResearcherSavedData.Companion.getPersistent(server);
        savedData.setData(new CompoundTag());
        savedData.setName(null);
        savedData.setDead(false);
        this.updateResearcherData(savedData, server, ctx);
    }

    private final void resetResearcherDataKeepDialogues(CommandContext<CommandSourceStack> ctx, MinecraftServer server) {
        ResearcherSavedData savedData = ResearcherSavedData.Companion.getPersistent(server);
        CompoundTag dialogueData = savedData.getData().getCompound("SharedDialogueData");
        savedData.setData(new CompoundTag());
        savedData.getData().put("SharedDialogueData", (Tag)dialogueData);
        savedData.setDead(false);
        this.updateResearcherData(savedData, server, ctx);
    }

    private final void updateResearcherData(ResearcherSavedData savedData, MinecraftServer server, CommandContext<CommandSourceStack> ctx) {
        savedData.setDirty();
        try {
            Iterable iterable = server.getAllLevels();
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getAllLevels(...)");
            Iterable $this$forEach$iv = iterable;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ServerLevel level = (ServerLevel)element$iv;
                boolean bl = false;
                List list = level.getEntities((EntityTypeTest)GrowssethEntities.INSTANCE.getRESEARCHER(), arg_0 -> ResearcherResetCommand.updateResearcherData$lambda$9$lambda$7(UtilsKt.alwaysTruePredicate(), arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEntities(...)");
                Iterable $this$forEach$iv2 = list;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    Researcher researcher = (Researcher)element$iv2;
                    boolean bl2 = false;
                    researcher.readSavedData(savedData);
                }
            }
        }
        catch (Exception e) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)("Error in resetting loaded researchers: " + e.getMessage())));
            e.printStackTrace();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void resetStructureProgress(CommandContext<CommandSourceStack> ctx, MinecraftServer server) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        ProgressResearcherTradesProvider.ProgressTradesSavedData progressData = ProgressResearcherTradesProvider.ProgressTradesSavedData.Companion.get(server);
        progressData.getFoundStructures().clear();
        progressData.setDirty();
        Iterable iterable = StructureAdvancements.INSTANCE.getAllStructureAdvancementIds();
        boolean $i$f$map = false;
        void var7_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ResourceLocation resourceLocation = (ResourceLocation)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            AdvancementHolder advancementHolder = server.getAdvancements().get((ResourceLocation)it);
            if (advancementHolder == null) {
                ResearcherResetCommand $this$resetStructureProgress_u24lambda_u2411_u24lambda_u2410 = INSTANCE;
                boolean bl2 = false;
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)("Server didn't have all required advancements, missing " + (ResourceLocation)it)));
                return;
            }
            collection.add(advancementHolder);
        }
        List structureFoundAdvancements = (List)destination$iv$iv;
        ServerPlayer serverPlayer = ((CommandSourceStack)ctx.getSource()).getPlayer();
        if (serverPlayer != null) {
            ServerPlayer player = serverPlayer;
            boolean bl = false;
            Iterable $this$forEach$iv = structureFoundAdvancements;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AdvancementHolder adv = (AdvancementHolder)element$iv;
                boolean bl3 = false;
                AdvancementProgress progress = player.getAdvancements().getOrStartProgress(adv);
                for (String string : progress.getCompletedCriteria()) {
                    player.getAdvancements().revoke(adv, string);
                }
            }
        } else {
            ResearcherResetCommand $this$resetStructureProgress_u24lambda_u2414 = this;
            boolean bl = false;
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)"Warning: couldn't reset player advancements as run not from player, researcher structure progress won't be completely reset").withStyle(ChatFormatting.YELLOW));
        }
    }

    private final void resetAll(CommandContext<CommandSourceStack> ctx, MinecraftServer server) {
        this.resetResearcherData(ctx, server);
        this.resetStructureProgress(ctx, server);
    }

    private static final boolean register$lambda$0(CommandSourceStack it) {
        return it.hasPermission(2);
    }

    private static final int register$lambda$1(CommandContext ctx) {
        Intrinsics.checkNotNull((Object)ctx);
        return INSTANCE.runResetFunction((CommandContext<CommandSourceStack>)ctx, (Function2<? super CommandContext<CommandSourceStack>, ? super MinecraftServer, Unit>)((Function2)new Function2<CommandContext<CommandSourceStack>, MinecraftServer, Unit>((Object)INSTANCE){

            public final void invoke(CommandContext<CommandSourceStack> p0, MinecraftServer p1) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                ResearcherResetCommand.access$resetResearcherDataKeepDialogues((ResearcherResetCommand)this.receiver, p0, p1);
            }
        }));
    }

    private static final int register$lambda$2(CommandContext ctx) {
        Intrinsics.checkNotNull((Object)ctx);
        return INSTANCE.runResetFunction((CommandContext<CommandSourceStack>)ctx, (Function2<? super CommandContext<CommandSourceStack>, ? super MinecraftServer, Unit>)((Function2)new Function2<CommandContext<CommandSourceStack>, MinecraftServer, Unit>((Object)INSTANCE){

            public final void invoke(CommandContext<CommandSourceStack> p0, MinecraftServer p1) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                ResearcherResetCommand.access$resetResearcherData((ResearcherResetCommand)this.receiver, p0, p1);
            }
        }));
    }

    private static final int register$lambda$3(CommandContext ctx) {
        Intrinsics.checkNotNull((Object)ctx);
        return INSTANCE.runResetFunction((CommandContext<CommandSourceStack>)ctx, (Function2<? super CommandContext<CommandSourceStack>, ? super MinecraftServer, Unit>)((Function2)new Function2<CommandContext<CommandSourceStack>, MinecraftServer, Unit>((Object)INSTANCE){

            public final void invoke(CommandContext<CommandSourceStack> p0, MinecraftServer p1) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                ResearcherResetCommand.access$resetStructureProgress((ResearcherResetCommand)this.receiver, p0, p1);
            }
        }));
    }

    private static final int register$lambda$4(CommandContext ctx) {
        Intrinsics.checkNotNull((Object)ctx);
        return INSTANCE.runResetFunction((CommandContext<CommandSourceStack>)ctx, (Function2<? super CommandContext<CommandSourceStack>, ? super MinecraftServer, Unit>)((Function2)new Function2<CommandContext<CommandSourceStack>, MinecraftServer, Unit>((Object)INSTANCE){

            public final void invoke(CommandContext<CommandSourceStack> p0, MinecraftServer p1) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                ResearcherResetCommand.access$resetAll((ResearcherResetCommand)this.receiver, p0, p1);
            }
        }));
    }

    private static final int register$lambda$5(CommandContext ctx) {
        Intrinsics.checkNotNull((Object)ctx);
        return INSTANCE.runResetFunction((CommandContext<CommandSourceStack>)ctx, (Function2<? super CommandContext<CommandSourceStack>, ? super MinecraftServer, Unit>)((Function2)new Function2<CommandContext<CommandSourceStack>, MinecraftServer, Unit>((Object)INSTANCE){

            public final void invoke(CommandContext<CommandSourceStack> p0, MinecraftServer p1) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                ResearcherResetCommand.access$resetAll((ResearcherResetCommand)this.receiver, p0, p1);
            }
        }));
    }

    private static final Component runResetFunction$lambda$6() {
        return (Component)Component.translatable((String)"growsseth.commands.greset.done");
    }

    private static final boolean updateResearcherData$lambda$9$lambda$7(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$resetResearcherDataKeepDialogues(ResearcherResetCommand $this, CommandContext ctx, MinecraftServer server) {
        $this.resetResearcherDataKeepDialogues((CommandContext<CommandSourceStack>)ctx, server);
    }

    public static final /* synthetic */ void access$resetResearcherData(ResearcherResetCommand $this, CommandContext ctx, MinecraftServer server) {
        $this.resetResearcherData((CommandContext<CommandSourceStack>)ctx, server);
    }

    public static final /* synthetic */ void access$resetStructureProgress(ResearcherResetCommand $this, CommandContext ctx, MinecraftServer server) {
        $this.resetStructureProgress((CommandContext<CommandSourceStack>)ctx, server);
    }

    public static final /* synthetic */ void access$resetAll(ResearcherResetCommand $this, CommandContext ctx, MinecraftServer server) {
        $this.resetAll((CommandContext<CommandSourceStack>)ctx, server);
    }
}

