/*
 * Decompiled with CFR 0.152.
 */
package com.ruslan.growsseth.compat;

import com.mojang.datafixers.util.Pair;
import dev.worldgen.lithostitched.worldgen.modifier.AddTemplatePoolElementsModifier;
import dev.worldgen.lithostitched.worldgen.structure.DelegatingStructure;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.LegacySinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J:\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013\u00a8\u0006\u0014"}, d2={"Lcom/ruslan/growsseth/compat/LithostitchedCompat;", "", "<init>", "()V", "isValidJigsawCheckStructure", "", "struct", "Lnet/minecraft/world/level/levelgen/structure/Structure;", "addBuildingToPool", "", "templatePoolRegistry", "Lnet/minecraft/core/Registry;", "Lnet/minecraft/world/level/levelgen/structure/pools/StructureTemplatePool;", "processorListRegistry", "Lnet/minecraft/world/level/levelgen/structure/templatesystem/StructureProcessorList;", "poolId", "Lnet/minecraft/resources/ResourceLocation;", "poolPieceId", "weight", "", "ruins-of-growsseth"})
public final class LithostitchedCompat {
    @NotNull
    public static final LithostitchedCompat INSTANCE = new LithostitchedCompat();

    private LithostitchedCompat() {
    }

    public final boolean isValidJigsawCheckStructure(@NotNull Structure struct) {
        Intrinsics.checkNotNullParameter((Object)struct, (String)"struct");
        if (struct instanceof DelegatingStructure) {
            return Intrinsics.areEqual((Object)((DelegatingStructure)struct).delegate().type(), (Object)StructureType.JIGSAW);
        }
        return false;
    }

    public final void addBuildingToPool(@NotNull Registry<StructureTemplatePool> templatePoolRegistry, @NotNull Registry<StructureProcessorList> processorListRegistry, @NotNull ResourceLocation poolId, @NotNull ResourceLocation poolPieceId, int weight) {
        Intrinsics.checkNotNullParameter(templatePoolRegistry, (String)"templatePoolRegistry");
        Intrinsics.checkNotNullParameter(processorListRegistry, (String)"processorListRegistry");
        Intrinsics.checkNotNullParameter((Object)poolId, (String)"poolId");
        Intrinsics.checkNotNullParameter((Object)poolPieceId, (String)"poolPieceId");
        Holder.Reference pool = templatePoolRegistry.getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)poolId));
        LegacySinglePoolElement newPiece = (LegacySinglePoolElement)LegacySinglePoolElement.legacy((String)poolPieceId.toString()).apply(StructureTemplatePool.Projection.RIGID);
        Holder[] holderArray = new Holder[]{pool};
        HolderSet.Direct poolSet = HolderSet.direct((Holder[])holderArray);
        AddTemplatePoolElementsModifier modifier = new AddTemplatePoolElementsModifier(0, (HolderSet)poolSet, CollectionsKt.listOf((Object)Pair.of((Object)newPiece, (Object)weight)));
        modifier.applyModifier();
    }
}

