/*
 * Decompiled with CFR 0.152.
 */
package com.ruslan.growsseth.data;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.ruslan.growsseth.structure.GrProcessorLists;
import com.ruslan.growsseth.structure.VillageBuildings;
import com.ruslan.growsseth.utils.UtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.data.worldgen.ProcessorLists;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 /2\u00020\u0001:\u0001/B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0012\u001a\u00020\u0011H\u0002J\b\u0010\u0013\u001a\u00020\u0011H\u0002J\b\u0010\u0014\u001a\u00020\u0011H\u0002J\b\u0010\u0015\u001a\u00020\u0011H\u0002J\b\u0010\u0016\u001a\u00020\u0011H\u0002J\b\u0010\u0017\u001a\u00020\u0011H\u0002J\b\u0010\u0018\u001a\u00020\u0011H\u0002J\b\u0010\u0019\u001a\u00020\u0011H\u0002JM\u0010\u001a\u001a\u00020\u00112\u0012\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001d0\u001c\"\u00020\u001d2\u000e\b\u0002\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001f2\u000e\b\u0002\u0010 \u001a\b\u0012\u0004\u0012\u00020\t0!2\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010#H\u0002\u00a2\u0006\u0002\u0010$JM\u0010%\u001a\u00020\u00112\u0012\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001d0\u001c\"\u00020\u001d2\u000e\b\u0002\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001f2\u000e\b\u0002\u0010 \u001a\b\u0012\u0004\u0012\u00020\t0!2\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010#H\u0002\u00a2\u0006\u0002\u0010$JB\u0010%\u001a\u00020\u00112\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001f2\u000e\b\u0002\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001f2\u000e\b\u0002\u0010 \u001a\b\u0012\u0004\u0012\u00020\t0!2\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010#H\u0002J6\u0010&\u001a\u00020\u00112\u0006\u0010'\u001a\u00020\u001d2\b\b\u0002\u0010(\u001a\u00020\u001d2\u000e\b\u0002\u0010 \u001a\b\u0012\u0004\u0012\u00020\t0!2\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010#H\u0002J6\u0010)\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020,0*2\u0006\u0010-\u001a\u00020.2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\t0!2\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010#H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R4\u0010\u000b\u001a&\u0012\f\u0012\n \r*\u0004\u0018\u00010\u00040\u0004 \r*\u0012\u0012\f\u0012\n \r*\u0004\u0018\u00010\u00040\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR4\u0010\u000f\u001a&\u0012\f\u0012\n \r*\u0004\u0018\u00010\t0\t \r*\u0012\u0012\f\u0012\n \r*\u0004\u0018\u00010\t0\t\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000e\u00a8\u00060"}, d2={"Lcom/ruslan/growsseth/data/SimplePools;", "", "context", "Lnet/minecraft/data/worldgen/BootstrapContext;", "Lnet/minecraft/world/level/levelgen/structure/pools/StructureTemplatePool;", "<init>", "(Lnet/minecraft/data/worldgen/BootstrapContext;)V", "processorGetter", "Lnet/minecraft/core/HolderGetter;", "Lnet/minecraft/world/level/levelgen/structure/templatesystem/StructureProcessorList;", "templatePoolGetter", "emptyPool", "Lnet/minecraft/core/Holder$Reference;", "kotlin.jvm.PlatformType", "Lnet/minecraft/core/Holder$Reference;", "emptyProcessor", "bootstrap", "", "bootstrapBeekeperHouse", "bootstrapConduitChurch", "bootstrapEnchantTower", "bootstrapNoteblockLab", "bootstrapAbandonedForge", "bootstrapMinorRuins", "bootstrapMisc", "bootstrapVillageHouses", "registerPoolElementsWithCydonia", "paths", "", "", "templatePaths", "", "processors", "Lnet/minecraft/core/Holder;", "overrideLiquidSettings", "Lnet/minecraft/world/level/levelgen/structure/templatesystem/LiquidSettings;", "([Ljava/lang/String;Ljava/util/List;Lnet/minecraft/core/Holder;Lnet/minecraft/world/level/levelgen/structure/templatesystem/LiquidSettings;)V", "registerPoolElements", "registerSimplePoolElement", "path", "templatePath", "singlePoolElement", "Ljava/util/function/Function;", "Lnet/minecraft/world/level/levelgen/structure/pools/StructureTemplatePool$Projection;", "Lnet/minecraft/world/level/levelgen/structure/pools/SinglePoolElement;", "id", "Lnet/minecraft/resources/ResourceLocation;", "Companion", "ruins-of-growsseth"})
@SourceDebugExtension(value={"SMAP\nSimplePools.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimplePools.kt\ncom/ruslan/growsseth/data/SimplePools\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,200:1\n1863#2,2:201\n1368#2:203\n1454#2,5:204\n*S KotlinDebug\n*F\n+ 1 SimplePools.kt\ncom/ruslan/growsseth/data/SimplePools\n*L\n134#1:201,2\n150#1:203\n150#1:204,5\n*E\n"})
public final class SimplePools {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BootstrapContext<StructureTemplatePool> context;
    @NotNull
    private final HolderGetter<StructureProcessorList> processorGetter;
    @NotNull
    private final HolderGetter<StructureTemplatePool> templatePoolGetter;
    private final Holder.Reference<StructureTemplatePool> emptyPool;
    private final Holder.Reference<StructureProcessorList> emptyProcessor;

    public SimplePools(@NotNull BootstrapContext<StructureTemplatePool> context) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        this.context = context;
        HolderGetter holderGetter = this.context.lookup(Registries.PROCESSOR_LIST);
        Intrinsics.checkNotNullExpressionValue((Object)holderGetter, (String)"lookup(...)");
        this.processorGetter = holderGetter;
        HolderGetter holderGetter2 = this.context.lookup(Registries.TEMPLATE_POOL);
        Intrinsics.checkNotNullExpressionValue((Object)holderGetter2, (String)"lookup(...)");
        this.templatePoolGetter = holderGetter2;
        this.emptyPool = this.templatePoolGetter.getOrThrow(Pools.EMPTY);
        this.emptyProcessor = this.processorGetter.getOrThrow(ProcessorLists.EMPTY);
    }

    public final void bootstrap() {
        this.bootstrapBeekeperHouse();
        this.bootstrapConduitChurch();
        this.bootstrapEnchantTower();
        this.bootstrapNoteblockLab();
        this.bootstrapAbandonedForge();
        this.bootstrapMinorRuins();
        this.bootstrapMisc();
        this.bootstrapVillageHouses();
    }

    private final void bootstrapBeekeperHouse() {
        String[] stringArray = new String[]{"ruins/beekeeper_house/beenest", "ruins/beekeeper_house/house", "ruins/beekeeper_house/zombie"};
        SimplePools.registerPoolElementsWithCydonia$default(this, stringArray, null, null, null, 14, null);
        stringArray = new String[]{"ruins/beekeeper_house/beehive", "cydonia/ruins/beekeeper_house/beehive_off", "cydonia/ruins/beekeeper_house/beehive_on", "cydonia/ruins/beekeeper_house/beenest_campfire"};
        SimplePools.registerPoolElements$default(this, stringArray, null, null, null, 14, null);
    }

    private final void bootstrapConduitChurch() {
        String[] stringArray = new String[]{"ruins/conduit_church/main"};
        SimplePools.registerPoolElementsWithCydonia$default(this, stringArray, null, null, LiquidSettings.APPLY_WATERLOGGING, 6, null);
        stringArray = new String[]{"ruins/conduit_church/maze_end", "ruins/conduit_church/maze", "ruins/conduit_church/secret_tunnel"};
        SimplePools.registerPoolElementsWithCydonia$default(this, stringArray, null, null, null, 14, null);
        stringArray = new String[]{"cydonia/ruins/conduit_church/follonichese", "cydonia/ruins/conduit_church/follonichese_shell"};
        SimplePools.registerPoolElements$default(this, stringArray, null, null, LiquidSettings.APPLY_WATERLOGGING, 6, null);
    }

    private final void bootstrapEnchantTower() {
        Holder.Reference processors = this.processorGetter.getOrThrow(GrProcessorLists.INSTANCE.getTOWER_DEGRADATION());
        String[] stringArray = new String[]{"ruins/enchant_tower/base", "ruins/enchant_tower/table", "ruins/enchant_tower/tower"};
        Intrinsics.checkNotNull((Object)processors);
        SimplePools.registerPoolElements$default(this, stringArray, null, (Holder)processors, null, 10, null);
        stringArray = new String[]{"cydonia/ruins/enchant_tower/base", "cydonia/ruins/enchant_tower/table", "cydonia/ruins/enchant_tower/tower"};
        SimplePools.registerPoolElements$default(this, stringArray, null, null, null, 14, null);
        stringArray = new String[]{"ruins/enchant_tower/armor_stand"};
        SimplePools.registerPoolElements$default(this, stringArray, null, null, null, 14, null);
    }

    private final void bootstrapNoteblockLab() {
        String[] stringArray = new String[]{"ruins/noteblock_lab/basement", "ruins/noteblock_lab/house"};
        SimplePools.registerPoolElementsWithCydonia$default(this, stringArray, null, null, null, 14, null);
    }

    private final void bootstrapAbandonedForge() {
        Holder.Reference processors = this.processorGetter.getOrThrow(GrProcessorLists.INSTANCE.getFORGE_DEGRADATION());
        String[] stringArray = new String[]{"ruins/abandoned_forge/base", "ruins/abandoned_forge/cave", "ruins/abandoned_forge/hole"};
        Intrinsics.checkNotNull((Object)processors);
        SimplePools.registerPoolElements$default(this, stringArray, null, (Holder)processors, null, 10, null);
    }

    private final void bootstrapMinorRuins() {
        String[] stringArray = new String[]{"ruins/conduit_ruins"};
        SimplePools.registerPoolElements$default(this, stringArray, null, null, LiquidSettings.APPLY_WATERLOGGING, 6, null);
        stringArray = new String[]{"ruins/noteblock_ship/top", "ruins/noteblock_ship/bottom"};
        SimplePools.registerPoolElements$default(this, stringArray, null, null, null, 14, null);
    }

    private final void bootstrapMisc() {
        String[] stringArray = new String[]{"misc/cave_camp", "misc/marker"};
        SimplePools.registerPoolElementsWithCydonia$default(this, stringArray, null, null, null, 14, null);
        stringArray = new String[]{"cydonia/misc/golem_house"};
        Holder.Reference reference = this.processorGetter.getOrThrow(ProcessorLists.MOSSIFY_10_PERCENT);
        Intrinsics.checkNotNullExpressionValue((Object)reference, (String)"getOrThrow(...)");
        SimplePools.registerPoolElements$default(this, stringArray, null, (Holder)reference, null, 10, null);
    }

    private final void bootstrapVillageHouses() {
        List<VillageBuildings.VillageEntry> list = VillageBuildings.INSTANCE.getHouseEntries().get("golem_house");
        Intrinsics.checkNotNull(list);
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VillageBuildings.VillageEntry entry = (VillageBuildings.VillageEntry)element$iv;
            boolean bl = false;
            Object[] objectArray = new String[]{entry.getNormalPool().getPath(), entry.getZombiePool().getPath()};
            Object[] objectArray2 = objectArray;
            objectArray = new String[]{entry.getNormalTemplate().getPath(), entry.getZombieTemplate().getPath()};
            SimplePools.registerPoolElements$default(this, (String[])objectArray2, CollectionsKt.listOf((Object[])objectArray), null, null, 12, null);
        }
    }

    private final void registerPoolElementsWithCydonia(String[] paths, List<String> templatePaths, Holder<StructureProcessorList> processors, LiquidSettings overrideLiquidSettings) {
        Iterable list$iv$iv;
        Object[] objectArray;
        String it;
        Iterable $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        Iterable iterable = ArraysKt.toList((Object[])paths);
        SimplePools simplePools = this;
        boolean $i$f$flatMap = false;
        void var7_8 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            objectArray = new String[]{it, "cydonia/" + it};
            list$iv$iv = CollectionsKt.listOf((Object[])objectArray);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = templatePaths;
        List list = (List)destination$iv$iv;
        $i$f$flatMap = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            objectArray = new String[]{it, "cydonia/" + it};
            list$iv$iv = CollectionsKt.listOf((Object[])objectArray);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        simplePools.registerPoolElements(list, (List<String>)list2, processors, overrideLiquidSettings);
    }

    static /* synthetic */ void registerPoolElementsWithCydonia$default(SimplePools simplePools, String[] stringArray, List list, Holder holder, LiquidSettings liquidSettings, int n, Object object) {
        if ((n & 2) != 0) {
            list = ArraysKt.toList((Object[])stringArray);
        }
        if ((n & 4) != 0) {
            holder = (Holder)simplePools.emptyProcessor;
        }
        if ((n & 8) != 0) {
            liquidSettings = null;
        }
        simplePools.registerPoolElementsWithCydonia(stringArray, list, (Holder<StructureProcessorList>)holder, liquidSettings);
    }

    private final void registerPoolElements(String[] paths, List<String> templatePaths, Holder<StructureProcessorList> processors, LiquidSettings overrideLiquidSettings) {
        this.registerPoolElements(ArraysKt.toList((Object[])paths), templatePaths, processors, overrideLiquidSettings);
    }

    static /* synthetic */ void registerPoolElements$default(SimplePools simplePools, String[] stringArray, List list, Holder holder, LiquidSettings liquidSettings, int n, Object object) {
        if ((n & 2) != 0) {
            list = ArraysKt.toList((Object[])stringArray);
        }
        if ((n & 4) != 0) {
            holder = (Holder)simplePools.emptyProcessor;
        }
        if ((n & 8) != 0) {
            liquidSettings = null;
        }
        simplePools.registerPoolElements(stringArray, (List<String>)list, (Holder<StructureProcessorList>)holder, liquidSettings);
    }

    private final void registerPoolElements(List<String> paths, List<String> templatePaths, Holder<StructureProcessorList> processors, LiquidSettings overrideLiquidSettings) {
        for (kotlin.Pair pair : CollectionsKt.zip((Iterable)paths, (Iterable)templatePaths)) {
            String path = (String)pair.component1();
            String templatePath = (String)pair.component2();
            this.registerSimplePoolElement(path, templatePath, processors, overrideLiquidSettings);
        }
    }

    static /* synthetic */ void registerPoolElements$default(SimplePools simplePools, List list, List list2, Holder holder, LiquidSettings liquidSettings, int n, Object object) {
        if ((n & 2) != 0) {
            list2 = CollectionsKt.toList((Iterable)list);
        }
        if ((n & 4) != 0) {
            holder = (Holder)simplePools.emptyProcessor;
        }
        if ((n & 8) != 0) {
            liquidSettings = null;
        }
        simplePools.registerPoolElements(list, (List<String>)list2, (Holder<StructureProcessorList>)holder, liquidSettings);
    }

    private final void registerSimplePoolElement(String path, String templatePath, Holder<StructureProcessorList> processors, LiquidSettings overrideLiquidSettings) {
        this.context.register(ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)UtilsKt.resLoc(path)), (Object)new StructureTemplatePool((Holder)this.emptyPool, CollectionsKt.listOf((Object)new Pair(this.singlePoolElement(UtilsKt.resLoc(templatePath), processors, overrideLiquidSettings), (Object)1)), StructureTemplatePool.Projection.RIGID));
    }

    static /* synthetic */ void registerSimplePoolElement$default(SimplePools simplePools, String string, String string2, Holder holder, LiquidSettings liquidSettings, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = string;
        }
        if ((n & 4) != 0) {
            holder = (Holder)simplePools.emptyProcessor;
        }
        if ((n & 8) != 0) {
            liquidSettings = null;
        }
        simplePools.registerSimplePoolElement(string, string2, (Holder<StructureProcessorList>)holder, liquidSettings);
    }

    private final Function<StructureTemplatePool.Projection, SinglePoolElement> singlePoolElement(ResourceLocation id, Holder<StructureProcessorList> processors, LiquidSettings overrideLiquidSettings) {
        return arg_0 -> SimplePools.singlePoolElement$lambda$3(id, processors, overrideLiquidSettings, arg_0);
    }

    static /* synthetic */ Function singlePoolElement$default(SimplePools simplePools, ResourceLocation resourceLocation, Holder holder, LiquidSettings liquidSettings, int n, Object object) {
        if ((n & 4) != 0) {
            liquidSettings = null;
        }
        return simplePools.singlePoolElement(resourceLocation, (Holder<StructureProcessorList>)holder, liquidSettings);
    }

    private static final SinglePoolElement singlePoolElement$lambda$3(ResourceLocation $id, Holder $processors, LiquidSettings $overrideLiquidSettings, StructureTemplatePool.Projection proj) {
        return new SinglePoolElement(Either.left((Object)$id), $processors, proj, Optional.ofNullable($overrideLiquidSettings));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a8\u0006\t"}, d2={"Lcom/ruslan/growsseth/data/SimplePools$Companion;", "", "<init>", "()V", "bootstrap", "", "ctx", "Lnet/minecraft/data/worldgen/BootstrapContext;", "Lnet/minecraft/world/level/levelgen/structure/pools/StructureTemplatePool;", "ruins-of-growsseth"})
    public static final class Companion {
        private Companion() {
        }

        public final void bootstrap(@NotNull BootstrapContext<StructureTemplatePool> ctx) {
            Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
            new SimplePools(ctx).bootstrap();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

