/*
 * Decompiled with CFR 0.152.
 */
package com.ruslan.growsseth.entity.researcher;

import com.filloax.fxlib.api.FxItemUtilsKt;
import com.ruslan.growsseth.RuinsOfGrowsseth;
import com.ruslan.growsseth.entity.researcher.CustomRemoteDiaries;
import com.ruslan.growsseth.templates.BookData;
import com.ruslan.growsseth.templates.BookTemplates;
import com.ruslan.growsseth.templates.TemplateEntry;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.LecternBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\tH\u0002J<\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u0007J\u0018\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/ruslan/growsseth/entity/researcher/DiaryHelper;", "", "<init>", "()V", "TAG_REMOVE_DIARIES_ON_PUSH", "", "hasCustomEndDiary", "", "getCustomEndDiary", "Lnet/minecraft/world/item/ItemStack;", "author", "Lnet/minecraft/network/chat/Component;", "diaryMatches", "book1", "book2", "pushDiaryToContainers", "", "book", "level", "Lnet/minecraft/server/level/ServerLevel;", "entity", "Lnet/minecraft/world/entity/LivingEntity;", "lectern", "Lnet/minecraft/world/level/block/entity/LecternBlockEntity;", "chest", "Lnet/minecraft/world/level/block/entity/ChestBlockEntity;", "skipExisting", "addToContainer", "container", "Lnet/minecraft/world/Container;", "stack", "ruins-of-growsseth"})
@SourceDebugExtension(value={"SMAP\nResearcherDiaryComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResearcherDiaryComponent.kt\ncom/ruslan/growsseth/entity/researcher/DiaryHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,582:1\n1#2:583\n*E\n"})
public final class DiaryHelper {
    @NotNull
    public static final DiaryHelper INSTANCE = new DiaryHelper();
    @NotNull
    public static final String TAG_REMOVE_DIARIES_ON_PUSH = "RemoveOnResDiaryPush";

    private DiaryHelper() {
    }

    public final boolean hasCustomEndDiary() {
        return CustomRemoteDiaries.INSTANCE.getEndDiary() != null;
    }

    @Nullable
    public final ItemStack getCustomEndDiary(@NotNull Component author) {
        Intrinsics.checkNotNullParameter((Object)author, (String)"author");
        ItemStack book = new ItemStack((ItemLike)Items.WRITTEN_BOOK);
        BookData bookData = CustomRemoteDiaries.INSTANCE.getEndDiary();
        if (bookData == null) {
            DiaryHelper $this$getCustomEndDiary_u24lambda_u240 = this;
            boolean bl = false;
            RuinsOfGrowsseth.LOGGER.error("getCustomEndDiary: no end diary loaded!", new Object[0]);
            return null;
        }
        BookData diaryData = bookData;
        List<TemplateEntry> pages = diaryData.getPages();
        RuinsOfGrowsseth.LOGGER.info("Created end diary (" + diaryData.getName() + ", " + pages.size() + " pages)", new Object[0]);
        return BookTemplates.loadTemplate$default(BookTemplates.INSTANCE, book, diaryData, null, 4, null);
    }

    private final boolean diaryMatches(ItemStack book1, ItemStack book2) {
        List text1 = FxItemUtilsKt.getBookText((ItemStack)book1);
        List text2 = FxItemUtilsKt.getBookText((ItemStack)book2);
        if (!Intrinsics.areEqual((Object)book1.getItem(), (Object)book2.getItem()) || book1.is(Items.WRITTEN_BOOK) && !Intrinsics.areEqual((Object)FxItemUtilsKt.getBookTitle((ItemStack)book1), (Object)FxItemUtilsKt.getBookTitle((ItemStack)book2)) || book1.is(Items.WRITTEN_BOOK) && !Intrinsics.areEqual((Object)FxItemUtilsKt.getBookAuthor((ItemStack)book1), (Object)FxItemUtilsKt.getBookAuthor((ItemStack)book2)) || text1.size() != text2.size()) {
            return false;
        }
        int n = ((Collection)text1).size();
        for (int i = 0; i < n; ++i) {
            if (Intrinsics.areEqual((Object)((Component)text1.get(i)).getString(), (Object)((Component)text2.get(i)).getString())) continue;
            return false;
        }
        return true;
    }

    public final void pushDiaryToContainers(@NotNull ItemStack book, @NotNull ServerLevel level, @NotNull LivingEntity entity, @Nullable LecternBlockEntity lectern, @Nullable ChestBlockEntity chest, boolean skipExisting) {
        boolean bl;
        LecternBlockEntity it;
        Intrinsics.checkNotNullParameter((Object)book, (String)"book");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        ItemStack currentItem = null;
        currentItem = book;
        LecternBlockEntity lecternBlockEntity = lectern;
        if (lecternBlockEntity != null) {
            it = lecternBlockEntity;
            boolean bl2 = false;
            BlockState state = level.getBlockState(it.getBlockPos());
            if (skipExisting && !it.getBook().isEmpty()) {
                ItemStack itemStack = it.getBook();
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getBook(...)");
                if (INSTANCE.diaryMatches(itemStack, currentItem)) {
                    return;
                }
            }
            if (!LecternBlock.tryPlaceBook((LivingEntity)entity, (Level)((Level)level), (BlockPos)it.getBlockPos(), (BlockState)state, (ItemStack)currentItem)) {
                ItemStack prevBook = it.getBook();
                it.setBook(currentItem);
                it.setChanged();
                level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, it.getBlockPos(), GameEvent.Context.of((Entity)((Entity)entity), (BlockState)state));
                currentItem = prevBook;
            }
        }
        ItemStack itemStack = currentItem;
        boolean bl3 = itemStack != null ? itemStack.isEmpty() : false;
        if (bl3) {
            currentItem = null;
        }
        ItemStack itemStack2 = currentItem;
        if (itemStack2 != null) {
            ItemStack it2 = itemStack2;
            boolean bl4 = false;
            CustomData customData = (CustomData)it2.get(DataComponents.CUSTOM_DATA);
            bl = Intrinsics.areEqual((Object)(customData != null ? Boolean.valueOf(customData.contains(TAG_REMOVE_DIARIES_ON_PUSH)) : null), (Object)true);
        } else {
            bl = false;
        }
        if (bl) {
            currentItem = null;
        }
        if (currentItem != null) {
            ChestBlockEntity chestBlockEntity = chest;
            if (chestBlockEntity != null) {
                boolean success;
                it = chestBlockEntity;
                boolean bl5 = false;
                if (skipExisting) {
                    int n = it.getContainerSize();
                    for (int slot = 0; slot < n; ++slot) {
                        ItemStack item = it.getItem(slot);
                        if (item.isEmpty() || !item.is(Items.WRITABLE_BOOK) && !item.is(Items.WRITTEN_BOOK)) continue;
                        Intrinsics.checkNotNull((Object)item);
                        if (!INSTANCE.diaryMatches(item, currentItem)) continue;
                        return;
                    }
                }
                if (success = INSTANCE.addToContainer((Container)it, currentItem)) {
                    currentItem = null;
                }
            }
        }
        ItemStack itemStack3 = currentItem;
        boolean bl6 = itemStack3 != null ? itemStack3.isEmpty() : false;
        if (bl6) {
            currentItem = null;
        }
        if (currentItem != null) {
            ItemEntity itemEntity = new ItemEntity((Level)level, entity.getX(), entity.getEyeY() - (double)0.3f, entity.getZ(), currentItem);
            itemEntity.setPickUpDelay(20);
            level.addFreshEntity((Entity)itemEntity);
        }
    }

    public static /* synthetic */ void pushDiaryToContainers$default(DiaryHelper diaryHelper, ItemStack itemStack, ServerLevel serverLevel, LivingEntity livingEntity, LecternBlockEntity lecternBlockEntity, ChestBlockEntity chestBlockEntity, boolean bl, int n, Object object) {
        if ((n & 0x20) != 0) {
            bl = false;
        }
        diaryHelper.pushDiaryToContainers(itemStack, serverLevel, livingEntity, lecternBlockEntity, chestBlockEntity, bl);
    }

    private final boolean addToContainer(Container container, ItemStack stack) {
        int n = container.getContainerSize();
        for (int slot = 0; slot < n; ++slot) {
            ItemStack slotStack = container.getItem(slot);
            if (!container.canPlaceItem(slot, stack)) continue;
            if (slotStack.isEmpty()) {
                container.setItem(slot, stack);
                return true;
            }
            if (slotStack.getCount() > slotStack.getMaxStackSize() - stack.getCount() || !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)slotStack)) continue;
            slotStack.grow(stack.getCount());
            return true;
        }
        return false;
    }
}

