/*
 * Decompiled with CFR 0.152.
 */
package com.ruslan.growsseth.entity.researcher;

import com.ruslan.growsseth.entity.researcher.Researcher;
import com.ruslan.growsseth.utils.UtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.BreathAirGoal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0002J\u0018\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/ruslan/growsseth/entity/researcher/ResearcherBreatheAirGoal;", "Lnet/minecraft/world/entity/ai/goal/BreathAirGoal;", "researcher", "Lcom/ruslan/growsseth/entity/researcher/Researcher;", "<init>", "(Lcom/ruslan/growsseth/entity/researcher/Researcher;)V", "canUse", "", "start", "", "findAirPosition", "givesAir", "level", "Lnet/minecraft/world/level/LevelReader;", "pos", "Lnet/minecraft/core/BlockPos;", "ruins-of-growsseth"})
public final class ResearcherBreatheAirGoal
extends BreathAirGoal {
    @NotNull
    private final Researcher researcher;

    public ResearcherBreatheAirGoal(@NotNull Researcher researcher) {
        Intrinsics.checkNotNullParameter((Object)researcher, (String)"researcher");
        super((PathfinderMob)researcher);
        this.researcher = researcher;
    }

    public boolean canUse() {
        return this.researcher.isInWall();
    }

    public void start() {
        this.findAirPosition();
    }

    private final void findAirPosition() {
        Iterable iterable = BlockPos.betweenClosed((int)Mth.floor((double)(this.researcher.getX() - 1.0)), (int)Mth.floor((double)(this.researcher.getY() + 1.0)), (int)Mth.floor((double)(this.researcher.getZ() - 1.0)), (int)Mth.floor((double)(this.researcher.getX() + 1.0)), (int)Mth.floor((double)(this.researcher.getY() + 1.0)), (int)Mth.floor((double)(this.researcher.getZ() + 1.0)));
        BlockPos blockPos = null;
        for (BlockPos blockPos2 : iterable) {
            Level level = this.researcher.level();
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
            LevelReader levelReader = (LevelReader)level;
            Intrinsics.checkNotNull((Object)blockPos2);
            if (!this.givesAir(levelReader, blockPos2)) continue;
            blockPos = blockPos2;
            break;
        }
        if (UtilsKt.notNull(blockPos)) {
            this.researcher.getNavigation().moveTo((double)blockPos.getX(), (double)blockPos.getY() - 1.0, (double)blockPos.getZ(), 0.6);
        }
    }

    private final boolean givesAir(LevelReader level, BlockPos pos) {
        BlockState blockState = level.getBlockState(pos);
        BlockState blockStateLower = level.getBlockState(new BlockPos(pos.getX(), pos.getY() - 1, pos.getZ()));
        return (level.getFluidState(pos).isEmpty() || blockState.is(Blocks.BUBBLE_COLUMN)) && blockStateLower.isPathfindable(PathComputationType.LAND);
    }
}

