/*
 * Decompiled with CFR 0.152.
 */
package com.ruslan.growsseth.entity.researcher;

import com.filloax.fxlib.api.UtilsKt;
import com.ruslan.growsseth.config.ResearcherConfig;
import com.ruslan.growsseth.dialogues.BasicDialogueEvents;
import com.ruslan.growsseth.dialogues.DialogueEvent;
import com.ruslan.growsseth.dialogues.NpcDialoguesComponent;
import com.ruslan.growsseth.effect.GrowssethEffects;
import com.ruslan.growsseth.entity.researcher.Researcher;
import com.ruslan.growsseth.entity.researcher.ResearcherDialoguesComponent;
import com.ruslan.growsseth.item.GrowssethItems;
import com.ruslan.growsseth.sound.GrowssethSounds;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001=B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010(\u001a\u00020)J7\u0010*\u001a\u0004\u0018\u00010%2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0018\u0010/\u001a\u0014\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020%00\u00a2\u0006\u0002\u00101J\u0006\u00102\u001a\u000203J\u000e\u00104\u001a\u00020%2\u0006\u00105\u001a\u00020\u000eJ\u000e\u00106\u001a\u0002032\u0006\u00105\u001a\u000207J\u0010\u00108\u001a\u00020%2\b\u00109\u001a\u0004\u0018\u00010:J\u0010\u0010;\u001a\u00020%2\b\u00109\u001a\u0004\u0018\u00010:J\u0010\u0010<\u001a\u00020%2\u0006\u0010+\u001a\u00020,H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R6\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00130\u00122\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00130\u0012@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u0019X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001bR\u001d\u0010\u001e\u001a\u0004\u0018\u00010\u001f8BX\u0082\u0084\u0002\u00a2\u0006\f\u001a\u0004\b\"\u0010#*\u0004\b \u0010!R\u0014\u0010$\u001a\u00020%8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'\u00a8\u0006>"}, d2={"Lcom/ruslan/growsseth/entity/researcher/ResearcherCombatComponent;", "", "owner", "Lcom/ruslan/growsseth/entity/researcher/Researcher;", "<init>", "(Lcom/ruslan/growsseth/entity/researcher/Researcher;)V", "getOwner", "()Lcom/ruslan/growsseth/entity/researcher/Researcher;", "level", "Lnet/minecraft/world/level/Level;", "getLevel", "()Lnet/minecraft/world/level/Level;", "lastKilledPlayers", "", "Lnet/minecraft/world/entity/player/Player;", "getLastKilledPlayers", "()Ljava/util/List;", "angerBuildupTimer", "", "Lorg/apache/commons/lang3/mutable/MutableInt;", "value", "hitCounter", "getHitCounter", "()Ljava/util/Map;", "ticksToCalmDown", "", "getTicksToCalmDown", "()I", "maxHitCounter", "getMaxHitCounter", "dialogues", "Lcom/ruslan/growsseth/entity/researcher/ResearcherDialoguesComponent;", "getDialogues$delegate", "(Lcom/ruslan/growsseth/entity/researcher/ResearcherCombatComponent;)Ljava/lang/Object;", "getDialogues", "()Lcom/ruslan/growsseth/entity/researcher/ResearcherDialoguesComponent;", "lowHealthCondition", "", "getLowHealthCondition", "()Z", "createWeapon", "Lnet/minecraft/world/item/ItemStack;", "hurt", "source", "Lnet/minecraft/world/damagesource/DamageSource;", "amount", "", "superHurt", "Lkotlin/Function2;", "(Lnet/minecraft/world/damagesource/DamageSource;FLkotlin/jvm/functions/Function2;)Ljava/lang/Boolean;", "aggressiveAiStep", "", "wantsToKillPlayer", "player", "onPlayerKilled", "Lnet/minecraft/server/level/ServerPlayer;", "shouldApplySelfDefence", "entity", "Lnet/minecraft/world/entity/LivingEntity;", "shouldStrikeFirst", "deflectArrow", "ResearcherAttackGoal", "ruins-of-growsseth"})
@SourceDebugExtension(value={"SMAP\nResearcherCombatComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResearcherCombatComponent.kt\ncom/ruslan/growsseth/entity/researcher/ResearcherCombatComponent\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,192:1\n216#2,2:193\n1#3:195\n*S KotlinDebug\n*F\n+ 1 ResearcherCombatComponent.kt\ncom/ruslan/growsseth/entity/researcher/ResearcherCombatComponent\n*L\n133#1:193,2\n*E\n"})
public final class ResearcherCombatComponent {
    @NotNull
    private final Researcher owner;
    @NotNull
    private final Level level;
    @NotNull
    private final List<Player> lastKilledPlayers;
    @NotNull
    private Map<Player, MutableInt> angerBuildupTimer;
    @NotNull
    private Map<Player, MutableInt> hitCounter;
    private final int ticksToCalmDown;
    private final int maxHitCounter;

    public ResearcherCombatComponent(@NotNull Researcher owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        this.owner = owner;
        Level level = this.owner.level();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
        this.level = level;
        this.lastKilledPlayers = new ArrayList();
        this.angerBuildupTimer = new LinkedHashMap();
        this.hitCounter = new LinkedHashMap();
        this.ticksToCalmDown = UtilsKt.secondsToTicks((int)10);
        this.maxHitCounter = 3;
    }

    @NotNull
    public final Researcher getOwner() {
        return this.owner;
    }

    @NotNull
    public final Level getLevel() {
        return this.level;
    }

    @NotNull
    public final List<Player> getLastKilledPlayers() {
        return this.lastKilledPlayers;
    }

    @NotNull
    public final Map<Player, MutableInt> getHitCounter() {
        return this.hitCounter;
    }

    public final int getTicksToCalmDown() {
        return this.ticksToCalmDown;
    }

    public final int getMaxHitCounter() {
        return this.maxHitCounter;
    }

    private final ResearcherDialoguesComponent getDialogues() {
        return this.owner.getDialogues();
    }

    private static Object getDialogues$delegate(ResearcherCombatComponent researcherCombatComponent) {
        return Reflection.property0((PropertyReference0)((PropertyReference0)new PropertyReference0Impl((Object)researcherCombatComponent.owner, Researcher.class, "dialogues", "getDialogues()Lcom/ruslan/growsseth/entity/researcher/ResearcherDialoguesComponent;", 0)));
    }

    private final boolean getLowHealthCondition() {
        return this.owner.getHealth() <= this.owner.getMaxHealth() / (float)3;
    }

    @NotNull
    public final ItemStack createWeapon() {
        ItemStack itemStack;
        ItemStack dagger = itemStack = new ItemStack((ItemLike)GrowssethItems.INSTANCE.getRESEARCHER_DAGGER());
        boolean bl = false;
        Registry registry = this.level.registryAccess().registryOrThrow(Registries.ENCHANTMENT);
        dagger.enchant((Holder)registry.getHolderOrThrow(Enchantments.UNBREAKING), 3);
        dagger.enchant((Holder)registry.getHolderOrThrow(Enchantments.MENDING), 1);
        return itemStack;
    }

    @Nullable
    public final Boolean hurt(@NotNull DamageSource source, float amount, @NotNull Function2<? super DamageSource, ? super Float, Boolean> superHurt) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter(superHurt, (String)"superHurt");
        Entity attacker = source.getEntity();
        if (attacker instanceof WitherBoss) {
            return (Boolean)superHurt.invoke((Object)source, (Object)Float.valueOf(amount * (float)2));
        }
        if (attacker instanceof Player && !((Player)attacker).isCreative() && this.level.getDifficulty() != Difficulty.PEACEFUL && !ResearcherConfig.immortalResearcher) {
            if (this.getLowHealthCondition()) {
                ResearcherDialoguesComponent researcherDialoguesComponent = this.getDialogues();
                if (researcherDialoguesComponent != null) {
                    DialogueEvent[] dialogueEventArray = new DialogueEvent[]{BasicDialogueEvents.INSTANCE.getLOW_HEALTH()};
                    NpcDialoguesComponent.DefaultImpls.triggerDialogue$default(researcherDialoguesComponent, (ServerPlayer)attacker, dialogueEventArray, null, false, 12, null);
                }
            } else {
                ResearcherDialoguesComponent researcherDialoguesComponent = this.getDialogues();
                if (researcherDialoguesComponent != null) {
                    DialogueEvent[] dialogueEventArray = new DialogueEvent[]{BasicDialogueEvents.INSTANCE.getHIT_BY_PLAYER()};
                    NpcDialoguesComponent.DefaultImpls.triggerDialogue$default(researcherDialoguesComponent, (ServerPlayer)attacker, dialogueEventArray, null, false, 12, null);
                }
            }
            if (!this.hitCounter.containsKey(attacker)) {
                this.hitCounter.put((Player)attacker, new MutableInt(0));
            }
            if (!this.wantsToKillPlayer((Player)attacker)) {
                MutableInt mutableInt = this.hitCounter.get(attacker);
                if (mutableInt != null) {
                    mutableInt.increment();
                }
                this.angerBuildupTimer.put((Player)attacker, new MutableInt(this.ticksToCalmDown));
            }
        }
        if (this.owner.isAggressive() && source.getDirectEntity() instanceof AbstractArrow && this.deflectArrow(source)) {
            this.owner.setShowArrowDeflectParticles(true);
            this.owner.playSound((SoundEvent)GrowssethSounds.Companion.getDEFLECT_ARROW_SOUND().value());
            return false;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public final void aggressiveAiStep() {
        block13: {
            if (!this.owner.isAggressive()) break block13;
            if (this.owner.tickCount % 10 == 0) {
                if (this.owner.hasEffect(GrowssethEffects.INSTANCE.getSERENITY())) {
                    this.owner.removeEffect(GrowssethEffects.INSTANCE.getSERENITY());
                }
                if (!(this.owner.getTarget() instanceof WitherBoss)) {
                    this.owner.addEffect(new MobEffectInstance(GrowssethEffects.INSTANCE.getFIGHTING_SPIRIT(), 15, 0, false, false));
                }
                if (!ResearcherConfig.immortalResearcher && ResearcherConfig.researcherAntiCheat && this.owner.hasEffect(MobEffects.DAMAGE_RESISTANCE) && this.owner.hasEffect(MobEffects.MOVEMENT_SLOWDOWN) || !(this.owner.getTarget() instanceof Player) && !(this.owner.getTarget() instanceof WitherBoss)) {
                    this.owner.addEffect(new MobEffectInstance(GrowssethEffects.INSTANCE.getJUSTICE(), 15, 0, false, false));
                }
            }
            if (!com.ruslan.growsseth.utils.UtilsKt.notNull(this.owner.getTarget())) ** GOTO lbl-1000
            v0 = this.owner.getTarget();
            Intrinsics.checkNotNull((Object)v0);
            if (!(v0.getY() >= this.owner.getY() + (double)2)) ** GOTO lbl-1000
            v1 = this.owner.getTarget();
            Intrinsics.checkNotNull((Object)v1);
            if (this.owner.distanceTo((Entity)v1) < 4.0f) {
                this.owner.setNeedsJumpBoost$ruins_of_growsseth(true);
                if (this.owner.onGround()) {
                    this.owner.jumpFromGroundAccess$ruins_of_growsseth();
                }
            } else lbl-1000:
            // 3 sources

            {
                this.owner.setNeedsJumpBoost$ruins_of_growsseth(false);
            }
            if (!ResearcherConfig.researcherAntiCheat) break block13;
            if (this.owner.getStuckCounter$ruins_of_growsseth() >= this.owner.getMaxStuckCounter$ruins_of_growsseth() || this.owner.tickCount - this.owner.getLastHurtByMobTimestamp() >= UtilsKt.secondsToTicks((float)2.0f) || this.owner.tickCount - this.owner.getLastHurtMobTimestamp() <= UtilsKt.secondsToTicks((float)5.0f)) ** GOTO lbl-1000
            v2 = this.owner.blockPosition();
            v3 = this.owner.getLastCheckStuckPosition$ruins_of_growsseth();
            Intrinsics.checkNotNull((Object)v3);
            if (v2.distSqr((Vec3i)v3) < 4.0) {
                var1_1 = this.owner;
                var2_2 = var1_1.getStuckCounter$ruins_of_growsseth();
                var1_1.setStuckCounter$ruins_of_growsseth(var2_2 + 1);
            } else lbl-1000:
            // 2 sources

            {
                this.owner.setLastCheckStuckPosition$ruins_of_growsseth(this.owner.blockPosition());
                this.owner.setStuckCounter$ruins_of_growsseth(0);
                this.owner.setStuck$ruins_of_growsseth(false);
            }
        }
        attributeInstance = this.owner.getAttribute(Attributes.MOVEMENT_SPEED);
        if (!this.owner.isAggressive()) ** GOTO lbl-1000
        var2_2 = UtilsKt.secondsToTicks((float)3.0f);
        var3_4 = this.owner.tickCount - this.owner.getLastHurtByMobTimestamp();
        v4 = 0 <= var3_4 ? var3_4 <= var2_2 : false;
        if (v4) {
            v5 = attributeInstance;
            Intrinsics.checkNotNull((Object)v5);
            v5.removeModifier(Researcher.Companion.getSPEED_MODIFIER_FIGHTING().id());
            attributeInstance.addTransientModifier(Researcher.Companion.getSPEED_MODIFIER_FIGHTING());
        } else lbl-1000:
        // 2 sources

        {
            v6 = attributeInstance;
            Intrinsics.checkNotNull((Object)v6);
            v6.removeModifier(Researcher.Companion.getSPEED_MODIFIER_FIGHTING().id());
        }
        $this$forEach$iv = this.angerBuildupTimer;
        $i$f$forEach = false;
        var4_5 = $this$forEach$iv.entrySet().iterator();
        while (var4_5.hasNext()) {
            var6_7 = element$iv = var4_5.next();
            $i$a$-forEach-ResearcherCombatComponent$aggressiveAiStep$1 = false;
            key = var6_7.getKey();
            value = var6_7.getValue();
            if (value.intValue() > 0 && !this.owner.isAggressive()) {
                v7 = this.angerBuildupTimer.get(key);
                Intrinsics.checkNotNull((Object)v7);
                v7.decrement();
            }
            if (value.intValue() != 0) continue;
            v8 = this.hitCounter.get(key);
            Intrinsics.checkNotNull((Object)v8);
            v8.decrement();
            v9 = this.hitCounter.get(key);
            Intrinsics.checkNotNull((Object)v9);
            this.angerBuildupTimer.put(key, v9.intValue() > 0 ? new MutableInt(this.ticksToCalmDown) : new MutableInt(-1));
        }
    }

    public final boolean wantsToKillPlayer(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return ((Number)this.hitCounter.getOrDefault(player, (MutableInt)Integer.valueOf(0))).intValue() == this.maxHitCounter;
    }

    public final void onPlayerKilled(@NotNull ServerPlayer player) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            MutableInt mutableInt = this.hitCounter.get(player);
            Intrinsics.checkNotNull((Object)mutableInt);
            mutableInt.setValue(0);
            MutableInt mutableInt2 = this.angerBuildupTimer.get(player);
            Intrinsics.checkNotNull((Object)mutableInt2);
            mutableInt2.setValue(-1);
            this.lastKilledPlayers.add((Player)player);
            ResearcherDialoguesComponent researcherDialoguesComponent = this.getDialogues();
            if (researcherDialoguesComponent == null) break block0;
            DialogueEvent[] dialogueEventArray = new DialogueEvent[]{ResearcherDialoguesComponent.Companion.getEV_KILL_PLAYER()};
            NpcDialoguesComponent.DefaultImpls.triggerDialogue$default(researcherDialoguesComponent, player, dialogueEventArray, null, false, 12, null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean shouldApplySelfDefence(@Nullable LivingEntity entity) {
        if (!(entity instanceof Mob)) return false;
        LivingEntity it = ((Mob)entity).getTarget();
        boolean bl = false;
        if (!com.ruslan.growsseth.utils.UtilsKt.notNull(it)) return false;
        if (!Intrinsics.areEqual((Object)it, (Object)this.owner)) return false;
        return true;
    }

    public final boolean shouldStrikeFirst(@Nullable LivingEntity entity) {
        int distanceForUnjustifiedAggression = 10;
        return entity != null && this.owner.distanceTo((Entity)entity) < (float)distanceForUnjustifiedAggression && (entity instanceof Raider || entity instanceof Vex || entity instanceof Zombie || entity instanceof AbstractSkeleton);
    }

    private final boolean deflectArrow(DamageSource source) {
        Entity entity = source.getDirectEntity();
        Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type net.minecraft.world.entity.projectile.AbstractArrow");
        AbstractArrow arrow = (AbstractArrow)entity;
        Vec3 directionToArrow = arrow.position().subtract(this.owner.position()).normalize();
        double dotProduct = directionToArrow.dot(this.owner.getLookAngle().normalize());
        return dotProduct > 0.5;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u0007H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/ruslan/growsseth/entity/researcher/ResearcherCombatComponent$ResearcherAttackGoal;", "Lnet/minecraft/world/entity/ai/goal/MeleeAttackGoal;", "mob", "Lcom/ruslan/growsseth/entity/researcher/Researcher;", "speedModifier", "", "followingTargetEvenIfNotSeen", "", "<init>", "(Lcom/ruslan/growsseth/entity/researcher/Researcher;DZ)V", "canContinueToUse", "ruins-of-growsseth"})
    public static final class ResearcherAttackGoal
    extends MeleeAttackGoal {
        private final boolean followingTargetEvenIfNotSeen;

        public ResearcherAttackGoal(@NotNull Researcher mob, double speedModifier, boolean followingTargetEvenIfNotSeen) {
            Intrinsics.checkNotNullParameter((Object)mob, (String)"mob");
            super((PathfinderMob)mob, speedModifier, followingTargetEvenIfNotSeen);
            this.followingTargetEvenIfNotSeen = followingTargetEvenIfNotSeen;
        }

        public boolean canContinueToUse() {
            LivingEntity livingEntity = this.mob.getTarget();
            return com.ruslan.growsseth.utils.UtilsKt.isNull(livingEntity) ? false : (!livingEntity.isAlive() ? false : (!this.followingTargetEvenIfNotSeen ? !this.mob.getNavigation().isDone() : !(livingEntity instanceof Player) || !((Player)livingEntity).isSpectator() && !((Player)livingEntity).isCreative()));
        }
    }
}

