/*
 * Decompiled with CFR 0.152.
 */
package com.ruslan.growsseth.entity.researcher;

import com.filloax.fxlib.api.codec.CodecUtils;
import com.filloax.fxlib.api.codec.CodecUtilsKt;
import com.filloax.fxlib.api.nbt.NbtUtilsKt;
import com.filloax.fxlib.api.networking.NetworkingUtilsKt;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.PrimitiveCodec;
import com.ruslan.growsseth.GrowssethTags;
import com.ruslan.growsseth.RuinsOfGrowsseth;
import com.ruslan.growsseth.config.ResearcherConfig;
import com.ruslan.growsseth.dialogues.BasicDialogueEvents;
import com.ruslan.growsseth.dialogues.BasicDialoguesComponent;
import com.ruslan.growsseth.dialogues.DialogueEntry;
import com.ruslan.growsseth.dialogues.DialogueEvent;
import com.ruslan.growsseth.dialogues.DialogueLineProcessed;
import com.ruslan.growsseth.dialogues.NpcDialoguesComponent;
import com.ruslan.growsseth.entity.researcher.Researcher;
import com.ruslan.growsseth.entity.researcher.ResearcherCombatComponent;
import com.ruslan.growsseth.network.AmbientSoundsPacket;
import com.ruslan.growsseth.network.StopMusicPacket;
import com.ruslan.growsseth.sound.GrowssethSounds;
import com.ruslan.growsseth.structure.pieces.ResearcherTent;
import com.ruslan.growsseth.utils.UtilsKt;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.phys.AABB;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\b\u000b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 D2\u00020\u0001:\u0002DEB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ;\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001a0\u0019\"\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016\u00a2\u0006\u0002\u0010\u001fJ$\u0010 \u001a\u00020\u00152\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00170\r2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00170\rH\u0014J\u0010\u0010#\u001a\u00020\u001e2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J2\u0010$\u001a\u00020\u00152\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00170%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00170%2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00170%H\u0014J\u0018\u0010'\u001a\u00020\u00152\u0006\u0010(\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J*\u0010)\u001a\u00020\u00152\u0006\u0010(\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010*\u001a\u00020\u001eH\u0014J\u0010\u0010+\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u0010\u0010,\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u0018\u0010-\u001a\u00020\u001e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010.\u001a\u00020\u001aH\u0016J<\u0010/\u001a\u00020\u00152\u0018\u00100\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u000203\u0012\u0004\u0012\u00020\u001e02012\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010(\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0014J\u0010\u00107\u001a\u00020\u00152\u0006\u00108\u001a\u000209H\u0014J\u0010\u0010:\u001a\u00020\u00152\u0006\u00108\u001a\u000209H\u0014J\u000e\u0010;\u001a\u00020\u00152\u0006\u0010<\u001a\u000209J\u000e\u0010=\u001a\u00020\u00152\u0006\u0010<\u001a\u000209J\u0006\u0010>\u001a\u00020\u001eJ\u000e\u0010?\u001a\u00020\u001e2\u0006\u0010@\u001a\u00020\u000eJ\u0018\u0010A\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010B\u001a\u00020CH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00104\u001a\u00020\u001eX\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106\u00a8\u0006F"}, d2={"Lcom/ruslan/growsseth/entity/researcher/ResearcherDialoguesComponent;", "Lcom/ruslan/growsseth/dialogues/BasicDialoguesComponent;", "researcher", "Lcom/ruslan/growsseth/entity/researcher/Researcher;", "random", "Lnet/minecraft/util/RandomSource;", "combat", "Lcom/ruslan/growsseth/entity/researcher/ResearcherCombatComponent;", "<init>", "(Lcom/ruslan/growsseth/entity/researcher/Researcher;Lnet/minecraft/util/RandomSource;Lcom/ruslan/growsseth/entity/researcher/ResearcherCombatComponent;)V", "getResearcher", "()Lcom/ruslan/growsseth/entity/researcher/Researcher;", "playersInCellar", "", "Ljava/util/UUID;", "playersWhoMadeMess", "cartographyTablesInTent", "", "lecternsInTent", "playersMetThisEntity", "triggerDialogue", "", "player", "Lnet/minecraft/server/level/ServerPlayer;", "dialogueEvents", "", "Lcom/ruslan/growsseth/dialogues/DialogueEvent;", "eventParam", "", "ignoreEventConditions", "", "(Lnet/minecraft/server/level/ServerPlayer;[Lcom/ruslan/growsseth/dialogues/DialogueEvent;Ljava/lang/String;Z)V", "changeNearPlayers", "nearPlayers", "farPlayers", "isInCellar", "afterPlayersCheck", "", "inbetweenPlayers", "incrementEventCount", "event", "onEventSelected", "triggerSuccess", "onPlayerArrive", "onPlayerTickNear", "canTriggeredEventRun", "dialogueEvent", "addDialogueOptionFilters", "filters", "", "Lkotlin/Function1;", "Lcom/ruslan/growsseth/dialogues/DialogueEntry;", "saveNbtPersistData", "getSaveNbtPersistData", "()Z", "addExtraNbtData", "dialogueData", "Lnet/minecraft/nbt/CompoundTag;", "readExtraNbtData", "saveSharedData", "data", "readSharedData", "playersMadeMess", "playerMadeMess", "playerUuid", "sendDialogueToPlayer", "line", "Lcom/ruslan/growsseth/dialogues/DialogueLineProcessed;", "Companion", "Callbacks", "ruins-of-growsseth"})
@SourceDebugExtension(value={"SMAP\nResearcherDialoguesComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResearcherDialoguesComponent.kt\ncom/ruslan/growsseth/entity/researcher/ResearcherDialoguesComponent\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,381:1\n1734#2,3:382\n535#3:385\n520#3,6:386\n*S KotlinDebug\n*F\n+ 1 ResearcherDialoguesComponent.kt\ncom/ruslan/growsseth/entity/researcher/ResearcherDialoguesComponent\n*L\n103#1:382,3\n206#1:385\n206#1:386,6\n*E\n"})
public final class ResearcherDialoguesComponent
extends BasicDialoguesComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Researcher researcher;
    @NotNull
    private final ResearcherCombatComponent combat;
    @NotNull
    private Set<UUID> playersInCellar;
    @NotNull
    private final Set<UUID> playersWhoMadeMess;
    private int cartographyTablesInTent;
    private int lecternsInTent;
    @NotNull
    private final Set<UUID> playersMetThisEntity;
    private final boolean saveNbtPersistData;
    @NotNull
    private static final Codec<Set<UUID>> CODEC_PLAYERSET;
    @NotNull
    private static final DialogueEvent EV_MAKE_MESS;
    @NotNull
    private static final DialogueEvent EV_FIX_MESS;
    @NotNull
    private static final DialogueEvent EV_REFUSE_TRADE;
    @NotNull
    private static final DialogueEvent EV_BREAK_TENT;
    @NotNull
    private static final DialogueEvent EV_RETURN_DONKEY;
    @NotNull
    private static final DialogueEvent EV_CELLAR;
    @NotNull
    private static final DialogueEvent EV_CELLAR_EXIT;
    @NotNull
    private static final DialogueEvent EV_BORROW_DONKEY;
    @NotNull
    private static final DialogueEvent EV_BORROW_DONKEY_HEALED;
    @NotNull
    private static final DialogueEvent EV_PLAYER_CHEATS;
    @NotNull
    private static final DialogueEvent EV_KILL_PLAYER;
    @NotNull
    private static final DialogueEvent EV_PLAYER_ARRIVE_LAST_KILLED;
    @NotNull
    private static final DialogueEvent EV_HIT_BY_PLAYER_IMMORTAL;
    @NotNull
    private static final DialogueEvent EV_ARRIVE_NEW_LOCATION;
    @NotNull
    private static final List<DialogueEvent> AGGRESSIVE_DIALOGUE_EVENTS_ALLOWED;
    @NotNull
    public static final String DDATA_MADE_MESS = "madeMess";
    @NotNull
    public static final String DDATA_SOUND = "sound";
    @NotNull
    public static final String DDATA_SINGLE_ONLY = "singleOnly";
    @NotNull
    private static final Set<Block> BREAK_BLOCK_BLACKLIST;

    public ResearcherDialoguesComponent(@NotNull Researcher researcher, @NotNull RandomSource random, @NotNull ResearcherCombatComponent combat) {
        Intrinsics.checkNotNullParameter((Object)researcher, (String)"researcher");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        Intrinsics.checkNotNullParameter((Object)combat, (String)"combat");
        super((LivingEntity)researcher, random);
        this.researcher = researcher;
        this.combat = combat;
        this.playersInCellar = new LinkedHashSet();
        this.playersWhoMadeMess = new LinkedHashSet();
        this.cartographyTablesInTent = 1;
        this.lecternsInTent = 1;
        this.playersMetThisEntity = new LinkedHashSet();
        this.setSecondsForAttackDiagRepeat(this.combat.getTicksToCalmDown() / 20);
        this.setMaxCloseHitsForDialogues(this.combat.getMaxHitCounter());
    }

    @NotNull
    public final Researcher getResearcher() {
        return this.researcher;
    }

    @Override
    public void triggerDialogue(@NotNull ServerPlayer player, @NotNull DialogueEvent[] dialogueEvents, @Nullable String eventParam, boolean ignoreEventConditions) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)dialogueEvents, (String)"dialogueEvents");
        if (this.researcher.isAggressive()) {
            int n = dialogueEvents.length;
            for (int i = 0; i < n; ++i) {
                boolean bl;
                DialogueEvent dialogueEvent;
                block5: {
                    dialogueEvent = dialogueEvents[i];
                    Iterable $this$all$iv = AGGRESSIVE_DIALOGUE_EVENTS_ALLOWED;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            DialogueEvent it = (DialogueEvent)element$iv;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual((Object)it, (Object)dialogueEvent)) continue;
                            bl = false;
                            break block5;
                        }
                        bl = true;
                    }
                }
                if (!bl && (!Intrinsics.areEqual((Object)dialogueEvent, (Object)BasicDialogueEvents.INSTANCE.getHIT_BY_PLAYER()) || !this.combat.wantsToKillPlayer((Player)player))) continue;
                return;
            }
        }
        super.triggerDialogue(player, Arrays.copyOf(dialogueEvents, dialogueEvents.length), eventParam, ignoreEventConditions);
    }

    @Override
    protected void changeNearPlayers(@NotNull Set<ServerPlayer> nearPlayers, @NotNull Set<ServerPlayer> farPlayers) {
        Intrinsics.checkNotNullParameter(nearPlayers, (String)"nearPlayers");
        Intrinsics.checkNotNullParameter(farPlayers, (String)"farPlayers");
        Level level = this.getEntity().level();
        Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
        StructureManager structureManager = ((ServerLevel)level).structureManager();
        farPlayers.removeIf(arg_0 -> ResearcherDialoguesComponent.changeNearPlayers$lambda$2(arg_0 -> ResearcherDialoguesComponent.changeNearPlayers$lambda$1(structureManager, arg_0), arg_0));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isInCellar(ServerPlayer player) {
        ResearcherTent tent;
        ResearcherTent researcherTent = tent = this.researcher.getTent();
        BlockPos cellarTrapdoorPos = researcherTent != null ? researcherTent.getCellarTrapdoorPos() : null;
        if (!UtilsKt.notNull(cellarTrapdoorPos)) return false;
        boolean areaCheck = UtilsKt.notNull(tent.getCellarBoundingBox());
        if (!tent.getBoundingBox().isInside((Vec3i)player.blockPosition())) return false;
        if (areaCheck) {
            boolean bl;
            BoundingBox boundingBox = tent.getCellarBoundingBox();
            if (boundingBox != null) {
                if (boundingBox.isInside((Vec3i)player.blockPosition())) {
                    return true;
                }
                bl = false;
            } else {
                bl = false;
            }
            if (bl) return true;
        }
        if (areaCheck) return false;
        if (player.blockPosition().getY() >= cellarTrapdoorPos.getY() - 5) return false;
        return true;
    }

    @Override
    protected void afterPlayersCheck(@NotNull Set<? extends ServerPlayer> nearPlayers, @NotNull Set<? extends ServerPlayer> inbetweenPlayers, @NotNull Set<? extends ServerPlayer> farPlayers) {
        boolean cellarCheck;
        Intrinsics.checkNotNullParameter(nearPlayers, (String)"nearPlayers");
        Intrinsics.checkNotNullParameter(inbetweenPlayers, (String)"inbetweenPlayers");
        Intrinsics.checkNotNullParameter(farPlayers, (String)"farPlayers");
        boolean bl = cellarCheck = !this.researcher.getHealed();
        if (cellarCheck) {
            Set players = SetsKt.plus(nearPlayers, (Iterable)inbetweenPlayers);
            for (ServerPlayer player : players) {
                DialogueEvent[] dialogueEventArray;
                if (player.isSpectator()) continue;
                boolean inCellar = this.isInCellar(player);
                if (inCellar && !this.playersInCellar.contains(player.getUUID())) {
                    UUID uUID = player.getUUID();
                    Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
                    this.playersInCellar.add(uUID);
                    dialogueEventArray = new DialogueEvent[]{EV_CELLAR};
                    NpcDialoguesComponent.DefaultImpls.triggerDialogue$default(this, player, dialogueEventArray, null, false, 12, null);
                    continue;
                }
                if (inCellar || !this.playersInCellar.contains(player.getUUID()) || !this.researcher.hasLineOfSight((Entity)player)) continue;
                this.playersInCellar.remove(player.getUUID());
                dialogueEventArray = new DialogueEvent[]{EV_CELLAR_EXIT};
                NpcDialoguesComponent.DefaultImpls.triggerDialogue$default(this, player, dialogueEventArray, null, false, 12, null);
            }
        } else {
            this.playersInCellar.clear();
        }
    }

    @Override
    protected void incrementEventCount(@NotNull DialogueEvent event, @NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (Intrinsics.areEqual((Object)event, (Object)BasicDialogueEvents.INSTANCE.getHIT_BY_PLAYER())) {
            BasicDialoguesComponent.PlayerData pdata = this.playerDataOrCreate(player);
            pdata.getEventLastTriggerTime().put(event, this.getEntity().level().getGameTime());
            pdata.getEventTriggerCount().put(event, ((Number)pdata.getEventTriggerCount().getOrDefault(event, 0)).intValue() + 1);
            pdata.getEventCloseTriggerCount().put(event, ((Number)this.combat.getHitCounter().getOrDefault(player, (MutableInt)Integer.valueOf(0))).intValue() + 1);
            org.apache.logging.log4j.Level level = org.apache.logging.log4j.Level.INFO;
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"INFO");
            Integer n = pdata.getEventCloseTriggerCount().get(event);
            RuinsOfGrowsseth.Companion.logDev(level, "Triggered " + event + " " + pdata.getEventTriggerCount().get(event) + " times (close " + (n != null ? n : 0) + ")");
        } else {
            super.incrementEventCount(event, player);
        }
    }

    @Override
    protected void onEventSelected(@NotNull DialogueEvent event, @Nullable String eventParam, @NotNull ServerPlayer player, boolean triggerSuccess) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        super.onEventSelected(event, eventParam, player, triggerSuccess);
        DialogueEvent dialogueEvent = event;
        if (Intrinsics.areEqual((Object)dialogueEvent, (Object)EV_MAKE_MESS)) {
            this.researcher.setAngryForMess(true);
            this.researcher.setUnhappy();
        } else if (Intrinsics.areEqual((Object)dialogueEvent, (Object)EV_FIX_MESS)) {
            this.researcher.setAngryForMess(false);
        } else if (Intrinsics.areEqual((Object)dialogueEvent, (Object)EV_CELLAR) && triggerSuccess) {
            NetworkingUtilsKt.sendPacket$default((ServerPlayer)player, (CustomPacketPayload)new StopMusicPacket(), null, (int)2, null);
            NetworkingUtilsKt.sendPacket$default((ServerPlayer)player, (CustomPacketPayload)new AmbientSoundsPacket(), null, (int)2, null);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void onPlayerArrive(@NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        justMet = this.playersMetThisEntity.contains(player.getUUID()) == false;
        v0 = player.getUUID();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getUUID(...)");
        this.playersMetThisEntity.add(v0);
        this.researcher.getNavigation().moveTo((Entity)this.researcher, 0.6);
        this.researcher.getNavigation().recomputePath();
        var4_3 = this.playerData(player);
        if (var4_3 == null || (var5_4 = var4_3.getEventTriggerCount()) == null) ** GOTO lbl-1000
        var6_5 = var5_4;
        $i$f$filter = false;
        var8_7 = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap<K, V>();
        $i$f$filterTo = false;
        var11_10 = $this$filterTo$iv$iv.entrySet().iterator();
        while (var11_10.hasNext()) {
            it = element$iv$iv = var11_10.next();
            $i$a$-filter-ResearcherDialoguesComponent$onPlayerArrive$triggeredArriveBefore$1 = false;
            var15_14 = new DialogueEvent[]{BasicDialogueEvents.INSTANCE.getPLAYER_ARRIVE_SOON(), BasicDialogueEvents.INSTANCE.getPLAYER_ARRIVE_NIGHT(), BasicDialogueEvents.INSTANCE.getPLAYER_ARRIVE_LONG_TIME(), BasicDialogueEvents.INSTANCE.getPLAYER_ARRIVE()};
            if (!SetsKt.setOf((Object[])var15_14).contains(it.getKey())) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        var6_5 = destination$iv$iv.values();
        if (var6_5 != null) {
            v1 = CollectionsKt.sumOfInt((Iterable)var6_5);
        } else lbl-1000:
        // 2 sources

        {
            v1 = 0;
        }
        v2 = triggeredArriveBefore = v1 > 0;
        if (this.combat.getLastKilledPlayers().contains(player)) {
            var4_3 = new DialogueEvent[]{ResearcherDialoguesComponent.EV_PLAYER_ARRIVE_LAST_KILLED};
            NpcDialoguesComponent.DefaultImpls.triggerDialogue$default(this, player, var4_3, null, false, 12, null);
            this.combat.getLastKilledPlayers().remove(player);
        } else if (ResearcherConfig.singleResearcher && justMet && triggeredArriveBefore) {
            var4_3 = new DialogueEvent[]{ResearcherDialoguesComponent.EV_ARRIVE_NEW_LOCATION};
            NpcDialoguesComponent.DefaultImpls.triggerDialogue$default(this, player, var4_3, null, false, 12, null);
        } else {
            super.onPlayerArrive(player);
        }
    }

    @Override
    protected void onPlayerTickNear(@NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (this.combat.getLastKilledPlayers().contains(player)) {
            DialogueEvent[] dialogueEventArray = new DialogueEvent[]{EV_PLAYER_ARRIVE_LAST_KILLED};
            NpcDialoguesComponent.DefaultImpls.triggerDialogue$default(this, player, dialogueEventArray, null, false, 12, null);
            this.combat.getLastKilledPlayers().remove(player);
        } else {
            super.onPlayerTickNear(player);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean canTriggeredEventRun(@NotNull ServerPlayer player, @NotNull DialogueEvent dialogueEvent) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)dialogueEvent, (String)"dialogueEvent");
        if (!super.canTriggeredEventRun(player, dialogueEvent)) return false;
        DialogueEvent dialogueEvent2 = dialogueEvent;
        if (Intrinsics.areEqual((Object)dialogueEvent2, (Object)EV_MAKE_MESS)) {
            if (this.playersMadeMess()) return false;
            return true;
        }
        if (!Intrinsics.areEqual((Object)dialogueEvent2, (Object)EV_FIX_MESS)) {
            if (!Intrinsics.areEqual((Object)dialogueEvent2, (Object)EV_BREAK_TENT)) return true;
            if (this.playersInCellar.contains(player.getUUID())) return false;
            return true;
        }
        boolean bl = this.playersMadeMess();
        if (!bl) return false;
        return true;
    }

    @Override
    protected void addDialogueOptionFilters(@NotNull List<Function1<DialogueEntry, Boolean>> filters, @NotNull ServerPlayer player, @NotNull DialogueEvent event, @Nullable String eventParam) {
        Intrinsics.checkNotNullParameter(filters, (String)"filters");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        super.addDialogueOptionFilters(filters, player, event, eventParam);
        filters.add((Function1<DialogueEntry, Boolean>)((Function1)ResearcherDialoguesComponent::addDialogueOptionFilters$lambda$4));
        if (!this.researcher.getAngryForMess()) {
            filters.add((Function1<DialogueEntry, Boolean>)((Function1)ResearcherDialoguesComponent::addDialogueOptionFilters$lambda$5));
        }
    }

    @Override
    protected boolean getSaveNbtPersistData() {
        return this.saveNbtPersistData;
    }

    @Override
    protected void addExtraNbtData(@NotNull CompoundTag dialogueData) {
        Intrinsics.checkNotNullParameter((Object)dialogueData, (String)"dialogueData");
        super.addExtraNbtData(dialogueData);
        NbtUtilsKt.saveField((CompoundTag)dialogueData, (String)"PlayersWhoMadeMess", CODEC_PLAYERSET, (Function0)((Function0)new PropertyReference0Impl(this){

            public Object get() {
                return ResearcherDialoguesComponent.access$getPlayersWhoMadeMess$p((ResearcherDialoguesComponent)this.receiver);
            }
        }));
        PrimitiveCodec primitiveCodec = Codec.INT;
        Intrinsics.checkNotNullExpressionValue((Object)primitiveCodec, (String)"INT");
        NbtUtilsKt.saveField((CompoundTag)dialogueData, (String)"CartographyTablesInTent", (Codec)((Codec)primitiveCodec), (Function0)((Function0)new MutablePropertyReference0Impl(this){

            public Object get() {
                return ResearcherDialoguesComponent.access$getCartographyTablesInTent$p((ResearcherDialoguesComponent)this.receiver);
            }

            public void set(Object value) {
                ResearcherDialoguesComponent.access$setCartographyTablesInTent$p((ResearcherDialoguesComponent)this.receiver, ((Number)value).intValue());
            }
        }));
        PrimitiveCodec primitiveCodec2 = Codec.INT;
        Intrinsics.checkNotNullExpressionValue((Object)primitiveCodec2, (String)"INT");
        NbtUtilsKt.saveField((CompoundTag)dialogueData, (String)"LecternsInTent", (Codec)((Codec)primitiveCodec2), (Function0)((Function0)new MutablePropertyReference0Impl(this){

            public Object get() {
                return ResearcherDialoguesComponent.access$getLecternsInTent$p((ResearcherDialoguesComponent)this.receiver);
            }

            public void set(Object value) {
                ResearcherDialoguesComponent.access$setLecternsInTent$p((ResearcherDialoguesComponent)this.receiver, ((Number)value).intValue());
            }
        }));
        NbtUtilsKt.saveField((CompoundTag)dialogueData, (String)"PlayersInCellar", CODEC_PLAYERSET, (Function0)((Function0)new MutablePropertyReference0Impl(this){

            public Object get() {
                return ResearcherDialoguesComponent.access$getPlayersInCellar$p((ResearcherDialoguesComponent)this.receiver);
            }

            public void set(Object value) {
                ResearcherDialoguesComponent.access$setPlayersInCellar$p((ResearcherDialoguesComponent)this.receiver, (Set)value);
            }
        }));
        NbtUtilsKt.saveField((CompoundTag)dialogueData, (String)"PlayersMetThisEntity", CODEC_PLAYERSET, (Function0)((Function0)new PropertyReference0Impl(this){

            public Object get() {
                return ResearcherDialoguesComponent.access$getPlayersMetThisEntity$p((ResearcherDialoguesComponent)this.receiver);
            }
        }));
    }

    @Override
    protected void readExtraNbtData(@NotNull CompoundTag dialogueData) {
        Intrinsics.checkNotNullParameter((Object)dialogueData, (String)"dialogueData");
        super.readExtraNbtData(dialogueData);
        NbtUtilsKt.loadField((CompoundTag)dialogueData, (String)"PlayersWhoMadeMess", CODEC_PLAYERSET, arg_0 -> ResearcherDialoguesComponent.readExtraNbtData$lambda$6(this, arg_0));
        PrimitiveCodec primitiveCodec = Codec.INT;
        Intrinsics.checkNotNullExpressionValue((Object)primitiveCodec, (String)"INT");
        NbtUtilsKt.loadField((CompoundTag)dialogueData, (String)"CartographyTablesInTent", (Codec)((Codec)primitiveCodec), arg_0 -> ResearcherDialoguesComponent.readExtraNbtData$lambda$7(this, arg_0));
        PrimitiveCodec primitiveCodec2 = Codec.INT;
        Intrinsics.checkNotNullExpressionValue((Object)primitiveCodec2, (String)"INT");
        NbtUtilsKt.loadField((CompoundTag)dialogueData, (String)"LecternsInTent", (Codec)((Codec)primitiveCodec2), arg_0 -> ResearcherDialoguesComponent.readExtraNbtData$lambda$8(this, arg_0));
        NbtUtilsKt.loadField((CompoundTag)dialogueData, (String)"PlayersInCellar", CODEC_PLAYERSET, arg_0 -> ResearcherDialoguesComponent.readExtraNbtData$lambda$9(this, arg_0));
        this.playersMetThisEntity.clear();
        NbtUtilsKt.loadField((CompoundTag)dialogueData, (String)"PlayersMetThisEntity", CODEC_PLAYERSET, arg_0 -> ResearcherDialoguesComponent.readExtraNbtData$lambda$10(this, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    public final void saveSharedData(@NotNull CompoundTag data) {
        void $this$saveSharedData_u24lambda_u2411;
        CompoundTag compoundTag;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        CompoundTag compoundTag2 = compoundTag = new CompoundTag();
        String string = "SharedDialogueData";
        CompoundTag compoundTag3 = data;
        boolean bl = false;
        Codec codec = UUIDUtil.STRING_CODEC;
        Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"STRING_CODEC");
        NbtUtilsKt.saveField((CompoundTag)$this$saveSharedData_u24lambda_u2411, (String)"savedPlayersData", (Codec)CodecUtilsKt.mutableMapCodec((Codec)codec, BasicDialoguesComponent.Companion.getPLAYER_DATA_CODEC()), (Function0)((Function0)new PropertyReference0Impl(this){

            public Object get() {
                return ResearcherDialoguesComponent.access$getSavedPlayersData((ResearcherDialoguesComponent)this.receiver);
            }
        }));
        Unit unit = Unit.INSTANCE;
        compoundTag3.put(string, (Tag)compoundTag);
    }

    public final void readSharedData(@NotNull CompoundTag data) {
        CompoundTag compoundTag;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.getSavedPlayersData().clear();
        CompoundTag $this$readSharedData_u24lambda_u2413 = compoundTag = data.getCompound("SharedDialogueData");
        boolean bl = false;
        Intrinsics.checkNotNull((Object)$this$readSharedData_u24lambda_u2413);
        Codec codec = UUIDUtil.STRING_CODEC;
        Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"STRING_CODEC");
        NbtUtilsKt.loadField((CompoundTag)$this$readSharedData_u24lambda_u2413, (String)"savedPlayersData", (Codec)CodecUtilsKt.mutableMapCodec((Codec)codec, BasicDialoguesComponent.Companion.getPLAYER_DATA_CODEC()), arg_0 -> ResearcherDialoguesComponent.readSharedData$lambda$13$lambda$12(this, arg_0));
    }

    public final boolean playersMadeMess() {
        return !((Collection)this.playersWhoMadeMess).isEmpty();
    }

    public final boolean playerMadeMess(@NotNull UUID playerUuid) {
        Intrinsics.checkNotNullParameter((Object)playerUuid, (String)"playerUuid");
        return this.playersWhoMadeMess.contains(playerUuid);
    }

    @Override
    public void sendDialogueToPlayer(@NotNull ServerPlayer player, @NotNull DialogueLineProcessed line) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        super.sendDialogueToPlayer(player, line);
        String soundData = line.getDialogue().getData().get(DDATA_SOUND);
        if (!Intrinsics.areEqual((Object)soundData, (Object)"none")) {
            if (Intrinsics.areEqual((Object)soundData, (Object)"angry")) {
                this.researcher.playSound(GrowssethSounds.Companion.getRESEARCHER_NO());
            } else {
                this.researcher.playAmbientSound();
            }
            this.researcher.resetAmbientSoundTime();
        }
    }

    private static final boolean changeNearPlayers$lambda$1(StructureManager $structureManager, ServerPlayer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        StructureStart struct = $structureManager.getStructureWithPieceAt(it.blockPosition(), GrowssethTags.StructTags.INSTANCE.getRESEARCHER_TENT());
        return struct.isValid() ? struct.getBoundingBox().inflatedBy(5).isInside((Vec3i)it.blockPosition()) : false;
    }

    private static final boolean changeNearPlayers$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean addDialogueOptionFilters$lambda$4(DialogueEntry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        return !Intrinsics.areEqual((Object)entry.getData().get(DDATA_SINGLE_ONLY), (Object)"true") || ResearcherConfig.singleResearcher;
    }

    private static final boolean addDialogueOptionFilters$lambda$5(DialogueEntry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        return !Intrinsics.areEqual((Object)entry.getData().get(DDATA_MADE_MESS), (Object)"true");
    }

    private static final Unit readExtraNbtData$lambda$6(ResearcherDialoguesComponent this$0, Set it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.playersWhoMadeMess.addAll(it);
        return Unit.INSTANCE;
    }

    private static final Unit readExtraNbtData$lambda$7(ResearcherDialoguesComponent this$0, Integer it) {
        this$0.cartographyTablesInTent = it;
        return Unit.INSTANCE;
    }

    private static final Unit readExtraNbtData$lambda$8(ResearcherDialoguesComponent this$0, Integer it) {
        this$0.lecternsInTent = it;
        return Unit.INSTANCE;
    }

    private static final Unit readExtraNbtData$lambda$9(ResearcherDialoguesComponent this$0, Set it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.playersInCellar = CollectionsKt.toMutableSet((Iterable)it);
        return Unit.INSTANCE;
    }

    private static final Unit readExtraNbtData$lambda$10(ResearcherDialoguesComponent this$0, Set it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.playersMetThisEntity.addAll(it);
        return Unit.INSTANCE;
    }

    private static final Unit readSharedData$lambda$13$lambda$12(ResearcherDialoguesComponent this$0, Map it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.getSavedPlayersData().putAll(it);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Set access$getPlayersInCellar$p(ResearcherDialoguesComponent $this) {
        return $this.playersInCellar;
    }

    public static final /* synthetic */ void access$setPlayersInCellar$p(ResearcherDialoguesComponent $this, Set set) {
        $this.playersInCellar = set;
    }

    public static final /* synthetic */ Set access$getPlayersMetThisEntity$p(ResearcherDialoguesComponent $this) {
        return $this.playersMetThisEntity;
    }

    public static final /* synthetic */ Map access$getSavedPlayersData(ResearcherDialoguesComponent $this) {
        return $this.getSavedPlayersData();
    }

    static {
        Codec codec = CodecUtils.setOf((Codec)UUIDUtil.STRING_CODEC);
        Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"setOf(...)");
        CODEC_PLAYERSET = codec;
        EV_MAKE_MESS = DialogueEvent.Companion.event$default(DialogueEvent.Companion, "makeMess", null, null, false, true, false, false, 110, null);
        EV_FIX_MESS = DialogueEvent.Companion.event$default(DialogueEvent.Companion, "fixMess", null, null, false, true, false, false, 110, null);
        EV_REFUSE_TRADE = DialogueEvent.Companion.event$default(DialogueEvent.Companion, "refuseTrade", null, null, false, true, false, false, 110, null);
        EV_BREAK_TENT = DialogueEvent.Companion.event$default(DialogueEvent.Companion, "breakTent", null, null, false, true, false, false, 110, null);
        EV_RETURN_DONKEY = DialogueEvent.Companion.event$default(DialogueEvent.Companion, "returnDonkey", null, null, false, true, false, false, 110, null);
        EV_CELLAR = DialogueEvent.Companion.event$default(DialogueEvent.Companion, "exploreCellar", null, null, false, true, false, false, 46, null);
        EV_CELLAR_EXIT = DialogueEvent.Companion.event$default(DialogueEvent.Companion, "exitCellar", null, null, false, true, false, false, 46, null);
        EV_BORROW_DONKEY = DialogueEvent.Companion.event$default(DialogueEvent.Companion, "borrowDonkey", null, null, false, true, false, false, 110, null);
        EV_BORROW_DONKEY_HEALED = DialogueEvent.Companion.event$default(DialogueEvent.Companion, "borrowDonkeyHealed", null, null, false, true, false, false, 110, null);
        EV_PLAYER_CHEATS = DialogueEvent.Companion.event$default(DialogueEvent.Companion, "playerCheats", null, null, false, true, false, false, 110, null);
        EV_KILL_PLAYER = DialogueEvent.Companion.event$default(DialogueEvent.Companion, "killPlayer", null, null, false, true, false, false, 110, null);
        EV_PLAYER_ARRIVE_LAST_KILLED = DialogueEvent.Companion.event$default(DialogueEvent.Companion, "playerArriveAfterKilled", null, null, false, false, false, false, 126, null);
        EV_HIT_BY_PLAYER_IMMORTAL = DialogueEvent.Companion.event$default(DialogueEvent.Companion, "hitByPlayerImmortal", null, null, false, true, false, false, 110, null);
        EV_ARRIVE_NEW_LOCATION = DialogueEvent.Companion.event$default(DialogueEvent.Companion, "playerArriveNewLocation", null, null, true, false, false, false, 118, null);
        Object[] objectArray = new DialogueEvent[]{BasicDialogueEvents.INSTANCE.getDEATH(), BasicDialogueEvents.INSTANCE.getLOW_HEALTH(), EV_PLAYER_CHEATS, EV_KILL_PLAYER, BasicDialogueEvents.INSTANCE.getHIT_BY_PLAYER()};
        AGGRESSIVE_DIALOGUE_EVENTS_ALLOWED = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new Block[]{Blocks.WHITE_CARPET};
        BREAK_BLOCK_BLACKLIST = SetsKt.mutableSetOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ6\u0010\u000e\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013J \u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00152\u0006\u0010\u0006\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0018"}, d2={"Lcom/ruslan/growsseth/entity/researcher/ResearcherDialoguesComponent$Callbacks;", "", "<init>", "()V", "onBlockBreak", "", "level", "Lnet/minecraft/world/level/Level;", "player", "Lnet/minecraft/world/entity/player/Player;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "onPlaceBlock", "placeContext", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "blockState", "item", "Lnet/minecraft/world/item/BlockItem;", "getResearchersNearTentAt", "", "Lcom/ruslan/growsseth/entity/researcher/Researcher;", "Lnet/minecraft/server/level/ServerLevel;", "ruins-of-growsseth"})
    @SourceDebugExtension(value={"SMAP\nResearcherDialoguesComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResearcherDialoguesComponent.kt\ncom/ruslan/growsseth/entity/researcher/ResearcherDialoguesComponent$Callbacks\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,381:1\n1863#2,2:382\n1863#2,2:384\n1863#2,2:386\n*S KotlinDebug\n*F\n+ 1 ResearcherDialoguesComponent.kt\ncom/ruslan/growsseth/entity/researcher/ResearcherDialoguesComponent$Callbacks\n*L\n327#1:382,2\n341#1:384,2\n353#1:386,2\n*E\n"})
    public static final class Callbacks {
        @NotNull
        public static final Callbacks INSTANCE = new Callbacks();

        private Callbacks() {
        }

        public final void onBlockBreak(@NotNull Level level, @NotNull Player player, @NotNull BlockPos pos, @NotNull BlockState state) {
            block9: {
                block8: {
                    Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                    Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                    Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
                    Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                    if (!(level instanceof ServerLevel)) {
                        return;
                    }
                    if (!state.is(GrowssethTags.INSTANCE.getRESEARCHER_MESS_TRIGGER())) break block8;
                    List<Researcher> list = this.getResearchersNearTentAt((ServerLevel)level, pos);
                    if (list == null) {
                        return;
                    }
                    List<Researcher> researchersInBounds = list;
                    Iterable $this$forEach$iv = researchersInBounds;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        ResearcherDialoguesComponent dialogues;
                        Researcher it = (Researcher)element$iv;
                        boolean bl = false;
                        Intrinsics.checkNotNull((Object)it.getDialogues());
                        if (state.is(Blocks.CARTOGRAPHY_TABLE)) {
                            int n = dialogues.cartographyTablesInTent;
                            dialogues.cartographyTablesInTent = n + -1;
                        } else if (state.is(Blocks.LECTERN)) {
                            int n = dialogues.lecternsInTent;
                            dialogues.lecternsInTent = n + -1;
                        }
                        if (dialogues.cartographyTablesInTent >= 1 && dialogues.lecternsInTent >= 1) continue;
                        DialogueEvent[] dialogueEventArray = new DialogueEvent[]{Companion.getEV_MAKE_MESS()};
                        NpcDialoguesComponent.DefaultImpls.triggerDialogue$default(dialogues, (ServerPlayer)player, dialogueEventArray, null, false, 12, null);
                        Set set = dialogues.playersWhoMadeMess;
                        UUID uUID = ((ServerPlayer)player).getUUID();
                        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
                        set.add(uUID);
                    }
                    break block9;
                }
                if (!state.is(GrowssethTags.INSTANCE.getTENT_MATERIALS_WHITELIST()) || Companion.getBREAK_BLOCK_BLACKLIST().contains(state.getBlock())) break block9;
                List<Researcher> list = this.getResearchersNearTentAt((ServerLevel)level, pos);
                if (list == null) {
                    return;
                }
                List<Researcher> researchersInBounds = list;
                Iterable $this$forEach$iv = researchersInBounds;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Researcher it = (Researcher)element$iv;
                    boolean bl = false;
                    ResearcherDialoguesComponent researcherDialoguesComponent = it.getDialogues();
                    if (researcherDialoguesComponent == null) continue;
                    DialogueEvent[] dialogueEventArray = new DialogueEvent[]{Companion.getEV_BREAK_TENT()};
                    NpcDialoguesComponent.DefaultImpls.triggerDialogue$default(researcherDialoguesComponent, (ServerPlayer)player, dialogueEventArray, null, false, 12, null);
                }
            }
        }

        public final void onPlaceBlock(@NotNull Player player, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockPlaceContext placeContext, @NotNull BlockState blockState, @NotNull BlockItem item) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)placeContext, (String)"placeContext");
            Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            if (!(level instanceof ServerLevel)) {
                return;
            }
            if (!blockState.is(GrowssethTags.INSTANCE.getRESEARCHER_MESS_TRIGGER())) {
                return;
            }
            if (player.isSpectator()) {
                return;
            }
            List<Researcher> list = this.getResearchersNearTentAt((ServerLevel)level, pos);
            if (list == null) {
                return;
            }
            List<Researcher> researchersInBounds = list;
            Iterable $this$forEach$iv = researchersInBounds;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ResearcherDialoguesComponent dialogues;
                Researcher it = (Researcher)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it.getDialogues());
                if (blockState.is(Blocks.CARTOGRAPHY_TABLE)) {
                    int n = dialogues.cartographyTablesInTent;
                    dialogues.cartographyTablesInTent = n + 1;
                } else if (blockState.is(Blocks.LECTERN)) {
                    int n = dialogues.lecternsInTent;
                    dialogues.lecternsInTent = n + 1;
                }
                if (dialogues.cartographyTablesInTent < 1 || dialogues.lecternsInTent < 1) continue;
                DialogueEvent[] dialogueEventArray = new DialogueEvent[]{Companion.getEV_FIX_MESS()};
                NpcDialoguesComponent.DefaultImpls.triggerDialogue$default(dialogues, (ServerPlayer)player, dialogueEventArray, null, false, 12, null);
                dialogues.playersWhoMadeMess.clear();
            }
        }

        private final List<Researcher> getResearchersNearTentAt(ServerLevel level, BlockPos pos) {
            StructureManager structureManager = level.structureManager();
            StructureStart structureStart = structureManager.getStructureWithPieceAt(pos, GrowssethTags.StructTags.INSTANCE.getRESEARCHER_TENT());
            if (structureStart.isValid()) {
                BoundingBox tentBbox = structureStart.getBoundingBox();
                double bboxInflation = 15.0;
                return level.getEntitiesOfClass(Researcher.class, AABB.of((BoundingBox)tentBbox).inflate(bboxInflation, 0.0, bboxInflation));
            }
            return null;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u001d\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0010\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u0011\u0010\u0012\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\rR\u0011\u0010\u0014\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\rR\u0011\u0010\u0016\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\rR\u0011\u0010\u0018\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\rR\u0011\u0010\u001a\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\rR\u0011\u0010\u001c\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\rR\u0011\u0010\u001e\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\rR\u0011\u0010 \u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\rR\u0011\u0010\"\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\rR\u0011\u0010$\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\rR\u0011\u0010&\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\rR\u0017\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000b0)\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u000e\u0010,\u001a\u00020-X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020-X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020-X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u00100\u001a\b\u0012\u0004\u0012\u0002010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103\u00a8\u00064"}, d2={"Lcom/ruslan/growsseth/entity/researcher/ResearcherDialoguesComponent$Companion;", "", "<init>", "()V", "CODEC_PLAYERSET", "Lcom/mojang/serialization/Codec;", "", "Ljava/util/UUID;", "getCODEC_PLAYERSET", "()Lcom/mojang/serialization/Codec;", "EV_MAKE_MESS", "Lcom/ruslan/growsseth/dialogues/DialogueEvent;", "getEV_MAKE_MESS", "()Lcom/ruslan/growsseth/dialogues/DialogueEvent;", "EV_FIX_MESS", "getEV_FIX_MESS", "EV_REFUSE_TRADE", "getEV_REFUSE_TRADE", "EV_BREAK_TENT", "getEV_BREAK_TENT", "EV_RETURN_DONKEY", "getEV_RETURN_DONKEY", "EV_CELLAR", "getEV_CELLAR", "EV_CELLAR_EXIT", "getEV_CELLAR_EXIT", "EV_BORROW_DONKEY", "getEV_BORROW_DONKEY", "EV_BORROW_DONKEY_HEALED", "getEV_BORROW_DONKEY_HEALED", "EV_PLAYER_CHEATS", "getEV_PLAYER_CHEATS", "EV_KILL_PLAYER", "getEV_KILL_PLAYER", "EV_PLAYER_ARRIVE_LAST_KILLED", "getEV_PLAYER_ARRIVE_LAST_KILLED", "EV_HIT_BY_PLAYER_IMMORTAL", "getEV_HIT_BY_PLAYER_IMMORTAL", "EV_ARRIVE_NEW_LOCATION", "getEV_ARRIVE_NEW_LOCATION", "AGGRESSIVE_DIALOGUE_EVENTS_ALLOWED", "", "getAGGRESSIVE_DIALOGUE_EVENTS_ALLOWED", "()Ljava/util/List;", "DDATA_MADE_MESS", "", "DDATA_SOUND", "DDATA_SINGLE_ONLY", "BREAK_BLOCK_BLACKLIST", "Lnet/minecraft/world/level/block/Block;", "getBREAK_BLOCK_BLACKLIST", "()Ljava/util/Set;", "ruins-of-growsseth"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Codec<Set<UUID>> getCODEC_PLAYERSET() {
            return CODEC_PLAYERSET;
        }

        @NotNull
        public final DialogueEvent getEV_MAKE_MESS() {
            return EV_MAKE_MESS;
        }

        @NotNull
        public final DialogueEvent getEV_FIX_MESS() {
            return EV_FIX_MESS;
        }

        @NotNull
        public final DialogueEvent getEV_REFUSE_TRADE() {
            return EV_REFUSE_TRADE;
        }

        @NotNull
        public final DialogueEvent getEV_BREAK_TENT() {
            return EV_BREAK_TENT;
        }

        @NotNull
        public final DialogueEvent getEV_RETURN_DONKEY() {
            return EV_RETURN_DONKEY;
        }

        @NotNull
        public final DialogueEvent getEV_CELLAR() {
            return EV_CELLAR;
        }

        @NotNull
        public final DialogueEvent getEV_CELLAR_EXIT() {
            return EV_CELLAR_EXIT;
        }

        @NotNull
        public final DialogueEvent getEV_BORROW_DONKEY() {
            return EV_BORROW_DONKEY;
        }

        @NotNull
        public final DialogueEvent getEV_BORROW_DONKEY_HEALED() {
            return EV_BORROW_DONKEY_HEALED;
        }

        @NotNull
        public final DialogueEvent getEV_PLAYER_CHEATS() {
            return EV_PLAYER_CHEATS;
        }

        @NotNull
        public final DialogueEvent getEV_KILL_PLAYER() {
            return EV_KILL_PLAYER;
        }

        @NotNull
        public final DialogueEvent getEV_PLAYER_ARRIVE_LAST_KILLED() {
            return EV_PLAYER_ARRIVE_LAST_KILLED;
        }

        @NotNull
        public final DialogueEvent getEV_HIT_BY_PLAYER_IMMORTAL() {
            return EV_HIT_BY_PLAYER_IMMORTAL;
        }

        @NotNull
        public final DialogueEvent getEV_ARRIVE_NEW_LOCATION() {
            return EV_ARRIVE_NEW_LOCATION;
        }

        @NotNull
        public final List<DialogueEvent> getAGGRESSIVE_DIALOGUE_EVENTS_ALLOWED() {
            return AGGRESSIVE_DIALOGUE_EVENTS_ALLOWED;
        }

        @NotNull
        public final Set<Block> getBREAK_BLOCK_BLACKLIST() {
            return BREAK_BLOCK_BLACKLIST;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

