/*
 * Decompiled with CFR 0.152.
 */
package com.ruslan.growsseth.entity.researcher;

import com.filloax.fxlib.api.FxItemUtils;
import com.filloax.fxlib.api.FxItemUtilsKt;
import com.filloax.fxlib.api.UtilsKt;
import com.filloax.fxlib.api.codec.CodecUtilsKt;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.PrimitiveCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.ruslan.growsseth.GrowssethTags;
import com.ruslan.growsseth.RuinsOfGrowsseth;
import com.ruslan.growsseth.advancements.StructureAdvancements;
import com.ruslan.growsseth.config.GrowssethConfig;
import com.ruslan.growsseth.config.ResearcherConfig;
import com.ruslan.growsseth.entity.researcher.CustomRemoteDiaries;
import com.ruslan.growsseth.entity.researcher.DiaryHelper;
import com.ruslan.growsseth.entity.researcher.Researcher;
import com.ruslan.growsseth.entity.researcher.ResearcherDiaryComponent;
import com.ruslan.growsseth.structure.GrowssethStructures;
import com.ruslan.growsseth.structure.StructureVisitTracker;
import com.ruslan.growsseth.templates.BookData;
import com.ruslan.growsseth.templates.BookTemplates;
import com.ruslan.growsseth.templates.TemplateKind;
import com.ruslan.growsseth.templates.TemplateListener;
import com.ruslan.growsseth.utils.GrowssethCodecs;
import com.ruslan.growsseth.worldgen.worldpreset.GrowssethWorldPreset;
import java.lang.invoke.LambdaMetafactory;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KProperty1;
import kotlin.text.StringsKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.LecternBlockEntity;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 C2\u00020\u0001:\u0003CDEB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0017\u001a\u00020\u0018J\u0014\u0010\u0019\u001a\u00020\u00182\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0016\u0010!\u001a\u00020\u001e2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002J\u0016\u0010#\u001a\u00020\u001e2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002J,\u0010$\u001a\u00020\u001e2\u000e\u0010%\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010 0&2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u00180(H\u0002J@\u0010$\u001a\u00020\u001e2\u000e\u0010%\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010 0&2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u00180(2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020\u00180(H\u0002J\u0016\u0010+\u001a\u00020\u00182\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020-J\u0010\u0010/\u001a\u00020\u00182\u0006\u00100\u001a\u00020*H\u0002J\b\u00104\u001a\u00020\u001eH\u0002J\b\u00105\u001a\u00020\u001eH\u0002J\u000e\u00106\u001a\b\u0012\u0004\u0012\u00020807H\u0002J\b\u00109\u001a\u00020\u0018H\u0002J,\u0010:\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001e0;2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020\u001e2\u0006\u0010?\u001a\u00020\u001eH\u0002J\u000e\u0010@\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020AJ\u000e\u0010B\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020AR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u00101\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0302X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lcom/ruslan/growsseth/entity/researcher/ResearcherDiaryComponent;", "", "researcher", "Lcom/ruslan/growsseth/entity/researcher/Researcher;", "<init>", "(Lcom/ruslan/growsseth/entity/researcher/Researcher;)V", "getResearcher", "()Lcom/ruslan/growsseth/entity/researcher/Researcher;", "updatePeriod", "", "getUpdatePeriod", "()I", "value", "Lcom/ruslan/growsseth/entity/researcher/ResearcherDiaryComponent$DiaryData;", "data", "getData", "()Lcom/ruslan/growsseth/entity/researcher/ResearcherDiaryComponent$DiaryData;", "level", "Lnet/minecraft/server/level/ServerLevel;", "lecternBlockEntity", "Lnet/minecraft/world/level/block/entity/LecternBlockEntity;", "previousDiariesChestBlockEntity", "Lnet/minecraft/world/level/block/entity/ChestBlockEntity;", "aiStep", "", "trackRandomMapStructure", "tag", "Lnet/minecraft/tags/TagKey;", "Lnet/minecraft/world/level/levelgen/structure/Structure;", "makeEventDiary", "", "customDiaryData", "Lcom/ruslan/growsseth/templates/BookData;", "hasStructureDiary", "forStructure", "makeStructureDiary", "makeDiary", "selector", "Lkotlin/Function0;", "done", "Lkotlin/Function1;", "doOnDiary", "Lnet/minecraft/world/item/ItemStack;", "makeArbitraryDiary", "name", "", "content", "pushDiaryToContainers", "book", "printedWarningFor", "", "Lnet/minecraft/resources/ResourceKey;", "updateUnlockedStructuresGlobal", "updateUnlockedStructuresOnlyTracked", "getPossiblePlayersToCheck", "", "Lnet/minecraft/server/level/ServerPlayer;", "findBlockEntsIfNull", "checkBlockPosForEnt", "Lkotlin/Pair;", "pos", "Lnet/minecraft/core/BlockPos;", "findLectern", "findChest", "writeNbt", "Lnet/minecraft/nbt/CompoundTag;", "readNbt", "Companion", "DiaryData", "Callbacks", "ruins-of-growsseth"})
@SourceDebugExtension(value={"SMAP\nResearcherDiaryComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResearcherDiaryComponent.kt\ncom/ruslan/growsseth/entity/researcher/ResearcherDiaryComponent\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,582:1\n1734#2,3:583\n1557#2:593\n1628#2,3:594\n1863#2:597\n1611#2,9:598\n1863#2:607\n1864#2:609\n1620#2:610\n774#2:611\n865#2,2:612\n1279#2,2:614\n1293#2,4:616\n1864#2:620\n1863#2,2:621\n1557#2:623\n1628#2,3:624\n535#3:586\n520#3,6:587\n1#4:608\n*S KotlinDebug\n*F\n+ 1 ResearcherDiaryComponent.kt\ncom/ruslan/growsseth/entity/researcher/ResearcherDiaryComponent\n*L\n141#1:583,3\n218#1:593\n218#1:594,3\n243#1:597\n245#1:598,9\n245#1:607\n245#1:609\n245#1:610\n252#1:611\n252#1:612,2\n256#1:614,2\n256#1:616,4\n243#1:620\n283#1:621,2\n303#1:623\n303#1:624,3\n150#1:586\n150#1:587,6\n245#1:608\n*E\n"})
public final class ResearcherDiaryComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Researcher researcher;
    private final int updatePeriod;
    @NotNull
    private DiaryData data;
    @NotNull
    private final ServerLevel level;
    @Nullable
    private LecternBlockEntity lecternBlockEntity;
    @Nullable
    private ChestBlockEntity previousDiariesChestBlockEntity;
    @NotNull
    private final Set<ResourceKey<Structure>> printedWarningFor;
    @NotNull
    private static final Codec<DiaryData> PERSIST_CODEC;
    @NotNull
    private static final Map<ServerLevel, Map<ResourceKey<Structure>, TagKey<Structure>>> structToTag;
    @NotNull
    private static final TargetingConditions targetingConditions;
    @Nullable
    private static Map<TagKey<Structure>, BookData> structureDiaries_;
    @Nullable
    private static String lastLanguageCode;

    public ResearcherDiaryComponent(@NotNull Researcher researcher) {
        Intrinsics.checkNotNullParameter((Object)researcher, (String)"researcher");
        this.researcher = researcher;
        this.updatePeriod = UtilsKt.secondsToTicks((float)1.0f);
        this.data = new DiaryData(null, null, null, 7, null);
        Level level = this.researcher.level();
        Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
        this.level = (ServerLevel)level;
        this.printedWarningFor = new LinkedHashSet();
    }

    @NotNull
    public final Researcher getResearcher() {
        return this.researcher;
    }

    public final int getUpdatePeriod() {
        return this.updatePeriod;
    }

    @NotNull
    public final DiaryData getData() {
        return this.data;
    }

    /*
     * WARNING - void declaration
     */
    public final void aiStep() {
        block13: {
            void $this$filterTo$iv$iv;
            block15: {
                block14: {
                    boolean bl;
                    block12: {
                        boolean anyNew;
                        if (!ResearcherConfig.researcherWritesDiaries) {
                            return;
                        }
                        if (this.researcher.tickCount % this.updatePeriod != 0) break block13;
                        ResearcherDiaryComponent.Companion.checkLanguageChanged();
                        boolean bl2 = anyNew = ResearcherConfig.singleResearcher ? this.updateUnlockedStructuresGlobal() : this.updateUnlockedStructuresOnlyTracked();
                        if (anyNew) break block14;
                        Iterable $this$all$iv = this.data.getRecordedStructures().values();
                        boolean bl3 = false;
                        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                            bl = true;
                        } else {
                            Iterator iterator = $this$all$iv.iterator();
                            while (iterator.hasNext()) {
                                Object element$iv = iterator.next();
                                boolean it = (Boolean)element$iv;
                                boolean bl32 = false;
                                if (it) continue;
                                bl = false;
                                break block12;
                            }
                            bl = true;
                        }
                    }
                    if (bl) break block15;
                }
                for (Map.Entry entry : this.data.getRecordedStructures().entrySet()) {
                    TagKey structKey = (TagKey)entry.getKey();
                    boolean alreadyRecorded = (Boolean)entry.getValue();
                    if (alreadyRecorded) continue;
                    this.data.getRecordedStructures().put((TagKey<Structure>)structKey, this.makeStructureDiary((TagKey<Structure>)structKey));
                }
            }
            Map<String, BookData> map = CustomRemoteDiaries.INSTANCE.getDiaries();
            boolean $i$f$filter = false;
            Map<String, BookData> alreadyRecorded = map;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = iterator.next();
                boolean bl = false;
                if (!(!this.data.getRecordedEvents().contains(it.getKey()))) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            Map newEvents = destination$iv$iv;
            if (!newEvents.isEmpty()) {
                for (Map.Entry entry : newEvents.entrySet()) {
                    String id = (String)entry.getKey();
                    BookData diary = (BookData)entry.getValue();
                    this.makeEventDiary(diary);
                    this.data.getRecordedEvents().add(id);
                }
            }
        }
    }

    public final void trackRandomMapStructure(@NotNull TagKey<Structure> tag) {
        Intrinsics.checkNotNullParameter(tag, (String)"tag");
        if (ResearcherConfig.singleResearcher) {
            return;
        }
        if (!this.data.getTrackedStructures().containsKey(tag)) {
            this.data.getTrackedStructures().put(tag, LocalDateTime.now());
        }
    }

    private final boolean makeEventDiary(BookData customDiaryData) {
        boolean success = this.makeDiary((Function0<BookData>)((Function0)() -> ResearcherDiaryComponent.makeEventDiary$lambda$2(customDiaryData)), (Function1<? super BookData, Unit>)((Function1)ResearcherDiaryComponent::makeEventDiary$lambda$3), (Function1<? super ItemStack, Unit>)((Function1)ResearcherDiaryComponent::makeEventDiary$lambda$5));
        if (!success) {
            RuinsOfGrowsseth.LOGGER.info("Failed in creating custom remote diary " + customDiaryData.getName(), new Object[0]);
            return false;
        }
        return true;
    }

    private final boolean hasStructureDiary(TagKey<Structure> forStructure) {
        return Companion.getStructureDiaries().containsKey(forStructure);
    }

    private final boolean makeStructureDiary(TagKey<Structure> forStructure) {
        if (!this.hasStructureDiary(forStructure)) {
            return false;
        }
        MinecraftServer minecraftServer = this.level.getServer();
        Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
        if (GrowssethWorldPreset.isGrowssethPreset(minecraftServer) && Intrinsics.areEqual(forStructure, GrowssethTags.StructTags.INSTANCE.getBEEKEEPER_HOUSE())) {
            return false;
        }
        Map<TagKey<Structure>, BookData> remoteDiaries = CustomRemoteDiaries.INSTANCE.getStructureReplacementDiaries();
        boolean success = this.makeDiary((Function0<BookData>)((Function0)() -> ResearcherDiaryComponent.makeStructureDiary$lambda$6(remoteDiaries, forStructure)), (Function1<? super BookData, Unit>)((Function1)arg_0 -> ResearcherDiaryComponent.makeStructureDiary$lambda$7(forStructure, arg_0)));
        if (!success) {
            RuinsOfGrowsseth.LOGGER.info("No diary for " + forStructure.location(), new Object[0]);
            return false;
        }
        return true;
    }

    private final boolean makeDiary(Function0<BookData> selector, Function1<? super BookData, Unit> done) {
        return this.makeDiary(selector, done, (Function1<? super ItemStack, Unit>)((Function1)ResearcherDiaryComponent::makeDiary$lambda$8));
    }

    private final boolean makeDiary(Function0<BookData> selector, Function1<? super BookData, Unit> done, Function1<? super ItemStack, Unit> doOnDiary) {
        BookData bookData = (BookData)selector.invoke();
        if (bookData == null) {
            return false;
        }
        BookData diaryData = bookData;
        String string = diaryData.getName();
        if (string == null) {
            string = "???";
        }
        MutableComponent title = Component.literal((String)string);
        List<Component> pages = diaryData.getPagesComponents();
        Intrinsics.checkNotNull((Object)title);
        Component component = (Component)title;
        Component component2 = this.researcher.getName();
        Intrinsics.checkNotNullExpressionValue((Object)component2, (String)"getName(...)");
        ItemStack book = FxItemUtils.createWrittenBook((Component)component, (Component)component2, pages);
        done.invoke((Object)diaryData);
        doOnDiary.invoke((Object)book);
        this.pushDiaryToContainers(book);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final void makeArbitraryDiary(@NotNull String name, @NotNull String content) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        MutableComponent cname = Component.literal((String)name);
        String[] stringArray = new String[]{"==="};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)content, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean $i$f$makeArbitraryDiary$stub_for_inlining = false;
            boolean bl = false;
            collection.add(Component.literal((String)p0));
        }
        List pages = (List)destination$iv$iv;
        Intrinsics.checkNotNull((Object)cname);
        Component component = (Component)cname;
        Component component2 = this.researcher.getName();
        Intrinsics.checkNotNullExpressionValue((Object)component2, (String)"getName(...)");
        ItemStack book = FxItemUtilsKt.createWrittenBook((Component)component, (Component)component2, (List)pages);
        RuinsOfGrowsseth.LOGGER.info("Created test diary " + name + ", recording content...", new Object[0]);
        this.pushDiaryToContainers(book);
    }

    private final void pushDiaryToContainers(ItemStack book) {
        this.findBlockEntsIfNull();
        DiaryHelper.INSTANCE.pushDiaryToContainers(book, this.level, (LivingEntity)this.researcher, this.lecternBlockEntity, this.previousDiariesChestBlockEntity, true);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean updateUnlockedStructuresGlobal() {
        Map<ResourceKey<Structure>, TagKey<Structure>> structToTagLevel;
        boolean found = false;
        Map<ResourceKey<Structure>, TagKey<Structure>> map = structToTag.get(this.level);
        if (map == null) {
            map = structToTag.get(this.level.getServer().overworld());
        }
        if ((structToTagLevel = map) == null) {
            RuinsOfGrowsseth.LOGGER.error("No structToTag initialized for level or overworld in global check! Level is " + this.level, new Object[0]);
            return false;
        }
        List<ServerPlayer> possiblePlayers = this.getPossiblePlayersToCheck();
        Iterable $this$forEach$iv = possiblePlayers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$associateWith$iv;
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            void $this$mapNotNullTo$iv$iv;
            ServerPlayer player = (ServerPlayer)element$iv;
            boolean bl = false;
            Set<ResourceKey<Structure>> unlocked = StructureAdvancements.INSTANCE.getPlayerFoundStructures(player);
            Iterable $this$mapNotNull$iv = unlocked;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach2 = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                TagKey<Structure> it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl2 = false;
                ResourceKey it = (ResourceKey)element$iv$iv;
                boolean bl3 = false;
                TagKey<Structure> tag = structToTagLevel.get(it);
                if (tag == null && !this.printedWarningFor.contains(it)) {
                    RuinsOfGrowsseth.LOGGER.warn("Structure " + it + " doesn't have a corresponding tag defined in GrowssethTags!", new Object[0]);
                    this.printedWarningFor.add((ResourceKey<Structure>)it);
                }
                if (tag == null) continue;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$filter22 = false;
            $this$mapNotNullTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                TagKey p0 = (TagKey)element$iv$iv;
                boolean bl5 = false;
                boolean $i$f$updateUnlockedStructuresGlobal$lambda$12$stub_for_inlining$10 = false;
                if (!this.hasStructureDiary((TagKey<Structure>)p0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List unlockedTags = (List)destination$iv$iv;
            List list = CollectionsKt.minus((Iterable)unlockedTags, (Iterable)this.data.getRecordedStructures().keySet());
            if (!(!((Collection)list).isEmpty())) continue;
            found = true;
            Iterable $i$f$filter22 = list;
            Map<TagKey<Structure>, Boolean> map2 = this.data.getRecordedStructures();
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            void $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                TagKey bl5 = (TagKey)element$iv$iv;
                Object t = element$iv$iv;
                Map map3 = result$iv;
                boolean bl6 = false;
                Boolean bl7 = false;
                map3.put(t, bl7);
            }
            map2.putAll(result$iv);
        }
        return found;
    }

    private final boolean updateUnlockedStructuresOnlyTracked() {
        Map<ResourceKey<Structure>, TagKey<Structure>> structToTagLevel;
        if (this.data.getTrackedStructures().isEmpty()) {
            return false;
        }
        boolean found = false;
        Map<ResourceKey<Structure>, TagKey<Structure>> map = structToTag.get(this.level);
        if (map == null) {
            map = structToTag.get(this.level.getServer().overworld());
        }
        if ((structToTagLevel = map) == null) {
            RuinsOfGrowsseth.LOGGER.error("No structToTag initialized for level or overworld in tracked check! Level is " + this.level, new Object[0]);
            return false;
        }
        List<ServerPlayer> possiblePlayers = this.getPossiblePlayersToCheck();
        Iterable $this$forEach$iv = possiblePlayers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ServerPlayer player = (ServerPlayer)element$iv;
            boolean bl = false;
            for (Map.Entry<TagKey<Structure>, LocalDateTime> entry : this.data.getTrackedStructures().entrySet()) {
                boolean discovered;
                TagKey<Structure> tag = entry.getKey();
                LocalDateTime trackedAt = entry.getValue();
                LocalDateTime localDateTime = StructureVisitTracker.INSTANCE.getLastStructureEnterTime(player, tag);
                boolean bl2 = localDateTime != null ? localDateTime.isAfter(trackedAt) : (discovered = false);
                boolean isNew = !this.data.getRecordedStructures().keySet().contains(tag);
                if (!isNew || !discovered) continue;
                found = true;
                this.data.getRecordedStructures().put(tag, false);
            }
        }
        return found;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ServerPlayer> getPossiblePlayersToCheck() {
        void $this$mapTo$iv$iv;
        double checkRange = 64.0;
        List list = this.level.getNearbyPlayers(targetingConditions, (LivingEntity)this.researcher, AABB.ofSize((Vec3)this.researcher.position(), (double)checkRange, (double)(checkRange / (double)2), (double)checkRange));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getNearbyPlayers(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Player player = (Player)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerPlayer");
            collection.add((ServerPlayer)it);
        }
        return (List)destination$iv$iv;
    }

    /*
     * Unable to fully structure code
     */
    private final void findBlockEntsIfNull() {
        findLectern = new Ref.BooleanRef();
        if (this.lecternBlockEntity == null) ** GOTO lbl-1000
        v0 = this.lecternBlockEntity;
        v1 = v0 != null ? v0.isRemoved() : false;
        if (v1) lbl-1000:
        // 2 sources

        {
            v2 = true;
        } else {
            v2 = false;
        }
        findLectern.element = v2;
        findChest = new Ref.BooleanRef();
        if (this.previousDiariesChestBlockEntity == null) ** GOTO lbl-1000
        v3 = this.previousDiariesChestBlockEntity;
        v4 = v3 != null ? v3.isRemoved() : false;
        if (v4) lbl-1000:
        // 2 sources

        {
            v5 = true;
        } else {
            v5 = false;
        }
        findChest.element = v5;
        attemptInPos = (Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, findBlockEntsIfNull$lambda$15(com.ruslan.growsseth.entity.researcher.ResearcherDiaryComponent kotlin.jvm.internal.Ref$BooleanRef kotlin.jvm.internal.Ref$BooleanRef net.minecraft.core.BlockPos ), (Lnet/minecraft/core/BlockPos;)Lkotlin/Unit;)((ResearcherDiaryComponent)this, (Ref.BooleanRef)findLectern, (Ref.BooleanRef)findChest);
        tent = this.researcher.getTent();
        if (findLectern.element || findChest.element) {
            if (tent == null) {
                searchRange = 10;
                offset = new Vec3i(searchRange, searchRange * 3 / 4, searchRange);
                var8_8 = new BlockPos[]{this.researcher.getStartingPos(), this.researcher.blockPosition()};
                for (BlockPos center : CollectionsKt.listOfNotNull((Object[])var8_8)) {
                    searchArea = BoundingBox.fromCorners((Vec3i)((Vec3i)center.subtract(offset)), (Vec3i)((Vec3i)center.offset(offset)));
                    Intrinsics.checkNotNull((Object)searchArea);
                    UtilsKt.iterBlocks((BoundingBox)searchArea, (Function1)attemptInPos);
                }
            } else {
                v6 = tent.getBoundingBox();
                Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"getBoundingBox(...)");
                v7 = tent.getCellarTrapdoorPos();
                boundingBoxWithoutCellar = UtilsKt.clip$default((BoundingBox)v6, (int)0, (int)(v7 != null ? v7.getY() : tent.getBoundingBox().minY() + 11), (int)0, (int)0, (int)0, (int)0, (int)61, null);
                UtilsKt.iterBlocks((BoundingBox)boundingBoxWithoutCellar, (Function1)attemptInPos);
            }
        }
    }

    private final kotlin.Pair<Boolean, Boolean> checkBlockPosForEnt(BlockPos pos, boolean findLectern, boolean findChest) {
        boolean foundChest;
        boolean foundLectern;
        block5: {
            BlockEntity it;
            foundLectern = false;
            foundChest = false;
            if (findLectern) {
                BlockEntity blockEntity = this.level.getBlockEntity(pos);
                if (blockEntity != null) {
                    it = blockEntity;
                    boolean bl = false;
                    if (it instanceof LecternBlockEntity) {
                        this.lecternBlockEntity = (LecternBlockEntity)it;
                        foundLectern = true;
                    }
                }
            }
            if (!findChest) break block5;
            BlockEntity blockEntity = this.level.getBlockEntity(pos);
            if (blockEntity != null) {
                it = blockEntity;
                boolean bl = false;
                if (it instanceof ChestBlockEntity) {
                    this.previousDiariesChestBlockEntity = (ChestBlockEntity)it;
                    foundChest = true;
                }
            }
        }
        return new kotlin.Pair((Object)foundLectern, (Object)foundChest);
    }

    public final void writeNbt(@NotNull CompoundTag tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        tag.put("DiaryData", (Tag)PERSIST_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.data).getOrThrow((Function)writeNbt.1.INSTANCE));
    }

    public final void readNbt(@NotNull CompoundTag tag) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            this.data = new DiaryData(null, null, null, 7, null);
            Tag tag2 = tag.get("DiaryData");
            if (tag2 == null) break block0;
            Tag diaryData = tag2;
            boolean bl = false;
            this.data = (DiaryData)((Pair)PERSIST_CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)diaryData).getOrThrow((Function)readNbt.1.1.INSTANCE)).getFirst();
        }
    }

    private static final BookData makeEventDiary$lambda$2(BookData $customDiaryData) {
        return $customDiaryData;
    }

    private static final Unit makeEventDiary$lambda$3(BookData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        RuinsOfGrowsseth.LOGGER.info("Created custom remote diary (" + it.getName() + "), recording content...", new Object[0]);
        return Unit.INSTANCE;
    }

    private static final void makeEventDiary$lambda$5$lambda$4(CompoundTag tag) {
        tag.put("RemoveOnResDiaryPush", (Tag)ByteTag.valueOf((boolean)true));
    }

    private static final Unit makeEventDiary$lambda$5(ItemStack book) {
        Intrinsics.checkNotNullParameter((Object)book, (String)"book");
        CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)book, ResearcherDiaryComponent::makeEventDiary$lambda$5$lambda$4);
        return Unit.INSTANCE;
    }

    private static final BookData makeStructureDiary$lambda$6(Map $remoteDiaries, TagKey $forStructure) {
        BookData bookData = (BookData)$remoteDiaries.get($forStructure);
        if (bookData == null) {
            bookData = Companion.getStructureDiaries().get($forStructure);
        }
        return bookData;
    }

    private static final Unit makeStructureDiary$lambda$7(TagKey $forStructure, BookData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        RuinsOfGrowsseth.LOGGER.info("Created diary for " + $forStructure.location() + " (" + it.getName() + "), recording content...", new Object[0]);
        return Unit.INSTANCE;
    }

    private static final Unit makeDiary$lambda$8(ItemStack it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    private static final Unit findBlockEntsIfNull$lambda$15(ResearcherDiaryComponent this$0, Ref.BooleanRef $findLectern, Ref.BooleanRef $findChest, BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        kotlin.Pair<Boolean, Boolean> found = this$0.checkBlockPosForEnt(pos, $findLectern.element, $findChest.element);
        $findLectern.element = (Boolean)found.getFirst() == false;
        boolean bl = $findChest.element = (Boolean)found.getSecond() == false;
        if (!$findChest.element && !$findLectern.element) {
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    private static final Map PERSIST_CODEC$lambda$22$lambda$19(KProperty1 $tmp0, DiaryData p0) {
        return (Map)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final Set PERSIST_CODEC$lambda$22$lambda$20(KProperty1 $tmp0, DiaryData p0) {
        return (Set)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final Map PERSIST_CODEC$lambda$22$lambda$21(KProperty1 $tmp0, DiaryData p0) {
        return (Map)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final App PERSIST_CODEC$lambda$22(RecordCodecBuilder.Instance b) {
        Codec codec = TagKey.codec((ResourceKey)Registries.STRUCTURE);
        Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"codec(...)");
        PrimitiveCodec primitiveCodec = Codec.BOOL;
        Intrinsics.checkNotNullExpressionValue((Object)primitiveCodec, (String)"BOOL");
        App app = (App)CodecUtilsKt.mutableMapCodec((Codec)codec, (Codec)((Codec)primitiveCodec)).fieldOf("recordedStructures").forGetter(arg_0 -> ResearcherDiaryComponent.PERSIST_CODEC$lambda$22$lambda$19((KProperty1)Companion.PERSIST_CODEC.1.1.INSTANCE, arg_0));
        PrimitiveCodec primitiveCodec2 = Codec.STRING;
        Intrinsics.checkNotNullExpressionValue((Object)primitiveCodec2, (String)"STRING");
        App app2 = (App)CodecUtilsKt.mutableSetCodec((Codec)((Codec)primitiveCodec2)).fieldOf("recordedEvents").forGetter(arg_0 -> ResearcherDiaryComponent.PERSIST_CODEC$lambda$22$lambda$20((KProperty1)Companion.PERSIST_CODEC.1.2.INSTANCE, arg_0));
        Codec codec2 = TagKey.codec((ResourceKey)Registries.STRUCTURE);
        Intrinsics.checkNotNullExpressionValue((Object)codec2, (String)"codec(...)");
        return b.group(app, app2, (App)CodecUtilsKt.mutableMapCodec((Codec)codec2, GrowssethCodecs.INSTANCE.getLOCAL_DATE_TIME_CODEC()).optionalFieldOf("trackedStructures", (Object)new LinkedHashMap()).forGetter(arg_0 -> ResearcherDiaryComponent.PERSIST_CODEC$lambda$22$lambda$21((KProperty1)Companion.PERSIST_CODEC.1.3.INSTANCE, arg_0))).apply((Applicative)b, DiaryData::new);
    }

    static {
        Codec codec = RecordCodecBuilder.create(ResearcherDiaryComponent::PERSIST_CODEC$lambda$22);
        Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"create(...)");
        PERSIST_CODEC = codec;
        structToTag = new LinkedHashMap();
        TargetingConditions targetingConditions = TargetingConditions.forNonCombat().ignoreLineOfSight().ignoreInvisibilityTesting();
        Intrinsics.checkNotNullExpressionValue((Object)targetingConditions, (String)"ignoreInvisibilityTesting(...)");
        ResearcherDiaryComponent.targetingConditions = targetingConditions;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/ruslan/growsseth/entity/researcher/ResearcherDiaryComponent$Callbacks;", "", "<init>", "()V", "onServerLevel", "", "level", "Lnet/minecraft/server/level/ServerLevel;", "ruins-of-growsseth"})
    @SourceDebugExtension(value={"SMAP\nResearcherDiaryComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResearcherDiaryComponent.kt\ncom/ruslan/growsseth/entity/researcher/ResearcherDiaryComponent$Callbacks\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,582:1\n1368#2:583\n1454#2,2:584\n774#2:586\n865#2,2:587\n1557#2:589\n1628#2,3:590\n1456#2,3:593\n1187#2,2:596\n1261#2,4:598\n1246#2,4:604\n462#3:602\n412#3:603\n*S KotlinDebug\n*F\n+ 1 ResearcherDiaryComponent.kt\ncom/ruslan/growsseth/entity/researcher/ResearcherDiaryComponent$Callbacks\n*L\n377#1:583\n377#1:584,2\n378#1:586\n378#1:587,2\n378#1:589\n378#1:590,3\n377#1:593,3\n379#1:596,2\n379#1:598,4\n383#1:604,4\n383#1:602\n383#1:603\n*E\n"})
    public static final class Callbacks {
        @NotNull
        public static final Callbacks INSTANCE = new Callbacks();

        private Callbacks() {
        }

        /*
         * WARNING - void declaration
         */
        public final void onServerLevel(@NotNull ServerLevel level) {
            void $this$mapValuesTo$iv$iv;
            Map<ResourceKey<Structure>, GrowssethStructures.StructureInfo> $this$associateTo$iv$iv;
            void $this$associate$iv;
            Object object;
            Object element$iv$iv2;
            void $this$flatMapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Registry registry = level.registryAccess().registryOrThrow(Registries.STRUCTURE);
            Iterable $this$flatMap$iv = GrowssethTags.StructTags.INSTANCE.getALL();
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv2 : $this$flatMapTo$iv$iv) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Holder it;
                void $this$filterTo$iv$iv;
                TagKey tag = (TagKey)element$iv$iv2;
                boolean bl = false;
                Iterable iterable2 = registry.getTagOrEmpty(tag);
                Intrinsics.checkNotNullExpressionValue((Object)iterable2, (String)"getTagOrEmpty(...)");
                Iterable $this$filter$iv = iterable2;
                boolean $i$f$filter = false;
                object = $this$filter$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv3 : $this$filterTo$iv$iv) {
                    it = (Holder)element$iv$iv3;
                    boolean bl2 = false;
                    if (!it.unwrapKey().isPresent()) continue;
                    destination$iv$iv2.add(element$iv$iv3);
                }
                $this$filter$iv = (List)destination$iv$iv2;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (Holder)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl3 = false;
                    collection.add(TuplesKt.to(it.unwrapKey().get(), (Object)tag));
                }
                Iterable list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            destination$iv$iv = $this$associate$iv;
            Map destination$iv$iv3 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            element$iv$iv2 = $this$associateTo$iv$iv.iterator();
            while (element$iv$iv2.hasNext()) {
                Object element$iv$iv4 = element$iv$iv2.next();
                Map map = destination$iv$iv3;
                kotlin.Pair it = (kotlin.Pair)element$iv$iv4;
                boolean bl = false;
                map.put(it.getFirst(), it.getSecond());
            }
            Map registryTagAssociations = destination$iv$iv3;
            Map<ResourceKey<Structure>, GrowssethStructures.StructureInfo> $this$mapValues$iv = GrowssethStructures.INSTANCE.getInfo();
            boolean $i$f$mapValues = false;
            $this$associateTo$iv$iv = $this$mapValues$iv;
            destination$iv$iv3 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it;
                void it$iv$iv;
                Map.Entry bl = (Map.Entry)element$iv$iv$iv;
                object = destination$iv$iv3;
                boolean bl4 = false;
                Map.Entry $i$f$mapTo = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                Object object2 = object;
                boolean bl5 = false;
                TagKey<Structure> tagKey = ((GrowssethStructures.StructureInfo)it.getValue()).getTag();
                object2.put(k, tagKey);
            }
            Map staticTagAssociations = destination$iv$iv3;
            Companion.getStructToTag().put(level, MapsKt.plus((Map)staticTagAssociations, (Map)registryTagAssociations));
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u001c\u001a\u00020\u001dJ\b\u0010\u001e\u001a\u00020\u001dH\u0002R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR5\u0010\t\u001a&\u0012\u0004\u0012\u00020\u000b\u0012\u001c\u0012\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u000f0\f0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\"\u0010\u0016\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u000f\u0012\u0004\u0012\u00020\u0017\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R#\u0010\u0018\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u000f\u0012\u0004\u0012\u00020\u00170\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0011R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/ruslan/growsseth/entity/researcher/ResearcherDiaryComponent$Companion;", "", "<init>", "()V", "PERSIST_CODEC", "Lcom/mojang/serialization/Codec;", "Lcom/ruslan/growsseth/entity/researcher/ResearcherDiaryComponent$DiaryData;", "getPERSIST_CODEC", "()Lcom/mojang/serialization/Codec;", "structToTag", "", "Lnet/minecraft/server/level/ServerLevel;", "", "Lnet/minecraft/resources/ResourceKey;", "Lnet/minecraft/world/level/levelgen/structure/Structure;", "Lnet/minecraft/tags/TagKey;", "getStructToTag", "()Ljava/util/Map;", "targetingConditions", "Lnet/minecraft/world/entity/ai/targeting/TargetingConditions;", "getTargetingConditions", "()Lnet/minecraft/world/entity/ai/targeting/TargetingConditions;", "structureDiaries_", "Lcom/ruslan/growsseth/templates/BookData;", "structureDiaries", "getStructureDiaries", "lastLanguageCode", "", "init", "", "checkLanguageChanged", "ruins-of-growsseth"})
    @SourceDebugExtension(value={"SMAP\nResearcherDiaryComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResearcherDiaryComponent.kt\ncom/ruslan/growsseth/entity/researcher/ResearcherDiaryComponent$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,582:1\n774#2:583\n865#2,2:584\n1863#2,2:586\n774#2:588\n865#2,2:589\n1863#2,2:591\n*S KotlinDebug\n*F\n+ 1 ResearcherDiaryComponent.kt\ncom/ruslan/growsseth/entity/researcher/ResearcherDiaryComponent$Companion\n*L\n104#1:583\n104#1:584,2\n104#1:586,2\n88#1:588\n88#1:589,2\n88#1:591,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Codec<DiaryData> getPERSIST_CODEC() {
            return PERSIST_CODEC;
        }

        @NotNull
        public final Map<ServerLevel, Map<ResourceKey<Structure>, TagKey<Structure>>> getStructToTag() {
            return structToTag;
        }

        @NotNull
        public final TargetingConditions getTargetingConditions() {
            return targetingConditions;
        }

        @NotNull
        public final Map<TagKey<Structure>, BookData> getStructureDiaries() {
            Map map = structureDiaries_;
            if (map == null) {
                throw new IllegalStateException("StructureDiaries not init!");
            }
            return map;
        }

        public final void init() {
            String prefix = "researcher_diary/";
            TemplateListener.INSTANCE.onReload(TemplateKind.Companion.getBOOK(), (arg_0, arg_1, arg_2) -> Companion.init$lambda$2(prefix, arg_0, arg_1, arg_2));
        }

        /*
         * WARNING - void declaration
         */
        private final void checkLanguageChanged() {
            String langCode = GrowssethConfig.serverLanguage;
            if (!Intrinsics.areEqual((Object)lastLanguageCode, (Object)langCode)) {
                void $this$forEach$iv;
                void $this$filterTo$iv$iv;
                lastLanguageCode = langCode;
                Map diaries = new LinkedHashMap();
                List<String> keys = BookTemplates.INSTANCE.getAvailableTemplates();
                String prefix = "researcher_diary/";
                Iterable $this$filter$iv = keys;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    String it = (String)element$iv$iv;
                    boolean bl = false;
                    if (!StringsKt.startsWith$default((String)it, (String)prefix, (boolean)false, (int)2, null)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    BookData bookData;
                    String key = (String)element$iv;
                    boolean bl = false;
                    TagKey structTag = TagKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)com.ruslan.growsseth.utils.UtilsKt.resLoc(StringsKt.replace$default((String)key, (String)prefix, (String)"", (boolean)false, (int)4, null)));
                    Map map = diaries;
                    if (BookTemplates.INSTANCE.getTemplates().get(key) == null) {
                        throw new IllegalStateException("Error in caching structure diaries");
                    }
                    map.put(structTag, bookData);
                }
                structureDiaries_ = diaries;
                RuinsOfGrowsseth.LOGGER.info("Updated structure researcher diaries on language change, has " + diaries.size(), new Object[0]);
            }
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit init$lambda$2(String $prefix, Map langTemplates, Set keys, Map map) {
            void $this$forEach$iv;
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)langTemplates, (String)"langTemplates");
            Intrinsics.checkNotNullParameter((Object)keys, (String)"keys");
            Intrinsics.checkNotNullParameter((Object)map, (String)"<unused var>");
            Map diaries = new LinkedHashMap();
            String langCode = GrowssethConfig.serverLanguage;
            lastLanguageCode = langCode;
            Iterable $this$filter$iv = keys;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                if (!StringsKt.startsWith$default((String)it, (String)$prefix, (boolean)false, (int)2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BookData bookData;
                String key = (String)element$iv;
                boolean bl = false;
                TagKey structTag = TagKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)com.ruslan.growsseth.utils.UtilsKt.resLoc(StringsKt.replace$default((String)key, (String)$prefix, (String)"", (boolean)false, (int)4, null)));
                Map map2 = diaries;
                if ((BookData)langTemplates.get(key) == null) {
                    throw new IllegalStateException("Error in caching structure diaries");
                }
                map2.put(structTag, bookData);
            }
            structureDiaries_ = diaries;
            RuinsOfGrowsseth.LOGGER.info("Updated structure researcher diaries, has " + diaries.size(), new Object[0]);
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001BO\u0012\u001a\b\u0002\u0010\u0002\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u001a\b\u0002\u0010\n\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u000b0\u0003\u00a2\u0006\u0004\b\f\u0010\rJ\u001b\u0010\u0013\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0003J\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0003J\u001b\u0010\u0015\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u000b0\u0003H\u00c6\u0003JQ\u0010\u0016\u001a\u00020\u00002\u001a\b\u0002\u0010\u0002\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u00060\u00032\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u001a\b\u0002\u0010\n\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u000b0\u0003H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00062\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\tH\u00d6\u0001R#\u0010\u0002\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R#\u0010\n\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u000b0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lcom/ruslan/growsseth/entity/researcher/ResearcherDiaryComponent$DiaryData;", "", "recordedStructures", "", "Lnet/minecraft/tags/TagKey;", "Lnet/minecraft/world/level/levelgen/structure/Structure;", "", "recordedEvents", "", "", "trackedStructures", "Ljava/time/LocalDateTime;", "<init>", "(Ljava/util/Map;Ljava/util/Set;Ljava/util/Map;)V", "getRecordedStructures", "()Ljava/util/Map;", "getRecordedEvents", "()Ljava/util/Set;", "getTrackedStructures", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "ruins-of-growsseth"})
    public static final class DiaryData {
        @NotNull
        private final Map<TagKey<Structure>, Boolean> recordedStructures;
        @NotNull
        private final Set<String> recordedEvents;
        @NotNull
        private final Map<TagKey<Structure>, LocalDateTime> trackedStructures;

        public DiaryData(@NotNull Map<TagKey<Structure>, Boolean> recordedStructures, @NotNull Set<String> recordedEvents, @NotNull Map<TagKey<Structure>, LocalDateTime> trackedStructures) {
            Intrinsics.checkNotNullParameter(recordedStructures, (String)"recordedStructures");
            Intrinsics.checkNotNullParameter(recordedEvents, (String)"recordedEvents");
            Intrinsics.checkNotNullParameter(trackedStructures, (String)"trackedStructures");
            this.recordedStructures = recordedStructures;
            this.recordedEvents = recordedEvents;
            this.trackedStructures = trackedStructures;
        }

        public /* synthetic */ DiaryData(Map map, Set set, Map map2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = new LinkedHashMap();
            }
            if ((n & 2) != 0) {
                set = new LinkedHashSet();
            }
            if ((n & 4) != 0) {
                map2 = new LinkedHashMap();
            }
            this(map, set, map2);
        }

        @NotNull
        public final Map<TagKey<Structure>, Boolean> getRecordedStructures() {
            return this.recordedStructures;
        }

        @NotNull
        public final Set<String> getRecordedEvents() {
            return this.recordedEvents;
        }

        @NotNull
        public final Map<TagKey<Structure>, LocalDateTime> getTrackedStructures() {
            return this.trackedStructures;
        }

        @NotNull
        public final Map<TagKey<Structure>, Boolean> component1() {
            return this.recordedStructures;
        }

        @NotNull
        public final Set<String> component2() {
            return this.recordedEvents;
        }

        @NotNull
        public final Map<TagKey<Structure>, LocalDateTime> component3() {
            return this.trackedStructures;
        }

        @NotNull
        public final DiaryData copy(@NotNull Map<TagKey<Structure>, Boolean> recordedStructures, @NotNull Set<String> recordedEvents, @NotNull Map<TagKey<Structure>, LocalDateTime> trackedStructures) {
            Intrinsics.checkNotNullParameter(recordedStructures, (String)"recordedStructures");
            Intrinsics.checkNotNullParameter(recordedEvents, (String)"recordedEvents");
            Intrinsics.checkNotNullParameter(trackedStructures, (String)"trackedStructures");
            return new DiaryData(recordedStructures, recordedEvents, trackedStructures);
        }

        public static /* synthetic */ DiaryData copy$default(DiaryData diaryData, Map map, Set set, Map map2, int n, Object object) {
            if ((n & 1) != 0) {
                map = diaryData.recordedStructures;
            }
            if ((n & 2) != 0) {
                set = diaryData.recordedEvents;
            }
            if ((n & 4) != 0) {
                map2 = diaryData.trackedStructures;
            }
            return diaryData.copy(map, set, map2);
        }

        @NotNull
        public String toString() {
            return "DiaryData(recordedStructures=" + this.recordedStructures + ", recordedEvents=" + this.recordedEvents + ", trackedStructures=" + this.trackedStructures + ")";
        }

        public int hashCode() {
            int result = ((Object)this.recordedStructures).hashCode();
            result = result * 31 + ((Object)this.recordedEvents).hashCode();
            result = result * 31 + ((Object)this.trackedStructures).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DiaryData)) {
                return false;
            }
            DiaryData diaryData = (DiaryData)other;
            if (!Intrinsics.areEqual(this.recordedStructures, diaryData.recordedStructures)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.recordedEvents, diaryData.recordedEvents)) {
                return false;
            }
            return Intrinsics.areEqual(this.trackedStructures, diaryData.trackedStructures);
        }

        public DiaryData() {
            this(null, null, null, 7, null);
        }
    }
}

