/*
 * Decompiled with CFR 0.152.
 */
package com.ruslan.growsseth.entity.researcher;

import com.filloax.fxlib.api.EventUtil;
import com.ruslan.growsseth.GrowssethTags;
import com.ruslan.growsseth.RuinsOfGrowsseth;
import com.ruslan.growsseth.dialogues.DialogueEvent;
import com.ruslan.growsseth.dialogues.NpcDialoguesComponent;
import com.ruslan.growsseth.entity.researcher.Researcher;
import com.ruslan.growsseth.entity.researcher.ResearcherDialoguesComponent;
import com.ruslan.growsseth.structure.pieces.ResearcherTent;
import com.ruslan.growsseth.utils.UtilsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.animal.horse.Donkey;
import net.minecraft.world.entity.decoration.LeashFenceKnotEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u001e\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012J,\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u00162\u0014\b\u0002\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00050\u0018J,\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0006\u001a\u00020\u00162\u0014\b\u0002\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00050\u0018\u00a8\u0006\u001b"}, d2={"Lcom/ruslan/growsseth/entity/researcher/ResearcherDonkey;", "", "<init>", "()V", "shouldProtectDonkey", "", "level", "Lnet/minecraft/world/level/Level;", "donkey", "Lnet/minecraft/world/entity/Entity;", "onFenceUnleash", "", "mob", "Lnet/minecraft/world/entity/Leashable;", "pos", "Lnet/minecraft/core/BlockPos;", "onFenceLeash", "player", "Lnet/minecraft/server/level/ServerPlayer;", "removeDonkey", "entity", "Lcom/ruslan/growsseth/entity/researcher/Researcher;", "Lnet/minecraft/server/level/ServerLevel;", "predicate", "Lkotlin/Function1;", "tent", "Lcom/ruslan/growsseth/structure/pieces/ResearcherTent;", "ruins-of-growsseth"})
@SourceDebugExtension(value={"SMAP\nResearcherDonkey.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResearcherDonkey.kt\ncom/ruslan/growsseth/entity/researcher/ResearcherDonkey\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,113:1\n1#2:114\n1863#3,2:115\n1863#3,2:117\n*S KotlinDebug\n*F\n+ 1 ResearcherDonkey.kt\ncom/ruslan/growsseth/entity/researcher/ResearcherDonkey\n*L\n59#1:115,2\n79#1:117,2\n*E\n"})
public final class ResearcherDonkey {
    @NotNull
    public static final ResearcherDonkey INSTANCE = new ResearcherDonkey();

    private ResearcherDonkey() {
    }

    @JvmStatic
    public static final boolean shouldProtectDonkey(@NotNull Level level, @NotNull Entity donkey) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)donkey, (String)"donkey");
        if (!level.isClientSide()) {
            List nearbyResearchers = level.getEntitiesOfClass(Researcher.class, AABB.ofSize((Vec3)donkey.position(), (double)80.0, (double)80.0, (double)80.0));
            if (nearbyResearchers.size() == 0) {
                return false;
            }
            BlockPos pos = donkey.blockPosition();
            ServerLevel serverLevel = (ServerLevel)level;
            StructureManager structures = serverLevel.structureManager();
            BoundingBox checkArea = new BoundingBox(pos.getX() - 3, pos.getY() - 2, pos.getZ() - 3, pos.getX() + 3, pos.getY() + 2, pos.getZ() + 3);
            Object object = new BlockPos[]{pos};
            Object it = object = CollectionsKt.mutableListOf((Object[])object);
            boolean bl = false;
            checkArea.forAllCorners(arg_0 -> ResearcherDonkey.shouldProtectDonkey$lambda$0$add((List)it, arg_0));
            Object checkPoints = object;
            object = checkPoints.iterator();
            while (object.hasNext()) {
                BlockPos checkPos = (BlockPos)object.next();
                if (!structures.getStructureWithPieceAt(checkPos, GrowssethTags.StructTags.INSTANCE.getRESEARCHER_TENT()).isValid()) continue;
                return true;
            }
        }
        return false;
    }

    public final void onFenceUnleash(@NotNull Leashable mob, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)mob, (String)"mob");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        if (!(mob instanceof Donkey) || !((Donkey)mob).getTags().contains("researcher_donkey")) {
            return;
        }
        double playerRadius = 15.0;
        Level level = ((Donkey)mob).level();
        Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
        ServerPlayer serverPlayer = (ServerPlayer)((ServerLevel)level).getNearestPlayer((Entity)mob, playerRadius);
        if (serverPlayer == null) {
            return;
        }
        ServerPlayer player = serverPlayer;
        double searchRadius = 80.0;
        AABB searchArea = AABB.ofSize((Vec3)player.position(), (double)searchRadius, (double)searchRadius, (double)searchRadius);
        List researchers = player.level().getEntitiesOfClass(Researcher.class, searchArea);
        Intrinsics.checkNotNull((Object)researchers);
        Iterable $this$forEach$iv = researchers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DialogueEvent[] dialogueEventArray;
            Researcher researcher = (Researcher)element$iv;
            boolean bl = false;
            if (researcher.getDonkeyWasBorrowed()) continue;
            researcher.setDonkeyWasBorrowed(true);
            if (researcher.getHealed()) {
                ResearcherDialoguesComponent researcherDialoguesComponent = researcher.getDialogues();
                if (researcherDialoguesComponent != null) {
                    dialogueEventArray = new DialogueEvent[]{ResearcherDialoguesComponent.Companion.getEV_BORROW_DONKEY_HEALED()};
                    NpcDialoguesComponent.DefaultImpls.triggerDialogue$default(researcherDialoguesComponent, player, dialogueEventArray, null, false, 12, null);
                }
                continue;
            }
            ResearcherDialoguesComponent researcherDialoguesComponent = researcher.getDialogues();
            if (researcherDialoguesComponent == null) continue;
            dialogueEventArray = new DialogueEvent[]{ResearcherDialoguesComponent.Companion.getEV_BORROW_DONKEY()};
            NpcDialoguesComponent.DefaultImpls.triggerDialogue$default(researcherDialoguesComponent, player, dialogueEventArray, null, false, 12, null);
        }
        ((Donkey)mob).getTags().remove("researcher_donkey");
    }

    public final void onFenceLeash(@NotNull Leashable mob, @NotNull BlockPos pos, @NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)mob, (String)"mob");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!(mob instanceof Donkey) || ((Donkey)mob).getTags().contains("researcher_donkey")) {
            return;
        }
        ServerLevel serverLevel = player.serverLevel();
        Intrinsics.checkNotNull((Object)serverLevel);
        StructureStart structureStart = Researcher.Companion.findTent$default(Researcher.Companion, serverLevel, pos, null, 4, null);
        if (structureStart == null) {
            return;
        }
        StructureStart tent = structureStart;
        List researchers = serverLevel.getEntitiesOfClass(Researcher.class, AABB.of((BoundingBox)tent.getBoundingBox()).inflate(80.0));
        Intrinsics.checkNotNull((Object)researchers);
        Iterable $this$forEach$iv = researchers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Researcher researcher = (Researcher)element$iv;
            boolean bl = false;
            if (!researcher.getDonkeyWasBorrowed()) continue;
            researcher.setDonkeyWasBorrowed(false);
            if (researcher.getHealed()) continue;
            ResearcherDialoguesComponent researcherDialoguesComponent = researcher.getDialogues();
            if (researcherDialoguesComponent == null) continue;
            DialogueEvent[] dialogueEventArray = new DialogueEvent[]{ResearcherDialoguesComponent.Companion.getEV_RETURN_DONKEY()};
            NpcDialoguesComponent.DefaultImpls.triggerDialogue$default(researcherDialoguesComponent, player, dialogueEventArray, null, false, 12, null);
        }
        ((Donkey)mob).getTags().add("researcher_donkey");
    }

    public final void removeDonkey(@NotNull Researcher entity, @NotNull ServerLevel level, @NotNull Function1<? super Entity, Boolean> predicate) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        ResearcherTent researcherTent = entity.getTent();
        if (researcherTent == null) {
            return;
        }
        ResearcherTent tent = researcherTent;
        this.removeDonkey(tent, level, predicate);
    }

    public static /* synthetic */ void removeDonkey$default(ResearcherDonkey researcherDonkey, Researcher researcher, ServerLevel serverLevel, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = ResearcherDonkey::removeDonkey$lambda$3;
        }
        researcherDonkey.removeDonkey(researcher, serverLevel, (Function1<? super Entity, Boolean>)function1);
    }

    public final void removeDonkey(@NotNull ResearcherTent tent, @NotNull ServerLevel level, @NotNull Function1<? super Entity, Boolean> predicate) {
        Intrinsics.checkNotNullParameter((Object)((Object)tent), (String)"tent");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        List donkeys = level.getEntitiesOfClass(Donkey.class, AABB.of((BoundingBox)tent.getBoundingBox()).inflate(80.0), arg_0 -> ResearcherDonkey.removeDonkey$lambda$5(predicate, arg_0));
        Intrinsics.checkNotNull((Object)donkeys);
        Donkey donkeyToRemove = (Donkey)CollectionsKt.firstOrNull((List)donkeys);
        if (UtilsKt.notNull(donkeyToRemove)) {
            LeashFenceKnotEntity leashFenceKnotEntity;
            RuinsOfGrowsseth.LOGGER.info("Removing Researcher donkey " + donkeyToRemove, new Object[0]);
            Entity entity = donkeyToRemove.getLeashHolder();
            if (entity != null) {
                Entity it = entity;
                boolean bl = false;
                leashFenceKnotEntity = it instanceof LeashFenceKnotEntity ? (LeashFenceKnotEntity)it : null;
            } else {
                leashFenceKnotEntity = null;
            }
            LeashFenceKnotEntity knot = leashFenceKnotEntity;
            EventUtil.INSTANCE.runAtServerTickEnd(arg_0 -> ResearcherDonkey.removeDonkey$lambda$7(donkeyToRemove, knot, arg_0));
        }
    }

    public static /* synthetic */ void removeDonkey$default(ResearcherDonkey researcherDonkey, ResearcherTent researcherTent, ServerLevel serverLevel, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = ResearcherDonkey::removeDonkey$lambda$4;
        }
        researcherDonkey.removeDonkey(researcherTent, serverLevel, (Function1<? super Entity, Boolean>)function1);
    }

    private static final /* synthetic */ void shouldProtectDonkey$lambda$0$add(List $this$shouldProtectDonkey_u24lambda_u240_u24add, BlockPos p0) {
        $this$shouldProtectDonkey_u24lambda_u240_u24add.add(p0);
    }

    private static final boolean removeDonkey$lambda$3(Entity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getTags().contains("researcher_donkey");
    }

    private static final boolean removeDonkey$lambda$4(Entity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final boolean removeDonkey$lambda$5(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit removeDonkey$lambda$7(Donkey $donkeyToRemove, LeashFenceKnotEntity $knot, MinecraftServer it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            $donkeyToRemove.discard();
            LeashFenceKnotEntity leashFenceKnotEntity = $knot;
            if (leashFenceKnotEntity == null) break block0;
            leashFenceKnotEntity.discard();
        }
        return Unit.INSTANCE;
    }
}

