/*
 * Decompiled with CFR 0.152.
 */
package com.ruslan.growsseth.entity.researcher;

import com.filloax.fxlib.api.EventUtil;
import com.filloax.fxlib.api.FxItemUtilsKt;
import com.filloax.fxlib.api.UtilsKt;
import com.filloax.fxlib.api.codec.CodecUtilsKt;
import com.filloax.fxlib.api.enums.SetBlockFlag;
import com.filloax.fxlib.api.nbt.NbtUtilsKt;
import com.mojang.datafixers.util.Pair;
import com.ruslan.growsseth.GrowssethTags;
import com.ruslan.growsseth.RuinsOfGrowsseth;
import com.ruslan.growsseth.config.ResearcherConfig;
import com.ruslan.growsseth.dialogues.BasicDialoguesComponent;
import com.ruslan.growsseth.entity.GrowssethEntities;
import com.ruslan.growsseth.entity.researcher.DiaryHelper;
import com.ruslan.growsseth.entity.researcher.Researcher;
import com.ruslan.growsseth.entity.researcher.ResearcherDialoguesComponent;
import com.ruslan.growsseth.entity.researcher.ResearcherDonkey;
import com.ruslan.growsseth.entity.researcher.ResearcherQuestComponent;
import com.ruslan.growsseth.entity.researcher.ResearcherSavedData;
import com.ruslan.growsseth.entity.researcher.ZombieResearcher;
import com.ruslan.growsseth.entity.researcher.trades.AbstractResearcherTradesProvider;
import com.ruslan.growsseth.entity.researcher.trades.ProgressResearcherTradesProvider;
import com.ruslan.growsseth.entity.researcher.trades.ResearcherTradeMode;
import com.ruslan.growsseth.item.GrowssethItems;
import com.ruslan.growsseth.quests.ApiEventTrigger;
import com.ruslan.growsseth.quests.DialogueGroupTrigger;
import com.ruslan.growsseth.quests.EventTrigger;
import com.ruslan.growsseth.quests.NoPlayersInRadiusTrigger;
import com.ruslan.growsseth.quests.QuestComponent;
import com.ruslan.growsseth.quests.QuestStage;
import com.ruslan.growsseth.quests.QuestStageTrigger;
import com.ruslan.growsseth.quests.QuestTriggersKt;
import com.ruslan.growsseth.quests.QuestUpdateEvent;
import com.ruslan.growsseth.quests.TriggerTreeNode;
import com.ruslan.growsseth.structure.pieces.ResearcherTent;
import com.ruslan.growsseth.templates.BookData;
import com.ruslan.growsseth.templates.BookTemplates;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Clearable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.InstrumentItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.LecternBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 \u00182\b\u0012\u0004\u0012\u00020\u00020\u0001:\n\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/ruslan/growsseth/entity/researcher/ResearcherQuestComponent;", "Lcom/ruslan/growsseth/quests/QuestComponent;", "Lcom/ruslan/growsseth/entity/researcher/Researcher;", "researcher", "<init>", "(Lcom/ruslan/growsseth/entity/researcher/Researcher;)V", "availableStages", "", "", "getAvailableStages", "()Ljava/util/List;", "finalQuestStartName", "finalQuestZombieName", "finalQuestLeaveName", "commonReloadTrigger", "Lcom/ruslan/growsseth/quests/QuestStageTrigger;", "alreadyRemovedTent", "", "writeCustomNbt", "", "tag", "Lnet/minecraft/nbt/CompoundTag;", "readCustomNbt", "Stages", "Companion", "StartStage", "ZombieStage", "HealedStage", "HealedWaitForDialogueStage", "HomeLastDialogueStage", "WaitBeforeLeaveStage", "EndingStage", "ProgressTradesTrigger", "ruins-of-growsseth"})
@SourceDebugExtension(value={"SMAP\nResearcherQuestComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResearcherQuestComponent.kt\ncom/ruslan/growsseth/entity/researcher/ResearcherQuestComponent\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,445:1\n3829#2:446\n4344#2,2:447\n1053#3:449\n1557#3:450\n1628#3,3:451\n*S KotlinDebug\n*F\n+ 1 ResearcherQuestComponent.kt\ncom/ruslan/growsseth/entity/researcher/ResearcherQuestComponent\n*L\n74#1:446\n74#1:447,2\n75#1:449\n76#1:450\n76#1:451,3\n*E\n"})
public final class ResearcherQuestComponent
extends QuestComponent<Researcher> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<String> availableStages;
    @NotNull
    private final String finalQuestStartName;
    @NotNull
    private final String finalQuestZombieName;
    @NotNull
    private final String finalQuestLeaveName;
    @NotNull
    private final QuestStageTrigger<Researcher> commonReloadTrigger;
    private boolean alreadyRemovedTent;
    @NotNull
    public static final String QUEST_NAME = "researcherIllness";
    @NotNull
    public static final String TAG_ALREADY_REMOVED_TENT = "alreadyRemovedTent";
    private static boolean playerSkippedQuest;

    /*
     * WARNING - void declaration
     */
    public ResearcherQuestComponent(@NotNull Researcher researcher) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)researcher, (String)"researcher");
        super((LivingEntity)researcher, QUEST_NAME);
        Field[] fieldArray = Stages.class.getDeclaredFields();
        Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"getDeclaredFields(...)");
        Object[] objectArray = fieldArray;
        ResearcherQuestComponent researcherQuestComponent = this;
        boolean $i$f$filter = false;
        void var4_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Field element$iv$iv : $this$filterTo$iv$iv) {
            Field it = element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getType(), String.class)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Field it = (Field)a;
                boolean bl = false;
                Field[] fieldArray = it.getDeclaringClass().getDeclaredFields();
                Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"getDeclaredFields(...)");
                Comparable comparable = Integer.valueOf(ArraysKt.indexOf((Object[])fieldArray, (Object)it));
                it = (Field)b;
                Comparable comparable2 = comparable;
                bl = false;
                Field[] fieldArray2 = it.getDeclaringClass().getDeclaredFields();
                Intrinsics.checkNotNullExpressionValue((Object)fieldArray2, (String)"getDeclaredFields(...)");
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(ArraysKt.indexOf((Object[])fieldArray2, (Object)it)));
            }
        });
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Field element$iv$iv;
            element$iv$iv = (Field)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object object = it.get(null);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
            collection.add((String)object);
        }
        researcherQuestComponent.availableStages = (List)destination$iv$iv;
        this.finalQuestStartName = "researcher_end_quest_start";
        this.finalQuestZombieName = "researcher_end_quest_zombie";
        this.finalQuestLeaveName = "researcher_end_quest_leave";
        objectArray = new QuestUpdateEvent[]{QuestUpdateEvent.LOAD};
        this.commonReloadTrigger = new EventTrigger((QuestUpdateEvent[])objectArray).or(new NoPlayersInRadiusTrigger(this, null, 8, 2, null)).or(QuestTriggersKt.TimeOrDayTimeTrigger(this, 24000L));
        QuestComponent.addStage$default(this, "start", new StartStage(), new String[0], 0, false, false, 56, null);
        objectArray = new String[]{"start", "init"};
        QuestComponent.addStage$default(this, "zombie", new ZombieStage(), (String[])objectArray, -10, true, false, 32, null);
        objectArray = new String[]{"zombie"};
        QuestComponent.addStage$default(this, "healed", new HealedStage(), (String[])objectArray, 0, false, false, 56, null);
        objectArray = new String[]{"zombie"};
        QuestComponent.addStage$default(this, "healed_wait", new HealedWaitForDialogueStage(), (String[])objectArray, 0, false, false, 56, null);
        objectArray = new String[]{"healed"};
        QuestComponent.addStage$default(this, "home", new HomeLastDialogueStage(), (String[])objectArray, 0, false, true, 24, null);
        objectArray = new String[]{"home"};
        QuestComponent.addStage$default(this, "home_wait", new WaitBeforeLeaveStage(), (String[])objectArray, 0, false, true, 24, null);
        objectArray = new String[]{"home_wait"};
        QuestComponent.addStage$default(this, "ending", new EndingStage(), (String[])objectArray, 0, false, false, 56, null);
    }

    @Override
    @NotNull
    public List<String> getAvailableStages() {
        return this.availableStages;
    }

    @Override
    public void writeCustomNbt(@NotNull CompoundTag tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        tag.putBoolean(TAG_ALREADY_REMOVED_TENT, this.alreadyRemovedTent);
    }

    @Override
    public void readCustomNbt(@NotNull CompoundTag tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.alreadyRemovedTent = tag.getBoolean(TAG_ALREADY_REMOVED_TENT);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\nJ\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010\u0011\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u0012\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0005J\u000e\u0010\u0015\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018J\u001e\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/ruslan/growsseth/entity/researcher/ResearcherQuestComponent$Companion;", "", "<init>", "()V", "QUEST_NAME", "", "TAG_ALREADY_REMOVED_TENT", "playerSkippedQuest", "", "getPersistentData", "Lcom/ruslan/growsseth/quests/QuestComponent$QuestData;", "server", "Lnet/minecraft/server/MinecraftServer;", "writePersistentData", "", "data", "updateCurrentResearchers", "isHealed", "shouldRemoveTent", "setStage", "stage", "backOneStage", "removeTentAndResearcher", "researcher", "Lcom/ruslan/growsseth/entity/researcher/Researcher;", "removeResearcher", "spawnRewardChest", "level", "Lnet/minecraft/server/level/ServerLevel;", "pos", "Lnet/minecraft/core/BlockPos;", "tentRotation", "Lnet/minecraft/world/level/block/Rotation;", "ruins-of-growsseth"})
    @SourceDebugExtension(value={"SMAP\nResearcherQuestComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResearcherQuestComponent.kt\ncom/ruslan/growsseth/entity/researcher/ResearcherQuestComponent$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 NbtUtils.kt\ncom/filloax/fxlib/api/nbt/NbtUtilsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,445:1\n1#2:446\n42#3,8:447\n1863#4:455\n1863#4,2:456\n1864#4:458\n*S KotlinDebug\n*F\n+ 1 ResearcherQuestComponent.kt\ncom/ruslan/growsseth/entity/researcher/ResearcherQuestComponent$Companion\n*L\n136#1:447,8\n143#1:455\n144#1:456,2\n143#1:458\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final QuestComponent.QuestData getPersistentData(@NotNull MinecraftServer server) {
            Object object;
            block5: {
                block4: {
                    Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                    if (!ResearcherConfig.singleResearcher) {
                        RuinsOfGrowsseth.LOGGER.error("Tried getting researcher quest data when not in single researcher mode!", new Object[0]);
                        return new QuestComponent.QuestData(null, null, false, 0L, 0L, 31, null);
                    }
                    CompoundTag compoundTag = ResearcherSavedData.Companion.getPersistent(server).getData().getCompound("Quests").getCompound(ResearcherQuestComponent.QUEST_NAME);
                    Intrinsics.checkNotNullExpressionValue((Object)compoundTag, (String)"getCompound(...)");
                    CompoundTag tag = NbtUtilsKt.getCompoundOrNull((CompoundTag)compoundTag, (String)"status");
                    object = tag;
                    if (object == null) break block4;
                    CompoundTag it = object;
                    boolean bl = false;
                    QuestComponent.QuestData questData = (QuestComponent.QuestData)((Pair)CodecUtilsKt.decodeNbt(QuestComponent.Companion.getPERSIST_CODEC(), (Tag)((Tag)it)).getOrThrow(arg_0 -> Companion.getPersistentData$lambda$1$lambda$0(CodecUtilsKt.throwableCodecErr((String)"ResearcherQuestComponent getPersistentData"), arg_0))).getFirst();
                    object = questData;
                    if (questData != null) break block5;
                }
                object = new QuestComponent.QuestData(null, null, false, 0L, 0L, 31, null);
            }
            return object;
        }

        public final void writePersistentData(@NotNull MinecraftServer server, @NotNull QuestComponent.QuestData data) {
            String key$iv;
            CompoundTag $this$getOrPut$iv;
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            if (!ResearcherConfig.singleResearcher) {
                RuinsOfGrowsseth.LOGGER.error("Tried writing researcher quest data when not in single researcher mode!", new Object[0]);
            }
            ResearcherSavedData researcherData = ResearcherSavedData.Companion.getPersistent(server);
            CompoundTag compoundTag = researcherData.getData();
            String string = "Quests";
            Tag default$iv = (Tag)new CompoundTag();
            boolean $i$f$getOrPut = false;
            Tag value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                Tag tag = default$iv.copy();
                if (tag == null) {
                    throw new NullPointerException("null cannot be cast to non-null type net.minecraft.nbt.CompoundTag");
                }
                value$iv = (Tag)((CompoundTag)tag);
                $this$getOrPut$iv.put(key$iv, value$iv);
            } else if (!(value$iv instanceof CompoundTag)) {
                throw new ClassCastException("Existing tag is of wrong type! " + value$iv.getClass());
            }
            $this$getOrPut$iv = (CompoundTag)value$iv;
            key$iv = ResearcherQuestComponent.QUEST_NAME;
            default$iv = (Tag)new CompoundTag();
            $i$f$getOrPut = false;
            value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                Tag tag = default$iv.copy();
                if (tag == null) {
                    throw new NullPointerException("null cannot be cast to non-null type net.minecraft.nbt.CompoundTag");
                }
                value$iv = (Tag)((CompoundTag)tag);
                $this$getOrPut$iv.put(key$iv, value$iv);
            } else if (!(value$iv instanceof CompoundTag)) {
                throw new ClassCastException("Existing tag is of wrong type! " + value$iv.getClass());
            }
            CompoundTag questsTag = (CompoundTag)value$iv;
            questsTag.put("status", (Tag)CodecUtilsKt.encodeNbt(QuestComponent.Companion.getPERSIST_CODEC(), (Object)data).getOrThrow(arg_0 -> Companion.writePersistentData$lambda$2(CodecUtilsKt.throwableCodecErr((String)"writePersistentData quest"), arg_0)));
            researcherData.setDirty();
            this.updateCurrentResearchers(server);
        }

        private final void updateCurrentResearchers(MinecraftServer server) {
            Iterable iterable = server.getAllLevels();
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getAllLevels(...)");
            Iterable $this$forEach$iv = iterable;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ServerLevel level = (ServerLevel)element$iv;
                boolean bl = false;
                List list = level.getEntities((EntityTypeTest)GrowssethEntities.INSTANCE.getRESEARCHER(), arg_0 -> Companion.updateCurrentResearchers$lambda$5$lambda$3(UtilsKt.alwaysTruePredicate(), arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEntities(...)");
                Iterable $this$forEach$iv2 = list;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    Researcher researcher = (Researcher)element$iv2;
                    boolean bl2 = false;
                    researcher.readSavedData(ResearcherSavedData.Companion.getPersistent(server));
                }
            }
        }

        public final boolean isHealed(@NotNull MinecraftServer server) {
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            return this.getPersistentData(server).getStageHistory().contains("healed");
        }

        public final boolean shouldRemoveTent(@NotNull MinecraftServer server) {
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            return this.getPersistentData(server).getStageHistory().contains("ending");
        }

        public final void setStage(@NotNull MinecraftServer server, @NotNull String stage) {
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            Intrinsics.checkNotNullParameter((Object)stage, (String)"stage");
            Object[] objectArray = new String[]{"home", "home_wait", "start", "healed", "zombie", "ending"};
            boolean bl = CollectionsKt.listOf((Object[])objectArray).contains(stage);
            if (_Assertions.ENABLED && !bl) {
                boolean bl2 = false;
                String string = "Stage " + stage + " not included in stages for researcher!";
                throw new AssertionError((Object)string);
            }
            QuestComponent.QuestData data = this.getPersistentData(server);
            data.setCurrentStageId(stage);
            data.getStageHistory().add(stage);
            data.setCurrentStageTriggerTime(server.overworld().getGameTime());
            this.writePersistentData(server, data);
        }

        public final boolean backOneStage(@NotNull MinecraftServer server) {
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            QuestComponent.QuestData data = this.getPersistentData(server);
            String string = (String)CollectionsKt.removeLastOrNull(data.getStageHistory());
            if (string == null) {
                return false;
            }
            data.setCurrentStageId(string);
            this.writePersistentData(server, data);
            return true;
        }

        public final void removeTentAndResearcher(@NotNull Researcher researcher) {
            Intrinsics.checkNotNullParameter((Object)researcher, (String)"researcher");
            Level level = researcher.level();
            Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            ServerLevel level2 = (ServerLevel)level;
            RuinsOfGrowsseth.LOGGER.info("Removing tent and researcher " + this, new Object[0]);
            MinecraftServer $this$removeTentAndResearcher_u24lambda_u248 = level2.getServer();
            boolean bl = false;
            ResearcherTent researcherTent = researcher.getTent();
            if (researcherTent != null) {
                ResearcherTent tent = researcherTent;
                boolean bl2 = false;
                BlockPos giftPos = tent.getBoundingBox().getCenter().above(2);
                Rotation tentRotation = tent.placeSettings().getRotation();
                ResearcherTent.remove$default(tent, level2, null, true, 2, null);
                Intrinsics.checkNotNull((Object)giftPos);
                Intrinsics.checkNotNull((Object)tentRotation);
                Companion.spawnRewardChest(level2, giftPos, tentRotation);
            }
            Companion.removeResearcher(researcher);
        }

        public final void removeResearcher(@NotNull Researcher researcher) {
            Intrinsics.checkNotNullParameter((Object)researcher, (String)"researcher");
            Level level = researcher.level();
            Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            ServerLevel level2 = (ServerLevel)level;
            if (!researcher.getDonkeyWasBorrowed()) {
                ResearcherDonkey.removeDonkey$default(ResearcherDonkey.INSTANCE, researcher, level2, null, 4, null);
            }
            MinecraftServer minecraftServer = level2.getServer();
            Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
            ResearcherSavedData savedData = ResearcherSavedData.Companion.getPersistent(minecraftServer);
            Researcher.writeSavedData$default(researcher, savedData, null, false, 6, null);
            savedData.setDirty();
            researcher.discard();
        }

        public final void spawnRewardChest(@NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull Rotation tentRotation) {
            ItemStack itemStack;
            ItemStack itemStack2;
            String finalDiaryTemplate;
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)tentRotation, (String)"tentRotation");
            BlockEntity prevBlockEntity = level.getBlockEntity(pos);
            Clearable.tryClear((Object)prevBlockEntity);
            Object object = Blocks.CHEST.defaultBlockState().setValue((Property)ChestBlock.FACING, (Comparable)tentRotation.rotate(Direction.NORTH));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"setValue(...)");
            BlockState chestState = (BlockState)object;
            SetBlockFlag[] setBlockFlagArray = new SetBlockFlag[]{SetBlockFlag.NOTIFY_CLIENTS, SetBlockFlag.NO_NEIGHBOR_REACTIONS, SetBlockFlag.NO_NEIGHBOR_REACTION_DROPS};
            level.setBlock(pos, chestState, SetBlockFlag.Companion.or(setBlockFlagArray));
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity == null || !(blockEntity instanceof BaseContainerBlockEntity)) {
                RuinsOfGrowsseth.LOGGER.error("No blockentity at reward chest pos " + pos + ", error in spawning?", new Object[0]);
                return;
            }
            Holder.Reference resInstrumentHolder = (Holder.Reference)BuiltInRegistries.INSTRUMENT.getHolder(ResourceKey.create((ResourceKey)Registries.INSTRUMENT, (ResourceLocation)((ResourceLocation)GrowssethItems.Instruments.INSTANCE.getRESEARCHER_HORN().getFirst()))).orElseThrow();
            ItemStack hornItem = InstrumentItem.create((Item)((Item)GrowssethItems.INSTANCE.getRESEARCHER_HORN()), (Holder)((Holder)resInstrumentHolder));
            Intrinsics.checkNotNull((Object)hornItem);
            List list = FxItemUtilsKt.loreLines((ItemStack)hornItem);
            MutableComponent mutableComponent = Component.translatable((String)"item.growsseth.researcher_horn.description1");
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
            list.add(mutableComponent);
            List list2 = FxItemUtilsKt.loreLines((ItemStack)hornItem);
            MutableComponent mutableComponent2 = Component.translatable((String)"item.growsseth.researcher_horn.description2");
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent2, (String)"translatable(...)");
            list2.add(mutableComponent2);
            MinecraftServer minecraftServer = level.getServer();
            Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
            Component component = ResearcherSavedData.Companion.getPersistent(minecraftServer).getName();
            if (component == null) {
                component = (Component)Component.translatable((String)"entity.growsseth.researcher");
            }
            Component researcherName = component;
            String string = finalDiaryTemplate = !playerSkippedQuest ? "quest_good_ending" : "quest_good_ending_skip";
            if (DiaryHelper.INSTANCE.hasCustomEndDiary()) {
                Intrinsics.checkNotNull((Object)researcherName);
                itemStack2 = DiaryHelper.INSTANCE.getCustomEndDiary(researcherName);
            } else {
                itemStack2 = itemStack = null;
            }
            if (itemStack2 == null && (itemStack = BookTemplates.createTemplatedBook$default(BookTemplates.INSTANCE, finalDiaryTemplate, null, null, arg_0 -> Companion.spawnRewardChest$lambda$9(researcherName, arg_0), 6, null)) == null) {
                ItemStack itemStack3;
                ItemStack itemStack4 = itemStack3 = Items.PAPER.getDefaultInstance().copyWithCount(1);
                boolean bl = false;
                itemStack4.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)"growsseth.final_diary_fallback"));
                RuinsOfGrowsseth.LOGGER.warn("Couldn't load final diary, researcher used a piece of paper instead!", new Object[0]);
                itemStack = itemStack3;
            }
            ItemStack endTextItem = itemStack;
            ((BaseContainerBlockEntity)blockEntity).setItem(4, endTextItem);
            ((BaseContainerBlockEntity)blockEntity).setItem(13, hornItem);
            level.blockUpdated(pos, chestState.getBlock());
            RuinsOfGrowsseth.LOGGER.info("Spawned researcher reward chest at " + pos, new Object[0]);
        }

        private static final Exception getPersistentData$lambda$1$lambda$0(Function1 $tmp0, String p0) {
            return (Exception)$tmp0.invoke((Object)p0);
        }

        private static final Exception writePersistentData$lambda$2(Function1 $tmp0, String p0) {
            return (Exception)$tmp0.invoke((Object)p0);
        }

        private static final boolean updateCurrentResearchers$lambda$5$lambda$3(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final BookData spawnRewardChest$lambda$9(Component $researcherName, BookData $this$createTemplatedBook) {
            Intrinsics.checkNotNullParameter((Object)$this$createTemplatedBook, (String)"$this$createTemplatedBook");
            String string = $researcherName.getString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            return $this$createTemplatedBook.withAuthor(string);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lcom/ruslan/growsseth/entity/researcher/ResearcherQuestComponent$EndingStage;", "Lcom/ruslan/growsseth/quests/QuestStage;", "Lcom/ruslan/growsseth/entity/researcher/Researcher;", "<init>", "(Lcom/ruslan/growsseth/entity/researcher/ResearcherQuestComponent;)V", "trigger", "Lcom/ruslan/growsseth/quests/QuestStageTrigger;", "getTrigger", "()Lcom/ruslan/growsseth/quests/QuestStageTrigger;", "onActivated", "", "entity", "onUpdate", "ruins-of-growsseth"})
    public final class EndingStage
    implements QuestStage<Researcher> {
        @NotNull
        private final QuestStageTrigger<Researcher> trigger;

        public EndingStage() {
            this.trigger = ResearcherQuestComponent.this.commonReloadTrigger.and(QuestTriggersKt.TimeOrDayTimeTrigger(ResearcherQuestComponent.this, 48000L).or(new ApiEventTrigger(ResearcherQuestComponent.this.finalQuestLeaveName)));
        }

        @Override
        @NotNull
        public QuestStageTrigger<Researcher> getTrigger() {
            return this.trigger;
        }

        @Override
        public void onActivated(@NotNull Researcher entity) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            entity.setHealed(true);
        }

        @Override
        public void onUpdate(@NotNull Researcher entity) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            ResearcherDialoguesComponent researcherDialoguesComponent = entity.getDialogues();
            Intrinsics.checkNotNull((Object)researcherDialoguesComponent);
            if (researcherDialoguesComponent.getTriggeredDialogues().isEmpty()) {
                playerSkippedQuest = true;
            }
            if (!ResearcherQuestComponent.this.alreadyRemovedTent) {
                Companion.removeTentAndResearcher(entity);
            } else {
                Companion.removeResearcher(entity);
            }
        }

        @Override
        public void onStep(@NotNull Researcher entity) {
            QuestStage.DefaultImpls.onStep(this, (LivingEntity)entity);
        }

        @Override
        @NotNull
        public TriggerTreeNode getTriggerStatusTree(@NotNull Researcher entity, @NotNull QuestUpdateEvent event) {
            return QuestStage.DefaultImpls.getTriggerStatusTree(this, (LivingEntity)entity, event);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\f"}, d2={"Lcom/ruslan/growsseth/entity/researcher/ResearcherQuestComponent$HealedStage;", "Lcom/ruslan/growsseth/quests/QuestStage;", "Lcom/ruslan/growsseth/entity/researcher/Researcher;", "<init>", "()V", "trigger", "Lcom/ruslan/growsseth/quests/QuestStageTrigger;", "getTrigger", "()Lcom/ruslan/growsseth/quests/QuestStageTrigger;", "onActivated", "", "entity", "ruins-of-growsseth"})
    public static final class HealedStage
    implements QuestStage<Researcher> {
        @NotNull
        private final QuestStageTrigger<Researcher> trigger = trigger.1.INSTANCE;

        @Override
        @NotNull
        public QuestStageTrigger<Researcher> getTrigger() {
            return this.trigger;
        }

        @Override
        public void onActivated(@NotNull Researcher entity) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            entity.setHealed(true);
        }

        @Override
        public void onStep(@NotNull Researcher entity) {
            QuestStage.DefaultImpls.onStep(this, (LivingEntity)entity);
        }

        @Override
        public void onUpdate(@NotNull Researcher entity) {
            QuestStage.DefaultImpls.onUpdate(this, (LivingEntity)entity);
        }

        @Override
        @NotNull
        public TriggerTreeNode getTriggerStatusTree(@NotNull Researcher entity, @NotNull QuestUpdateEvent event) {
            return QuestStage.DefaultImpls.getTriggerStatusTree(this, (LivingEntity)entity, event);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\f"}, d2={"Lcom/ruslan/growsseth/entity/researcher/ResearcherQuestComponent$HealedWaitForDialogueStage;", "Lcom/ruslan/growsseth/quests/QuestStage;", "Lcom/ruslan/growsseth/entity/researcher/Researcher;", "<init>", "(Lcom/ruslan/growsseth/entity/researcher/ResearcherQuestComponent;)V", "trigger", "Lcom/ruslan/growsseth/quests/QuestStageTrigger;", "getTrigger", "()Lcom/ruslan/growsseth/quests/QuestStageTrigger;", "onActivated", "", "entity", "ruins-of-growsseth"})
    public final class HealedWaitForDialogueStage
    implements QuestStage<Researcher> {
        @NotNull
        private final QuestStageTrigger<Researcher> trigger = new DialogueGroupTrigger("group-cure-dialogue");

        @Override
        @NotNull
        public QuestStageTrigger<Researcher> getTrigger() {
            return this.trigger;
        }

        @Override
        public void onActivated(@NotNull Researcher entity) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            entity.setHealed(true);
        }

        @Override
        public void onStep(@NotNull Researcher entity) {
            QuestStage.DefaultImpls.onStep(this, (LivingEntity)entity);
        }

        @Override
        public void onUpdate(@NotNull Researcher entity) {
            QuestStage.DefaultImpls.onUpdate(this, (LivingEntity)entity);
        }

        @Override
        @NotNull
        public TriggerTreeNode getTriggerStatusTree(@NotNull Researcher entity, @NotNull QuestUpdateEvent event) {
            return QuestStage.DefaultImpls.getTriggerStatusTree(this, (LivingEntity)entity, event);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\f"}, d2={"Lcom/ruslan/growsseth/entity/researcher/ResearcherQuestComponent$HomeLastDialogueStage;", "Lcom/ruslan/growsseth/quests/QuestStage;", "Lcom/ruslan/growsseth/entity/researcher/Researcher;", "<init>", "(Lcom/ruslan/growsseth/entity/researcher/ResearcherQuestComponent;)V", "trigger", "Lcom/ruslan/growsseth/quests/QuestStageTrigger;", "getTrigger", "()Lcom/ruslan/growsseth/quests/QuestStageTrigger;", "onActivated", "", "entity", "ruins-of-growsseth"})
    @SourceDebugExtension(value={"SMAP\nResearcherQuestComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResearcherQuestComponent.kt\ncom/ruslan/growsseth/entity/researcher/ResearcherQuestComponent$HomeLastDialogueStage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,445:1\n1#2:446\n*E\n"})
    public final class HomeLastDialogueStage
    implements QuestStage<Researcher> {
        @NotNull
        private final QuestStageTrigger<Researcher> trigger;

        public HomeLastDialogueStage() {
            this.trigger = ResearcherQuestComponent.this.commonReloadTrigger;
        }

        @Override
        @NotNull
        public QuestStageTrigger<Researcher> getTrigger() {
            return this.trigger;
        }

        @Override
        public void onActivated(@NotNull Researcher entity) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                entity.setHealed(true);
                BlockPos blockPos = entity.getStartingPos();
                if (blockPos != null) {
                    BlockPos it = blockPos;
                    boolean bl = false;
                    entity.moveTo(it, entity.getYRot(), entity.getXRot());
                }
                ResearcherDialoguesComponent researcherDialoguesComponent = entity.getDialogues();
                if (researcherDialoguesComponent == null) break block1;
                researcherDialoguesComponent.resetNearbyPlayers();
            }
        }

        @Override
        public void onStep(@NotNull Researcher entity) {
            QuestStage.DefaultImpls.onStep(this, (LivingEntity)entity);
        }

        @Override
        public void onUpdate(@NotNull Researcher entity) {
            QuestStage.DefaultImpls.onUpdate(this, (LivingEntity)entity);
        }

        @Override
        @NotNull
        public TriggerTreeNode getTriggerStatusTree(@NotNull Researcher entity, @NotNull QuestUpdateEvent event) {
            return QuestStage.DefaultImpls.getTriggerStatusTree(this, (LivingEntity)entity, event);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lcom/ruslan/growsseth/entity/researcher/ResearcherQuestComponent$ProgressTradesTrigger;", "Lcom/ruslan/growsseth/quests/QuestStageTrigger;", "Lcom/ruslan/growsseth/entity/researcher/Researcher;", "server", "Lnet/minecraft/server/MinecraftServer;", "onlyOne", "", "<init>", "(Lnet/minecraft/server/MinecraftServer;Z)V", "getServer", "()Lnet/minecraft/server/MinecraftServer;", "getOnlyOne", "()Z", "isActive", "entity", "event", "Lcom/ruslan/growsseth/quests/QuestUpdateEvent;", "ruins-of-growsseth"})
    private static final class ProgressTradesTrigger
    implements QuestStageTrigger<Researcher> {
        @NotNull
        private final MinecraftServer server;
        private final boolean onlyOne;

        public ProgressTradesTrigger(@NotNull MinecraftServer server, boolean onlyOne) {
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            this.server = server;
            this.onlyOne = onlyOne;
        }

        public /* synthetic */ ProgressTradesTrigger(MinecraftServer minecraftServer, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = false;
            }
            this(minecraftServer, bl);
        }

        @NotNull
        public final MinecraftServer getServer() {
            return this.server;
        }

        public final boolean getOnlyOne() {
            return this.onlyOne;
        }

        @Override
        public boolean isActive(@NotNull Researcher entity, @NotNull QuestUpdateEvent event) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            Intrinsics.checkNotNullParameter((Object)((Object)event), (String)"event");
            AbstractResearcherTradesProvider tradesProvider = ResearcherTradeMode.Companion.providerFromSettings(this.server);
            if (!(tradesProvider instanceof ProgressResearcherTradesProvider)) {
                return false;
            }
            return this.onlyOne ? ((ProgressResearcherTradesProvider)tradesProvider).onlyOneLeft(this.server) : ((ProgressResearcherTradesProvider)tradesProvider).isFinished(this.server);
        }

        @Override
        @NotNull
        public QuestStageTrigger<Researcher> and(@NotNull QuestStageTrigger<Researcher> other) {
            return QuestStageTrigger.DefaultImpls.and(this, other);
        }

        @Override
        @NotNull
        public QuestStageTrigger<Researcher> or(@NotNull QuestStageTrigger<Researcher> other) {
            return QuestStageTrigger.DefaultImpls.or(this, other);
        }

        @Override
        @NotNull
        public QuestStageTrigger<Researcher> andMulti(QuestStageTrigger<Researcher> ... with) {
            return QuestStageTrigger.DefaultImpls.andMulti(this, with);
        }

        @Override
        @NotNull
        public QuestStageTrigger<Researcher> orMulti(QuestStageTrigger<Researcher> ... with) {
            return QuestStageTrigger.DefaultImpls.orMulti(this, with);
        }

        @Override
        @NotNull
        public TriggerTreeNode getActiveTree(@NotNull Researcher entity, @NotNull QuestUpdateEvent event) {
            return QuestStageTrigger.DefaultImpls.getActiveTree(this, (LivingEntity)entity, event);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/ruslan/growsseth/entity/researcher/ResearcherQuestComponent$Stages;", "", "<init>", "()V", "START", "", "ZOMBIE", "HEALED", "HEALED_WAIT", "HOME", "HOME_WAIT", "ENDING", "ruins-of-growsseth"})
    public static final class Stages {
        @NotNull
        public static final Stages INSTANCE = new Stages();
        @NotNull
        public static final String START = "start";
        @NotNull
        public static final String ZOMBIE = "zombie";
        @NotNull
        public static final String HEALED = "healed";
        @NotNull
        public static final String HEALED_WAIT = "healed_wait";
        @NotNull
        public static final String HOME = "home";
        @NotNull
        public static final String HOME_WAIT = "home_wait";
        @NotNull
        public static final String ENDING = "ending";

        private Stages() {
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\f"}, d2={"Lcom/ruslan/growsseth/entity/researcher/ResearcherQuestComponent$StartStage;", "Lcom/ruslan/growsseth/quests/QuestStage;", "Lcom/ruslan/growsseth/entity/researcher/Researcher;", "<init>", "(Lcom/ruslan/growsseth/entity/researcher/ResearcherQuestComponent;)V", "trigger", "Lcom/ruslan/growsseth/quests/QuestStageTrigger;", "getTrigger", "()Lcom/ruslan/growsseth/quests/QuestStageTrigger;", "onActivated", "", "entity", "ruins-of-growsseth"})
    public final class StartStage
    implements QuestStage<Researcher> {
        @NotNull
        private final QuestStageTrigger<Researcher> trigger;

        public StartStage() {
            this.trigger = new ProgressTradesTrigger(ResearcherQuestComponent.this.getServer(), true).or(new ApiEventTrigger(ResearcherQuestComponent.this.finalQuestStartName));
        }

        @Override
        @NotNull
        public QuestStageTrigger<Researcher> getTrigger() {
            return this.trigger;
        }

        @Override
        public void onActivated(@NotNull Researcher entity) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                entity.setHealed(false);
                ResearcherDialoguesComponent researcherDialoguesComponent = entity.getDialogues();
                if (researcherDialoguesComponent == null) break block0;
                researcherDialoguesComponent.resetNearbyPlayers();
            }
        }

        @Override
        public void onStep(@NotNull Researcher entity) {
            QuestStage.DefaultImpls.onStep(this, (LivingEntity)entity);
        }

        @Override
        public void onUpdate(@NotNull Researcher entity) {
            QuestStage.DefaultImpls.onUpdate(this, (LivingEntity)entity);
        }

        @Override
        @NotNull
        public TriggerTreeNode getTriggerStatusTree(@NotNull Researcher entity, @NotNull QuestUpdateEvent event) {
            return QuestStage.DefaultImpls.getTriggerStatusTree(this, (LivingEntity)entity, event);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\f"}, d2={"Lcom/ruslan/growsseth/entity/researcher/ResearcherQuestComponent$WaitBeforeLeaveStage;", "Lcom/ruslan/growsseth/quests/QuestStage;", "Lcom/ruslan/growsseth/entity/researcher/Researcher;", "<init>", "()V", "trigger", "Lcom/ruslan/growsseth/quests/DialogueGroupTrigger;", "getTrigger", "()Lcom/ruslan/growsseth/quests/DialogueGroupTrigger;", "onActivated", "", "entity", "ruins-of-growsseth"})
    public static final class WaitBeforeLeaveStage
    implements QuestStage<Researcher> {
        @NotNull
        private final DialogueGroupTrigger<Researcher> trigger = new DialogueGroupTrigger("group-quest-last-dialogue");

        @Override
        @NotNull
        public DialogueGroupTrigger<Researcher> getTrigger() {
            return this.trigger;
        }

        @Override
        public void onActivated(@NotNull Researcher entity) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            entity.setHealed(true);
        }

        @Override
        public void onStep(@NotNull Researcher entity) {
            QuestStage.DefaultImpls.onStep(this, (LivingEntity)entity);
        }

        @Override
        public void onUpdate(@NotNull Researcher entity) {
            QuestStage.DefaultImpls.onUpdate(this, (LivingEntity)entity);
        }

        @Override
        @NotNull
        public TriggerTreeNode getTriggerStatusTree(@NotNull Researcher entity, @NotNull QuestUpdateEvent event) {
            return QuestStage.DefaultImpls.getTriggerStatusTree(this, (LivingEntity)entity, event);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0018\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/ruslan/growsseth/entity/researcher/ResearcherQuestComponent$ZombieStage;", "Lcom/ruslan/growsseth/quests/QuestStage;", "Lcom/ruslan/growsseth/entity/researcher/Researcher;", "<init>", "(Lcom/ruslan/growsseth/entity/researcher/ResearcherQuestComponent;)V", "trigger", "Lcom/ruslan/growsseth/quests/QuestStageTrigger;", "getTrigger", "()Lcom/ruslan/growsseth/quests/QuestStageTrigger;", "onActivated", "", "entity", "onUpdate", "createDiary", "Lnet/minecraft/world/entity/LivingEntity;", "tent", "Lcom/ruslan/growsseth/structure/pieces/ResearcherTent;", "moveToJail", "Lnet/minecraft/world/entity/Entity;", "ruins-of-growsseth"})
    public final class ZombieStage
    implements QuestStage<Researcher> {
        @NotNull
        private final QuestStageTrigger<Researcher> trigger;

        public ZombieStage() {
            this.trigger = new ProgressTradesTrigger(ResearcherQuestComponent.this.getServer(), false).or(new ApiEventTrigger(ResearcherQuestComponent.this.finalQuestZombieName));
        }

        @Override
        @NotNull
        public QuestStageTrigger<Researcher> getTrigger() {
            return this.trigger;
        }

        @Override
        public void onActivated(@NotNull Researcher entity) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            entity.setHealed(false);
        }

        @Override
        public void onUpdate(@NotNull Researcher entity) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            EventUtil.INSTANCE.runAtServerTickEnd(arg_0 -> ZombieStage.onUpdate$lambda$2(entity, this, arg_0));
        }

        private final void createDiary(LivingEntity entity, ResearcherTent tent) {
            String zombieDiaryTemplate = !playerSkippedQuest ? "quest_zombie" : "quest_zombie_skip";
            ItemStack diary = BookTemplates.createTemplatedBook$default(BookTemplates.INSTANCE, zombieDiaryTemplate, null, null, arg_0 -> ZombieStage.createDiary$lambda$3(entity, arg_0), 6, null);
            if (diary == null) {
                RuinsOfGrowsseth.LOGGER.error("No diary for quest_zombie!", new Object[0]);
                return;
            }
            Ref.ObjectRef lectern = new Ref.ObjectRef();
            Ref.ObjectRef chest = new Ref.ObjectRef();
            BoundingBox boundingBox = tent.getCellarBoundingBox();
            if (boundingBox != null) {
                BoundingBox boundingBox2 = boundingBox;
                ResearcherQuestComponent researcherQuestComponent = ResearcherQuestComponent.this;
                BoundingBox boundingBox3 = boundingBox2;
                boolean bl = false;
                UtilsKt.iterBlocks((BoundingBox)boundingBox3, arg_0 -> ZombieStage.createDiary$lambda$6$lambda$5(researcherQuestComponent, lectern, chest, arg_0));
            }
            DiaryHelper.pushDiaryToContainers$default(DiaryHelper.INSTANCE, diary, ResearcherQuestComponent.this.getServerLevel(), entity, (LecternBlockEntity)lectern.element, (ChestBlockEntity)chest.element, false, 32, null);
            RuinsOfGrowsseth.LOGGER.info("Placed diary for quest", new Object[0]);
        }

        private final void moveToJail(Entity entity, ResearcherTent tent) {
            BlockPos pos = tent.getJailPos();
            if (com.ruslan.growsseth.utils.UtilsKt.notNull(pos)) {
                entity.moveTo(pos, entity.getYRot(), entity.getXRot());
            } else {
                RuinsOfGrowsseth.LOGGER.warn("Tent doesn't have a jail position set!", new Object[0]);
            }
        }

        @Override
        public void onStep(@NotNull Researcher entity) {
            QuestStage.DefaultImpls.onStep(this, (LivingEntity)entity);
        }

        @Override
        @NotNull
        public TriggerTreeNode getTriggerStatusTree(@NotNull Researcher entity, @NotNull QuestUpdateEvent event) {
            return QuestStage.DefaultImpls.getTriggerStatusTree(this, (LivingEntity)entity, event);
        }

        private static final Unit onUpdate$lambda$2$lambda$1(ServerLevel $level, BlockPos $resStartingPos, Researcher $entity, ZombieStage this$0, ZombieResearcher $zombie, MinecraftServer minecraftServer) {
            ResearcherTent tent2;
            Intrinsics.checkNotNullParameter((Object)minecraftServer, (String)"<unused var>");
            Intrinsics.checkNotNull((Object)$resStartingPos);
            StructureStart tentStart2 = Researcher.Companion.findTent$default(Researcher.Companion, $level, $resStartingPos, null, 4, null);
            Object object = tentStart2;
            ResearcherTent researcherTent = tent2 = (ResearcherTent)(object != null && (object = object.getPieces()) != null ? (StructurePiece)object.get(0) : null);
            if (researcherTent != null) {
                ResearcherTent it = researcherTent;
                boolean bl = false;
                Level level = $entity.level();
                Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                ResearcherTent.remove$default(it, (ServerLevel)level, GrowssethTags.INSTANCE.getTENT_CLEAR_ZOMBIE_STAGE_WHITELIST(), false, 4, null);
                this$0.moveToJail((Entity)$zombie, it);
                this$0.createDiary((LivingEntity)$zombie, it);
                RuinsOfGrowsseth.LOGGER.info("Success in moving at end of server tick", new Object[0]);
            } else {
                RuinsOfGrowsseth.LOGGER.warn("Cannot find tent to move zombie researcher to!", new Object[0]);
            }
            return Unit.INSTANCE;
        }

        private static final Unit onUpdate$lambda$2(Researcher $entity, ZombieStage this$0, MinecraftServer minecraftServer) {
            Intrinsics.checkNotNullParameter((Object)minecraftServer, (String)"<unused var>");
            Object object = $entity.getDialogues();
            boolean bl = object != null && (object = ((BasicDialoguesComponent)object).getTriggeredDialogues()) != null ? object.isEmpty() : false;
            if (bl) {
                playerSkippedQuest = true;
            }
            ResearcherTent tent = $entity.getTent();
            Vec3 startingPos = $entity.position();
            ResearcherDialoguesComponent researcherDialoguesComponent = $entity.getDialogues();
            if (researcherDialoguesComponent != null) {
                researcherDialoguesComponent.resetNearbyPlayers();
            }
            CompoundTag data = $entity.saveResearcherData();
            boolean scheduleMoveRemoveLater = false;
            if (tent != null) {
                this$0.moveToJail((Entity)$entity, tent);
                this$0.createDiary((LivingEntity)$entity, tent);
                Level level = $entity.level();
                Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                ResearcherTent.remove$default(tent, (ServerLevel)level, GrowssethTags.INSTANCE.getTENT_CLEAR_ZOMBIE_STAGE_WHITELIST(), false, 4, null);
            } else {
                scheduleMoveRemoveLater = true;
            }
            Level level = $entity.level();
            Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            ServerLevel level2 = (ServerLevel)level;
            BlockPos blockPos = $entity.getStartingPos();
            if (blockPos == null) {
                blockPos = $entity.blockPosition();
            }
            BlockPos resStartingPos = blockPos;
            long spawnTime = $entity.getSpawnTime();
            ZombieResearcher zombie = (ZombieResearcher)$entity.convertTo(GrowssethEntities.INSTANCE.getZOMBIE_RESEARCHER(), false);
            if (com.ruslan.growsseth.utils.UtilsKt.isNull(zombie)) {
                RuinsOfGrowsseth.LOGGER.error("Couldn't zombify researcher in quest stage!", new Object[0]);
                $entity.moveTo(startingPos);
                return Unit.INSTANCE;
            }
            zombie.setResearcherData(data);
            zombie.setLastWorldDataTime($entity.getLastWorldDataTime());
            zombie.setSpawnTime(spawnTime);
            zombie.setResearcherOriginalPos(resStartingPos);
            zombie.setVillagerData(zombie.getVillagerData().setProfession(VillagerProfession.CARTOGRAPHER).setLevel(5));
            Object[] objectArray = new Object[]{zombie};
            RuinsOfGrowsseth.LOGGER.info("Spawned researcher zombie {} from quest stage", objectArray);
            $entity.discard();
            if (scheduleMoveRemoveLater) {
                RuinsOfGrowsseth.LOGGER.info("Couldn't find tent, trying again at end of server tick...", new Object[0]);
                EventUtil.INSTANCE.runAtServerTickEnd(arg_0 -> ZombieStage.onUpdate$lambda$2$lambda$1(level2, resStartingPos, $entity, this$0, zombie, arg_0));
            }
            return Unit.INSTANCE;
        }

        private static final BookData createDiary$lambda$3(LivingEntity $entity, BookData $this$createTemplatedBook) {
            Intrinsics.checkNotNullParameter((Object)$this$createTemplatedBook, (String)"$this$createTemplatedBook");
            String string = $entity.getName().getString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            return $this$createTemplatedBook.withAuthor(string);
        }

        private static final Unit createDiary$lambda$6$lambda$5(ResearcherQuestComponent this$0, Ref.ObjectRef $lectern, Ref.ObjectRef $chest, BlockPos pos) {
            boolean found;
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            BlockEntity blockEntity = this$0.getServerLevel().getBlockEntity(pos);
            if (blockEntity != null) {
                BlockEntity it = blockEntity;
                boolean bl = false;
                if (it instanceof LecternBlockEntity) {
                    $lectern.element = it;
                }
                if (it instanceof ChestBlockEntity) {
                    $chest.element = it;
                }
                v1 = $chest.element != null && $lectern.element != null;
            } else {
                v1 = found = false;
            }
            if (found) {
                return Unit.INSTANCE;
            }
            return Unit.INSTANCE;
        }
    }
}

