/*
 * Decompiled with CFR 0.152.
 */
package com.ruslan.growsseth.entity.researcher;

import com.filloax.fxlib.api.nbt.NbtUtilsKt;
import com.mojang.serialization.Codec;
import com.ruslan.growsseth.RuinsOfGrowsseth;
import com.ruslan.growsseth.config.DebugConfig;
import com.ruslan.growsseth.config.ResearcherConfig;
import com.ruslan.growsseth.entity.GrowssethEntities;
import com.ruslan.growsseth.entity.SpawnTimeTracker;
import com.ruslan.growsseth.entity.researcher.Researcher;
import com.ruslan.growsseth.entity.researcher.ResearcherDataUser;
import com.ruslan.growsseth.entity.researcher.ResearcherDialoguesComponent;
import com.ruslan.growsseth.entity.researcher.ResearcherQuestComponent;
import com.ruslan.growsseth.entity.researcher.ResearcherSavedData;
import com.ruslan.growsseth.http.GrowssethExtraEvents;
import com.ruslan.growsseth.sound.GrowssethSounds;
import com.ruslan.growsseth.utils.UtilsKt;
import java.time.LocalDateTime;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FleeSunGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RestrictSunGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.ZombieAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 N2\u00020\u00012\u00020\u00022\u00020\u0003:\u0002NOB\u001d\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ,\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010\u0006\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\b\u00102\u001a\u0004\u0018\u00010,H\u0016J\b\u00103\u001a\u000204H\u0014J\b\u00105\u001a\u000204H\u0014J\b\u00106\u001a\u00020\u0017H\u0014J\u001a\u00107\u001a\u0002042\u0006\u00108\u001a\u0002092\b\b\u0002\u0010:\u001a\u00020\u0017H\u0002J\u0010\u0010;\u001a\u0002042\u0006\u00108\u001a\u000209H\u0016J\b\u0010<\u001a\u000204H\u0016J\b\u0010=\u001a\u000204H\u0014J\u0010\u0010>\u001a\u0002042\u0006\u0010?\u001a\u00020@H\u0016J\u0010\u0010A\u001a\u00020\u00172\u0006\u0010B\u001a\u00020CH\u0016J\b\u0010D\u001a\u00020\u0017H\u0016J\u0010\u0010E\u001a\u0002042\u0006\u0010F\u001a\u00020\u0017H\u0016J\u0010\u0010G\u001a\u0002042\u0006\u0010H\u001a\u00020\u000bH\u0016J\u0010\u0010I\u001a\u0002042\u0006\u0010H\u001a\u00020\u000bH\u0016J\b\u0010J\u001a\u00020KH\u0016J\u0010\u0010L\u001a\u00020K2\u0006\u0010?\u001a\u00020@H\u0016J\b\u0010M\u001a\u00020KH\u0016R\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R$\u0010$\u001a\u00020#2\u0006\u0010\"\u001a\u00020#8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u0012\u0010)\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010*\u00a8\u0006P"}, d2={"Lcom/ruslan/growsseth/entity/researcher/ZombieResearcher;", "Lnet/minecraft/world/entity/monster/ZombieVillager;", "Lcom/ruslan/growsseth/entity/SpawnTimeTracker;", "Lcom/ruslan/growsseth/entity/researcher/ResearcherDataUser;", "entityType", "Lnet/minecraft/world/entity/EntityType;", "level", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "researcherData", "Lnet/minecraft/nbt/CompoundTag;", "getResearcherData", "()Lnet/minecraft/nbt/CompoundTag;", "setResearcherData", "(Lnet/minecraft/nbt/CompoundTag;)V", "researcherOriginalPos", "Lnet/minecraft/core/BlockPos;", "getResearcherOriginalPos", "()Lnet/minecraft/core/BlockPos;", "setResearcherOriginalPos", "(Lnet/minecraft/core/BlockPos;)V", "shouldDespawn", "", "getShouldDespawn", "()Z", "setShouldDespawn", "(Z)V", "lastWorldDataTime", "Ljava/time/LocalDateTime;", "getLastWorldDataTime", "()Ljava/time/LocalDateTime;", "setLastWorldDataTime", "(Ljava/time/LocalDateTime;)V", "value", "", "spawnTime", "getSpawnTime", "()J", "setSpawnTime", "(J)V", "_spawnTime", "Ljava/lang/Long;", "finalizeSpawn", "Lnet/minecraft/world/entity/SpawnGroupData;", "Lnet/minecraft/world/level/ServerLevelAccessor;", "difficulty", "Lnet/minecraft/world/DifficultyInstance;", "reason", "Lnet/minecraft/world/entity/MobSpawnType;", "spawnData", "registerGoals", "", "addBehaviourGoals", "shouldDespawnInPeaceful", "convertToResearcher", "serverLevel", "Lnet/minecraft/server/level/ServerLevel;", "alsoMove", "finishConversion", "tick", "customServerAiStep", "die", "damageSource", "Lnet/minecraft/world/damagesource/DamageSource;", "removeWhenFarAway", "distanceToClosestPlayer", "", "requiresCustomPersistence", "setBaby", "baby", "addAdditionalSaveData", "compound", "readAdditionalSaveData", "getAmbientSound", "Lnet/minecraft/sounds/SoundEvent;", "getHurtSound", "getDeathSound", "Companion", "ZombieResearcherAttackGoal", "ruins-of-growsseth"})
@SourceDebugExtension(value={"SMAP\nZombieResearcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ZombieResearcher.kt\ncom/ruslan/growsseth/entity/researcher/ZombieResearcher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,246:1\n1#2:247\n*E\n"})
public final class ZombieResearcher
extends ZombieVillager
implements SpawnTimeTracker,
ResearcherDataUser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private CompoundTag researcherData;
    @Nullable
    private BlockPos researcherOriginalPos;
    private boolean shouldDespawn;
    @Nullable
    private LocalDateTime lastWorldDataTime;
    @Nullable
    private Long _spawnTime;
    @NotNull
    public static final String SPAWN_TIME_TAG = "ResearcherSpawnTime";

    public ZombieResearcher(@NotNull EntityType<ZombieResearcher> entityType, @NotNull Level level) {
        Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        super(entityType, level);
    }

    @Nullable
    public final CompoundTag getResearcherData() {
        return this.researcherData;
    }

    public final void setResearcherData(@Nullable CompoundTag compoundTag) {
        this.researcherData = compoundTag;
    }

    @Nullable
    public final BlockPos getResearcherOriginalPos() {
        return this.researcherOriginalPos;
    }

    public final void setResearcherOriginalPos(@Nullable BlockPos blockPos) {
        this.researcherOriginalPos = blockPos;
    }

    public final boolean getShouldDespawn() {
        return this.shouldDespawn;
    }

    public final void setShouldDespawn(boolean bl) {
        this.shouldDespawn = bl;
    }

    @Override
    @Nullable
    public LocalDateTime getLastWorldDataTime() {
        return this.lastWorldDataTime;
    }

    public void setLastWorldDataTime(@Nullable LocalDateTime localDateTime) {
        this.lastWorldDataTime = localDateTime;
    }

    @Override
    public long getSpawnTime() {
        if (this._spawnTime == null) {
            this._spawnTime = this.level().getGameTime();
        }
        Long l = this._spawnTime;
        Intrinsics.checkNotNull((Object)l);
        return l;
    }

    public void setSpawnTime(long value) {
        this._spawnTime = value;
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(@NotNull ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType reason, @Nullable SpawnGroupData spawnData) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)difficulty, (String)"difficulty");
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        this.setVillagerData(this.getVillagerData().setProfession(VillagerProfession.CARTOGRAPHER).setLevel(5));
        return super.finalizeSpawn(level, difficulty, reason, spawnData);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(2, (Goal)new RestrictSunGoal((PathfinderMob)this));
        this.goalSelector.addGoal(3, (Goal)new FleeSunGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.addBehaviourGoals();
    }

    protected void addBehaviourGoals() {
        Zombie zombie = (Zombie)this;
        Level level = this.level();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
        this.goalSelector.addGoal(2, (Goal)new ZombieResearcherAttackGoal(zombie, 1.0, false, level));
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        Class[] classArray = new Class[]{ZombifiedPiglin.class};
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(classArray));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Researcher.class, true));
    }

    protected boolean shouldDespawnInPeaceful() {
        return false;
    }

    private final void convertToResearcher(ServerLevel serverLevel, boolean alsoMove) {
        block8: {
            CompoundTag useResData;
            CompoundTag compoundTag;
            Researcher researcher = (Researcher)this.convertTo(GrowssethEntities.INSTANCE.getRESEARCHER(), false);
            for (EquipmentSlot equipmentSlot : EntriesMappings.entries$0) {
                double d;
                ItemStack itemStack = this.getItemBySlot(equipmentSlot);
                if (itemStack.isEmpty() || (d = (double)this.getEquipmentDropChance(equipmentSlot)) <= 1.0) continue;
                this.spawnAtLocation(itemStack);
            }
            if (UtilsKt.isNull(researcher)) {
                RuinsOfGrowsseth.LOGGER.error("Zombie researcher to researcher for " + this + " conversion failed!", new Object[0]);
                return;
            }
            ServerLevelAccessor serverLevelAccessor = (ServerLevelAccessor)serverLevel;
            DifficultyInstance difficultyInstance = serverLevel.getCurrentDifficultyAt(researcher.blockPosition());
            Intrinsics.checkNotNullExpressionValue((Object)difficultyInstance, (String)"getCurrentDifficultyAt(...)");
            researcher.finalizeSpawn(serverLevelAccessor, difficultyInstance, MobSpawnType.CONVERSION, null);
            if (ResearcherConfig.singleResearcher) {
                MinecraftServer minecraftServer = serverLevel.getServer();
                Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
                compoundTag = ResearcherSavedData.Companion.getPersistent(minecraftServer).getData();
            } else {
                compoundTag = this.researcherData;
            }
            CompoundTag compoundTag2 = useResData = compoundTag;
            if (compoundTag2 != null) {
                CompoundTag it = compoundTag2;
                boolean bl = false;
                researcher.readResearcherData(it);
            }
            researcher.setHealed(true);
            ResearcherDialoguesComponent researcherDialoguesComponent = researcher.getDialogues();
            if (researcherDialoguesComponent != null) {
                researcherDialoguesComponent.resetNearbyPlayers();
            }
            BlockPos blockPos = this.researcherOriginalPos;
            if (blockPos != null) {
                BlockPos it = blockPos;
                boolean bl = false;
                researcher.resetStartingPos(it);
            }
            researcher.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 200, 0));
            if (!alsoMove) break block8;
            BlockPos blockPos2 = researcher.getStartingPos();
            if (blockPos2 != null) {
                BlockPos it = blockPos2;
                boolean bl = false;
                researcher.moveTo(it, researcher.getYRot(), researcher.getXRot());
            }
        }
    }

    static /* synthetic */ void convertToResearcher$default(ZombieResearcher zombieResearcher, ServerLevel serverLevel, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        zombieResearcher.convertToResearcher(serverLevel, bl);
    }

    public void finishConversion(@NotNull ServerLevel serverLevel) {
        Intrinsics.checkNotNullParameter((Object)serverLevel, (String)"serverLevel");
        ZombieResearcher.convertToResearcher$default(this, serverLevel, false, 2, null);
        if (!this.isSilent()) {
            serverLevel.levelEvent(null, 1027, this.blockPosition(), 0);
        }
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide && this.isAlive() && this.isConverting()) {
            if (DebugConfig.researcherSpeedup) {
                this.villagerConversionTime = Math.min(10, this.villagerConversionTime);
            }
            int n = this.villagerConversionTime;
            this.villagerConversionTime = n + -1;
        }
    }

    protected void customServerAiStep() {
        super.customServerAiStep();
        MinecraftServer minecraftServer = this.getServer();
        Intrinsics.checkNotNull((Object)minecraftServer);
        MinecraftServer server = minecraftServer;
        if (ResearcherConfig.singleResearcher) {
            ResearcherSavedData savedData = ResearcherSavedData.Companion.getPersistent(server);
            if (savedData.isDead()) {
                RuinsOfGrowsseth.LOGGER.info("Zombie researcher " + this + " | should be dead from data, discarding...", new Object[0]);
                this.discard();
                return;
            }
            if (!this.isUpToDateWithWorldData(savedData)) {
                RuinsOfGrowsseth.LOGGER.info("Zombie researcher " + this + " | is not up to date with world data, updating...", new Object[0]);
                this.researcherData = savedData.getData();
                this.setLastWorldDataTime(savedData.getLastChangeTimestamp());
                RuinsOfGrowsseth.LOGGER.info("Zombie researcher " + this + " | updated world data!", new Object[0]);
            }
        }
        if (ResearcherQuestComponent.Companion.isHealed(server)) {
            Level level = this.level();
            Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            this.convertToResearcher((ServerLevel)level, true);
        }
        if (this.tickCount % 20 == 0 && GrowssethExtraEvents.INSTANCE.getShouldRunResearcherRemoveCheck()) {
            GrowssethExtraEvents.INSTANCE.researcherRemoveCheck((LivingEntity)this, this);
        }
        if (this.shouldDespawn) {
            this.remove(Entity.RemovalReason.DISCARDED);
            RuinsOfGrowsseth.LOGGER.info("Removed " + this + " because another researcher was killed somewhere else", new Object[0]);
        }
    }

    public void die(@NotNull DamageSource damageSource) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)damageSource, (String)"damageSource");
            super.die(damageSource);
            if (!ResearcherConfig.singleResearcher) break block1;
            MinecraftServer minecraftServer = this.getServer();
            if (minecraftServer != null) {
                MinecraftServer serv = minecraftServer;
                boolean bl = false;
                ResearcherSavedData savedData = ResearcherSavedData.Companion.getPersistent(serv);
                savedData.setDead(true);
                savedData.setDirty();
            }
        }
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public boolean requiresCustomPersistence() {
        return true;
    }

    public void setBaby(boolean baby) {
    }

    public void addAdditionalSaveData(@NotNull CompoundTag compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        super.addAdditionalSaveData(compound);
        CompoundTag compoundTag = this.researcherData;
        if (compoundTag != null) {
            CompoundTag it = compoundTag;
            boolean bl = false;
            compound.put("ResearcherData", (Tag)it);
        }
        Codec codec = BlockPos.CODEC;
        Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"CODEC");
        NbtUtilsKt.saveField((CompoundTag)compound, (String)"ResearcherPos", (Codec)codec, (Function0)((Function0)new MutablePropertyReference0Impl(this){

            public Object get() {
                return ((ZombieResearcher)this.receiver).getResearcherOriginalPos();
            }

            public void set(Object value) {
                ((ZombieResearcher)this.receiver).setResearcherOriginalPos((BlockPos)value);
            }
        }));
        compound.putLong(SPAWN_TIME_TAG, this.getSpawnTime());
    }

    public void readAdditionalSaveData(@NotNull CompoundTag compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        super.readAdditionalSaveData(compound);
        CompoundTag compoundTag = compound.getCompound("ResearcherData");
        if (compoundTag != null) {
            CompoundTag it = compoundTag;
            boolean bl = false;
            this.researcherData = it;
        }
        Codec codec = BlockPos.CODEC;
        Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"CODEC");
        this.researcherOriginalPos = (BlockPos)NbtUtilsKt.loadField((CompoundTag)compound, (String)"ResearcherPos", (Codec)codec);
        if (compound.contains(SPAWN_TIME_TAG)) {
            this.setSpawnTime(compound.getLong(SPAWN_TIME_TAG));
        }
    }

    @NotNull
    public SoundEvent getAmbientSound() {
        return GrowssethSounds.Companion.getZOMBIE_RESEARCHER_AMBIENT();
    }

    @NotNull
    public SoundEvent getHurtSound(@NotNull DamageSource damageSource) {
        Intrinsics.checkNotNullParameter((Object)damageSource, (String)"damageSource");
        return GrowssethSounds.Companion.getZOMBIE_RESEARCHER_HURT();
    }

    @NotNull
    public SoundEvent getDeathSound() {
        return GrowssethSounds.Companion.getZOMBIE_RESEARCHER_DEATH();
    }

    @Override
    public boolean isUpToDateWithWorldData(@NotNull ResearcherSavedData savedData) {
        return ResearcherDataUser.DefaultImpls.isUpToDateWithWorldData(this, savedData);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/ruslan/growsseth/entity/researcher/ZombieResearcher$Companion;", "", "<init>", "()V", "createAttributes", "Lkotlin/Function0;", "Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier$Builder;", "SPAWN_TIME_TAG", "", "ruins-of-growsseth"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Function0<AttributeSupplier.Builder> createAttributes() {
            return Companion::createAttributes$lambda$0;
        }

        private static final AttributeSupplier.Builder createAttributes$lambda$0() {
            return ZombieVillager.createAttributes().add(Attributes.MAX_HEALTH, 40.0).add(Attributes.ARMOR, 10.0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<EquipmentSlot> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])EquipmentSlot.values()));
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u000e\u001a\u00020\u0007H\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000f"}, d2={"Lcom/ruslan/growsseth/entity/researcher/ZombieResearcher$ZombieResearcherAttackGoal;", "Lnet/minecraft/world/entity/ai/goal/ZombieAttackGoal;", "zombie", "Lnet/minecraft/world/entity/monster/Zombie;", "speedModifier", "", "followingTargetEvenIfNotSeen", "", "level", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/entity/monster/Zombie;DZLnet/minecraft/world/level/Level;)V", "getLevel", "()Lnet/minecraft/world/level/Level;", "canUse", "ruins-of-growsseth"})
    public static final class ZombieResearcherAttackGoal
    extends ZombieAttackGoal {
        @NotNull
        private final Level level;

        public ZombieResearcherAttackGoal(@NotNull Zombie zombie, double speedModifier, boolean followingTargetEvenIfNotSeen, @NotNull Level level) {
            Intrinsics.checkNotNullParameter((Object)zombie, (String)"zombie");
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            super(zombie, speedModifier, followingTargetEvenIfNotSeen);
            this.level = level;
        }

        @NotNull
        public final Level getLevel() {
            return this.level;
        }

        public boolean canUse() {
            if (this.level.getDifficulty() == Difficulty.PEACEFUL) {
                return false;
            }
            return super.canUse();
        }
    }
}

