/*
 * Decompiled with CFR 0.152.
 */
package com.ruslan.growsseth.entity.researcher.trades;

import com.filloax.fxlib.api.FxLibServices;
import com.filloax.fxlib.api.structure.FixedStructureGeneration;
import com.ruslan.growsseth.entity.researcher.Researcher;
import com.ruslan.growsseth.entity.researcher.trades.ResearcherTradeEntry;
import com.ruslan.growsseth.entity.researcher.trades.ResearcherTradeMode;
import com.ruslan.growsseth.entity.researcher.trades.ResearcherTradesData;
import com.ruslan.growsseth.entity.researcher.trades.ResearcherTradesProvider;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.trading.MerchantOffers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J \u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H&J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0004J\u001c\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0004J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00122\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001e"}, d2={"Lcom/ruslan/growsseth/entity/researcher/trades/AbstractResearcherTradesProvider;", "Lcom/ruslan/growsseth/entity/researcher/trades/ResearcherTradesProvider;", "<init>", "()V", "lastPlayers", "", "Ljava/util/UUID;", "fixedStructureGeneration", "Lcom/filloax/fxlib/api/structure/FixedStructureGeneration;", "getFixedStructureGeneration", "()Lcom/filloax/fxlib/api/structure/FixedStructureGeneration;", "getOffers", "Lnet/minecraft/world/item/trading/MerchantOffers;", "researcher", "Lcom/ruslan/growsseth/entity/researcher/Researcher;", "tradesData", "Lcom/ruslan/growsseth/entity/researcher/trades/ResearcherTradesData;", "player", "Lnet/minecraft/server/level/ServerPlayer;", "getOffersImpl", "isEnabled", "", "server", "Lnet/minecraft/server/MinecraftServer;", "processTrades", "", "Lcom/ruslan/growsseth/entity/researcher/trades/ResearcherTradeEntry;", "list", "getPlayer", "lastTradePlayerId", "ruins-of-growsseth"})
@SourceDebugExtension(value={"SMAP\nResearcherTradesProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResearcherTradesProvider.kt\ncom/ruslan/growsseth/entity/researcher/trades/AbstractResearcherTradesProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,64:1\n1053#2:65\n1#3:66\n*S KotlinDebug\n*F\n+ 1 ResearcherTradesProvider.kt\ncom/ruslan/growsseth/entity/researcher/trades/AbstractResearcherTradesProvider\n*L\n54#1:65\n*E\n"})
public abstract class AbstractResearcherTradesProvider
implements ResearcherTradesProvider {
    @NotNull
    private Map<UUID, UUID> lastPlayers = new LinkedHashMap();
    @NotNull
    private final FixedStructureGeneration fixedStructureGeneration = FxLibServices.INSTANCE.getFixedStructureGeneration();

    @NotNull
    protected final FixedStructureGeneration getFixedStructureGeneration() {
        return this.fixedStructureGeneration;
    }

    @Override
    @NotNull
    public final MerchantOffers getOffers(@NotNull Researcher researcher, @NotNull ResearcherTradesData tradesData, @NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)researcher, (String)"researcher");
        Intrinsics.checkNotNullParameter((Object)tradesData, (String)"tradesData");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.lastPlayers.put(researcher.getUUID(), player.getUUID());
        return this.getOffersImpl(researcher, tradesData, player);
    }

    @NotNull
    public abstract MerchantOffers getOffersImpl(@NotNull Researcher var1, @NotNull ResearcherTradesData var2, @NotNull ServerPlayer var3);

    protected final boolean isEnabled(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        return ResearcherTradeMode.Companion.getFromSettings(server) == this.getMode();
    }

    @NotNull
    protected final List<ResearcherTradeEntry> processTrades(@NotNull List<ResearcherTradeEntry> list) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Map valueToItemMap = new LinkedHashMap();
        for (ResearcherTradeEntry entry : list) {
            List itemList;
            Item value = entry.getItemListing().getGivesItem();
            Intrinsics.checkNotNullExpressionValue((Object)valueToItemMap.computeIfAbsent(value, arg_0 -> AbstractResearcherTradesProvider.processTrades$lambda$1(AbstractResearcherTradesProvider::processTrades$lambda$0, arg_0)), (String)"computeIfAbsent(...)");
            if (entry.getReplace()) {
                CollectionsKt.removeAll((List)itemList, arg_0 -> AbstractResearcherTradesProvider.processTrades$lambda$2(entry, arg_0));
            }
            itemList.add(entry);
        }
        Iterable $this$sortedBy$iv = CollectionsKt.flatten((Iterable)valueToItemMap.values());
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ResearcherTradeEntry it = (ResearcherTradeEntry)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getPriority());
                it = (ResearcherTradeEntry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getPriority()));
            }
        });
    }

    private final ServerPlayer getPlayer(Researcher researcher) {
        ServerPlayer serverPlayer;
        UUID playerUuid;
        MinecraftServer minecraftServer = researcher.getServer();
        if (minecraftServer == null) {
            throw new IllegalStateException("Used AbstractGameProvider from client thread!");
        }
        MinecraftServer server = minecraftServer;
        UUID uUID = playerUuid = this.lastPlayers.get(researcher.getUUID());
        if (uUID != null) {
            UUID it = uUID;
            boolean bl = false;
            serverPlayer = server.getPlayerList().getPlayer(playerUuid);
        } else {
            serverPlayer = null;
        }
        return serverPlayer;
    }

    @Override
    @Nullable
    public UUID lastTradePlayerId(@NotNull Researcher researcher) {
        Intrinsics.checkNotNullParameter((Object)researcher, (String)"researcher");
        ServerPlayer serverPlayer = this.getPlayer(researcher);
        return serverPlayer != null ? serverPlayer.getUUID() : null;
    }

    private static final List processTrades$lambda$0(Item it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ArrayList();
    }

    private static final List processTrades$lambda$1(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final boolean processTrades$lambda$2(ResearcherTradeEntry $entry, ResearcherTradeEntry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getPriority() > $entry.getPriority() || !it.getReplace();
    }
}

