/*
 * Decompiled with CFR 0.152.
 */
package com.ruslan.growsseth.entity.researcher.trades;

import com.filloax.fxlib.api.UtilsKt;
import com.filloax.fxlib.api.codec.CodecUtils;
import com.filloax.fxlib.api.codec.CodecUtilsKt;
import com.filloax.fxlib.api.savedata.FxSavedData;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.ruslan.growsseth.advancements.StructureAdvancements;
import com.ruslan.growsseth.config.ResearcherConfig;
import com.ruslan.growsseth.entity.researcher.Researcher;
import com.ruslan.growsseth.entity.researcher.ResearcherQuestComponent;
import com.ruslan.growsseth.entity.researcher.trades.AbstractResearcherTradesProvider;
import com.ruslan.growsseth.entity.researcher.trades.GlobalResearcherTradesProvider;
import com.ruslan.growsseth.entity.researcher.trades.ProgressResearcherTradesProvider;
import com.ruslan.growsseth.entity.researcher.trades.ResearcherItemListing;
import com.ruslan.growsseth.entity.researcher.trades.ResearcherTradeEntry;
import com.ruslan.growsseth.entity.researcher.trades.ResearcherTradeMode;
import com.ruslan.growsseth.entity.researcher.trades.ResearcherTradesData;
import com.ruslan.growsseth.entity.researcher.trades.TradesListener;
import com.ruslan.growsseth.structure.GrowssethStructures;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import kotlin.random.Random;
import kotlin.random.RandomKt;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty1;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 /2\u00020\u0001:\u0003/01B%\u0012\u0012\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J&\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00032\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J0\u0010 \u001a\u00020\u00072\u0012\u0010!\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020#0\"0\u00032\u0012\u0010$\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020#0\"0\u0003H\u0002J\u0018\u0010%\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020&H\u0002J \u0010'\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020&H\u0002J\u001e\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00190\u00032\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020&H\u0002J(\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00190\u00032\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\b\u0002\u0010*\u001a\u00020\u0007H\u0002J6\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00190\u00032\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00190\u00032\b\b\u0002\u0010*\u001a\u00020\u0007H\u0002J\u001e\u0010-\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002R\u001a\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR&\u0010\u000e\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/ruslan/growsseth/entity/researcher/trades/ProgressResearcherTradesProvider;", "Lcom/ruslan/growsseth/entity/researcher/trades/GlobalResearcherTradesProvider;", "structures", "", "Lnet/minecraft/resources/ResourceKey;", "Lnet/minecraft/world/level/levelgen/structure/Structure;", "inOrder", "", "<init>", "(Ljava/util/List;Z)V", "mode", "Lcom/ruslan/growsseth/entity/researcher/trades/ResearcherTradeMode;", "getMode", "()Lcom/ruslan/growsseth/entity/researcher/trades/ResearcherTradeMode;", "structByTags", "", "Lnet/minecraft/tags/TagKey;", "onlyOneLeft", "server", "Lnet/minecraft/server/MinecraftServer;", "isFinished", "regenTrades", "", "reload", "getExtraPlayerTrades", "Lcom/ruslan/growsseth/entity/researcher/trades/ResearcherTradeEntry;", "player", "Lnet/minecraft/server/level/ServerPlayer;", "researcher", "Lcom/ruslan/growsseth/entity/researcher/Researcher;", "data", "Lcom/ruslan/growsseth/entity/researcher/trades/ResearcherTradesData;", "tradesDiffer", "tradesOld", "Lnet/minecraft/core/Holder;", "Lnet/minecraft/world/item/Item;", "tradesNew", "checkAndSetCurrentStructure", "Lcom/ruslan/growsseth/entity/researcher/trades/ProgressResearcherTradesProvider$ProgressTradesSavedData;", "getNewTargetStructure", "genFixedTrades", "getPossibleRandomTrades", "allTrades", "genRandomTrades", "possibleTrades", "getReferenceStructure", "structId", "Companion", "ProgressTradesSavedData", "Callbacks", "ruins-of-growsseth"})
@SourceDebugExtension(value={"SMAP\nProgressResearcherTradesProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProgressResearcherTradesProvider.kt\ncom/ruslan/growsseth/entity/researcher/trades/ProgressResearcherTradesProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,265:1\n1202#2,2:266\n1230#2,4:268\n1557#2:272\n1628#2,3:273\n1557#2:290\n1628#2,3:291\n487#3,7:276\n487#3,7:283\n487#3,7:294\n*S KotlinDebug\n*F\n+ 1 ProgressResearcherTradesProvider.kt\ncom/ruslan/growsseth/entity/researcher/trades/ProgressResearcherTradesProvider\n*L\n42#1:266,2\n42#1:268,4\n76#1:272\n76#1:273,3\n144#1:290\n144#1:291,3\n135#1:276,7\n139#1:283,7\n158#1:294,7\n*E\n"})
public final class ProgressResearcherTradesProvider
extends GlobalResearcherTradesProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<ResourceKey<Structure>> structures;
    private final boolean inOrder;
    @NotNull
    private final ResearcherTradeMode mode;
    @NotNull
    private final Map<TagKey<Structure>, ResourceKey<Structure>> structByTags;
    private static int numInstances;

    /*
     * WARNING - void declaration
     */
    public ProgressResearcherTradesProvider(@NotNull List<? extends ResourceKey<Structure>> structures, boolean inOrder) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Intrinsics.checkNotNullParameter(structures, (String)"structures");
        super(false, 1, null);
        this.structures = structures;
        this.inOrder = inOrder;
        this.mode = this.inOrder ? ResearcherTradeMode.GROWSSETH_PROGRESS : ResearcherTradeMode.PROGRESS;
        Iterable iterable = this.structures;
        ProgressResearcherTradesProvider progressResearcherTradesProvider = this;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void var6_8 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            ResourceKey resourceKey = (ResourceKey)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            GrowssethStructures.StructureInfo structureInfo = GrowssethStructures.INSTANCE.getInfo().get(it);
            Intrinsics.checkNotNull((Object)structureInfo);
            map.put(structureInfo.getTag(), element$iv$iv);
        }
        progressResearcherTradesProvider.structByTags = destination$iv$iv;
        this.init();
        int n = numInstances;
        numInstances = n + 1;
        if (numInstances > 2) {
            throw new IllegalStateException("Instanced more than two ProgressResearcherTradesProvider: " + this);
        }
    }

    public /* synthetic */ ProgressResearcherTradesProvider(List list, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(list, bl);
    }

    @Override
    @NotNull
    public ResearcherTradeMode getMode() {
        return this.mode;
    }

    public final boolean onlyOneLeft(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        ProgressTradesSavedData it = ProgressTradesSavedData.Companion.get(server);
        boolean bl = false;
        return it.getCurrentStructure() != null && it.getFoundStructures().size() == this.structures.size() - 1;
    }

    public final boolean isFinished(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        ProgressTradesSavedData it = ProgressTradesSavedData.Companion.get(server);
        boolean bl = false;
        return it.getCurrentStructure() == null && !((Collection)it.getFoundStructures()).isEmpty();
    }

    private final void regenTrades(MinecraftServer server) {
        ProgressTradesSavedData data = ProgressTradesSavedData.Companion.get(server);
        this.checkAndSetCurrentStructure(server, data);
        List<ResearcherTradeEntry> fixedTrades = this.genFixedTrades(server, data);
        this.applyUpdatedTrades(server, fixedTrades);
    }

    @Override
    public void reload(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        this.regenTrades(server);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected List<ResearcherTradeEntry> getExtraPlayerTrades(@NotNull ServerPlayer player, @NotNull Researcher researcher, @NotNull ResearcherTradesData data) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)researcher, (String)"researcher");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        ResearcherQuestComponent researcherQuestComponent = researcher.getQuest();
        Intrinsics.checkNotNull((Object)researcherQuestComponent);
        boolean finishedQuest = researcherQuestComponent.passedStage("home");
        List<ResearcherTradeEntry> possibleTrades = this.getPossibleRandomTrades(player, researcher, finishedQuest);
        Iterable $this$map$iv = possibleTrades;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ResearcherTradeEntry researcherTradeEntry = (ResearcherTradeEntry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getItemListing().getGivesItemHolder());
        }
        List possibleTradesItems = (List)destination$iv$iv;
        boolean tradesChanged = this.tradesDiffer(data.getLastAvailableRandomTrades(), possibleTradesItems);
        long time = researcher.level().getGameTime();
        List<ResearcherTradeEntry> randomTrades = data.getRandomTrades();
        if (randomTrades == null || tradesChanged || data.getLastRandomTradeChangeTime() < 0L || time - data.getLastRandomTradeChangeTime() > 24000L || finishedQuest) {
            data.setLastRandomTradeChangeTime(time);
            data.getLastAvailableRandomTrades().clear();
            data.getLastAvailableRandomTrades().addAll(possibleTradesItems);
            randomTrades = this.genRandomTrades(player, researcher, possibleTrades, finishedQuest);
        }
        data.setRandomTrades(randomTrades);
        return randomTrades;
    }

    private final boolean tradesDiffer(List<? extends Holder<Item>> tradesOld, List<? extends Holder<Item>> tradesNew) {
        if (tradesNew.size() != tradesOld.size()) {
            return true;
        }
        int n = ((Collection)tradesNew).size();
        for (int i = 0; i < n; ++i) {
            if (Intrinsics.areEqual((Object)tradesOld.get(i).value(), (Object)tradesNew.get(i).value())) continue;
            return true;
        }
        return false;
    }

    private final void checkAndSetCurrentStructure(MinecraftServer server, ProgressTradesSavedData data) {
        ResourceKey<Structure> currentStructure = data.getCurrentStructure();
        if (currentStructure != null && data.getFoundStructures().contains(currentStructure) || currentStructure == null && data.getFoundStructures().isEmpty()) {
            currentStructure = this.getNewTargetStructure(server, data);
            data.setCurrentStructure(currentStructure);
            data.setDirty();
        }
    }

    private final ResourceKey<Structure> getNewTargetStructure(MinecraftServer server, ProgressTradesSavedData data) {
        if (this.inOrder) {
            for (ResourceKey<Structure> structId : this.structures) {
                if (data.getFoundStructures().contains(structId)) continue;
                return structId;
            }
            return null;
        }
        List possibleStructures = CollectionsKt.minus((Iterable)this.structures, (Iterable)data.getFoundStructures());
        return (ResourceKey)CollectionsKt.randomOrNull((Collection)possibleStructures, (Random)RandomKt.Random((long)server.overworld().getSeed()));
    }

    /*
     * WARNING - void declaration
     */
    private final List<ResearcherTradeEntry> genFixedTrades(MinecraftServer server, ProgressTradesSavedData data) {
        Map<String, List<ResearcherTradeEntry>> $this$filterKeys$iv = TradesListener.Companion.getTRADES_BEFORE_STRUCTURE();
        boolean $i$f$filterKeys = false;
        LinkedHashMap<String, List<ResearcherTradeEntry>> result$iv = new LinkedHashMap<String, List<ResearcherTradeEntry>>();
        for (Map.Entry<String, List<ResearcherTradeEntry>> entry : $this$filterKeys$iv.entrySet()) {
            String string = entry.getKey();
            boolean bl = false;
            ResourceKey key = ResourceKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)com.ruslan.growsseth.utils.UtilsKt.resLoc(string));
            if (!(Intrinsics.areEqual(data.getCurrentStructure(), (Object)key) || data.getFoundStructures().contains(key))) continue;
            result$iv.put(entry.getKey(), entry.getValue());
        }
        List tradesBefore = CollectionsKt.flatten((Iterable)((Map)result$iv).values());
        Map<String, List<ResearcherTradeEntry>> $this$filterKeys$iv2 = TradesListener.Companion.getTRADES_PROGRESS_AFTER_STRUCTURE();
        boolean $i$f$filterKeys2 = false;
        LinkedHashMap<String, List<ResearcherTradeEntry>> result$iv2 = new LinkedHashMap<String, List<ResearcherTradeEntry>>();
        for (Map.Entry<String, List<ResearcherTradeEntry>> entry : $this$filterKeys$iv2.entrySet()) {
            String it = entry.getKey();
            boolean bl = false;
            ResourceKey key = ResourceKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)com.ruslan.growsseth.utils.UtilsKt.resLoc(it));
            if (!data.getFoundStructures().contains(key)) continue;
            result$iv2.put(entry.getKey(), entry.getValue());
        }
        List tradesAfter = CollectionsKt.flatten((Iterable)((Map)result$iv2).values());
        List allTrades = CollectionsKt.plus((Collection)tradesBefore, (Iterable)tradesAfter);
        Iterable $this$map$iv = allTrades;
        boolean bl = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : iterable) {
            void trade;
            ResearcherTradeEntry researcherTradeEntry = (ResearcherTradeEntry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            ResearcherItemListing researcherItemListing = trade.getItemListing();
            RegistryAccess.Frozen frozen = server.registryAccess();
            Intrinsics.checkNotNullExpressionValue((Object)frozen, (String)"registryAccess(...)");
            List<ResourceLocation> matchingStructures = researcherItemListing.getAllPossibleStructures((RegistryAccess)frozen);
            ResourceKey<Structure> resourceKey = data.getCurrentStructure();
            collection.add(!CollectionsKt.contains((Iterable)matchingStructures, (Object)(resourceKey != null ? resourceKey.location() : null)) ? ResearcherTradeEntry.copy$default((ResearcherTradeEntry)trade, null, trade.getPriority() + 1000, false, 5, null) : trade);
        }
        List changedMapPriority = (List)destination$iv$iv;
        return changedMapPriority;
    }

    private final List<ResearcherTradeEntry> getPossibleRandomTrades(ServerPlayer player, Researcher researcher, boolean allTrades) {
        Map map;
        Map tradesTable = TradesListener.Companion.getTRADES_PROGRESS_AFTER_STRUCTURE_RANDOM();
        if (!allTrades) {
            Map $this$filterKeys$iv = tradesTable;
            boolean $i$f$filterKeys = false;
            LinkedHashMap<String, List<ResearcherTradeEntry>> result$iv = new LinkedHashMap<String, List<ResearcherTradeEntry>>();
            for (Map.Entry<String, List<ResearcherTradeEntry>> entry$iv : $this$filterKeys$iv.entrySet()) {
                String it = entry$iv.getKey();
                boolean bl = false;
                ResourceKey key = ResourceKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)com.ruslan.growsseth.utils.UtilsKt.resLoc(it));
                GrowssethStructures.StructureInfo structureInfo = GrowssethStructures.INSTANCE.getInfo().get(key);
                Intrinsics.checkNotNull((Object)structureInfo);
                TagKey<Structure> tag = structureInfo.getTag();
                if (!StructureAdvancements.INSTANCE.playerHasFoundStructure(player, tag)) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            map = result$iv;
        } else {
            map = tradesTable;
        }
        return CollectionsKt.flatten((Iterable)map.values());
    }

    static /* synthetic */ List getPossibleRandomTrades$default(ProgressResearcherTradesProvider progressResearcherTradesProvider, ServerPlayer serverPlayer, Researcher researcher, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return progressResearcherTradesProvider.getPossibleRandomTrades(serverPlayer, researcher, bl);
    }

    private final List<ResearcherTradeEntry> genRandomTrades(ServerPlayer player, Researcher researcher, List<ResearcherTradeEntry> possibleTrades, boolean allTrades) {
        long daysOffset = researcher.level().getGameTime() * (long)1323;
        Random random = RandomKt.Random((long)(player.server.overworld().getSeed() + (long)(researcher.getUUID().hashCode() * 10) + daysOffset));
        if (!allTrades) {
            int amount = RangesKt.random((IntRange)new IntRange(Math.min(ResearcherConfig.randomTradeNumItems.min, possibleTrades.size()), Math.min(ResearcherConfig.randomTradeNumItems.max, possibleTrades.size())), (Random)random);
            return amount > 0 ? CollectionsKt.shuffled((Iterable)possibleTrades, (Random)random).subList(0, amount) : CollectionsKt.emptyList();
        }
        return possibleTrades;
    }

    static /* synthetic */ List genRandomTrades$default(ProgressResearcherTradesProvider progressResearcherTradesProvider, ServerPlayer serverPlayer, Researcher researcher, List list, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        return progressResearcherTradesProvider.genRandomTrades(serverPlayer, researcher, list, bl);
    }

    private final ResourceKey<Structure> getReferenceStructure(ResourceKey<Structure> structId) {
        GrowssethStructures.StructureInfo structureInfo = GrowssethStructures.INSTANCE.getInfo().get(structId);
        Intrinsics.checkNotNull((Object)structureInfo);
        TagKey<Structure> tag = structureInfo.getTag();
        return this.structByTags.get(tag);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J$\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010\u00a8\u0006\u0011"}, d2={"Lcom/ruslan/growsseth/entity/researcher/trades/ProgressResearcherTradesProvider$Callbacks;", "", "<init>", "()V", "onServerStarted", "", "server", "Lnet/minecraft/server/MinecraftServer;", "onServerTick", "onStructureFound", "player", "Lnet/minecraft/server/level/ServerPlayer;", "structId", "Lnet/minecraft/resources/ResourceKey;", "Lnet/minecraft/world/level/levelgen/structure/Structure;", "isJigsawPart", "", "ruins-of-growsseth"})
    @SourceDebugExtension(value={"SMAP\nProgressResearcherTradesProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProgressResearcherTradesProvider.kt\ncom/ruslan/growsseth/entity/researcher/trades/ProgressResearcherTradesProvider$Callbacks\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,265:1\n1368#2:266\n1454#2,5:267\n1611#2,9:272\n1863#2:281\n1864#2:283\n1620#2:284\n1#3:282\n*S KotlinDebug\n*F\n+ 1 ProgressResearcherTradesProvider.kt\ncom/ruslan/growsseth/entity/researcher/trades/ProgressResearcherTradesProvider$Callbacks\n*L\n235#1:266\n235#1:267,5\n237#1:272,9\n237#1:281\n237#1:283\n237#1:284\n237#1:282\n*E\n"})
    public static final class Callbacks {
        @NotNull
        public static final Callbacks INSTANCE = new Callbacks();

        private Callbacks() {
        }

        public final void onServerStarted(@NotNull MinecraftServer server) {
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            ProgressResearcherTradesProvider progressResearcherTradesProvider = Companion.getCurrent(server);
            if (progressResearcherTradesProvider == null) {
                return;
            }
            ProgressResearcherTradesProvider prov = progressResearcherTradesProvider;
            if (!prov.isEnabled(server)) {
                return;
            }
            prov.regenTrades(server);
        }

        /*
         * WARNING - void declaration
         */
        public final void onServerTick(@NotNull MinecraftServer server) {
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            if (server.getTickCount() % UtilsKt.secondsToTicks((float)5.0f) == 0) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                void $this$flatMapTo$iv$iv;
                ProgressResearcherTradesProvider progressResearcherTradesProvider = Companion.getCurrent(server);
                if (progressResearcherTradesProvider == null) {
                    return;
                }
                ProgressResearcherTradesProvider prov = progressResearcherTradesProvider;
                if (!prov.isEnabled(server)) {
                    return;
                }
                ProgressTradesSavedData data = ProgressTradesSavedData.Companion.get(server);
                List list = server.getPlayerList().getPlayers();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPlayers(...)");
                Iterable $this$flatMap$iv = list;
                boolean $i$f$flatMap = false;
                Iterable iterable = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    ServerPlayer player = (ServerPlayer)element$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)player);
                    Iterable list$iv$iv = StructureAdvancements.INSTANCE.getPlayerFoundStructures(player);
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                $this$flatMap$iv = (List)destination$iv$iv;
                boolean $i$f$mapNotNull = false;
                $this$flatMapTo$iv$iv = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    ResourceKey it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    ResourceKey it = (ResourceKey)element$iv$iv;
                    boolean bl2 = false;
                    if (prov.getReferenceStructure((ResourceKey<Structure>)it) == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                Set foundStructureRefs = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                Set newStructureRefs = SetsKt.minus((Set)foundStructureRefs, (Iterable)data.getFoundStructures());
                if (!((Collection)newStructureRefs).isEmpty()) {
                    data.getFoundStructures().addAll(newStructureRefs);
                    ProgressTradesSavedData.Companion.setDirty(server);
                    prov.regenTrades(server);
                }
            }
        }

        public final void onStructureFound(@NotNull ServerPlayer player, @NotNull ResourceKey<Structure> structId, boolean isJigsawPart) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter(structId, (String)"structId");
            if (!Intrinsics.areEqual((Object)structId.location().getNamespace(), (Object)"growsseth")) {
                return;
            }
            MinecraftServer server = player.server;
            Intrinsics.checkNotNull((Object)server);
            ProgressResearcherTradesProvider progressResearcherTradesProvider = Companion.getCurrent(server);
            if (progressResearcherTradesProvider == null) {
                return;
            }
            ProgressResearcherTradesProvider prov = progressResearcherTradesProvider;
            if (prov.getReferenceStructure((ResourceKey<Structure>)structId) == null) {
                return;
            }
            if (!prov.isEnabled(server)) {
                return;
            }
            ProgressTradesSavedData data = ProgressTradesSavedData.Companion.get(server);
            MinecraftServer minecraftServer = player.server;
            Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"server");
            if (data.alreadyFoundStructure(minecraftServer, structId)) {
                return;
            }
            Set<ResourceKey<Structure>> set = data.getFoundStructures();
            ResourceKey resourceKey = prov.getReferenceStructure((ResourceKey<Structure>)structId);
            Intrinsics.checkNotNull((Object)resourceKey);
            set.add((ResourceKey<Structure>)resourceKey);
            ProgressTradesSavedData.Companion.setDirty(server);
            prov.regenTrades(server);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/ruslan/growsseth/entity/researcher/trades/ProgressResearcherTradesProvider$Companion;", "", "<init>", "()V", "getCurrent", "Lcom/ruslan/growsseth/entity/researcher/trades/ProgressResearcherTradesProvider;", "server", "Lnet/minecraft/server/MinecraftServer;", "numInstances", "", "ruins-of-growsseth"})
    @SourceDebugExtension(value={"SMAP\nProgressResearcherTradesProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProgressResearcherTradesProvider.kt\ncom/ruslan/growsseth/entity/researcher/trades/ProgressResearcherTradesProvider$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,265:1\n1#2:266\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final ProgressResearcherTradesProvider getCurrent(MinecraftServer server) {
            AbstractResearcherTradesProvider it = ResearcherTradeMode.Companion.providerFromSettings(server);
            boolean bl = false;
            return it instanceof ProgressResearcherTradesProvider ? (ProgressResearcherTradesProvider)it : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0014B/\u0012\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003\u0012\u0010\b\u0002\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001c\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004R\u001d\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\"\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lcom/ruslan/growsseth/entity/researcher/trades/ProgressResearcherTradesProvider$ProgressTradesSavedData;", "Lcom/filloax/fxlib/api/savedata/FxSavedData;", "foundStructures", "", "Lnet/minecraft/resources/ResourceKey;", "Lnet/minecraft/world/level/levelgen/structure/Structure;", "currentStructure", "<init>", "(Ljava/util/Set;Lnet/minecraft/resources/ResourceKey;)V", "getFoundStructures", "()Ljava/util/Set;", "getCurrentStructure", "()Lnet/minecraft/resources/ResourceKey;", "setCurrentStructure", "(Lnet/minecraft/resources/ResourceKey;)V", "alreadyFoundStructure", "", "server", "Lnet/minecraft/server/MinecraftServer;", "structId", "Companion", "ruins-of-growsseth"})
    @SourceDebugExtension(value={"SMAP\nProgressResearcherTradesProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProgressResearcherTradesProvider.kt\ncom/ruslan/growsseth/entity/researcher/trades/ProgressResearcherTradesProvider$ProgressTradesSavedData\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,265:1\n1557#2:266\n1628#2,3:267\n1368#2:270\n1454#2,2:271\n1611#2,9:273\n1863#2:282\n1864#2:284\n1620#2:285\n1456#2,3:286\n1#3:283\n*S KotlinDebug\n*F\n+ 1 ProgressResearcherTradesProvider.kt\ncom/ruslan/growsseth/entity/researcher/trades/ProgressResearcherTradesProvider$ProgressTradesSavedData\n*L\n214#1:266\n214#1:267,3\n215#1:270\n215#1:271,2\n216#1:273,9\n216#1:282\n216#1:284\n216#1:285\n215#1:286,3\n216#1:283\n*E\n"})
    public static final class ProgressTradesSavedData
    extends FxSavedData<ProgressTradesSavedData> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Set<ResourceKey<Structure>> foundStructures;
        @Nullable
        private ResourceKey<Structure> currentStructure;
        @NotNull
        private static final Codec<ProgressTradesSavedData> CODEC;
        @NotNull
        private static final FxSavedData.Definition<ProgressTradesSavedData> DEF;

        public ProgressTradesSavedData(@NotNull Set<ResourceKey<Structure>> foundStructures, @Nullable ResourceKey<Structure> currentStructure) {
            Intrinsics.checkNotNullParameter(foundStructures, (String)"foundStructures");
            super(CODEC);
            this.foundStructures = foundStructures;
            this.currentStructure = currentStructure;
        }

        public /* synthetic */ ProgressTradesSavedData(Set set, ResourceKey resourceKey, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                set = new LinkedHashSet();
            }
            if ((n & 2) != 0) {
                resourceKey = null;
            }
            this(set, (ResourceKey<Structure>)resourceKey);
        }

        @NotNull
        public final Set<ResourceKey<Structure>> getFoundStructures() {
            return this.foundStructures;
        }

        @Nullable
        public final ResourceKey<Structure> getCurrentStructure() {
            return this.currentStructure;
        }

        public final void setCurrentStructure(@Nullable ResourceKey<Structure> resourceKey) {
            this.currentStructure = resourceKey;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean alreadyFoundStructure(@NotNull MinecraftServer server, @NotNull ResourceKey<Structure> structId) {
            void $this$flatMapTo$iv$iv;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            Intrinsics.checkNotNullParameter(structId, (String)"structId");
            Iterable $this$map$iv = this.foundStructures;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ResourceKey resourceKey = (ResourceKey)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                GrowssethStructures.StructureInfo structureInfo = GrowssethStructures.INSTANCE.getInfo().get(it);
                Intrinsics.checkNotNull((Object)structureInfo);
                collection.add(structureInfo.getTag());
            }
            List tags = (List)destination$iv$iv;
            Iterable $this$flatMap$iv = tags;
            boolean $i$f$flatMap = false;
            destination$iv$iv = $this$flatMap$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv;
                TagKey tag = (TagKey)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)server.registryAccess().registryOrThrow(Registries.STRUCTURE).getTagOrEmpty(tag), (String)"getTagOrEmpty(...)");
                boolean $i$f$mapNotNull = false;
                Iterable iterable2 = $this$mapNotNull$iv;
                Collection destination$iv$iv3 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    ResourceKey it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv2 = element$iv$iv$iv = iterator.next();
                    boolean bl2 = false;
                    Holder it = (Holder)element$iv$iv2;
                    boolean bl3 = false;
                    Optional optional = it.unwrapKey();
                    Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"unwrapKey(...)");
                    if ((ResourceKey)OptionalsKt.getOrNull((Optional)optional) == null) continue;
                    boolean bl4 = false;
                    destination$iv$iv3.add(it$iv$iv);
                }
                Iterable list$iv$iv = (List)destination$iv$iv3;
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            List matchingStructures = (List)destination$iv$iv2;
            return matchingStructures.contains(structId);
        }

        private static final Set CODEC$lambda$4$lambda$3(KProperty1 $tmp0, ProgressTradesSavedData p0) {
            return (Set)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final /* synthetic */ ProgressTradesSavedData CODEC$lambda$4$newInstance(CodecUtils.ConstructorProxy $this$CODEC_u24lambda_u244_u24newInstance, Object p0, Object p1) {
            Object[] objectArray = new Object[]{p0, p1};
            return (ProgressTradesSavedData)((Object)$this$CODEC_u24lambda_u244_u24newInstance.newInstance(objectArray));
        }

        private static final App CODEC$lambda$4(RecordCodecBuilder.Instance builder) {
            Codec codec = ResourceKey.codec((ResourceKey)Registries.STRUCTURE);
            Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"codec(...)");
            App app = (App)CodecUtilsKt.mutableSetCodec((Codec)codec).fieldOf("foundStructures").forGetter(arg_0 -> ProgressTradesSavedData.CODEC$lambda$4$lambda$3((KProperty1)Companion.CODEC.1.1.INSTANCE, arg_0));
            MapCodec mapCodec = ResourceKey.codec((ResourceKey)Registries.STRUCTURE).optionalFieldOf("currentStructure");
            Intrinsics.checkNotNullExpressionValue((Object)mapCodec, (String)"optionalFieldOf(...)");
            return builder.group(app, (App)CodecUtilsKt.forNullableGetter((MapCodec)mapCodec, (Function1)((Function1)Companion.CODEC.1.2.INSTANCE))).apply((Applicative)builder, (arg_0, arg_1) -> ProgressTradesSavedData.CODEC$lambda$4$newInstance(CodecUtilsKt.constructorWithOptionals((KClass)Reflection.getOrCreateKotlinClass(ProgressTradesSavedData.class)), arg_0, arg_1));
        }

        public ProgressTradesSavedData() {
            this(null, null, 3, null);
        }

        static {
            Codec codec = RecordCodecBuilder.create(ProgressTradesSavedData::CODEC$lambda$4);
            Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"create(...)");
            CODEC = codec;
            DEF = FxSavedData.Companion.define$default((FxSavedData.Companion)FxSavedData.Companion, (String)"growsseth/progress_trades", (Function0)Companion.DEF.1.INSTANCE, CODEC, null, (List)CollectionsKt.listOf((Object)"progressTrades"), (int)8, null);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/ruslan/growsseth/entity/researcher/trades/ProgressResearcherTradesProvider$ProgressTradesSavedData$Companion;", "", "<init>", "()V", "CODEC", "Lcom/mojang/serialization/Codec;", "Lcom/ruslan/growsseth/entity/researcher/trades/ProgressResearcherTradesProvider$ProgressTradesSavedData;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "DEF", "Lcom/filloax/fxlib/api/savedata/FxSavedData$Definition;", "get", "server", "Lnet/minecraft/server/MinecraftServer;", "setDirty", "", "ruins-of-growsseth"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Codec<ProgressTradesSavedData> getCODEC() {
                return CODEC;
            }

            @NotNull
            public final ProgressTradesSavedData get(@NotNull MinecraftServer server) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                return (ProgressTradesSavedData)FxSavedData.Companion.loadData(server, DEF);
            }

            public final void setDirty(@NotNull MinecraftServer server) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                ((ProgressTradesSavedData)FxSavedData.Companion.loadData(server, DEF)).setDirty();
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

