/*
 * Decompiled with CFR 0.152.
 */
package com.ruslan.growsseth.entity.researcher.trades;

import com.filloax.fxlib.api.UtilsKt;
import com.filloax.fxlib.api.codec.CodecUtilsKt;
import com.filloax.fxlib.api.nbt.NbtUtilsKt;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.ruslan.growsseth.RuinsOfGrowsseth;
import com.ruslan.growsseth.advancements.StructureAdvancements;
import com.ruslan.growsseth.config.QuestConfig;
import com.ruslan.growsseth.config.ResearcherConfig;
import com.ruslan.growsseth.entity.SerializableItemListing;
import com.ruslan.growsseth.entity.researcher.Researcher;
import com.ruslan.growsseth.entity.researcher.trades.ResearcherItemListing;
import com.ruslan.growsseth.entity.researcher.trades.ResearcherTradeUtils;
import com.ruslan.growsseth.entity.researcher.trades.TradeItemMapInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import kotlin.math.MathKt;
import kotlin.reflect.KProperty1;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 ,2\u00020\u0001:\u0001,Bi\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\b\b\u0002\u0010\r\u001a\u00020\b\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\u000e\u0010#\u001a\u00020\u00112\u0006\u0010$\u001a\u00020\u0000J\u000e\u0010%\u001a\u00020\u00112\u0006\u0010&\u001a\u00020'J\u0014\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\u00052\u0006\u0010*\u001a\u00020+R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0012\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006-"}, d2={"Lcom/ruslan/growsseth/entity/researcher/trades/ResearcherItemListing;", "Lcom/ruslan/growsseth/entity/SerializableItemListing;", "gives", "Lnet/minecraft/world/item/ItemStack;", "wants", "", "Lnet/minecraft/world/item/trading/ItemCost;", "maxUses", "", "mapPool", "Lcom/ruslan/growsseth/entity/researcher/trades/TradeItemMapInfo;", "bookId", "", "xp", "priceMul", "", "noNotification", "", "randomWeight", "<init>", "(Lnet/minecraft/world/item/ItemStack;Ljava/util/List;ILjava/util/List;Ljava/lang/String;IFZF)V", "getMapPool", "()Ljava/util/List;", "getBookId", "()Ljava/lang/String;", "getNoNotification", "()Z", "getRandomWeight", "()F", "getOffer", "Lnet/minecraft/world/item/trading/MerchantOffer;", "trader", "Lnet/minecraft/world/entity/Entity;", "random", "Lnet/minecraft/util/RandomSource;", "looselyMatches", "other", "isDiscoveredStructure", "player", "Lnet/minecraft/server/level/ServerPlayer;", "getAllPossibleStructures", "Lnet/minecraft/resources/ResourceLocation;", "registryAccess", "Lnet/minecraft/core/RegistryAccess;", "Companion", "ruins-of-growsseth"})
@SourceDebugExtension(value={"SMAP\nResearcherTradeEntry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResearcherTradeEntry.kt\ncom/ruslan/growsseth/entity/researcher/trades/ResearcherItemListing\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,233:1\n1755#2,2:234\n1757#2:237\n1368#2:238\n1454#2,5:239\n774#2:244\n865#2,2:245\n1368#2:247\n1454#2,5:248\n1#3:236\n*S KotlinDebug\n*F\n+ 1 ResearcherTradeEntry.kt\ncom/ruslan/growsseth/entity/researcher/trades/ResearcherItemListing\n*L\n138#1:234,2\n138#1:237\n151#1:238\n151#1:239,5\n153#1:244\n153#1:245,2\n154#1:247\n154#1:248,5\n*E\n"})
public final class ResearcherItemListing
extends SerializableItemListing {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<TradeItemMapInfo> mapPool;
    @Nullable
    private final String bookId;
    private final boolean noNotification;
    private final float randomWeight;
    @NotNull
    private static final Codec<ResearcherItemListing> CODEC;
    @NotNull
    private static final Codec<List<ResearcherItemListing>> MLIST_CODEC;
    @NotNull
    private static final Codec<List<ResearcherItemListing>> LIST_CODEC;
    private static final ImmutableList<TradeItemMapInfo> BLANK_MAP_POOL;
    @NotNull
    public static final String SET_MAP_TAG = "ResearcherSetMap";
    @NotNull
    public static final String MAP_INFO_TAG = "ResearcherMapInfo";
    @NotNull
    public static final String BOOK_TEMPLATE_TAG = "ResearcherBookId";

    public ResearcherItemListing(@NotNull ItemStack gives, @NotNull List<ItemCost> wants, int maxUses, @NotNull List<TradeItemMapInfo> mapPool, @Nullable String bookId, int xp, float priceMul, boolean noNotification, float randomWeight) {
        Intrinsics.checkNotNullParameter((Object)gives, (String)"gives");
        Intrinsics.checkNotNullParameter(wants, (String)"wants");
        Intrinsics.checkNotNullParameter(mapPool, (String)"mapPool");
        super(gives, wants, maxUses, xp, priceMul, 0.0f, 32, null);
        this.mapPool = mapPool;
        this.bookId = bookId;
        this.noNotification = noNotification;
        this.randomWeight = randomWeight;
    }

    public /* synthetic */ ResearcherItemListing(ItemStack itemStack, List list, int n, List list2, String string, int n2, float f, boolean bl, float f2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 8) != 0) {
            list2 = (List)BLANK_MAP_POOL;
        }
        if ((n3 & 0x10) != 0) {
            string = null;
        }
        if ((n3 & 0x20) != 0) {
            n2 = 0;
        }
        if ((n3 & 0x40) != 0) {
            f = 1.0f;
        }
        if ((n3 & 0x80) != 0) {
            bl = false;
        }
        if ((n3 & 0x100) != 0) {
            f2 = 0.0f;
        }
        this(itemStack, list, n, list2, string, n2, f, bl, f2);
    }

    @NotNull
    public final List<TradeItemMapInfo> getMapPool() {
        return this.mapPool;
    }

    @Nullable
    public final String getBookId() {
        return this.bookId;
    }

    public final boolean getNoNotification() {
        return this.noNotification;
    }

    public final float getRandomWeight() {
        return this.randomWeight;
    }

    @Override
    @NotNull
    public MerchantOffer getOffer(@NotNull Entity trader, @NotNull RandomSource random) {
        MerchantOffer offer;
        block5: {
            Intrinsics.checkNotNullParameter((Object)trader, (String)"trader");
            Intrinsics.checkNotNullParameter((Object)random, (String)"random");
            float costMultiplier = 1.0f;
            if (trader instanceof Researcher) {
                if (((Researcher)trader).getDonkeyWasBorrowed() && !((Researcher)trader).getHealed()) {
                    costMultiplier *= ResearcherConfig.researcherBorrowPenalty;
                }
                if (((Researcher)trader).getHealed()) {
                    costMultiplier *= QuestConfig.researcherCuredDiscount;
                }
            } else {
                RuinsOfGrowsseth.LOGGER.warn("ResearcherTradeEntry used for non-Researcher!", new Object[0]);
            }
            offer = super.getOffer(trader, random);
            offer.addToSpecialPriceDiff(MathKt.roundToInt((float)((float)offer.getCostA().getCount() * (costMultiplier - 1.0f))));
            if (!((Collection)this.mapPool).isEmpty()) {
                TradeItemMapInfo map = this.mapPool.get(random.nextInt(0, this.mapPool.size()));
                CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)offer.getResult(), arg_0 -> ResearcherItemListing.getOffer$lambda$1(map, arg_0));
            }
            String string = this.bookId;
            if (string == null) break block5;
            String id = string;
            boolean bl = false;
            CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)offer.getResult(), arg_0 -> ResearcherItemListing.getOffer$lambda$3$lambda$2(id, arg_0));
        }
        return offer;
    }

    public final boolean looselyMatches(@NotNull ResearcherItemListing other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return ItemStack.matches((ItemStack)this.gives(), (ItemStack)other.gives()) && Intrinsics.areEqual(this.mapPool, other.mapPool);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isDiscoveredStructure(@NotNull ServerPlayer player) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Iterable $this$any$iv = this.mapPool;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            Either fixedStructId;
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            TradeItemMapInfo mapInfo = (TradeItemMapInfo)element$iv;
            boolean bl2 = false;
            Either structId = UtilsKt.getStructTagOrKey((String)mapInfo.getStructure());
            if (mapInfo.getFixedStructureId() != null) {
                String p0;
                boolean bl3 = false;
                boolean $i$f$isDiscoveredStructure$lambda$5$stub_for_inlining = false;
                v0 = UtilsKt.getStructTagOrKey((String)p0);
            } else {
                v0 = fixedStructId = null;
            }
            if (StructureAdvancements.playerHasFoundStructure$default(StructureAdvancements.INSTANCE, player, structId, false, 4, null)) {
                boolean bl4;
                if (fixedStructId != null) {
                    Either it;
                    boolean bl5 = false;
                    if (StructureAdvancements.playerHasFoundStructure$default(StructureAdvancements.INSTANCE, player, it, false, 4, null)) {
                        return true;
                    }
                    bl4 = false;
                } else {
                    bl4 = false;
                }
                if (bl4) {
                    return true;
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ResourceLocation> getAllPossibleStructures(@NotNull RegistryAccess registryAccess) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        void $this$flatMapTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)registryAccess, (String)"registryAccess");
        Iterable $this$flatMap$iv2 = this.mapPool;
        boolean $i$f$flatMap22 = false;
        Iterable iterable = $this$flatMap$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
            TradeItemMapInfo it = (TradeItemMapInfo)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = ResearcherTradeUtils.INSTANCE.getMatchingStructures(registryAccess, it.getStructure());
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List baseStructures = (List)destination$iv$iv;
        Iterable $i$f$flatMap22 = this.mapPool;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TradeItemMapInfo it = (TradeItemMapInfo)element$iv$iv;
            boolean bl = false;
            if (!(it.getFixedStructureId() != null)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo2 = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            TradeItemMapInfo it = (TradeItemMapInfo)element$iv$iv;
            boolean bl = false;
            String string = it.getFixedStructureId();
            Intrinsics.checkNotNull((Object)string);
            Iterable list$iv$iv = ResearcherTradeUtils.INSTANCE.getMatchingStructures(registryAccess, string);
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        List fixedStructures = (List)destination$iv$iv2;
        return CollectionsKt.plus((Collection)baseStructures, (Iterable)fixedStructures);
    }

    private static final TradeItemMapInfo getOffer$lambda$1$lambda$0(TradeItemMapInfo $map) {
        return $map;
    }

    private static final void getOffer$lambda$1(TradeItemMapInfo $map, CompoundTag it) {
        Intrinsics.checkNotNull((Object)it);
        NbtUtilsKt.saveField((CompoundTag)it, (String)MAP_INFO_TAG, TradeItemMapInfo.Companion.getCODEC(), () -> ResearcherItemListing.getOffer$lambda$1$lambda$0($map));
    }

    private static final void getOffer$lambda$3$lambda$2(String $id, CompoundTag it) {
        it.putString(BOOK_TEMPLATE_TAG, $id);
    }

    private static final List CODEC$lambda$18$lambda$9(KProperty1 $tmp0, ResearcherItemListing p0) {
        return (List)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final Integer CODEC$lambda$18$lambda$10(KProperty1 $tmp0, ResearcherItemListing p0) {
        return (Integer)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final List CODEC$lambda$18$lambda$11(KProperty1 $tmp0, ResearcherItemListing p0) {
        return (List)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final String CODEC$lambda$18$lambda$12(ResearcherItemListing it) {
        return null;
    }

    private static final Integer CODEC$lambda$18$lambda$13(KProperty1 $tmp0, ResearcherItemListing p0) {
        return (Integer)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final Float CODEC$lambda$18$lambda$14(KProperty1 $tmp0, ResearcherItemListing p0) {
        return (Float)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final Boolean CODEC$lambda$18$lambda$15(KProperty1 $tmp0, ResearcherItemListing p0) {
        return (Boolean)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final Float CODEC$lambda$18$lambda$16(KProperty1 $tmp0, ResearcherItemListing p0) {
        return (Float)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final ResearcherItemListing CODEC$lambda$18$lambda$17(ItemStack gives, List wants, Integer maxUses, List mapPool, Optional diaryIdOpt, Optional bookIdOpt, Integer xp, Float priceMul, Boolean noNotification, Float randomWeight) {
        Intrinsics.checkNotNull((Object)diaryIdOpt);
        String diaryId = (String)OptionalsKt.getOrNull((Optional)diaryIdOpt);
        Intrinsics.checkNotNull((Object)bookIdOpt);
        String bookId = (String)OptionalsKt.getOrNull((Optional)bookIdOpt);
        Intrinsics.checkNotNull((Object)gives);
        Intrinsics.checkNotNull((Object)wants);
        Intrinsics.checkNotNull((Object)maxUses);
        int n = maxUses;
        Intrinsics.checkNotNull((Object)mapPool);
        String string = bookId;
        if (string == null) {
            string = diaryId;
        }
        Intrinsics.checkNotNull((Object)xp);
        int n2 = xp;
        Intrinsics.checkNotNull((Object)priceMul);
        float f = priceMul.floatValue();
        Intrinsics.checkNotNull((Object)noNotification);
        boolean bl = noNotification;
        Intrinsics.checkNotNull((Object)randomWeight);
        return new ResearcherItemListing(gives, wants, n, mapPool, string, n2, f, bl, randomWeight.floatValue());
    }

    private static final App CODEC$lambda$18(RecordCodecBuilder.Instance b) {
        App app = (App)ItemStack.CODEC.fieldOf("gives").forGetter(SerializableItemListing::gives);
        App app2 = (App)ItemCost.CODEC.listOf().fieldOf("wants").forGetter(arg_0 -> ResearcherItemListing.CODEC$lambda$18$lambda$9((KProperty1)Companion.CODEC.1.2.INSTANCE, arg_0));
        App app3 = (App)Codec.INT.fieldOf("maxUses").forGetter(arg_0 -> ResearcherItemListing.CODEC$lambda$18$lambda$10((KProperty1)Companion.CODEC.1.3.INSTANCE, arg_0));
        App app4 = (App)TradeItemMapInfo.Companion.getCODEC().listOf().optionalFieldOf("mapPool", BLANK_MAP_POOL).forGetter(arg_0 -> ResearcherItemListing.CODEC$lambda$18$lambda$11((KProperty1)Companion.CODEC.1.4.INSTANCE, arg_0));
        MapCodec mapCodec = Codec.STRING.optionalFieldOf("diaryId");
        Intrinsics.checkNotNullExpressionValue((Object)mapCodec, (String)"optionalFieldOf(...)");
        App app5 = (App)CodecUtilsKt.forNullableGetter((MapCodec)mapCodec, ResearcherItemListing::CODEC$lambda$18$lambda$12);
        MapCodec mapCodec2 = Codec.STRING.optionalFieldOf("bookId");
        Intrinsics.checkNotNullExpressionValue((Object)mapCodec2, (String)"optionalFieldOf(...)");
        return b.group(app, app2, app3, app4, app5, (App)CodecUtilsKt.forNullableGetter((MapCodec)mapCodec2, (Function1)((Function1)Companion.CODEC.1.6.INSTANCE)), (App)Codec.INT.fieldOf("xp").forGetter(arg_0 -> ResearcherItemListing.CODEC$lambda$18$lambda$13((KProperty1)Companion.CODEC.1.7.INSTANCE, arg_0)), (App)Codec.FLOAT.fieldOf("priceMul").forGetter(arg_0 -> ResearcherItemListing.CODEC$lambda$18$lambda$14((KProperty1)Companion.CODEC.1.8.INSTANCE, arg_0)), (App)Codec.BOOL.fieldOf("noNotification").forGetter(arg_0 -> ResearcherItemListing.CODEC$lambda$18$lambda$15((KProperty1)Companion.CODEC.1.9.INSTANCE, arg_0)), (App)Codec.FLOAT.fieldOf("randomWeight").forGetter(arg_0 -> ResearcherItemListing.CODEC$lambda$18$lambda$16((KProperty1)Companion.CODEC.1.10.INSTANCE, arg_0))).apply((Applicative)b, ResearcherItemListing::CODEC$lambda$18$lambda$17);
    }

    static {
        Codec codec = RecordCodecBuilder.create(ResearcherItemListing::CODEC$lambda$18);
        Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"create(...)");
        CODEC = codec;
        MLIST_CODEC = CodecUtilsKt.mutableListCodec(CODEC);
        Codec codec2 = Codec.list(CODEC);
        Intrinsics.checkNotNullExpressionValue((Object)codec2, (String)"list(...)");
        LIST_CODEC = codec2;
        BLANK_MAP_POOL = ImmutableList.of();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001d\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\n0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\bR\u001d\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\r0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\bR7\u0010\u000f\u001a&\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u0011 \u0012*\u0012\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u0011\u0018\u00010\u00100\u0010\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0016\u001a\u00020\u0017X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0017X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0017X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/ruslan/growsseth/entity/researcher/trades/ResearcherItemListing$Companion;", "", "<init>", "()V", "CODEC", "Lcom/mojang/serialization/Codec;", "Lcom/ruslan/growsseth/entity/researcher/trades/ResearcherItemListing;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "MLIST_CODEC", "", "getMLIST_CODEC", "LIST_CODEC", "", "getLIST_CODEC", "BLANK_MAP_POOL", "Lcom/google/common/collect/ImmutableList;", "Lcom/ruslan/growsseth/entity/researcher/trades/TradeItemMapInfo;", "kotlin.jvm.PlatformType", "getBLANK_MAP_POOL", "()Lcom/google/common/collect/ImmutableList;", "Lcom/google/common/collect/ImmutableList;", "SET_MAP_TAG", "", "MAP_INFO_TAG", "BOOK_TEMPLATE_TAG", "ruins-of-growsseth"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Codec<ResearcherItemListing> getCODEC() {
            return CODEC;
        }

        @NotNull
        public final Codec<List<ResearcherItemListing>> getMLIST_CODEC() {
            return MLIST_CODEC;
        }

        @NotNull
        public final Codec<List<ResearcherItemListing>> getLIST_CODEC() {
            return LIST_CODEC;
        }

        public final ImmutableList<TradeItemMapInfo> getBLANK_MAP_POOL() {
            return BLANK_MAP_POOL;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

