/*
 * Decompiled with CFR 0.152.
 */
package com.ruslan.growsseth.http;

import com.filloax.fxlib.api.FxUtils;
import com.filloax.fxlib.api.UtilsKt;
import com.filloax.fxlib.api.json.RotationSerializer;
import com.mojang.datafixers.util.Either;
import com.ruslan.growsseth.RuinsOfGrowsseth;
import com.ruslan.growsseth.config.WebConfig;
import com.ruslan.growsseth.http.AbstractGrowssethApi;
import com.ruslan.growsseth.http.ApiEvent;
import com.ruslan.growsseth.http.ApiQuestData;
import com.ruslan.growsseth.http.ApiStructureSpawn;
import com.ruslan.growsseth.http.DataRemoteSync;
import com.ruslan.growsseth.http.GrowssethApiV2$Entry$;
import com.ruslan.growsseth.http.GrowssethApiV2$Quest$;
import com.ruslan.growsseth.http.GrowssethApiV2$StructureSpawn$;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.IntSerializer;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.internal.StringSerializer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0005$%&'(B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001b\u001a\u00020\u0015H\u0016J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001b\u001a\u00020\u0015H\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u0015H\u0016J\b\u0010 \u001a\u00020!H\u0016J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001e0#H\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\bR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00060\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\n0\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0019R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00150\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/ruslan/growsseth/http/GrowssethApiV2;", "Lcom/ruslan/growsseth/http/AbstractGrowssethApi;", "<init>", "()V", "structureSpawns", "", "Lcom/ruslan/growsseth/http/ApiStructureSpawn;", "getStructureSpawns", "()Ljava/util/List;", "events", "Lcom/ruslan/growsseth/http/ApiEvent;", "getEvents", "quests", "Lcom/ruslan/growsseth/http/ApiQuestData;", "getQuests", "structSpawnsList", "", "eventsList", "questsList", "structSpawnsByName", "", "", "eventsByName", "contentsHash", "", "Ljava/lang/Integer;", "structByName", "name", "eventByName", "isEventActive", "", "EVENT_TYPES", "init", "", "reload", "Ljava/util/concurrent/CompletableFuture;", "Callbacks", "Entry", "StructureSpawn", "Event", "Quest", "ruins-of-growsseth"})
@SourceDebugExtension(value={"SMAP\nGrowssethApiV2.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrowssethApiV2.kt\ncom/ruslan/growsseth/http/GrowssethApiV2\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,335:1\n774#2:336\n865#2,2:337\n3193#2,10:339\n1557#2:349\n1628#2,3:350\n1557#2:353\n1628#2,3:354\n1202#2,2:357\n1230#2,4:359\n1557#2:363\n1628#2,3:364\n1202#2,2:367\n1230#2,4:369\n1611#2,9:373\n1863#2:382\n1864#2:384\n1620#2:385\n1485#2:386\n1510#2,3:387\n1513#2,3:397\n1#3:383\n381#4,7:390\n535#4:400\n520#4,6:401\n*S KotlinDebug\n*F\n+ 1 GrowssethApiV2.kt\ncom/ruslan/growsseth/http/GrowssethApiV2\n*L\n58#1:336\n58#1:337,2\n59#1:339,10\n63#1:349\n63#1:350,3\n64#1:353\n64#1:354,3\n64#1:357,2\n64#1:359,4\n68#1:363\n68#1:364,3\n69#1:367,2\n69#1:369,4\n72#1:373,9\n72#1:382\n72#1:384\n72#1:385\n83#1:386\n83#1:387,3\n83#1:397,3\n72#1:383\n83#1:390,7\n83#1:400\n83#1:401,6\n*E\n"})
public final class GrowssethApiV2
extends AbstractGrowssethApi {
    @NotNull
    public static final GrowssethApiV2 INSTANCE = new GrowssethApiV2();
    @NotNull
    private static final List<ApiStructureSpawn> structSpawnsList = new ArrayList();
    @NotNull
    private static final List<ApiEvent> eventsList = new ArrayList();
    @NotNull
    private static final List<ApiQuestData> questsList = new ArrayList();
    @NotNull
    private static final Map<String, ApiStructureSpawn> structSpawnsByName = new LinkedHashMap();
    @NotNull
    private static final Map<String, ApiEvent> eventsByName = new LinkedHashMap();
    @Nullable
    private static Integer contentsHash;
    @NotNull
    private static final List<String> EVENT_TYPES;

    private GrowssethApiV2() {
    }

    @Override
    @NotNull
    public List<ApiStructureSpawn> getStructureSpawns() {
        return structSpawnsList;
    }

    @Override
    @NotNull
    public List<ApiEvent> getEvents() {
        return eventsList;
    }

    @Override
    @NotNull
    public List<ApiQuestData> getQuests() {
        return questsList;
    }

    @Override
    @Nullable
    public ApiStructureSpawn structByName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return structSpawnsByName.get(name);
    }

    @Override
    @Nullable
    public ApiEvent eventByName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return eventsByName.get(name);
    }

    @Override
    public boolean isEventActive(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ApiEvent apiEvent = eventsByName.get(name);
        return apiEvent != null ? apiEvent.getActive() : false;
    }

    @Override
    public void init() {
        String string = WebConfig.dataSyncEndpoint;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dataSyncEndpoint");
        Map<String, String> map = DataRemoteSync.INSTANCE.endpointParams(string).getHeaders();
        String string2 = "apiKey";
        String string3 = WebConfig.dataSyncApiKey;
        map.put(string2, string3);
        String string4 = WebConfig.dataSyncEndpoint;
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"dataSyncEndpoint");
        DataRemoteSync.INSTANCE.subscribe(string4, (DeserializationStrategy)BuiltinSerializersKt.ListSerializer(Entry.Companion.serializer()), GrowssethApiV2::init$lambda$10);
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> reload() {
        MinecraftServer server = FxUtils.getServer();
        if (server == null) {
            RuinsOfGrowsseth.LOGGER.error("Server is not running, cannot reload!", new Object[0]);
            CompletableFuture<Boolean> completableFuture = CompletableFuture.completedFuture(false);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }
        String string = WebConfig.dataSyncUrl;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dataSyncUrl");
        return DataRemoteSync.INSTANCE.doSync(string, server);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit init$lambda$10(List list, MinecraftServer server) {
        int hash;
        boolean changed;
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$associateByTo$iv$iv;
        Iterable $this$associateBy$iv;
        Entry p0;
        Object object;
        Iterator<Object> iterator;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)list, (String)"list");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Entry p02 = (Entry)element$iv$iv;
            boolean bl = false;
            boolean $i$f$init$lambda$10$stub_for_inlining = false;
            if (!p02.checkValid()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List validEntries = (List)destination$iv$iv;
        Iterable $this$partition$iv = validEntries;
        boolean $i$f$partition = false;
        Iterable<Object> first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            Entry it = (Entry)element$iv;
            boolean bl = false;
            if (EVENT_TYPES.contains(it.getType())) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List events = (List)pair.component1();
        List structSpawns = (List)pair.component2();
        structSpawnsList.clear();
        structSpawnsByName.clear();
        first$iv = structSpawns;
        List<ApiQuestData> list2 = structSpawnsList;
        boolean $i$f$map = false;
        Iterator iterator2 = $this$map$iv;
        Iterable<Quest> destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            iterator = (Entry)item$iv$iv;
            object = destination$iv$iv2;
            boolean bl = false;
            boolean $i$f$init$lambda$10$stub_for_inlining$1 = false;
            object.add(p0.toStructureSpawn());
        }
        list2.addAll((List)destination$iv$iv2);
        $this$map$iv = structSpawns;
        list2 = structSpawnsByName;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            p0 = (Entry)item$iv$iv;
            object = destination$iv$iv2;
            boolean bl = false;
            boolean $i$f$init$lambda$10$stub_for_inlining$2 = false;
            object.add(p0.toStructureSpawn());
        }
        $this$map$iv = (List)destination$iv$iv2;
        boolean $i$f$associateBy = false;
        int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv2 = $this$associateBy$iv;
        Map destination$iv$iv3 = new LinkedHashMap(capacity$iv22);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void p03;
            ApiStructureSpawn bl = (ApiStructureSpawn)element$iv$iv;
            object = destination$iv$iv3;
            boolean bl2 = false;
            boolean $i$f$init$lambda$10$stub_for_inlining$3 = false;
            object.put(p03.getName(), element$iv$iv);
        }
        list2.putAll(destination$iv$iv3);
        eventsList.clear();
        eventsByName.clear();
        $this$associateBy$iv = events;
        list2 = eventsList;
        $i$f$map = false;
        Iterable capacity$iv22 = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Iterator item$iv$iv : $this$mapTo$iv$iv) {
            Object element$iv$iv;
            element$iv$iv = (Entry)((Object)item$iv$iv);
            object = destination$iv$iv2;
            boolean bl = false;
            boolean $i$f$init$lambda$10$stub_for_inlining$4 = false;
            object.add(p0.toEvent());
        }
        list2.addAll((List)destination$iv$iv2);
        $this$map$iv = eventsList;
        list2 = eventsByName;
        $i$f$associateBy = false;
        int capacity$iv32 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv2 = $this$associateBy$iv;
        destination$iv$iv = new LinkedHashMap(capacity$iv32);
        $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void p04;
            ApiEvent bl = (ApiEvent)element$iv$iv;
            object = destination$iv$iv;
            boolean bl3 = false;
            boolean $i$f$init$lambda$10$stub_for_inlining$5 = false;
            object.put(p04.getName(), element$iv$iv);
        }
        list2.putAll(destination$iv$iv);
        questsList.clear();
        $this$associateBy$iv = list;
        list2 = questsList;
        boolean $i$f$mapNotNull22 = false;
        void capacity$iv32 = $this$mapNotNull$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Quest it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Entry it = (Entry)element$iv$iv;
            boolean bl4 = false;
            if (it.getQuest() == null) continue;
            boolean bl5 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        list2.addAll((List)destination$iv$iv2);
        Object[] $i$f$mapNotNull22 = new Object[]{structSpawnsList, eventsList, questsList};
        Integer n = contentsHash;
        boolean bl = changed = n == null || (hash = Objects.hash($i$f$mapNotNull22)) != n;
        if (changed) {
            void $this$filterTo$iv$iv2;
            void $this$filter$iv2;
            void $this$groupByTo$iv$iv;
            RuinsOfGrowsseth.LOGGER.info("API v2 data updated!\n\tStructures: " + structSpawnsList + "\n\tEvents: " + eventsList, new Object[0]);
            Object $this$groupBy$iv = structSpawnsList;
            boolean $i$f$groupBy = false;
            Iterable $i$f$mapNotNullTo2 = $this$groupBy$iv;
            Map destination$iv$iv4 = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object2;
                ApiStructureSpawn it = (ApiStructureSpawn)element$iv$iv;
                boolean bl6 = false;
                String key$iv$iv = it.getName();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv4;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl7 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object2 = answer$iv$iv$iv;
                } else {
                    object2 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object2;
                list$iv$iv.add(element$iv$iv);
            }
            $this$groupBy$iv = destination$iv$iv4;
            boolean $i$f$filter2 = false;
            $this$groupByTo$iv$iv = $this$filter$iv2;
            destination$iv$iv4 = new LinkedHashMap();
            boolean $i$f$filterTo2 = false;
            iterator = $this$filterTo$iv$iv2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = (Map.Entry)iterator.next();
                boolean bl8 = false;
                if (!(((List)it.getValue()).size() > 1)) continue;
                destination$iv$iv4.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            Map it = destination$iv$iv4;
            boolean bl9 = false;
            if (!it.isEmpty()) {
                RuinsOfGrowsseth.LOGGER.warn("More than 1 structure spawn with the same name! (Check list above) " + it, new Object[0]);
            }
            INSTANCE.triggerSubscriberUpdates(server);
            contentsHash = hash;
        } else {
            RuinsOfGrowsseth.LOGGER.info("API data not changed, not triggering subscribers (hash = " + hash + ")", new Object[0]);
        }
        return Unit.INSTANCE;
    }

    static {
        Object[] objectArray = new String[]{"questStep", "tradePreset", "tradeCustom", "dialogue", "toast", "researcherDiary", "structureBook", "command", "operation"};
        EVENT_TYPES = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/ruslan/growsseth/http/GrowssethApiV2$Callbacks;", "", "<init>", "()V", "onServerStop", "", "server", "Lnet/minecraft/server/MinecraftServer;", "ruins-of-growsseth"})
    public static final class Callbacks {
        @NotNull
        public static final Callbacks INSTANCE = new Callbacks();

        private Callbacks() {
        }

        public final void onServerStop(@NotNull MinecraftServer server) {
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            structSpawnsList.clear();
            questsList.clear();
            eventsList.clear();
            structSpawnsByName.clear();
            eventsByName.clear();
            contentsHash = null;
        }
    }

    @Serializable
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 R2\u00020\u0001:\u0002QRB\u009d\u0001\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u000b\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000b\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\u0004\b\u0014\u0010\u0015B\u009b\u0001\b\u0010\u0012\u0006\u0010\u0016\u001a\u00020\u000b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u000b\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000b\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u0012\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018\u00a2\u0006\u0004\b\u0014\u0010\u0019J\u0006\u00101\u001a\u00020\u0006J\u0006\u00102\u001a\u000203J\u0006\u00104\u001a\u000205J\t\u00106\u001a\u00020\u0003H\u00c6\u0003J\t\u00107\u001a\u00020\u0003H\u00c6\u0003J\t\u00108\u001a\u00020\u0006H\u00c6\u0003J\u000b\u00109\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010:\u001a\u0004\u0018\u00010\tH\u00c6\u0003J\u0010\u0010;\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003\u00a2\u0006\u0002\u0010%J\u0010\u0010<\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003\u00a2\u0006\u0002\u0010%J\u0010\u0010=\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003\u00a2\u0006\u0002\u0010%J\u000b\u0010>\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010?\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010@\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010A\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010B\u001a\u0004\u0018\u00010\u0013H\u00c6\u0003J\u00a4\u0001\u0010C\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00c6\u0001\u00a2\u0006\u0002\u0010DJ\u0013\u0010E\u001a\u00020\u00062\b\u0010F\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010G\u001a\u00020\u000bH\u00d6\u0001J\t\u0010H\u001a\u00020\u0003H\u00d6\u0001J%\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020\u00002\u0006\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020OH\u0001\u00a2\u0006\u0002\bPR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001bR\u001e\u0010\b\u001a\u0004\u0018\u00010\t8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b \u0010!\u001a\u0004\b\"\u0010#R\u0015\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\n\n\u0002\u0010&\u001a\u0004\b$\u0010%R\u0015\u0010\f\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\n\n\u0002\u0010&\u001a\u0004\b'\u0010%R\u0015\u0010\r\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\n\n\u0002\u0010&\u001a\u0004\b(\u0010%R\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u001b\"\u0004\b*\u0010+R\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\u001bR\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\u001bR\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\u001bR\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100\u00a8\u0006S"}, d2={"Lcom/ruslan/growsseth/http/GrowssethApiV2$Entry;", "", "id", "", "type", "active", "", "structure", "rotation", "Lnet/minecraft/world/level/block/Rotation;", "x", "", "y", "z", "name", "content", "icon", "title", "quest", "Lcom/ruslan/growsseth/http/GrowssethApiV2$Quest;", "<init>", "(Ljava/lang/String;Ljava/lang/String;ZLjava/lang/String;Lnet/minecraft/world/level/block/Rotation;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/ruslan/growsseth/http/GrowssethApiV2$Quest;)V", "seen0", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;Ljava/lang/String;ZLjava/lang/String;Lnet/minecraft/world/level/block/Rotation;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/ruslan/growsseth/http/GrowssethApiV2$Quest;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getId", "()Ljava/lang/String;", "getType", "getActive", "()Z", "getStructure", "getRotation$annotations", "()V", "getRotation", "()Lnet/minecraft/world/level/block/Rotation;", "getX", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getY", "getZ", "getName", "setName", "(Ljava/lang/String;)V", "getContent", "getIcon", "getTitle", "getQuest", "()Lcom/ruslan/growsseth/http/GrowssethApiV2$Quest;", "checkValid", "toStructureSpawn", "Lcom/ruslan/growsseth/http/GrowssethApiV2$StructureSpawn;", "toEvent", "Lcom/ruslan/growsseth/http/GrowssethApiV2$Event;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "component11", "component12", "component13", "copy", "(Ljava/lang/String;Ljava/lang/String;ZLjava/lang/String;Lnet/minecraft/world/level/block/Rotation;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/ruslan/growsseth/http/GrowssethApiV2$Quest;)Lcom/ruslan/growsseth/http/GrowssethApiV2$Entry;", "equals", "other", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$ruins_of_growsseth", "$serializer", "Companion", "ruins-of-growsseth"})
    public static final class Entry {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String id;
        @NotNull
        private final String type;
        private final boolean active;
        @Nullable
        private final String structure;
        @Nullable
        private final Rotation rotation;
        @Nullable
        private final Integer x;
        @Nullable
        private final Integer y;
        @Nullable
        private final Integer z;
        @Nullable
        private String name;
        @Nullable
        private final String content;
        @Nullable
        private final String icon;
        @Nullable
        private final String title;
        @Nullable
        private final Quest quest;
        @JvmField
        @NotNull
        private static final KSerializer<Object>[] $childSerializers;

        public Entry(@NotNull String id, @NotNull String type, boolean active, @Nullable String structure, @Nullable Rotation rotation, @Nullable Integer x, @Nullable Integer y, @Nullable Integer z, @Nullable String name, @Nullable String content, @Nullable String icon, @Nullable String title, @Nullable Quest quest) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            this.id = id;
            this.type = type;
            this.active = active;
            this.structure = structure;
            this.rotation = rotation;
            this.x = x;
            this.y = y;
            this.z = z;
            this.name = name;
            this.content = content;
            this.icon = icon;
            this.title = title;
            this.quest = quest;
        }

        public /* synthetic */ Entry(String string, String string2, boolean bl, String string3, Rotation rotation, Integer n, Integer n2, Integer n3, String string4, String string5, String string6, String string7, Quest quest, int n4, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n4 & 1) != 0) {
                string = "";
            }
            if ((n4 & 2) != 0) {
                string2 = "";
            }
            if ((n4 & 4) != 0) {
                bl = false;
            }
            if ((n4 & 8) != 0) {
                string3 = null;
            }
            if ((n4 & 0x10) != 0) {
                rotation = null;
            }
            if ((n4 & 0x20) != 0) {
                n = null;
            }
            if ((n4 & 0x40) != 0) {
                n2 = null;
            }
            if ((n4 & 0x80) != 0) {
                n3 = null;
            }
            if ((n4 & 0x100) != 0) {
                string4 = null;
            }
            if ((n4 & 0x200) != 0) {
                string5 = null;
            }
            if ((n4 & 0x400) != 0) {
                string6 = null;
            }
            if ((n4 & 0x800) != 0) {
                string7 = null;
            }
            if ((n4 & 0x1000) != 0) {
                quest = null;
            }
            this(string, string2, bl, string3, rotation, n, n2, n3, string4, string5, string6, string7, quest);
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final String getType() {
            return this.type;
        }

        public final boolean getActive() {
            return this.active;
        }

        @Nullable
        public final String getStructure() {
            return this.structure;
        }

        @Nullable
        public final Rotation getRotation() {
            return this.rotation;
        }

        @Serializable(with=RotationSerializer.class)
        public static /* synthetic */ void getRotation$annotations() {
        }

        @Nullable
        public final Integer getX() {
            return this.x;
        }

        @Nullable
        public final Integer getY() {
            return this.y;
        }

        @Nullable
        public final Integer getZ() {
            return this.z;
        }

        @Nullable
        public final String getName() {
            return this.name;
        }

        public final void setName(@Nullable String string) {
            this.name = string;
        }

        @Nullable
        public final String getContent() {
            return this.content;
        }

        @Nullable
        public final String getIcon() {
            return this.icon;
        }

        @Nullable
        public final String getTitle() {
            return this.title;
        }

        @Nullable
        public final Quest getQuest() {
            return this.quest;
        }

        public final boolean checkValid() {
            if (Intrinsics.areEqual((Object)this.id, (Object)"")) {
                RuinsOfGrowsseth.LOGGER.error("The web sync entry:\n" + this + "\ndoes not have an id set!", new Object[0]);
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.type, (Object)"structure") && !EVENT_TYPES.contains(this.type)) {
                RuinsOfGrowsseth.LOGGER.error("Web sync entry with id " + this.id + " has type " + this.type + ", which is not supported!", new Object[0]);
                return false;
            }
            List missingFields = new ArrayList();
            switch (this.type) {
                case "structure": {
                    if (this.structure == null) {
                        missingFields.add("structure");
                    }
                    if (this.x == null) {
                        missingFields.add("x");
                    }
                    if (this.y == null) {
                        missingFields.add("y");
                    }
                    if (this.z != null) break;
                    missingFields.add("z");
                    break;
                }
                case "questStep": 
                case "tradePreset": 
                case "operation": {
                    if (this.name != null) break;
                    missingFields.add("name");
                    break;
                }
                case "dialogue": 
                case "tradeCustom": 
                case "command": {
                    if (this.content != null) break;
                    missingFields.add("content");
                    break;
                }
                case "toast": 
                case "researcherDiary": {
                    if (this.title == null) {
                        missingFields.add("title");
                    }
                    if (this.content != null) break;
                    missingFields.add("content");
                    break;
                }
                case "structureBook": {
                    if (this.structure == null) {
                        missingFields.add("structure");
                    }
                    if (this.content != null) break;
                    missingFields.add("content");
                }
            }
            if (missingFields.size() > 0) {
                RuinsOfGrowsseth.LOGGER.error("Web sync entry with id '" + this.id + "' has type '" + this.type + "', but is missing the following keys: " + missingFields, new Object[0]);
                return false;
            }
            return true;
        }

        @NotNull
        public final StructureSpawn toStructureSpawn() {
            String string = this.structure;
            Intrinsics.checkNotNull((Object)string);
            Integer n = this.x;
            Intrinsics.checkNotNull((Object)n);
            int n2 = n;
            Integer n3 = this.y;
            Intrinsics.checkNotNull((Object)n3);
            int n4 = n3;
            Integer n5 = this.z;
            Intrinsics.checkNotNull((Object)n5);
            return new StructureSpawn(string, this.id, n2, n4, n5, this.active, this.rotation, this.quest);
        }

        @NotNull
        public final Event toEvent() {
            Object eventName = "";
            String eventDesc = "";
            BlockPos eventPos = new BlockPos(0, 0, 0);
            switch (this.type) {
                case "questStep": {
                    String string = this.name;
                    Intrinsics.checkNotNull((Object)string);
                    eventName = string;
                    break;
                }
                case "tradePreset": {
                    String string = this.name;
                    Intrinsics.checkNotNull((Object)string);
                    eventName = string;
                    break;
                }
                case "tradeCustom": {
                    eventName = "customTrade/" + this.id;
                    String string = this.content;
                    Intrinsics.checkNotNull((Object)string);
                    eventDesc = string;
                    break;
                }
                case "dialogue": {
                    eventName = "rdialogue/" + this.id;
                    String string = this.content;
                    Intrinsics.checkNotNull((Object)string);
                    eventDesc = string;
                    break;
                }
                case "toast": {
                    eventName = this.icon == null ? "toast/" + this.title : "toast/" + StringsKt.replace$default((String)this.icon, (String)":", (String)"/", (boolean)false, (int)4, null) + "/" + this.title;
                    String string = this.content;
                    Intrinsics.checkNotNull((Object)string);
                    eventDesc = string;
                    break;
                }
                case "researcherDiary": {
                    String string;
                    if (this.structure == null) {
                        String string2 = this.title;
                        Intrinsics.checkNotNull((Object)string2);
                        string = StringsKt.endsWith$default((String)string2, (String)"/endDiary", (boolean)false, (int)2, null) ? "enddiary/" + this.title + "!!" : "rdiary/" + this.title + "!!";
                    } else {
                        string = "rdiary/" + this.structure + "/" + this.title + "!!";
                    }
                    eventName = string;
                    String string3 = this.content;
                    Intrinsics.checkNotNull((Object)string3);
                    eventDesc = string3;
                    break;
                }
                case "structureBook": {
                    eventName = "structbook/" + this.structure + "!!";
                    String string = this.content;
                    Intrinsics.checkNotNull((Object)string);
                    eventDesc = string;
                    break;
                }
                case "command": {
                    eventName = "cmd/" + this.id;
                    String string = this.content;
                    Intrinsics.checkNotNull((Object)string);
                    eventDesc = string;
                    break;
                }
                case "operation": {
                    String string = this.name;
                    Intrinsics.checkNotNull((Object)string);
                    eventName = string;
                    eventDesc = this.id;
                    if (this.x == null || this.y == null || this.z == null) break;
                    eventPos = new BlockPos(this.x.intValue(), this.y.intValue(), this.z.intValue());
                }
            }
            return new Event((String)eventName, this.active, eventDesc, eventPos, this.rotation);
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final String component2() {
            return this.type;
        }

        public final boolean component3() {
            return this.active;
        }

        @Nullable
        public final String component4() {
            return this.structure;
        }

        @Nullable
        public final Rotation component5() {
            return this.rotation;
        }

        @Nullable
        public final Integer component6() {
            return this.x;
        }

        @Nullable
        public final Integer component7() {
            return this.y;
        }

        @Nullable
        public final Integer component8() {
            return this.z;
        }

        @Nullable
        public final String component9() {
            return this.name;
        }

        @Nullable
        public final String component10() {
            return this.content;
        }

        @Nullable
        public final String component11() {
            return this.icon;
        }

        @Nullable
        public final String component12() {
            return this.title;
        }

        @Nullable
        public final Quest component13() {
            return this.quest;
        }

        @NotNull
        public final Entry copy(@NotNull String id, @NotNull String type, boolean active, @Nullable String structure, @Nullable Rotation rotation, @Nullable Integer x, @Nullable Integer y, @Nullable Integer z, @Nullable String name, @Nullable String content, @Nullable String icon, @Nullable String title, @Nullable Quest quest) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            return new Entry(id, type, active, structure, rotation, x, y, z, name, content, icon, title, quest);
        }

        public static /* synthetic */ Entry copy$default(Entry entry, String string, String string2, boolean bl, String string3, Rotation rotation, Integer n, Integer n2, Integer n3, String string4, String string5, String string6, String string7, Quest quest, int n4, Object object) {
            if ((n4 & 1) != 0) {
                string = entry.id;
            }
            if ((n4 & 2) != 0) {
                string2 = entry.type;
            }
            if ((n4 & 4) != 0) {
                bl = entry.active;
            }
            if ((n4 & 8) != 0) {
                string3 = entry.structure;
            }
            if ((n4 & 0x10) != 0) {
                rotation = entry.rotation;
            }
            if ((n4 & 0x20) != 0) {
                n = entry.x;
            }
            if ((n4 & 0x40) != 0) {
                n2 = entry.y;
            }
            if ((n4 & 0x80) != 0) {
                n3 = entry.z;
            }
            if ((n4 & 0x100) != 0) {
                string4 = entry.name;
            }
            if ((n4 & 0x200) != 0) {
                string5 = entry.content;
            }
            if ((n4 & 0x400) != 0) {
                string6 = entry.icon;
            }
            if ((n4 & 0x800) != 0) {
                string7 = entry.title;
            }
            if ((n4 & 0x1000) != 0) {
                quest = entry.quest;
            }
            return entry.copy(string, string2, bl, string3, rotation, n, n2, n3, string4, string5, string6, string7, quest);
        }

        @NotNull
        public String toString() {
            return "Entry(id=" + this.id + ", type=" + this.type + ", active=" + this.active + ", structure=" + this.structure + ", rotation=" + this.rotation + ", x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", name=" + this.name + ", content=" + this.content + ", icon=" + this.icon + ", title=" + this.title + ", quest=" + this.quest + ")";
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = result * 31 + this.type.hashCode();
            result = result * 31 + Boolean.hashCode(this.active);
            result = result * 31 + (this.structure == null ? 0 : this.structure.hashCode());
            result = result * 31 + (this.rotation == null ? 0 : this.rotation.hashCode());
            result = result * 31 + (this.x == null ? 0 : ((Object)this.x).hashCode());
            result = result * 31 + (this.y == null ? 0 : ((Object)this.y).hashCode());
            result = result * 31 + (this.z == null ? 0 : ((Object)this.z).hashCode());
            result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
            result = result * 31 + (this.content == null ? 0 : this.content.hashCode());
            result = result * 31 + (this.icon == null ? 0 : this.icon.hashCode());
            result = result * 31 + (this.title == null ? 0 : this.title.hashCode());
            result = result * 31 + (this.quest == null ? 0 : this.quest.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)entry.id)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.type, (Object)entry.type)) {
                return false;
            }
            if (this.active != entry.active) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.structure, (Object)entry.structure)) {
                return false;
            }
            if (this.rotation != entry.rotation) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.x, (Object)entry.x)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.y, (Object)entry.y)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.z, (Object)entry.z)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.name, (Object)entry.name)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.content, (Object)entry.content)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.icon, (Object)entry.icon)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.title, (Object)entry.title)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.quest, (Object)entry.quest);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$ruins_of_growsseth(Entry self, CompositeEncoder output, SerialDescriptor serialDesc) {
            KSerializer<Object>[] kSerializerArray = $childSerializers;
            if (output.shouldEncodeElementDefault(serialDesc, 0) ? true : !Intrinsics.areEqual((Object)self.id, (Object)"")) {
                output.encodeStringElement(serialDesc, 0, self.id);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 1) ? true : !Intrinsics.areEqual((Object)self.type, (Object)"")) {
                output.encodeStringElement(serialDesc, 1, self.type);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 2) ? true : self.active) {
                output.encodeBooleanElement(serialDesc, 2, self.active);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 3) ? true : self.structure != null) {
                output.encodeNullableSerializableElement(serialDesc, 3, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.structure);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 4) ? true : self.rotation != null) {
                output.encodeNullableSerializableElement(serialDesc, 4, (SerializationStrategy)kSerializerArray[4], (Object)self.rotation);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 5) ? true : self.x != null) {
                output.encodeNullableSerializableElement(serialDesc, 5, (SerializationStrategy)IntSerializer.INSTANCE, (Object)self.x);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 6) ? true : self.y != null) {
                output.encodeNullableSerializableElement(serialDesc, 6, (SerializationStrategy)IntSerializer.INSTANCE, (Object)self.y);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 7) ? true : self.z != null) {
                output.encodeNullableSerializableElement(serialDesc, 7, (SerializationStrategy)IntSerializer.INSTANCE, (Object)self.z);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 8) ? true : self.name != null) {
                output.encodeNullableSerializableElement(serialDesc, 8, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.name);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 9) ? true : self.content != null) {
                output.encodeNullableSerializableElement(serialDesc, 9, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.content);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 10) ? true : self.icon != null) {
                output.encodeNullableSerializableElement(serialDesc, 10, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.icon);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 11) ? true : self.title != null) {
                output.encodeNullableSerializableElement(serialDesc, 11, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.title);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 12) ? true : self.quest != null) {
                output.encodeNullableSerializableElement(serialDesc, 12, (SerializationStrategy)Quest$$serializer.INSTANCE, (Object)self.quest);
            }
        }

        public /* synthetic */ Entry(int seen0, String id, String type, boolean active, String structure, Rotation rotation, Integer x, Integer y, Integer z, String name, String content, String icon, String title, Quest quest, SerializationConstructorMarker serializationConstructorMarker) {
            if ((0 & seen0) != 0) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)0, (SerialDescriptor)Entry$$serializer.INSTANCE.getDescriptor());
            }
            this.id = (seen0 & 1) == 0 ? "" : id;
            this.type = (seen0 & 2) == 0 ? "" : type;
            this.active = (seen0 & 4) == 0 ? false : active;
            this.structure = (seen0 & 8) == 0 ? null : structure;
            this.rotation = (seen0 & 0x10) == 0 ? null : rotation;
            this.x = (seen0 & 0x20) == 0 ? null : x;
            this.y = (seen0 & 0x40) == 0 ? null : y;
            this.z = (seen0 & 0x80) == 0 ? null : z;
            this.name = (seen0 & 0x100) == 0 ? null : name;
            this.content = (seen0 & 0x200) == 0 ? null : content;
            this.icon = (seen0 & 0x400) == 0 ? null : icon;
            this.title = (seen0 & 0x800) == 0 ? null : title;
            this.quest = (seen0 & 0x1000) == 0 ? null : quest;
        }

        public Entry() {
            this(null, null, false, null, null, null, null, null, null, null, null, null, null, 8191, null);
        }

        public static final /* synthetic */ KSerializer[] access$get$childSerializers$cp() {
            return $childSerializers;
        }

        static {
            KSerializer[] kSerializerArray = new KSerializer[]{null, null, null, null, new RotationSerializer(), null, null, null, null, null, null, null, null};
            $childSerializers = kSerializerArray;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lcom/ruslan/growsseth/http/GrowssethApiV2$Entry$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/ruslan/growsseth/http/GrowssethApiV2$Entry;", "ruins-of-growsseth"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<Entry> serializer() {
                return (KSerializer)Entry$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u0016\u001a\u00020\u0003H\u0016J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0019\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u001a\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\u000b\u0010\u001b\u001a\u0004\u0018\u00010\nH\u00c6\u0003JA\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nH\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u00052\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u00d6\u0003J\t\u0010 \u001a\u00020!H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0016\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\t\u001a\u0004\u0018\u00010\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\""}, d2={"Lcom/ruslan/growsseth/http/GrowssethApiV2$Event;", "Lcom/ruslan/growsseth/http/ApiEvent;", "name", "", "active", "", "desc", "pos", "Lnet/minecraft/core/BlockPos;", "rotation", "Lnet/minecraft/world/level/block/Rotation;", "<init>", "(Ljava/lang/String;ZLjava/lang/String;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/Rotation;)V", "getName", "()Ljava/lang/String;", "getActive", "()Z", "getDesc", "getPos", "()Lnet/minecraft/core/BlockPos;", "getRotation", "()Lnet/minecraft/world/level/block/Rotation;", "toString", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "", "hashCode", "", "ruins-of-growsseth"})
    @SourceDebugExtension(value={"SMAP\nGrowssethApiV2.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrowssethApiV2.kt\ncom/ruslan/growsseth/http/GrowssethApiV2$Event\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,335:1\n1#2:336\n*E\n"})
    public static final class Event
    implements ApiEvent {
        @NotNull
        private final String name;
        private final boolean active;
        @Nullable
        private final String desc;
        @Nullable
        private final BlockPos pos;
        @Nullable
        private final Rotation rotation;

        public Event(@NotNull String name, boolean active, @Nullable String desc, @Nullable BlockPos pos, @Nullable Rotation rotation) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
            this.active = active;
            this.desc = desc;
            this.pos = pos;
            this.rotation = rotation;
        }

        public /* synthetic */ Event(String string, boolean bl, String string2, BlockPos blockPos, Rotation rotation, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = false;
            }
            if ((n & 4) != 0) {
                string2 = null;
            }
            if ((n & 8) != 0) {
                blockPos = new BlockPos(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
            }
            if ((n & 0x10) != 0) {
                rotation = null;
            }
            this(string, bl, string2, blockPos, rotation);
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        public boolean getActive() {
            return this.active;
        }

        @Override
        @Nullable
        public String getDesc() {
            return this.desc;
        }

        @Override
        @Nullable
        public BlockPos getPos() {
            return this.pos;
        }

        @Override
        @Nullable
        public Rotation getRotation() {
            return this.rotation;
        }

        @NotNull
        public String toString() {
            String it;
            Object object;
            block5: {
                block4: {
                    object = this.getDesc();
                    if (object == null) break block4;
                    it = object;
                    boolean bl = false;
                    String string = " " + it;
                    object = string;
                    if (string != null) break block5;
                }
                object = "";
            }
            String d = object;
            it = this.getPos();
            boolean bl = false;
            String string = " @" + (BlockPos)it;
            Object object2 = string;
            if (string == null) {
                object2 = "";
            }
            String p = object2;
            return this.getName() + "(" + (this.getActive() ? "X" : "") + d + p + ")";
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        public final boolean component2() {
            return this.active;
        }

        @Nullable
        public final String component3() {
            return this.desc;
        }

        @Nullable
        public final BlockPos component4() {
            return this.pos;
        }

        @Nullable
        public final Rotation component5() {
            return this.rotation;
        }

        @NotNull
        public final Event copy(@NotNull String name, boolean active, @Nullable String desc, @Nullable BlockPos pos, @Nullable Rotation rotation) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new Event(name, active, desc, pos, rotation);
        }

        public static /* synthetic */ Event copy$default(Event event, String string, boolean bl, String string2, BlockPos blockPos, Rotation rotation, int n, Object object) {
            if ((n & 1) != 0) {
                string = event.name;
            }
            if ((n & 2) != 0) {
                bl = event.active;
            }
            if ((n & 4) != 0) {
                string2 = event.desc;
            }
            if ((n & 8) != 0) {
                blockPos = event.pos;
            }
            if ((n & 0x10) != 0) {
                rotation = event.rotation;
            }
            return event.copy(string, bl, string2, blockPos, rotation);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + Boolean.hashCode(this.active);
            result = result * 31 + (this.desc == null ? 0 : this.desc.hashCode());
            result = result * 31 + (this.pos == null ? 0 : this.pos.hashCode());
            result = result * 31 + (this.rotation == null ? 0 : this.rotation.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Event)) {
                return false;
            }
            Event event = (Event)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)event.name)) {
                return false;
            }
            if (this.active != event.active) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.desc, (Object)event.desc)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.pos, (Object)event.pos)) {
                return false;
            }
            return this.rotation == event.rotation;
        }
    }

    @Serializable
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 52\u00020\u0001:\u000245BM\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\u0006\u0012\b\b\u0002\u0010\t\u001a\u00020\u0006\u0012\b\b\u0002\u0010\n\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000b\u0010\fB]\b\u0010\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0004\b\u000b\u0010\u0011J\b\u0010\u001f\u001a\u00020\u0006H\u0016J\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0006H\u00c6\u0003J\t\u0010#\u001a\u00020\u0006H\u00c6\u0003J\t\u0010$\u001a\u00020\u0006H\u00c6\u0003J\t\u0010%\u001a\u00020\u0006H\u00c6\u0003J\t\u0010&\u001a\u00020\u0006H\u00c6\u0003JO\u0010'\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\u00062\b\b\u0002\u0010\n\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010(\u001a\u00020\u00032\b\u0010)\u001a\u0004\u0018\u00010*H\u00d6\u0003J\t\u0010+\u001a\u00020\u000eH\u00d6\u0001J%\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u00002\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202H\u0001\u00a2\u0006\u0002\b3R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016R\u0014\u0010\t\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0016R\u0014\u0010\n\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0016R\u0014\u0010\u001b\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0016R\u0014\u0010\u001d\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0016\u00a8\u00066"}, d2={"Lcom/ruslan/growsseth/http/GrowssethApiV2$Quest;", "Lcom/ruslan/growsseth/http/ApiQuestData;", "unlocked", "", "solved", "name", "", "questIMGUnlocked", "questIMGLocked", "text", "difficulty", "<init>", "(ZZLjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(IZZLjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getUnlocked", "()Z", "getSolved", "getName", "()Ljava/lang/String;", "getQuestIMGUnlocked", "getQuestIMGLocked", "getText", "getDifficulty", "imgUnlocked", "getImgUnlocked", "imgLocked", "getImgLocked", "toString", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "other", "", "hashCode", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$ruins_of_growsseth", "$serializer", "Companion", "ruins-of-growsseth"})
    public static final class Quest
    implements ApiQuestData {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final boolean unlocked;
        private final boolean solved;
        @NotNull
        private final String name;
        @NotNull
        private final String questIMGUnlocked;
        @NotNull
        private final String questIMGLocked;
        @NotNull
        private final String text;
        @NotNull
        private final String difficulty;

        public Quest(boolean unlocked, boolean solved, @NotNull String name, @NotNull String questIMGUnlocked, @NotNull String questIMGLocked, @NotNull String text, @NotNull String difficulty) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)questIMGUnlocked, (String)"questIMGUnlocked");
            Intrinsics.checkNotNullParameter((Object)questIMGLocked, (String)"questIMGLocked");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)difficulty, (String)"difficulty");
            this.unlocked = unlocked;
            this.solved = solved;
            this.name = name;
            this.questIMGUnlocked = questIMGUnlocked;
            this.questIMGLocked = questIMGLocked;
            this.text = text;
            this.difficulty = difficulty;
        }

        public /* synthetic */ Quest(boolean bl, boolean bl2, String string, String string2, String string3, String string4, String string5, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            if ((n & 2) != 0) {
                bl2 = false;
            }
            if ((n & 4) != 0) {
                string = "";
            }
            if ((n & 8) != 0) {
                string2 = "";
            }
            if ((n & 0x10) != 0) {
                string3 = "";
            }
            if ((n & 0x20) != 0) {
                string4 = "";
            }
            if ((n & 0x40) != 0) {
                string5 = "";
            }
            this(bl, bl2, string, string2, string3, string4, string5);
        }

        @Override
        public boolean getUnlocked() {
            return this.unlocked;
        }

        @Override
        public boolean getSolved() {
            return this.solved;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public final String getQuestIMGUnlocked() {
            return this.questIMGUnlocked;
        }

        @NotNull
        public final String getQuestIMGLocked() {
            return this.questIMGLocked;
        }

        @Override
        @NotNull
        public String getText() {
            return this.text;
        }

        @Override
        @NotNull
        public String getDifficulty() {
            return this.difficulty;
        }

        @Override
        @NotNull
        public String getImgUnlocked() {
            return this.questIMGUnlocked;
        }

        @Override
        @NotNull
        public String getImgLocked() {
            return this.questIMGLocked;
        }

        @NotNull
        public String toString() {
            return this.getName() + "(" + (this.getUnlocked() ? "U" : "") + (this.getSolved() ? "S" : "") + ")";
        }

        public final boolean component1() {
            return this.unlocked;
        }

        public final boolean component2() {
            return this.solved;
        }

        @NotNull
        public final String component3() {
            return this.name;
        }

        @NotNull
        public final String component4() {
            return this.questIMGUnlocked;
        }

        @NotNull
        public final String component5() {
            return this.questIMGLocked;
        }

        @NotNull
        public final String component6() {
            return this.text;
        }

        @NotNull
        public final String component7() {
            return this.difficulty;
        }

        @NotNull
        public final Quest copy(boolean unlocked, boolean solved, @NotNull String name, @NotNull String questIMGUnlocked, @NotNull String questIMGLocked, @NotNull String text, @NotNull String difficulty) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)questIMGUnlocked, (String)"questIMGUnlocked");
            Intrinsics.checkNotNullParameter((Object)questIMGLocked, (String)"questIMGLocked");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)difficulty, (String)"difficulty");
            return new Quest(unlocked, solved, name, questIMGUnlocked, questIMGLocked, text, difficulty);
        }

        public static /* synthetic */ Quest copy$default(Quest quest, boolean bl, boolean bl2, String string, String string2, String string3, String string4, String string5, int n, Object object) {
            if ((n & 1) != 0) {
                bl = quest.unlocked;
            }
            if ((n & 2) != 0) {
                bl2 = quest.solved;
            }
            if ((n & 4) != 0) {
                string = quest.name;
            }
            if ((n & 8) != 0) {
                string2 = quest.questIMGUnlocked;
            }
            if ((n & 0x10) != 0) {
                string3 = quest.questIMGLocked;
            }
            if ((n & 0x20) != 0) {
                string4 = quest.text;
            }
            if ((n & 0x40) != 0) {
                string5 = quest.difficulty;
            }
            return quest.copy(bl, bl2, string, string2, string3, string4, string5);
        }

        public int hashCode() {
            int result = Boolean.hashCode(this.unlocked);
            result = result * 31 + Boolean.hashCode(this.solved);
            result = result * 31 + this.name.hashCode();
            result = result * 31 + this.questIMGUnlocked.hashCode();
            result = result * 31 + this.questIMGLocked.hashCode();
            result = result * 31 + this.text.hashCode();
            result = result * 31 + this.difficulty.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Quest)) {
                return false;
            }
            Quest quest = (Quest)other;
            if (this.unlocked != quest.unlocked) {
                return false;
            }
            if (this.solved != quest.solved) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.name, (Object)quest.name)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.questIMGUnlocked, (Object)quest.questIMGUnlocked)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.questIMGLocked, (Object)quest.questIMGLocked)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.text, (Object)quest.text)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.difficulty, (Object)quest.difficulty);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$ruins_of_growsseth(Quest self, CompositeEncoder output, SerialDescriptor serialDesc) {
            if (output.shouldEncodeElementDefault(serialDesc, 0) ? true : self.getUnlocked()) {
                output.encodeBooleanElement(serialDesc, 0, self.getUnlocked());
            }
            if (output.shouldEncodeElementDefault(serialDesc, 1) ? true : self.getSolved()) {
                output.encodeBooleanElement(serialDesc, 1, self.getSolved());
            }
            if (output.shouldEncodeElementDefault(serialDesc, 2) ? true : !Intrinsics.areEqual((Object)self.getName(), (Object)"")) {
                output.encodeStringElement(serialDesc, 2, self.getName());
            }
            if (output.shouldEncodeElementDefault(serialDesc, 3) ? true : !Intrinsics.areEqual((Object)self.questIMGUnlocked, (Object)"")) {
                output.encodeStringElement(serialDesc, 3, self.questIMGUnlocked);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 4) ? true : !Intrinsics.areEqual((Object)self.questIMGLocked, (Object)"")) {
                output.encodeStringElement(serialDesc, 4, self.questIMGLocked);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 5) ? true : !Intrinsics.areEqual((Object)self.getText(), (Object)"")) {
                output.encodeStringElement(serialDesc, 5, self.getText());
            }
            if (output.shouldEncodeElementDefault(serialDesc, 6) ? true : !Intrinsics.areEqual((Object)self.getDifficulty(), (Object)"")) {
                output.encodeStringElement(serialDesc, 6, self.getDifficulty());
            }
        }

        public /* synthetic */ Quest(int seen0, boolean unlocked, boolean solved, String name, String questIMGUnlocked, String questIMGLocked, String text, String difficulty, SerializationConstructorMarker serializationConstructorMarker) {
            if ((0 & seen0) != 0) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)0, (SerialDescriptor)Quest$$serializer.INSTANCE.getDescriptor());
            }
            this.unlocked = (seen0 & 1) == 0 ? false : unlocked;
            this.solved = (seen0 & 2) == 0 ? false : solved;
            this.name = (seen0 & 4) == 0 ? "" : name;
            this.questIMGUnlocked = (seen0 & 8) == 0 ? "" : questIMGUnlocked;
            this.questIMGLocked = (seen0 & 0x10) == 0 ? "" : questIMGLocked;
            this.text = (seen0 & 0x20) == 0 ? "" : text;
            this.difficulty = (seen0 & 0x40) == 0 ? "" : difficulty;
        }

        public Quest() {
            this(false, false, null, null, null, null, null, 127, null);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lcom/ruslan/growsseth/http/GrowssethApiV2$Quest$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/ruslan/growsseth/http/GrowssethApiV2$Quest;", "ruins-of-growsseth"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<Quest> serializer() {
                return (KSerializer)Quest$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Serializable
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 B2\u00020\u0001:\u0002ABB[\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\u0006\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010Bc\b\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0006\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\u0004\b\u000f\u0010\u0014J \u0010%\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020(0'\u0012\n\u0012\b\u0012\u0004\u0012\u00020(0)0&H\u0016J\b\u0010*\u001a\u00020\u0003H\u0016J\b\u0010+\u001a\u00020,H\u0002J\t\u0010-\u001a\u00020\u0003H\u00c2\u0003J\t\u0010.\u001a\u00020\u0003H\u00c6\u0003J\t\u0010/\u001a\u00020\u0006H\u00c2\u0003J\t\u00100\u001a\u00020\u0006H\u00c2\u0003J\t\u00101\u001a\u00020\u0006H\u00c2\u0003J\t\u00102\u001a\u00020\nH\u00c6\u0003J\u000b\u00103\u001a\u0004\u0018\u00010\fH\u00c6\u0003J\u000b\u00104\u001a\u0004\u0018\u00010\u000eH\u00c6\u0003J]\u00105\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00c6\u0001J\u0013\u00106\u001a\u00020\n2\b\u00107\u001a\u0004\u0018\u000108H\u00d6\u0003J\t\u00109\u001a\u00020\u0006H\u00d6\u0001J%\u0010:\u001a\u00020,2\u0006\u0010;\u001a\u00020\u00002\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?H\u0001\u00a2\u0006\u0002\b@R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001e\u0010\u000b\u001a\u0004\u0018\u00010\f8\u0016X\u0097\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u001cR\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0016R\u0014\u0010!\u001a\u00020\"8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$\u00a8\u0006C"}, d2={"Lcom/ruslan/growsseth/http/GrowssethApiV2$StructureSpawn;", "Lcom/ruslan/growsseth/http/ApiStructureSpawn;", "structureID", "", "name", "x", "", "y", "z", "active", "", "rotation", "Lnet/minecraft/world/level/block/Rotation;", "quest", "Lcom/ruslan/growsseth/http/GrowssethApiV2$Quest;", "<init>", "(Ljava/lang/String;Ljava/lang/String;IIIZLnet/minecraft/world/level/block/Rotation;Lcom/ruslan/growsseth/http/GrowssethApiV2$Quest;)V", "seen0", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;Ljava/lang/String;IIIZLnet/minecraft/world/level/block/Rotation;Lcom/ruslan/growsseth/http/GrowssethApiV2$Quest;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getName", "()Ljava/lang/String;", "getActive", "()Z", "getRotation$annotations", "()V", "getRotation", "()Lnet/minecraft/world/level/block/Rotation;", "getQuest", "()Lcom/ruslan/growsseth/http/GrowssethApiV2$Quest;", "structureId", "getStructureId", "startPos", "Lnet/minecraft/core/BlockPos;", "getStartPos", "()Lnet/minecraft/core/BlockPos;", "structureKey", "Lcom/mojang/datafixers/util/Either;", "Lnet/minecraft/tags/TagKey;", "Lnet/minecraft/world/level/levelgen/structure/Structure;", "Lnet/minecraft/resources/ResourceKey;", "toString", "checkValid", "", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "other", "", "hashCode", "write$Self", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$ruins_of_growsseth", "$serializer", "Companion", "ruins-of-growsseth"})
    public static final class StructureSpawn
    implements ApiStructureSpawn {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String structureID;
        @NotNull
        private final String name;
        private final int x;
        private final int y;
        private final int z;
        private final boolean active;
        @Nullable
        private final Rotation rotation;
        @Nullable
        private final Quest quest;
        @JvmField
        @NotNull
        private static final KSerializer<Object>[] $childSerializers;

        public StructureSpawn(@NotNull String structureID, @NotNull String name, int x, int y, int z, boolean active, @Nullable Rotation rotation, @Nullable Quest quest) {
            Intrinsics.checkNotNullParameter((Object)structureID, (String)"structureID");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.structureID = structureID;
            this.name = name;
            this.x = x;
            this.y = y;
            this.z = z;
            this.active = active;
            this.rotation = rotation;
            this.quest = quest;
            this.checkValid();
        }

        public /* synthetic */ StructureSpawn(String string, String string2, int n, int n2, int n3, boolean bl, Rotation rotation, Quest quest, int n4, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n4 & 1) != 0) {
                string = "";
            }
            if ((n4 & 2) != 0) {
                string2 = "";
            }
            if ((n4 & 4) != 0) {
                n = Integer.MAX_VALUE;
            }
            if ((n4 & 8) != 0) {
                n2 = Integer.MAX_VALUE;
            }
            if ((n4 & 0x10) != 0) {
                n3 = Integer.MAX_VALUE;
            }
            if ((n4 & 0x20) != 0) {
                bl = false;
            }
            if ((n4 & 0x40) != 0) {
                rotation = null;
            }
            if ((n4 & 0x80) != 0) {
                quest = null;
            }
            this(string, string2, n, n2, n3, bl, rotation, quest);
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        public boolean getActive() {
            return this.active;
        }

        @Override
        @Nullable
        public Rotation getRotation() {
            return this.rotation;
        }

        @Serializable(with=RotationSerializer.class)
        public static /* synthetic */ void getRotation$annotations() {
        }

        @Nullable
        public final Quest getQuest() {
            return this.quest;
        }

        @Override
        @NotNull
        public String getStructureId() {
            return this.structureID;
        }

        @Override
        @NotNull
        public BlockPos getStartPos() {
            return new BlockPos(this.x, this.y, this.z);
        }

        @Override
        @NotNull
        public Either<TagKey<Structure>, ResourceKey<Structure>> structureKey() {
            return UtilsKt.getStructTagOrKey((String)this.structureID);
        }

        @NotNull
        public String toString() {
            String string;
            Rotation rotation = this.getRotation();
            if (rotation != null) {
                Rotation it = rotation;
                boolean bl = false;
                string = " " + (switch (WhenMappings.$EnumSwitchMapping$0[it.ordinal()]) {
                    case 1 -> 0;
                    case 2 -> 90;
                    case 3 -> -90;
                    case 4 -> 180;
                    default -> throw new NoWhenBranchMatchedException();
                }) + "\u00b0";
            } else {
                string = null;
            }
            String rotString = string;
            return this.getName() + "(" + (this.getActive() ? "X" : "") + "(" + this.structureID + " @" + this.getStartPos() + rotString + ")";
        }

        private final void checkValid() {
        }

        private final String component1() {
            return this.structureID;
        }

        @NotNull
        public final String component2() {
            return this.name;
        }

        private final int component3() {
            return this.x;
        }

        private final int component4() {
            return this.y;
        }

        private final int component5() {
            return this.z;
        }

        public final boolean component6() {
            return this.active;
        }

        @Nullable
        public final Rotation component7() {
            return this.rotation;
        }

        @Nullable
        public final Quest component8() {
            return this.quest;
        }

        @NotNull
        public final StructureSpawn copy(@NotNull String structureID, @NotNull String name, int x, int y, int z, boolean active, @Nullable Rotation rotation, @Nullable Quest quest) {
            Intrinsics.checkNotNullParameter((Object)structureID, (String)"structureID");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new StructureSpawn(structureID, name, x, y, z, active, rotation, quest);
        }

        public static /* synthetic */ StructureSpawn copy$default(StructureSpawn structureSpawn, String string, String string2, int n, int n2, int n3, boolean bl, Rotation rotation, Quest quest, int n4, Object object) {
            if ((n4 & 1) != 0) {
                string = structureSpawn.structureID;
            }
            if ((n4 & 2) != 0) {
                string2 = structureSpawn.name;
            }
            if ((n4 & 4) != 0) {
                n = structureSpawn.x;
            }
            if ((n4 & 8) != 0) {
                n2 = structureSpawn.y;
            }
            if ((n4 & 0x10) != 0) {
                n3 = structureSpawn.z;
            }
            if ((n4 & 0x20) != 0) {
                bl = structureSpawn.active;
            }
            if ((n4 & 0x40) != 0) {
                rotation = structureSpawn.rotation;
            }
            if ((n4 & 0x80) != 0) {
                quest = structureSpawn.quest;
            }
            return structureSpawn.copy(string, string2, n, n2, n3, bl, rotation, quest);
        }

        public int hashCode() {
            int result = this.structureID.hashCode();
            result = result * 31 + this.name.hashCode();
            result = result * 31 + Integer.hashCode(this.x);
            result = result * 31 + Integer.hashCode(this.y);
            result = result * 31 + Integer.hashCode(this.z);
            result = result * 31 + Boolean.hashCode(this.active);
            result = result * 31 + (this.rotation == null ? 0 : this.rotation.hashCode());
            result = result * 31 + (this.quest == null ? 0 : this.quest.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof StructureSpawn)) {
                return false;
            }
            StructureSpawn structureSpawn = (StructureSpawn)other;
            if (!Intrinsics.areEqual((Object)this.structureID, (Object)structureSpawn.structureID)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.name, (Object)structureSpawn.name)) {
                return false;
            }
            if (this.x != structureSpawn.x) {
                return false;
            }
            if (this.y != structureSpawn.y) {
                return false;
            }
            if (this.z != structureSpawn.z) {
                return false;
            }
            if (this.active != structureSpawn.active) {
                return false;
            }
            if (this.rotation != structureSpawn.rotation) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.quest, (Object)structureSpawn.quest);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$ruins_of_growsseth(StructureSpawn self, CompositeEncoder output, SerialDescriptor serialDesc) {
            KSerializer<Object>[] kSerializerArray = $childSerializers;
            if (output.shouldEncodeElementDefault(serialDesc, 0) ? true : !Intrinsics.areEqual((Object)self.structureID, (Object)"")) {
                output.encodeStringElement(serialDesc, 0, self.structureID);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 1) ? true : !Intrinsics.areEqual((Object)self.getName(), (Object)"")) {
                output.encodeStringElement(serialDesc, 1, self.getName());
            }
            if (output.shouldEncodeElementDefault(serialDesc, 2) ? true : self.x != Integer.MAX_VALUE) {
                output.encodeIntElement(serialDesc, 2, self.x);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 3) ? true : self.y != Integer.MAX_VALUE) {
                output.encodeIntElement(serialDesc, 3, self.y);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 4) ? true : self.z != Integer.MAX_VALUE) {
                output.encodeIntElement(serialDesc, 4, self.z);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 5) ? true : self.getActive()) {
                output.encodeBooleanElement(serialDesc, 5, self.getActive());
            }
            if (output.shouldEncodeElementDefault(serialDesc, 6) ? true : self.getRotation() != null) {
                output.encodeNullableSerializableElement(serialDesc, 6, (SerializationStrategy)kSerializerArray[6], (Object)self.getRotation());
            }
            if (output.shouldEncodeElementDefault(serialDesc, 7) ? true : self.quest != null) {
                output.encodeNullableSerializableElement(serialDesc, 7, (SerializationStrategy)Quest$$serializer.INSTANCE, (Object)self.quest);
            }
        }

        public /* synthetic */ StructureSpawn(int seen0, String structureID, String name, int x, int y, int z, boolean active, Rotation rotation, Quest quest, SerializationConstructorMarker serializationConstructorMarker) {
            if ((0 & seen0) != 0) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)0, (SerialDescriptor)StructureSpawn$$serializer.INSTANCE.getDescriptor());
            }
            this.structureID = (seen0 & 1) == 0 ? "" : structureID;
            this.name = (seen0 & 2) == 0 ? "" : name;
            this.x = (seen0 & 4) == 0 ? Integer.MAX_VALUE : x;
            this.y = (seen0 & 8) == 0 ? Integer.MAX_VALUE : y;
            this.z = (seen0 & 0x10) == 0 ? Integer.MAX_VALUE : z;
            this.active = (seen0 & 0x20) == 0 ? false : active;
            this.rotation = (seen0 & 0x40) == 0 ? null : rotation;
            this.quest = (seen0 & 0x80) == 0 ? null : quest;
            this.checkValid();
        }

        public StructureSpawn() {
            this(null, null, 0, 0, 0, false, null, null, 255, null);
        }

        public static final /* synthetic */ KSerializer[] access$get$childSerializers$cp() {
            return $childSerializers;
        }

        static {
            KSerializer[] kSerializerArray = new KSerializer[]{null, null, null, null, null, null, new RotationSerializer(), null};
            $childSerializers = kSerializerArray;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lcom/ruslan/growsseth/http/GrowssethApiV2$StructureSpawn$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/ruslan/growsseth/http/GrowssethApiV2$StructureSpawn;", "ruins-of-growsseth"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<StructureSpawn> serializer() {
                return (KSerializer)StructureSpawn$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Rotation.values().length];
                try {
                    nArray[Rotation.NONE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Rotation.CLOCKWISE_90.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Rotation.COUNTERCLOCKWISE_90.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Rotation.CLOCKWISE_180.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

