/*
 * Decompiled with CFR 0.152.
 */
package com.ruslan.growsseth.http;

import com.filloax.fxlib.api.EventUtil;
import com.filloax.fxlib.api.ScheduledServerTask;
import com.filloax.fxlib.api.UtilsKt;
import com.filloax.fxlib.api.codec.CodecUtilsKt;
import com.filloax.fxlib.api.entity.EntityUtilsKt;
import com.filloax.fxlib.api.nbt.NbtUtilsKt;
import com.filloax.fxlib.api.networking.NetworkingUtilsKt;
import com.filloax.fxlib.api.savedata.FxSavedData;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.PrimitiveCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.ruslan.growsseth.RuinsOfGrowsseth;
import com.ruslan.growsseth.entity.GrowssethEntities;
import com.ruslan.growsseth.entity.SpawnTimeTracker;
import com.ruslan.growsseth.entity.researcher.Researcher;
import com.ruslan.growsseth.entity.researcher.ResearcherDonkey;
import com.ruslan.growsseth.entity.researcher.ResearcherQuestComponent;
import com.ruslan.growsseth.http.ApiEvent;
import com.ruslan.growsseth.http.GrowssethApi;
import com.ruslan.growsseth.http.GrowssethExtraEvents;
import com.ruslan.growsseth.http.RemoteCommandExec;
import com.ruslan.growsseth.network.CustomToastPacket;
import com.ruslan.growsseth.structure.pieces.ResearcherTent;
import com.ruslan.growsseth.utils.MixinHelpers;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KProperty1;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002;<B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u001d\u001a\u00020\u000bJ\u0016\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\tJ\u0006\u0010!\u001a\u00020\u000bJ \u0010\"\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\b2\u0006\u0010 \u001a\u00020\t2\u0006\u0010$\u001a\u00020\nH\u0002J\u0018\u0010%\u001a\u00020&2\u0006\u0010#\u001a\u00020\b2\u0006\u0010 \u001a\u00020\tH\u0002J\u0018\u0010'\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\u000eH\u0002J\u0018\u0010(\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\b2\u0006\u0010 \u001a\u00020\tH\u0002J \u0010)\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\u000e2\u0006\u0010*\u001a\u00020&2\u0006\u0010+\u001a\u00020\u0006H\u0002J \u0010,\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\b2\u0006\u0010 \u001a\u00020\t2\u0006\u0010$\u001a\u00020\nH\u0002J\u0016\u0010-\u001a\u00020\u000b2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u001cJ \u00101\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\b2\u0006\u0010 \u001a\u00020\t2\u0006\u0010$\u001a\u00020\nH\u0002J\u0016\u00102\u001a\u00020\u000b2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u000206J\u001e\u00107\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\b2\u0006\u0010 \u001a\u00020\t2\u0006\u0010$\u001a\u00020\nJ\u001e\u00108\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\b2\u0006\u0010 \u001a\u00020\t2\u0006\u0010$\u001a\u00020\nJ\u0016\u00109\u001a\u00020\u000b2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u001cJ\u001e\u0010:\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\b2\u0006\u0010 \u001a\u00020\t2\u0006\u0010$\u001a\u00020\nR2\u0010\u0004\u001a&\u0012\u0004\u0012\u00020\u0006\u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\f\u001a \u0012\u0004\u0012\u00020\u0006\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000b0\r0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0010\u001a\u0004\u0018\u00010\b2\b\u0010\u000f\u001a\u0004\u0018\u00010\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\"\u0010\u0013\u001a\u0004\u0018\u00010\b2\b\u0010\u000f\u001a\u0004\u0018\u00010\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u001e\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u0015@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R,\u0010\u0019\u001a \u0012\u0004\u0012\u00020\u0006\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u00150\r0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lcom/ruslan/growsseth/http/GrowssethExtraEvents;", "", "<init>", "()V", "prefixToHandler", "", "", "Lkotlin/Function3;", "Lcom/ruslan/growsseth/http/ApiEvent;", "Lnet/minecraft/server/MinecraftServer;", "Lcom/ruslan/growsseth/http/GrowssethApi;", "", "prefixToJoinHandler", "Lkotlin/Function2;", "Lnet/minecraft/server/level/ServerPlayer;", "value", "queuedTpResearcherEvent", "getQueuedTpResearcherEvent", "()Lcom/ruslan/growsseth/http/ApiEvent;", "queuedRemoveTentWithGiftEvent", "getQueuedRemoveTentWithGiftEvent", "", "shouldRunResearcherRemoveCheck", "getShouldRunResearcherRemoveCheck", "()Z", "doOnChunkLoad", "", "Lnet/minecraft/world/level/chunk/LevelChunk;", "Lnet/minecraft/server/level/ServerLevel;", "init", "onServerPlayerJoin", "player", "server", "onServerStop", "handleCustomToast", "event", "api", "getToastPacket", "Lcom/ruslan/growsseth/network/CustomToastPacket;", "handleCustomToastJoin", "sendAllCustomToastEvent", "checkAndSendCustomToastEvent", "packet", "seqId", "handleTeleportResearcher", "teleportResearcher", "researcher", "Lcom/ruslan/growsseth/entity/researcher/Researcher;", "level", "handleRemoveOldResearchers", "researcherRemoveCheck", "entity", "Lnet/minecraft/world/entity/LivingEntity;", "tracker", "Lcom/ruslan/growsseth/entity/SpawnTimeTracker;", "handleRemoveTent", "handleRemoveTentWithGift", "removeTentWithGift", "handleSpawnResearcher", "Callbacks", "EventsSavedData", "ruins-of-growsseth"})
@SourceDebugExtension(value={"SMAP\nGrowssethExtraEvents.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrowssethExtraEvents.kt\ncom/ruslan/growsseth/http/GrowssethExtraEvents\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,446:1\n1863#2:447\n1864#2:449\n1863#2,2:450\n295#2,2:452\n1863#2,2:454\n1863#2,2:456\n1#3:448\n*S KotlinDebug\n*F\n+ 1 GrowssethExtraEvents.kt\ncom/ruslan/growsseth/http/GrowssethExtraEvents\n*L\n96#1:447\n96#1:449\n168#1:450,2\n86#1:452,2\n75#1:454,2\n309#1:456,2\n*E\n"})
public final class GrowssethExtraEvents {
    @NotNull
    public static final GrowssethExtraEvents INSTANCE = new GrowssethExtraEvents();
    @NotNull
    private static final Map<String, Function3<ApiEvent, MinecraftServer, GrowssethApi, Unit>> prefixToHandler;
    @NotNull
    private static final Map<String, Function2<ApiEvent, ServerPlayer, Unit>> prefixToJoinHandler;
    @Nullable
    private static ApiEvent queuedTpResearcherEvent;
    @Nullable
    private static ApiEvent queuedRemoveTentWithGiftEvent;
    private static boolean shouldRunResearcherRemoveCheck;
    @NotNull
    private static final Map<String, Function2<LevelChunk, ServerLevel, Boolean>> doOnChunkLoad;

    private GrowssethExtraEvents() {
    }

    @Nullable
    public final ApiEvent getQueuedTpResearcherEvent() {
        return queuedTpResearcherEvent;
    }

    @Nullable
    public final ApiEvent getQueuedRemoveTentWithGiftEvent() {
        return queuedRemoveTentWithGiftEvent;
    }

    public final boolean getShouldRunResearcherRemoveCheck() {
        return shouldRunResearcherRemoveCheck;
    }

    public final void init() {
        GrowssethApi.Companion.getCurrent().subscribe((Function2<? super GrowssethApi, ? super MinecraftServer, Unit>)((Function2)GrowssethExtraEvents::init$lambda$6));
    }

    public final void onServerPlayerJoin(@NotNull ServerPlayer player, @NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Iterable $this$forEach$iv = GrowssethApi.Companion.getCurrent().getEvents();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function2<ApiEvent, ServerPlayer, Unit> it;
            ApiEvent event = (ApiEvent)element$iv;
            boolean bl = false;
            if (!event.getActive()) continue;
            String[] stringArray = new String[]{"/"};
            String prefix = (String)StringsKt.split$default((CharSequence)event.getName(), (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(0);
            if (prefixToJoinHandler.get(prefix) == null) continue;
            boolean bl2 = false;
            it.invoke((Object)event, (Object)player);
        }
    }

    public final void onServerStop() {
        doOnChunkLoad.clear();
        queuedTpResearcherEvent = null;
        queuedRemoveTentWithGiftEvent = null;
        shouldRunResearcherRemoveCheck = false;
    }

    private final void handleCustomToast(ApiEvent event, MinecraftServer server, GrowssethApi api) {
        int minStartTime = 40;
        int tickCount = server.getTickCount();
        int delay = RangesKt.coerceAtLeast((int)(minStartTime - tickCount), (int)0);
        if (delay > 0) {
            ScheduledServerTask.Companion.schedule(server, delay, () -> GrowssethExtraEvents.handleCustomToast$lambda$9(event, server));
        } else {
            this.sendAllCustomToastEvent(event, server);
        }
    }

    private final CustomToastPacket getToastPacket(ApiEvent event, MinecraftServer server) {
        MutableComponent mutableComponent;
        String string;
        String titlePart = ((Object)StringsKt.trim((CharSequence)StringsKt.replace$default((String)event.getName(), (String)"toast/", (String)"", (boolean)false, (int)4, null))).toString();
        Regex itemToastPattern = new Regex("(?<namespace>[^/]+)/(?<path>[^/]+)/(?<title>.+)");
        MatchResult match = itemToastPattern.matchEntire((CharSequence)titlePart);
        ItemStack item = null;
        if (match != null) {
            String title;
            MatchGroup matchGroup = RegexExtensionsJDK8Kt.get((MatchGroupCollection)match.getGroups(), (String)"namespace");
            String namespace = matchGroup != null ? matchGroup.getValue() : null;
            MatchGroup matchGroup2 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)match.getGroups(), (String)"path");
            String path = matchGroup2 != null ? matchGroup2.getValue() : null;
            MatchGroup matchGroup3 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)match.getGroups(), (String)"title");
            String string2 = title = matchGroup3 != null ? matchGroup3.getValue() : null;
            if (namespace != null && path != null && title != null) {
                ResourceLocation itemId = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path);
                RegistryAccess.Frozen registryAccess = server.registryAccess();
                Optional optional = registryAccess.registry(Registries.ITEM);
                Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"registry(...)");
                Registry registry = (Registry)OptionalsKt.getOrNull((Optional)optional);
                Item item2 = item = registry != null ? (Item)registry.get(itemId) : null;
                if (item == null) {
                    RuinsOfGrowsseth.LOGGER.warn("Custom item toast: couldn't find item with id " + itemId, new Object[0]);
                }
                string = title;
            } else {
                string = titlePart;
            }
        } else {
            string = titlePart;
        }
        String title = string;
        String string3 = event.getDesc();
        if (string3 != null) {
            String it = string3;
            boolean bl = false;
            mutableComponent = Component.literal((String)it);
        } else {
            mutableComponent = null;
        }
        MutableComponent content = mutableComponent;
        MutableComponent mutableComponent2 = Component.literal((String)title);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent2, (String)"literal(...)");
        Component component = (Component)mutableComponent2;
        Component component2 = (Component)content;
        ItemStack itemStack = item;
        if (itemStack == null || (itemStack = itemStack.getDefaultInstance()) == null) {
            itemStack = ItemStack.EMPTY;
        }
        ItemStack itemStack2 = itemStack;
        Intrinsics.checkNotNull((Object)itemStack2);
        return new CustomToastPacket(component, component2, itemStack2);
    }

    private final void handleCustomToastJoin(ApiEvent event, ServerPlayer player) {
        Object object;
        block3: {
            block2: {
                object = event.getPos();
                if (object == null) break block2;
                BlockPos it = object;
                boolean bl = false;
                String string = "" + it.getX() + it.getY() + it.getZ();
                object = string;
                if (string != null) break block3;
            }
            object = "";
        }
        Object seqId = object;
        MinecraftServer minecraftServer = player.server;
        Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"server");
        CustomToastPacket packet = this.getToastPacket(event, minecraftServer);
        this.checkAndSendCustomToastEvent(player, packet, (String)seqId);
    }

    private final void sendAllCustomToastEvent(ApiEvent event, MinecraftServer server) {
        Object object;
        block4: {
            block3: {
                object = event.getPos();
                if (object == null) break block3;
                BlockPos it = object;
                boolean bl = false;
                String string = "" + it.getX() + it.getY() + it.getZ();
                object = string;
                if (string != null) break block4;
            }
            object = "";
        }
        Object seqId = object;
        CustomToastPacket packet = this.getToastPacket(event, server);
        List list = server.getPlayerList().getPlayers();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPlayers(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ServerPlayer player = (ServerPlayer)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)player);
            INSTANCE.checkAndSendCustomToastEvent(player, packet, (String)seqId);
        }
    }

    private final void checkAndSendCustomToastEvent(ServerPlayer player, CustomToastPacket packet, String seqId) {
        CompoundTag data = EntityUtilsKt.getPersistData((Entity)((Entity)player));
        NbtUtilsKt.putIfAbsent((CompoundTag)data, (String)"growsseth:customToastMemory", (Tag)((Tag)new CompoundTag()));
        CompoundTag memory = data.getCompound("growsseth:customToastMemory");
        String id = packet.getTitle().getString() + seqId;
        if (!memory.contains(id)) {
            NetworkingUtilsKt.sendPacket$default((ServerPlayer)player, (CustomPacketPayload)packet, null, (int)2, null);
            memory.put(id, (Tag)IntTag.valueOf((int)1));
        }
    }

    private final void handleTeleportResearcher(ApiEvent event, MinecraftServer server, GrowssethApi api) {
        String id;
        BlockPos pos = event.getPos();
        String string = event.getDesc();
        if (string != null) {
            String it = string;
            boolean bl = false;
            v1 = "tp-" + it;
        } else {
            v1 = id = null;
        }
        if (com.ruslan.growsseth.utils.UtilsKt.isNull(pos) || id == null) {
            RuinsOfGrowsseth.LOGGER.error("Teleport researcher event must have a position and desc! " + event, new Object[0]);
            return;
        }
        EventUtil.INSTANCE.runWhenServerStarted(server, true, arg_0 -> GrowssethExtraEvents.handleTeleportResearcher$lambda$15(id, event, pos, arg_0));
    }

    public final void teleportResearcher(@NotNull Researcher researcher, @NotNull ServerLevel level) {
        Object object;
        ApiEvent event;
        block9: {
            block8: {
                Intrinsics.checkNotNullParameter((Object)researcher, (String)"researcher");
                Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                ApiEvent apiEvent = queuedTpResearcherEvent;
                if (apiEvent == null) {
                    GrowssethExtraEvents $this$teleportResearcher_u24lambda_u2416 = this;
                    boolean bl = false;
                    RuinsOfGrowsseth.LOGGER.warn("Tried to teleport researcher but no teleport action queued!", new Object[0]);
                    return;
                }
                event = apiEvent;
                object = event.getDesc();
                if (object == null) break block8;
                String it = object;
                boolean bl = false;
                String string = "tp-" + it;
                object = string;
                if (string != null) break block9;
            }
            GrowssethExtraEvents $this$teleportResearcher_u24lambda_u2418 = this;
            boolean bl = false;
            RuinsOfGrowsseth.LOGGER.error("No desc in teleport event " + event, new Object[0]);
            return;
        }
        Object id = object;
        BlockPos blockPos = event.getPos();
        if (blockPos == null) {
            GrowssethExtraEvents $this$teleportResearcher_u24lambda_u2419 = this;
            boolean bl = false;
            RuinsOfGrowsseth.LOGGER.error("No pos in teleport event " + event, new Object[0]);
            return;
        }
        BlockPos pos = blockPos;
        MinecraftServer minecraftServer = level.getServer();
        Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
        MinecraftServer server = minecraftServer;
        EventsSavedData savedData = EventsSavedData.Companion.get(server);
        if (!savedData.getAlreadyRan().contains(id)) {
            BlockPos blockPos2 = UtilsKt.nearestFreePosition((Level)((Level)level), (BlockPos)pos, (boolean)true, (boolean)true);
            if (blockPos2 == null) {
                blockPos2 = pos;
            }
            BlockPos teleportPos = blockPos2;
            researcher.moveTo(teleportPos.getCenter());
            researcher.resetStartingPos(teleportPos);
            RuinsOfGrowsseth.LOGGER.info("Teleported researcher " + researcher + " to " + teleportPos + "[" + pos + "] (" + (String)id + ")", new Object[0]);
            savedData.getAlreadyRan().add((String)id);
            savedData.setDirty();
        } else {
            RuinsOfGrowsseth.LOGGER.warn("Tried to teleport researcher twice! (id: " + (String)id + ")", new Object[0]);
        }
        queuedTpResearcherEvent = null;
    }

    private final void handleRemoveOldResearchers(ApiEvent event, MinecraftServer server, GrowssethApi api) {
        String id;
        String string = event.getDesc();
        if (string != null) {
            String it = string;
            boolean bl = false;
            v1 = "rm-" + it;
        } else {
            v1 = id = null;
        }
        if (id == null) {
            RuinsOfGrowsseth.LOGGER.error("Remove researcher event must have a desc! " + event, new Object[0]);
            return;
        }
        EventUtil.INSTANCE.runWhenServerStarted(server, true, arg_0 -> GrowssethExtraEvents.handleRemoveOldResearchers$lambda$21(server, id, arg_0));
    }

    public final void researcherRemoveCheck(@NotNull LivingEntity entity, @NotNull SpawnTimeTracker tracker) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
        if (entity.level().isClientSide) {
            return;
        }
        MinecraftServer minecraftServer = entity.level().getServer();
        Intrinsics.checkNotNull((Object)minecraftServer);
        EventsSavedData savedData = EventsSavedData.Companion.get(minecraftServer);
        if (savedData.getRemoveResearchersTimes().isEmpty()) {
            return;
        }
        long maxTime = ((Number)((Object)CollectionsKt.maxOrThrow((Iterable)savedData.getRemoveResearchersTimes().values()))).longValue();
        if (tracker.getSpawnTime() < maxTime) {
            entity.discard();
            RuinsOfGrowsseth.LOGGER.info("Removed researcher " + entity + " via remote command (time was " + tracker.getSpawnTime() + " " + UtilsKt.ticksToTimecode((long)tracker.getSpawnTime()) + ")", new Object[0]);
        }
    }

    public final void handleRemoveTent(@NotNull ApiEvent event, @NotNull MinecraftServer server, @NotNull GrowssethApi api) {
        String string;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)api, (String)"api");
        String string2 = event.getDesc();
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            string = "rmTent-" + it;
        } else {
            string = null;
        }
        String id = string;
        BlockPos pos = event.getPos();
        if (com.ruslan.growsseth.utils.UtilsKt.isNull(pos) || id == null) {
            RuinsOfGrowsseth.LOGGER.error("Remove tent event must have a position and desc! " + event, new Object[0]);
            return;
        }
        ChunkPos chunkPos = new ChunkPos(pos);
        EventUtil.INSTANCE.runWhenServerStarted(server, true, arg_0 -> GrowssethExtraEvents.handleRemoveTent$lambda$26(server, id, chunkPos, pos, arg_0));
    }

    public final void handleRemoveTentWithGift(@NotNull ApiEvent event, @NotNull MinecraftServer server, @NotNull GrowssethApi api) {
        String id;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)api, (String)"api");
        String string = event.getDesc();
        if (string != null) {
            String it = string;
            boolean bl = false;
            v1 = "rmTentGift-" + it;
        } else {
            v1 = id = null;
        }
        if (id == null) {
            RuinsOfGrowsseth.LOGGER.error("Remove tent with gift event must have a desc! " + event, new Object[0]);
            return;
        }
        EventUtil.INSTANCE.runWhenServerStarted(server, true, arg_0 -> GrowssethExtraEvents.handleRemoveTentWithGift$lambda$28(id, event, arg_0));
        queuedRemoveTentWithGiftEvent = null;
    }

    public final void removeTentWithGift(@NotNull Researcher researcher, @NotNull ServerLevel level) {
        Object object;
        block7: {
            ApiEvent event;
            block6: {
                Intrinsics.checkNotNullParameter((Object)researcher, (String)"researcher");
                Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                ApiEvent apiEvent = queuedRemoveTentWithGiftEvent;
                if (apiEvent == null) {
                    GrowssethExtraEvents $this$removeTentWithGift_u24lambda_u2429 = this;
                    boolean bl = false;
                    RuinsOfGrowsseth.LOGGER.warn("Tried to remove tent with gift but no event queued!", new Object[0]);
                    return;
                }
                event = apiEvent;
                object = event.getDesc();
                if (object == null) break block6;
                String it = object;
                boolean bl = false;
                String string = "rmTentGift-" + it;
                object = string;
                if (string != null) break block7;
            }
            GrowssethExtraEvents $this$removeTentWithGift_u24lambda_u2431 = this;
            boolean bl = false;
            RuinsOfGrowsseth.LOGGER.error("No desc in remove tent with gift event " + event, new Object[0]);
            return;
        }
        Object id = object;
        MinecraftServer minecraftServer = level.getServer();
        Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
        MinecraftServer server = minecraftServer;
        EventsSavedData savedData = EventsSavedData.Companion.get(server);
        if (!savedData.getAlreadyRan().contains(id)) {
            ResearcherQuestComponent.Companion.removeTentAndResearcher(researcher);
            savedData.getAlreadyRan().add((String)id);
            savedData.setDirty();
        } else {
            RuinsOfGrowsseth.LOGGER.warn("Tried to remove tent with gift twice! (id: " + (String)id + ")", new Object[0]);
        }
    }

    public final void handleSpawnResearcher(@NotNull ApiEvent event, @NotNull MinecraftServer server, @NotNull GrowssethApi api) {
        String string;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)api, (String)"api");
        String string2 = event.getDesc();
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            string = "spawnRes-" + it;
        } else {
            string = null;
        }
        String id = string;
        BlockPos pos = event.getPos();
        if (com.ruslan.growsseth.utils.UtilsKt.isNull(pos) || id == null) {
            RuinsOfGrowsseth.LOGGER.error("spawn Researcher event must have a position and desc! " + event, new Object[0]);
            return;
        }
        ChunkPos chunkPos = new ChunkPos(pos);
        EventUtil.INSTANCE.runWhenServerStarted(server, true, arg_0 -> GrowssethExtraEvents.handleSpawnResearcher$lambda$35(server, id, chunkPos, pos, arg_0));
    }

    private static final boolean init$lambda$6$lambda$5$lambda$3(GrowssethApi $api, Map.Entry entry) {
        Object v1;
        block1: {
            Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
            String id = (String)entry.getKey();
            long time = ((Number)entry.getValue()).longValue();
            Iterable $this$firstOrNull$iv = $api.getEvents();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ApiEvent it = (ApiEvent)element$iv;
                boolean bl = false;
                String string = it.getDesc();
                if (!Intrinsics.areEqual((Object)("rm-" + (string != null ? ((Object)StringsKt.trim((CharSequence)string)).toString() : null)), (Object)id)) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        ApiEvent found = v1;
        return found == null || !found.getActive();
    }

    private static final boolean init$lambda$6$lambda$5$lambda$4(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit init$lambda$6$lambda$5(MinecraftServer $server, GrowssethApi $api, MinecraftServer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        EventsSavedData savedData = EventsSavedData.Companion.get($server);
        savedData.getRemoveResearchersTimes().entrySet().removeIf(arg_0 -> GrowssethExtraEvents.init$lambda$6$lambda$5$lambda$4(arg_0 -> GrowssethExtraEvents.init$lambda$6$lambda$5$lambda$3($api, arg_0), arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit init$lambda$6(GrowssethApi api, MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)api, (String)"api");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Iterable $this$forEach$iv = api.getEvents();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function3<ApiEvent, MinecraftServer, GrowssethApi, Unit> it;
            ApiEvent event = (ApiEvent)element$iv;
            boolean bl = false;
            if (!event.getActive()) continue;
            String[] stringArray = new String[]{"/"};
            String prefix = (String)StringsKt.split$default((CharSequence)event.getName(), (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(0);
            if (prefixToHandler.get(prefix) == null) continue;
            boolean bl2 = false;
            it.invoke((Object)event, (Object)server, (Object)api);
        }
        EventUtil.INSTANCE.runWhenServerStarted(server, true, arg_0 -> GrowssethExtraEvents.init$lambda$6$lambda$5(server, api, arg_0));
        return Unit.INSTANCE;
    }

    private static final void handleCustomToast$lambda$9(ApiEvent $event, MinecraftServer $server) {
        INSTANCE.sendAllCustomToastEvent($event, $server);
    }

    private static final Unit handleTeleportResearcher$lambda$15(String $id, ApiEvent $event, BlockPos $pos, MinecraftServer srv) {
        Intrinsics.checkNotNullParameter((Object)srv, (String)"srv");
        EventsSavedData savedData = EventsSavedData.Companion.get(srv);
        if (savedData.getAlreadyRan().contains($id)) {
            return Unit.INSTANCE;
        }
        if (queuedTpResearcherEvent != null) {
            RuinsOfGrowsseth.LOGGER.warn("Tp researcher already scheduled, overlap?", new Object[0]);
        }
        queuedTpResearcherEvent = $event;
        RuinsOfGrowsseth.LOGGER.info("Scheduler researcher tp to " + $pos + " (" + $id + ")", new Object[0]);
        return Unit.INSTANCE;
    }

    private static final Unit handleRemoveOldResearchers$lambda$21(MinecraftServer $server, String $id, MinecraftServer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        EventsSavedData savedData = EventsSavedData.Companion.get($server);
        if (savedData.getRemoveResearchersTimes().containsKey($id)) {
            shouldRunResearcherRemoveCheck = true;
            return Unit.INSTANCE;
        }
        long time = $server.overworld().getGameTime() - (long)UtilsKt.secondsToTicks((float)60.0f);
        Long l = time;
        savedData.getRemoveResearchersTimes().put($id, l);
        savedData.setDirty();
        RuinsOfGrowsseth.LOGGER.info("Set researchers older than " + time + " (" + UtilsKt.ticksToTimecode((long)time) + ") to be removed", new Object[0]);
        shouldRunResearcherRemoveCheck = true;
        return Unit.INSTANCE;
    }

    private static final boolean handleRemoveTent$lambda$26$lambda$25$lambda$24$lambda$23(Ref.ObjectRef $tent, Entity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.position().distanceTo(((StructureStart)$tent.element).getBoundingBox().getCenter().getCenter()) < 40.0;
    }

    private static final Unit handleRemoveTent$lambda$26$lambda$25(EventsSavedData $savedData, String $id, BlockPos $pos, MinecraftServer $server, ServerLevel level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        if ($savedData.getAlreadyRan().contains($id)) {
            return Unit.INSTANCE;
        }
        StructureManager structureManager = level.structureManager();
        Ref.ObjectRef tent = new Ref.ObjectRef();
        Structure structure = MixinHelpers.researcherTent;
        Intrinsics.checkNotNull((Object)structure);
        tent.element = structureManager.getStructureAt($pos, structure);
        if (!((StructureStart)tent.element).isValid()) {
            int defaultY = level.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, $pos.getX(), $pos.getZ()) - 10;
            BlockPos blockPos = new BlockPos($pos.getX(), defaultY, $pos.getZ());
            Structure structure2 = MixinHelpers.researcherTent;
            Intrinsics.checkNotNull((Object)structure2);
            tent.element = structureManager.getStructureAt(blockPos, structure2);
        }
        if (!((StructureStart)tent.element).isValid()) {
            RuinsOfGrowsseth.LOGGER.warn("Cannot remove tent at " + $pos + " as no tent there!", new Object[0]);
            return Unit.INSTANCE;
        }
        List list = ((StructureStart)tent.element).getPieces();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPieces(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StructurePiece piece = (StructurePiece)element$iv;
            boolean bl = false;
            if (!(piece instanceof ResearcherTent)) continue;
            ResearcherTent.remove$default((ResearcherTent)piece, level, null, true, 2, null);
            ResearcherTent researcherTent = (ResearcherTent)piece;
            ServerLevel serverLevel = $server.overworld();
            Intrinsics.checkNotNullExpressionValue((Object)serverLevel, (String)"overworld(...)");
            ResearcherDonkey.INSTANCE.removeDonkey(researcherTent, serverLevel, (Function1<? super Entity, Boolean>)((Function1)arg_0 -> GrowssethExtraEvents.handleRemoveTent$lambda$26$lambda$25$lambda$24$lambda$23(tent, arg_0)));
        }
        $savedData.getAlreadyRan().add($id);
        $savedData.setDirty();
        return Unit.INSTANCE;
    }

    private static final Unit handleRemoveTent$lambda$26(MinecraftServer $server, String $id, ChunkPos $chunkPos, BlockPos $pos, MinecraftServer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        EventsSavedData savedData = EventsSavedData.Companion.get($server);
        if (savedData.getAlreadyRan().contains($id)) {
            return Unit.INSTANCE;
        }
        ServerLevel serverLevel = $server.overworld();
        Intrinsics.checkNotNullExpressionValue((Object)serverLevel, (String)"overworld(...)");
        EventUtil.INSTANCE.runWhenChunkLoaded(serverLevel, $chunkPos, arg_0 -> GrowssethExtraEvents.handleRemoveTent$lambda$26$lambda$25(savedData, $id, $pos, $server, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit handleRemoveTentWithGift$lambda$28(String $id, ApiEvent $event, MinecraftServer srv) {
        Intrinsics.checkNotNullParameter((Object)srv, (String)"srv");
        EventsSavedData savedData = EventsSavedData.Companion.get(srv);
        if (savedData.getAlreadyRan().contains($id)) {
            return Unit.INSTANCE;
        }
        if (queuedRemoveTentWithGiftEvent != null) {
            RuinsOfGrowsseth.LOGGER.warn("Remove tent with gift already scheduled, overlap?", new Object[0]);
        }
        queuedRemoveTentWithGiftEvent = $event;
        RuinsOfGrowsseth.LOGGER.info("Scheduler remove tent with gift", new Object[0]);
        return Unit.INSTANCE;
    }

    private static final Unit handleSpawnResearcher$lambda$35$lambda$34(EventsSavedData $savedData, String $id, BlockPos $pos, ServerLevel level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        if ($savedData.getAlreadyRan().contains($id)) {
            return Unit.INSTANCE;
        }
        $savedData.getAlreadyRan().add($id);
        $savedData.setDirty();
        Researcher researcher = (Researcher)GrowssethEntities.INSTANCE.getRESEARCHER().create((Level)level);
        if (researcher == null) {
            GrowssethExtraEvents $this$handleSpawnResearcher_u24lambda_u2435_u24lambda_u2434_u24lambda_u2433 = INSTANCE;
            boolean bl = false;
            RuinsOfGrowsseth.LOGGER.error("Couldn't spawn researcher through growsseth event!", new Object[0]);
            return Unit.INSTANCE;
        }
        Researcher mob = researcher;
        mob.moveTo((double)$pos.getX() + 0.5, (double)$pos.getY() + 0.0, (double)$pos.getZ() + 0.5, 0.0f, 0.0f);
        ServerLevelAccessor serverLevelAccessor = (ServerLevelAccessor)level;
        DifficultyInstance difficultyInstance = level.getCurrentDifficultyAt($pos);
        Intrinsics.checkNotNullExpressionValue((Object)difficultyInstance, (String)"getCurrentDifficultyAt(...)");
        mob.finalizeSpawn(serverLevelAccessor, difficultyInstance, MobSpawnType.MOB_SUMMONED, null);
        level.addFreshEntityWithPassengers((Entity)mob);
        return Unit.INSTANCE;
    }

    private static final Unit handleSpawnResearcher$lambda$35(MinecraftServer $server, String $id, ChunkPos $chunkPos, BlockPos $pos, MinecraftServer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        EventsSavedData savedData = EventsSavedData.Companion.get($server);
        if (savedData.getAlreadyRan().contains($id)) {
            return Unit.INSTANCE;
        }
        ServerLevel serverLevel = $server.overworld();
        Intrinsics.checkNotNullExpressionValue((Object)serverLevel, (String)"overworld(...)");
        EventUtil.INSTANCE.runWhenChunkLoaded(serverLevel, $chunkPos, arg_0 -> GrowssethExtraEvents.handleSpawnResearcher$lambda$35$lambda$34(savedData, $id, $pos, arg_0));
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$handleCustomToast(GrowssethExtraEvents $this, ApiEvent event, MinecraftServer server, GrowssethApi api) {
        $this.handleCustomToast(event, server, api);
    }

    public static final /* synthetic */ void access$handleTeleportResearcher(GrowssethExtraEvents $this, ApiEvent event, MinecraftServer server, GrowssethApi api) {
        $this.handleTeleportResearcher(event, server, api);
    }

    public static final /* synthetic */ void access$handleRemoveOldResearchers(GrowssethExtraEvents $this, ApiEvent event, MinecraftServer server, GrowssethApi api) {
        $this.handleRemoveOldResearchers(event, server, api);
    }

    public static final /* synthetic */ void access$handleCustomToastJoin(GrowssethExtraEvents $this, ApiEvent event, ServerPlayer player) {
        $this.handleCustomToastJoin(event, player);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"toast", (Object)new Function3<ApiEvent, MinecraftServer, GrowssethApi, Unit>((Object)INSTANCE){

            public final void invoke(ApiEvent p0, MinecraftServer p1, GrowssethApi p2) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                GrowssethExtraEvents.access$handleCustomToast((GrowssethExtraEvents)this.receiver, p0, p1, p2);
            }
        }), TuplesKt.to((Object)"tpResearcher", (Object)new Function3<ApiEvent, MinecraftServer, GrowssethApi, Unit>((Object)INSTANCE){

            public final void invoke(ApiEvent p0, MinecraftServer p1, GrowssethApi p2) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                GrowssethExtraEvents.access$handleTeleportResearcher((GrowssethExtraEvents)this.receiver, p0, p1, p2);
            }
        }), TuplesKt.to((Object)"rmResearcher", (Object)new Function3<ApiEvent, MinecraftServer, GrowssethApi, Unit>((Object)INSTANCE){

            public final void invoke(ApiEvent p0, MinecraftServer p1, GrowssethApi p2) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                GrowssethExtraEvents.access$handleRemoveOldResearchers((GrowssethExtraEvents)this.receiver, p0, p1, p2);
            }
        }), TuplesKt.to((Object)"rmTent", (Object)new Function3<ApiEvent, MinecraftServer, GrowssethApi, Unit>((Object)INSTANCE){

            public final void invoke(ApiEvent p0, MinecraftServer p1, GrowssethApi p2) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                ((GrowssethExtraEvents)this.receiver).handleRemoveTent(p0, p1, p2);
            }
        }), TuplesKt.to((Object)"spawnResearcher", (Object)new Function3<ApiEvent, MinecraftServer, GrowssethApi, Unit>((Object)INSTANCE){

            public final void invoke(ApiEvent p0, MinecraftServer p1, GrowssethApi p2) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                ((GrowssethExtraEvents)this.receiver).handleSpawnResearcher(p0, p1, p2);
            }
        }), TuplesKt.to((Object)"rmTentWithGift", (Object)new Function3<ApiEvent, MinecraftServer, GrowssethApi, Unit>((Object)INSTANCE){

            public final void invoke(ApiEvent p0, MinecraftServer p1, GrowssethApi p2) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                ((GrowssethExtraEvents)this.receiver).handleRemoveTentWithGift(p0, p1, p2);
            }
        }), TuplesKt.to((Object)"cmd", (Object)new Function3<ApiEvent, MinecraftServer, GrowssethApi, Unit>((Object)RemoteCommandExec.INSTANCE){

            public final void invoke(ApiEvent p0, MinecraftServer p1, GrowssethApi p2) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                ((RemoteCommandExec)this.receiver).handleCommandExec(p0, p1, p2);
            }
        })};
        prefixToHandler = MapsKt.mapOf((Pair[])pairArray);
        prefixToJoinHandler = MapsKt.mapOf((Pair)TuplesKt.to((Object)"toast", (Object)new Function2<ApiEvent, ServerPlayer, Unit>((Object)INSTANCE){

            public final void invoke(ApiEvent p0, ServerPlayer p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                GrowssethExtraEvents.access$handleCustomToastJoin((GrowssethExtraEvents)this.receiver, p0, p1);
            }
        }));
        doOnChunkLoad = new LinkedHashMap();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n\u00b2\u0006\n\u0010\u000b\u001a\u00020\fX\u008a\u0084\u0002"}, d2={"Lcom/ruslan/growsseth/http/GrowssethExtraEvents$Callbacks;", "", "<init>", "()V", "onLoadChunk", "", "level", "Lnet/minecraft/server/level/ServerLevel;", "chunk", "Lnet/minecraft/world/level/chunk/LevelChunk;", "ruins-of-growsseth", "savedData", "Lcom/ruslan/growsseth/http/GrowssethExtraEvents$EventsSavedData;"})
    public static final class Callbacks {
        @NotNull
        public static final Callbacks INSTANCE = new Callbacks();

        private Callbacks() {
        }

        public final void onLoadChunk(@NotNull ServerLevel level, @NotNull LevelChunk chunk) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
            Lazy savedData$delegate = LazyKt.lazy(() -> Callbacks.onLoadChunk$lambda$0(level));
            doOnChunkLoad.entrySet().removeIf(arg_0 -> Callbacks.onLoadChunk$lambda$3(arg_0 -> Callbacks.onLoadChunk$lambda$2(chunk, level, savedData$delegate, arg_0), arg_0));
        }

        private static final EventsSavedData onLoadChunk$lambda$0(ServerLevel $level) {
            MinecraftServer minecraftServer = $level.getServer();
            Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
            return EventsSavedData.Companion.get(minecraftServer);
        }

        private static final EventsSavedData onLoadChunk$lambda$1(Lazy<EventsSavedData> $savedData$delegate) {
            Lazy<EventsSavedData> lazy = $savedData$delegate;
            return (EventsSavedData)((Object)lazy.getValue());
        }

        private static final boolean onLoadChunk$lambda$2(LevelChunk $chunk, ServerLevel $level, Lazy $savedData$delegate, Map.Entry entry) {
            Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
            String id = (String)entry.getKey();
            Function2 action = (Function2)entry.getValue();
            if (Callbacks.onLoadChunk$lambda$1((Lazy<EventsSavedData>)$savedData$delegate).getAlreadyRan().contains(id)) {
                return false;
            }
            boolean clear = (Boolean)action.invoke((Object)$chunk, (Object)$level);
            if (clear) {
                Callbacks.onLoadChunk$lambda$1((Lazy<EventsSavedData>)$savedData$delegate).getAlreadyRan().add(id);
                Callbacks.onLoadChunk$lambda$1((Lazy<EventsSavedData>)$savedData$delegate).setDirty();
            }
            return clear;
        }

        private static final boolean onLoadChunk$lambda$3(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0004\u0018\u0000 \u00102\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0010B/\b\u0002\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lcom/ruslan/growsseth/http/GrowssethExtraEvents$EventsSavedData;", "Lcom/filloax/fxlib/api/savedata/FxSavedData;", "alreadyRan", "", "", "removeResearchersTimes", "", "", "<init>", "(Ljava/util/Set;Ljava/util/Map;)V", "", "getAlreadyRan", "()Ljava/util/Set;", "", "getRemoveResearchersTimes", "()Ljava/util/Map;", "Companion", "ruins-of-growsseth"})
    public static final class EventsSavedData
    extends FxSavedData<EventsSavedData> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Set<String> alreadyRan;
        @NotNull
        private final Map<String, Long> removeResearchersTimes;
        @NotNull
        private static final Codec<EventsSavedData> CODEC;
        @NotNull
        private static final FxSavedData.Definition<EventsSavedData> DEF;

        private EventsSavedData(Set<String> alreadyRan, Map<String, Long> removeResearchersTimes) {
            super(CODEC);
            this.alreadyRan = CollectionsKt.toMutableSet((Iterable)alreadyRan);
            this.removeResearchersTimes = MapsKt.toMutableMap(removeResearchersTimes);
        }

        /* synthetic */ EventsSavedData(Set set, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                set = SetsKt.emptySet();
            }
            if ((n & 2) != 0) {
                map = MapsKt.emptyMap();
            }
            this(set, map);
        }

        @NotNull
        public final Set<String> getAlreadyRan() {
            return this.alreadyRan;
        }

        @NotNull
        public final Map<String, Long> getRemoveResearchersTimes() {
            return this.removeResearchersTimes;
        }

        private static final Set CODEC$lambda$2$lambda$0(KProperty1 $tmp0, EventsSavedData p0) {
            return (Set)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final Map CODEC$lambda$2$lambda$1(KProperty1 $tmp0, EventsSavedData p0) {
            return (Map)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final App CODEC$lambda$2(RecordCodecBuilder.Instance builder) {
            PrimitiveCodec primitiveCodec = Codec.STRING;
            Intrinsics.checkNotNullExpressionValue((Object)primitiveCodec, (String)"STRING");
            return builder.group((App)CodecUtilsKt.mutableSetOf((Codec)((Codec)primitiveCodec)).fieldOf("alreadyRan").forGetter(arg_0 -> EventsSavedData.CODEC$lambda$2$lambda$0((KProperty1)Companion.CODEC.1.1.INSTANCE, arg_0)), (App)Codec.unboundedMap((Codec)((Codec)Codec.STRING), (Codec)((Codec)Codec.LONG)).fieldOf("removeResearchersTimes").forGetter(arg_0 -> EventsSavedData.CODEC$lambda$2$lambda$1((KProperty1)Companion.CODEC.1.2.INSTANCE, arg_0))).apply((Applicative)builder, (p0$alreadyRan, p1$removeResearchersTimes) -> new EventsSavedData((Set<String>)p0$alreadyRan, (Map<String, Long>)p1$removeResearchersTimes));
        }

        static {
            Codec codec = RecordCodecBuilder.create(EventsSavedData::CODEC$lambda$2);
            Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"create(...)");
            CODEC = codec;
            DEF = FxSavedData.Companion.define$default((FxSavedData.Companion)FxSavedData.Companion, (String)"growsseth/events", (Function0)Companion.DEF.1.INSTANCE, CODEC, null, (List)CollectionsKt.listOf((Object)"growssethEvents"), (int)8, null);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/ruslan/growsseth/http/GrowssethExtraEvents$EventsSavedData$Companion;", "", "<init>", "()V", "CODEC", "Lcom/mojang/serialization/Codec;", "Lcom/ruslan/growsseth/http/GrowssethExtraEvents$EventsSavedData;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "DEF", "Lcom/filloax/fxlib/api/savedata/FxSavedData$Definition;", "get", "server", "Lnet/minecraft/server/MinecraftServer;", "ruins-of-growsseth"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Codec<EventsSavedData> getCODEC() {
                return CODEC;
            }

            @NotNull
            public final EventsSavedData get(@NotNull MinecraftServer server) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                return (EventsSavedData)FxSavedData.Companion.loadData(server, DEF);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

