/*
 * Decompiled with CFR 0.152.
 */
package com.ruslan.growsseth.http;

import com.filloax.fxlib.api.json.ItemByNameSerializer;
import com.filloax.fxlib.api.json.SimpleComponentSerializer;
import com.filloax.fxlib.api.networking.NetworkingUtilsKt;
import com.ruslan.growsseth.RuinsOfGrowsseth;
import com.ruslan.growsseth.config.WebConfig;
import com.ruslan.growsseth.dialogues.BasicDialoguesComponent;
import com.ruslan.growsseth.dialogues.DialogueEntry;
import com.ruslan.growsseth.dialogues.NpcDialoguesComponent;
import com.ruslan.growsseth.entity.researcher.Researcher;
import com.ruslan.growsseth.http.GrowssethApi;
import com.ruslan.growsseth.http.LiveUpdatesConnection$ToastData$;
import com.ruslan.growsseth.http.RemoteCommandExec;
import com.ruslan.growsseth.http.ResponseSender;
import com.ruslan.growsseth.network.CustomToastPacket;
import io.socket.client.IO;
import io.socket.client.Socket;
import io.socket.emitter.Emitter;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MagicApiIntrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.modules.SerializersModule;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0010\u0018\u0000 &2\u00020\u0001:\u0002&'B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001c\u0010\u0015\u001a\u00020\u00112\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00180\u0017H\u0016J\u0012\u0010\u0019\u001a\u00020\u00112\b\u0010\u001a\u001a\u0004\u0018\u00010\u0014H\u0016J\u001e\u0010\u0012\u001a\u00020\u0011\"\u0006\b\u0000\u0010\u001b\u0018\u00012\u0006\u0010\u0013\u001a\u0002H\u001bH\u0082\b\u00a2\u0006\u0002\u0010\u001cJ\b\u0010\u001d\u001a\u00020\u0011H\u0002J\u0010\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010 \u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010!\u001a\u00020\u0011H\u0002J\u0006\u0010\"\u001a\u00020\u0011J\u0006\u0010#\u001a\u00020\u0011J\u0010\u0010$\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010%\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/ruslan/growsseth/http/LiveUpdatesConnection;", "Lcom/ruslan/growsseth/http/ResponseSender;", "server", "Lnet/minecraft/server/MinecraftServer;", "<init>", "(Lnet/minecraft/server/MinecraftServer;)V", "getServer", "()Lnet/minecraft/server/MinecraftServer;", "running", "", "socket", "Lio/socket/client/Socket;", "thread", "Ljava/lang/Thread;", "asyncLock", "Ljava/util/concurrent/locks/Lock;", "connect", "", "sendOnSocket", "message", "", "sendSuccess", "extraItems", "", "", "sendFailure", "reason", "T", "(Ljava/lang/Object;)V", "onRefreshMessage", "onDialogueMessage", "onCommandMessage", "onNotificationMessage", "listen", "start", "stop", "logInfo", "logError", "Companion", "ToastData", "ruins-of-growsseth"})
@SourceDebugExtension(value={"SMAP\nLiveUpdatesConnection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LiveUpdatesConnection.kt\ncom/ruslan/growsseth/http/LiveUpdatesConnection\n+ 2 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,350:1\n113#2:351\n1863#3:352\n1863#3:353\n1863#3,2:354\n1864#3:356\n1864#3:357\n1863#3,2:359\n147#4:358\n*S KotlinDebug\n*F\n+ 1 LiveUpdatesConnection.kt\ncom/ruslan/growsseth/http/LiveUpdatesConnection\n*L\n196#1:351\n225#1:352\n226#1:353\n227#1:354,2\n226#1:356\n225#1:357\n266#1:359,2\n257#1:358\n*E\n"})
public final class LiveUpdatesConnection
implements ResponseSender {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MinecraftServer server;
    private boolean running;
    @Nullable
    private Socket socket;
    @Nullable
    private Thread thread;
    @NotNull
    private Lock asyncLock;
    @NotNull
    public static final String RELOAD_EVENT = "reload";
    @NotNull
    public static final String DIALOGUE_EVENT = "rdialogue";
    @NotNull
    public static final String TOAST_EVENT = "toast";
    @NotNull
    public static final String COMMAND_EVENT = "cmd";
    private static int retryTimeSeconds = 60;
    @NotNull
    private static final Charset charset = Charsets.UTF_8;
    @NotNull
    private static final Json json = JsonKt.Json$default(null, LiveUpdatesConnection::json$lambda$19, (int)1, null);
    @Nullable
    private static LiveUpdatesConnection activeConnection;

    private LiveUpdatesConnection(MinecraftServer server) {
        this.server = server;
        this.running = true;
        this.asyncLock = new ReentrantLock();
    }

    @NotNull
    public final MinecraftServer getServer() {
        return this.server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void connect() {
        boolean interrupted = false;
        while (this.running && this.socket == null && !interrupted) {
            String host = WebConfig.liveUpdateUrl;
            int port = WebConfig.liveUpdatePort;
            URI uri = port > 0 ? new URI(host + ":" + port) : new URI(host);
            Ref.BooleanRef success = new Ref.BooleanRef();
            Condition connectCondition = this.asyncLock.newCondition();
            try {
                this.logInfo("Attempting connection to " + uri + "...");
                IO.Options options = IO.Options.builder().setExtraHeaders(MapsKt.mapOf((Pair)TuplesKt.to((Object)"apiKey", (Object)CollectionsKt.listOf((Object)WebConfig.dataSyncApiKey)))).build();
                Socket newSocket = IO.socket((URI)uri, (IO.Options)options);
                newSocket.on("connect", arg_0 -> LiveUpdatesConnection.connect$lambda$0(this, uri, success, newSocket, connectCondition, arg_0));
                newSocket.on("connect_error", arg_0 -> LiveUpdatesConnection.connect$lambda$1(this, connectCondition, arg_0));
                newSocket.connect();
                this.asyncLock.lockInterruptibly();
                try {
                    connectCondition.await(retryTimeSeconds, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    this.logError("Interrupted while connecting [A]");
                    interrupted = true;
                }
                finally {
                    this.asyncLock.unlock();
                }
                if (success.element) {
                    this.socket = newSocket;
                } else {
                    newSocket.off();
                }
            }
            catch (InterruptedException e) {
                this.logError("Interrupted while connecting [B]");
                interrupted = true;
            }
            catch (Exception e) {
                this.logError("Failed in connection: " + e.getMessage());
            }
            if (success.element) continue;
            this.socket = null;
            this.logInfo("Retrying in " + retryTimeSeconds + "s...");
            try {
                Thread.sleep((long)retryTimeSeconds * 1000L);
            }
            catch (InterruptedException interruptedException) {
                interrupted = true;
            }
        }
        if (!this.running) {
            RuinsOfGrowsseth.LOGGER.info("Stopped LiveUpdatesConnection while connecting to remote", new Object[0]);
        }
    }

    private final void sendOnSocket(String message) {
        try {
            Object[] objectArray;
            this.logInfo("Sending message on socket: " + message);
            Socket socket = this.socket;
            if (socket == null || (socket = socket.emit("mod_response", objectArray = new Object[]{message})) == null) {
                LiveUpdatesConnection $this$sendOnSocket_u24lambda_u242 = this;
                boolean bl = false;
                RuinsOfGrowsseth.LOGGER.error("Couldn't send message " + message + ": socket null", new Object[0]);
                socket = Unit.INSTANCE;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void sendSuccess(@NotNull Map<String, ? extends Object> extraItems) {
        Intrinsics.checkNotNullParameter(extraItems, (String)"extraItems");
        Ref.ObjectRef msg = new Ref.ObjectRef();
        msg.element = "{\"status\": \"success\"";
        extraItems.forEach((arg_0, arg_1) -> LiveUpdatesConnection.sendSuccess$lambda$4((arg_0, arg_1) -> LiveUpdatesConnection.sendSuccess$lambda$3(msg, arg_0, arg_1), arg_0, arg_1));
        msg.element = msg.element + "}";
        this.sendOnSocket((String)msg.element);
    }

    @Override
    public void sendFailure(@Nullable String reason) {
        Object msg = null;
        msg = "{\"status\": \"failure\"";
        String string = reason;
        if (string != null) {
            String it = string;
            boolean bl = false;
            msg = msg + ", \"reason\": \"" + it + "\"";
        }
        msg = msg + "}";
        this.sendOnSocket((String)msg);
    }

    private final /* synthetic */ <T> void sendOnSocket(T message) {
        boolean $i$f$sendOnSocket = false;
        StringFormat $this$encodeToString$iv = (StringFormat)Companion.getJson();
        boolean $i$f$encodeToString = false;
        SerializersModule serializersModule = $this$encodeToString$iv.getSerializersModule();
        Intrinsics.reifiedOperationMarker((int)6, (String)"T");
        MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.withModule");
        this.sendOnSocket($this$encodeToString$iv.encodeToString((SerializationStrategy)SerializersKt.serializer((SerializersModule)serializersModule, null), message));
    }

    private final void onRefreshMessage() {
        this.logInfo("Refresh command received, updating data sync...");
        GrowssethApi.Companion.getCurrent().reload().thenAccept(arg_0 -> LiveUpdatesConnection.onRefreshMessage$lambda$7(arg_0 -> LiveUpdatesConnection.onRefreshMessage$lambda$6(this, arg_0), arg_0));
    }

    private final void onDialogueMessage(String message) {
        DialogueEntry dialogueEntry;
        this.logInfo("Received dialogue message " + message);
        try {
            dialogueEntry = (DialogueEntry)json.decodeFromString((DeserializationStrategy)DialogueEntry.Companion.serializer(), message);
        }
        catch (Exception e) {
            this.logError("Wrong dialogue format: " + e.getMessage());
            e.printStackTrace();
            this.sendFailure(e.getMessage());
            return;
        }
        DialogueEntry dialogueEntry2 = dialogueEntry;
        double r = 100.0;
        int c = 0;
        Iterable iterable = this.server.getAllLevels();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getAllLevels(...)");
        Iterable $this$forEach$iv = iterable;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ServerLevel level = (ServerLevel)element$iv;
            boolean bl = false;
            List list = level.players();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"players(...)");
            Iterable $this$forEach$iv2 = list;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                ServerPlayer player = (ServerPlayer)element$iv2;
                boolean bl2 = false;
                List list2 = level.getEntitiesOfClass(Researcher.class, AABB.ofSize((Vec3)player.position(), (double)r, (double)r, (double)r));
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getEntitiesOfClass(...)");
                Iterable $this$forEach$iv3 = list2;
                boolean $i$f$forEach3 = false;
                for (Object element$iv3 : $this$forEach$iv3) {
                    Researcher researcher = (Researcher)element$iv3;
                    boolean bl3 = false;
                    Object object = researcher.getDialogues();
                    boolean bl4 = object != null && (object = ((BasicDialoguesComponent)object).nearbyPlayers()) != null ? object.contains(player) : false;
                    if (!bl4) continue;
                    NpcDialoguesComponent npcDialoguesComponent = researcher.getDialogues();
                    Intrinsics.checkNotNull((Object)player);
                    NpcDialoguesComponent.DefaultImpls.triggerDialogueEntry$default(npcDialoguesComponent, player, dialogueEntry2, false, 4, null);
                    ++c;
                }
            }
        }
        this.logInfo("Sent the dialogue successfully to " + c + " players");
        this.sendSuccess(MapsKt.mapOf((Pair)TuplesKt.to((Object)"amount", (Object)c)));
    }

    private final void onCommandMessage(String message) {
        RemoteCommandExec.INSTANCE.handleCommandMessage(message, this.server, this);
    }

    private final void onNotificationMessage(String message) {
        Object this_$iv;
        this.logInfo("Received toast message " + message);
        try {
            this_$iv = json;
            boolean $i$f$decodeFromString = false;
            this_$iv.getSerializersModule();
            this_$iv = (ToastData)this_$iv.decodeFromString((DeserializationStrategy)ToastData.Companion.serializer(), message);
        }
        catch (Exception e) {
            this.logError("Wrong toast format: " + e.getMessage());
            e.printStackTrace();
            this.sendFailure(e.getMessage());
            return;
        }
        Object toastData = this_$iv;
        Component component = ((ToastData)toastData).getTitle();
        Component component2 = ((ToastData)toastData).getMessage();
        Item item = ((ToastData)toastData).getItem();
        if (item == null || (item = item.getDefaultInstance()) == null) {
            item = ItemStack.EMPTY;
        }
        Item e = item;
        Intrinsics.checkNotNull((Object)e);
        CustomToastPacket packet = new CustomToastPacket(component, component2, (ItemStack)e);
        List list = this.server.getPlayerList().getPlayers();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPlayers(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ServerPlayer player = (ServerPlayer)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)player);
            NetworkingUtilsKt.sendPacket((ServerPlayer)player, (CustomPacketPayload)packet, (PacketSendListener)new PacketSendListener(this){
                final /* synthetic */ LiveUpdatesConnection this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onSuccess() {
                    ResponseSender.DefaultImpls.sendSuccess$default(this.this$0, null, 1, null);
                }

                public Packet<?> onFailure() {
                    ResponseSender.DefaultImpls.sendFailure$default(this.this$0, null, 1, null);
                    return null;
                }
            });
        }
    }

    private final void listen() {
        try {
            block14: {
                Socket socket;
                block13: {
                    socket = this.socket;
                    if (socket == null) break block13;
                    Socket socket2 = socket;
                    boolean bl = false;
                    socket2.on(RELOAD_EVENT, arg_0 -> LiveUpdatesConnection.listen$lambda$16$lambda$12(this, arg_0));
                    socket2.on(DIALOGUE_EVENT, arg_0 -> LiveUpdatesConnection.listen$lambda$16$lambda$13(this, arg_0));
                    socket2.on(TOAST_EVENT, arg_0 -> LiveUpdatesConnection.listen$lambda$16$lambda$14(this, arg_0));
                    Emitter emitter = socket2.on(COMMAND_EVENT, arg_0 -> LiveUpdatesConnection.listen$lambda$16$lambda$15(this, arg_0));
                    socket = emitter;
                    if (emitter != null) break block14;
                }
                LiveUpdatesConnection $this$listen_u24lambda_u2417 = this;
                boolean bl = false;
                $this$listen_u24lambda_u2417.logError("Socket is null!");
                socket = Unit.INSTANCE;
            }
            while (this.running) {
                Socket socket = this.socket;
                boolean bl = socket != null ? socket.isActive() : false;
                if (bl && this.running) {
                    Thread.sleep(1000L);
                    continue;
                }
                break;
            }
        }
        catch (InterruptedException e) {
            this.logInfo("Interrupted");
        }
        catch (Exception e) {
            this.logError("Other error in listening: " + ExceptionsKt.stackTraceToString((Throwable)e));
        }
        try {
            Socket socket = this.socket;
            if (socket != null) {
                socket.close();
            }
            this.socket = null;
        }
        catch (Exception e) {
            this.logError("Error when closing connection: " + ExceptionsKt.stackTraceToString((Throwable)e));
        }
    }

    public final void start() {
        this.thread = ThreadsKt.thread$default((boolean)true, (boolean)false, null, (String)"LiveCheckEgobalego", (int)0, () -> LiveUpdatesConnection.start$lambda$18(this), (int)22, null);
    }

    public final void stop() {
        this.logInfo("Stopping thread...");
        Socket socket = this.socket;
        if (socket != null) {
            socket.emit("mod_disconnect", new Object[0]);
        }
        this.running = false;
        try {
            Thread thread = this.thread;
            if (thread != null) {
                thread.interrupt();
            } else {
                RuinsOfGrowsseth.LOGGER.error("Thread is null!", new Object[0]);
            }
        }
        catch (Exception e) {
            RuinsOfGrowsseth.LOGGER.error("Error in interrupting the LiveUpdatesConnection thread: " + ExceptionsKt.stackTraceToString((Throwable)e), new Object[0]);
        }
    }

    private final void logInfo(String message) {
        RuinsOfGrowsseth.LOGGER.info("LiveUpdatesConnection | " + message, new Object[0]);
    }

    private final void logError(String message) {
        RuinsOfGrowsseth.LOGGER.error("LiveUpdatesConnection | " + message, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void connect$fulfillCondition(LiveUpdatesConnection this$0, Condition connectCondition) {
        this$0.asyncLock.lock();
        try {
            connectCondition.signal();
        }
        finally {
            this$0.asyncLock.unlock();
        }
    }

    private static final void connect$lambda$0(LiveUpdatesConnection this$0, URI $uri, Ref.BooleanRef $success, Socket $newSocket, Condition $connectCondition, Object[] it) {
        this$0.logInfo("Connected to " + $uri);
        $success.element = true;
        LiveUpdatesConnection.connect$fulfillCondition(this$0, $connectCondition);
        $newSocket.emit("mod_connect", new Object[0]);
    }

    private static final void connect$lambda$1(LiveUpdatesConnection this$0, Condition $connectCondition, Object[] args) {
        this$0.logError("Connection error: " + args[0]);
        LiveUpdatesConnection.connect$fulfillCondition(this$0, $connectCondition);
    }

    private static final Unit sendSuccess$lambda$3(Ref.ObjectRef $msg, String key, Object value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        $msg.element = $msg.element + ", \"" + key + "\": \"" + value + "\" ";
        return Unit.INSTANCE;
    }

    private static final void sendSuccess$lambda$4(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit onRefreshMessage$lambda$6(LiveUpdatesConnection this$0, Boolean success) {
        if (success.booleanValue()) {
            this$0.logInfo("Data sync update success");
            ResponseSender.DefaultImpls.sendSuccess$default(this$0, null, 1, null);
        } else {
            this$0.logError("Data sync update failure");
            ResponseSender.DefaultImpls.sendFailure$default(this$0, null, 1, null);
        }
        return Unit.INSTANCE;
    }

    private static final void onRefreshMessage$lambda$7(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void listen$lambda$16$lambda$12(LiveUpdatesConnection this$0, Object[] it) {
        this$0.onRefreshMessage();
    }

    private static final void listen$lambda$16$lambda$13(LiveUpdatesConnection this$0, Object[] args) {
        this$0.onDialogueMessage(args[0].toString());
    }

    private static final void listen$lambda$16$lambda$14(LiveUpdatesConnection this$0, Object[] args) {
        this$0.onNotificationMessage(args[0].toString());
    }

    private static final void listen$lambda$16$lambda$15(LiveUpdatesConnection this$0, Object[] args) {
        this$0.onCommandMessage(args[0].toString());
    }

    private static final Unit start$lambda$18(LiveUpdatesConnection this$0) {
        while (this$0.running) {
            this$0.connect();
            this$0.listen();
        }
        this$0.logInfo("Stopped");
        return Unit.INSTANCE;
    }

    private static final Unit json$lambda$19(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setIgnoreUnknownKeys(true);
        $this$Json.setLenient(true);
        return Unit.INSTANCE;
    }

    public /* synthetic */ LiveUpdatesConnection(MinecraftServer server, DefaultConstructorMarker $constructor_marker) {
        this(server);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/ruslan/growsseth/http/LiveUpdatesConnection$Companion;", "", "<init>", "()V", "RELOAD_EVENT", "", "DIALOGUE_EVENT", "TOAST_EVENT", "COMMAND_EVENT", "retryTimeSeconds", "", "getRetryTimeSeconds", "()I", "setRetryTimeSeconds", "(I)V", "charset", "Ljava/nio/charset/Charset;", "getCharset", "()Ljava/nio/charset/Charset;", "json", "Lkotlinx/serialization/json/Json;", "getJson", "()Lkotlinx/serialization/json/Json;", "activeConnection", "Lcom/ruslan/growsseth/http/LiveUpdatesConnection;", "serverStart", "", "server", "Lnet/minecraft/server/MinecraftServer;", "serverStop", "ruins-of-growsseth"})
    public static final class Companion {
        private Companion() {
        }

        public final int getRetryTimeSeconds() {
            return retryTimeSeconds;
        }

        public final void setRetryTimeSeconds(int n) {
            retryTimeSeconds = n;
        }

        @NotNull
        public final Charset getCharset() {
            return charset;
        }

        @NotNull
        public final Json getJson() {
            return json;
        }

        public final void serverStart(@NotNull MinecraftServer server) {
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            if (activeConnection == null && WebConfig.liveUpdateService) {
                LiveUpdatesConnection conn = new LiveUpdatesConnection(server, null);
                conn.start();
                activeConnection = conn;
            } else if (!WebConfig.liveUpdateService) {
                RuinsOfGrowsseth.LOGGER.info("LiveUpdatesConnection was disabled from mod settings, will not start", new Object[0]);
            }
        }

        public final void serverStop(@NotNull MinecraftServer server) {
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            if (WebConfig.liveUpdateService) {
                LiveUpdatesConnection liveUpdatesConnection = activeConnection;
                if (liveUpdatesConnection != null) {
                    liveUpdatesConnection.stop();
                }
                activeConnection = null;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Serializable
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0083\b\u0018\u0000 *2\u00020\u0001:\u0002)*B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB9\b\u0010\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\u0007\u0010\rJ\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0019\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J+\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\nH\u00d6\u0001J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J%\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00002\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0001\u00a2\u0006\u0002\b(R\u001c\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0004\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0012\u0010\u000f\u001a\u0004\b\u0013\u0010\u0011R\u001e\u0010\u0005\u001a\u0004\u0018\u00010\u00068\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0014\u0010\u000f\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006+"}, d2={"Lcom/ruslan/growsseth/http/LiveUpdatesConnection$ToastData;", "", "title", "Lnet/minecraft/network/chat/Component;", "message", "item", "Lnet/minecraft/world/item/Item;", "<init>", "(Lnet/minecraft/network/chat/Component;Lnet/minecraft/network/chat/Component;Lnet/minecraft/world/item/Item;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILnet/minecraft/network/chat/Component;Lnet/minecraft/network/chat/Component;Lnet/minecraft/world/item/Item;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getTitle$annotations", "()V", "getTitle", "()Lnet/minecraft/network/chat/Component;", "getMessage$annotations", "getMessage", "getItem$annotations", "getItem", "()Lnet/minecraft/world/item/Item;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$ruins_of_growsseth", "$serializer", "Companion", "ruins-of-growsseth"})
    private static final class ToastData {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Component title;
        @Nullable
        private final Component message;
        @Nullable
        private final Item item;
        @JvmField
        @NotNull
        private static final KSerializer<Object>[] $childSerializers;

        public ToastData(@NotNull Component title, @Nullable Component message, @Nullable Item item) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            this.title = title;
            this.message = message;
            this.item = item;
        }

        public /* synthetic */ ToastData(Component component, Component component2, Item item, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                component2 = null;
            }
            if ((n & 4) != 0) {
                item = null;
            }
            this(component, component2, item);
        }

        @NotNull
        public final Component getTitle() {
            return this.title;
        }

        @Serializable(with=SimpleComponentSerializer.class)
        public static /* synthetic */ void getTitle$annotations() {
        }

        @Nullable
        public final Component getMessage() {
            return this.message;
        }

        @Serializable(with=SimpleComponentSerializer.class)
        public static /* synthetic */ void getMessage$annotations() {
        }

        @Nullable
        public final Item getItem() {
            return this.item;
        }

        @Serializable(with=ItemByNameSerializer.class)
        public static /* synthetic */ void getItem$annotations() {
        }

        @NotNull
        public final Component component1() {
            return this.title;
        }

        @Nullable
        public final Component component2() {
            return this.message;
        }

        @Nullable
        public final Item component3() {
            return this.item;
        }

        @NotNull
        public final ToastData copy(@NotNull Component title, @Nullable Component message, @Nullable Item item) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            return new ToastData(title, message, item);
        }

        public static /* synthetic */ ToastData copy$default(ToastData toastData, Component component, Component component2, Item item, int n, Object object) {
            if ((n & 1) != 0) {
                component = toastData.title;
            }
            if ((n & 2) != 0) {
                component2 = toastData.message;
            }
            if ((n & 4) != 0) {
                item = toastData.item;
            }
            return toastData.copy(component, component2, item);
        }

        @NotNull
        public String toString() {
            return "ToastData(title=" + this.title + ", message=" + this.message + ", item=" + this.item + ")";
        }

        public int hashCode() {
            int result = this.title.hashCode();
            result = result * 31 + (this.message == null ? 0 : this.message.hashCode());
            result = result * 31 + (this.item == null ? 0 : this.item.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ToastData)) {
                return false;
            }
            ToastData toastData = (ToastData)other;
            if (!Intrinsics.areEqual((Object)this.title, (Object)toastData.title)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.message, (Object)toastData.message)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.item, (Object)toastData.item);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$ruins_of_growsseth(ToastData self, CompositeEncoder output, SerialDescriptor serialDesc) {
            KSerializer<Object>[] kSerializerArray = $childSerializers;
            output.encodeSerializableElement(serialDesc, 0, (SerializationStrategy)kSerializerArray[0], (Object)self.title);
            if (output.shouldEncodeElementDefault(serialDesc, 1) ? true : self.message != null) {
                output.encodeNullableSerializableElement(serialDesc, 1, (SerializationStrategy)kSerializerArray[1], (Object)self.message);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 2) ? true : self.item != null) {
                output.encodeNullableSerializableElement(serialDesc, 2, (SerializationStrategy)kSerializerArray[2], (Object)self.item);
            }
        }

        public /* synthetic */ ToastData(int seen0, Component title, Component message, Item item, SerializationConstructorMarker serializationConstructorMarker) {
            if (1 != (1 & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)1, (SerialDescriptor)ToastData$$serializer.INSTANCE.getDescriptor());
            }
            this.title = title;
            this.message = (seen0 & 2) == 0 ? null : message;
            this.item = (seen0 & 4) == 0 ? null : item;
        }

        public static final /* synthetic */ KSerializer[] access$get$childSerializers$cp() {
            return $childSerializers;
        }

        static {
            KSerializer[] kSerializerArray = new KSerializer[]{new SimpleComponentSerializer(), new SimpleComponentSerializer(), new ItemByNameSerializer()};
            $childSerializers = kSerializerArray;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lcom/ruslan/growsseth/http/LiveUpdatesConnection$ToastData$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/ruslan/growsseth/http/LiveUpdatesConnection$ToastData;", "ruins-of-growsseth"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<ToastData> serializer() {
                return (KSerializer)ToastData$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

