/*
 * Decompiled with CFR 0.152.
 */
package com.ruslan.growsseth.http;

import com.filloax.fxlib.api.EventUtil;
import com.ruslan.growsseth.RuinsOfGrowsseth;
import com.ruslan.growsseth.config.WebConfig;
import com.ruslan.growsseth.http.ApiEvent;
import com.ruslan.growsseth.http.GrowssethApi;
import com.ruslan.growsseth.http.GrowssethExtraEvents;
import com.ruslan.growsseth.http.RemoteCommandExec$RemoteCommandDto$;
import com.ruslan.growsseth.http.ResponseSender;
import com.ruslan.growsseth.utils.UtilsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.StringUtil;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001bB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u001e\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015J$\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001c"}, d2={"Lcom/ruslan/growsseth/http/RemoteCommandExec;", "", "<init>", "()V", "PREFIX", "", "json", "Lkotlinx/serialization/json/Json;", "getJson", "()Lkotlinx/serialization/json/Json;", "handleCommandExec", "", "event", "Lcom/ruslan/growsseth/http/ApiEvent;", "server", "Lnet/minecraft/server/MinecraftServer;", "api", "Lcom/ruslan/growsseth/http/GrowssethApi;", "handleCommandMessage", "message", "responseSender", "Lcom/ruslan/growsseth/http/ResponseSender;", "performCommand", "", "command", "pos", "Lnet/minecraft/world/phys/Vec3;", "RemoteCommandDto", "ruins-of-growsseth"})
@SourceDebugExtension(value={"SMAP\nRemoteCommandExec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteCommandExec.kt\ncom/ruslan/growsseth/http/RemoteCommandExec\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,103:1\n1#2:104\n*E\n"})
public final class RemoteCommandExec {
    @NotNull
    public static final RemoteCommandExec INSTANCE = new RemoteCommandExec();
    @NotNull
    public static final String PREFIX = "cmd";
    @NotNull
    private static final Json json = JsonKt.Json$default(null, RemoteCommandExec::json$lambda$0, (int)1, null);

    private RemoteCommandExec() {
    }

    @NotNull
    public final Json getJson() {
        return json;
    }

    public final void handleCommandExec(@NotNull ApiEvent event, @NotNull MinecraftServer server, @NotNull GrowssethApi api) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)api, (String)"api");
        if (!WebConfig.remoteCommandExecution) {
            RuinsOfGrowsseth.LOGGER.warn("Received command event but disabled in config, ignoring! " + event, new Object[0]);
            return;
        }
        String id = StringsKt.replace$default((String)event.getName(), (String)"cmd/", (String)"", (boolean)false, (int)4, null);
        String string = event.getDesc();
        String cmd = string != null ? ((Object)StringsKt.trim((CharSequence)string)).toString() : null;
        BlockPos pos = event.getPos();
        if (StringUtil.isNullOrEmpty((String)id)) {
            RuinsOfGrowsseth.LOGGER.error("Command exec must have an id after 'cmd/'! " + event, new Object[0]);
            return;
        }
        if (StringUtil.isNullOrEmpty((String)cmd)) {
            RuinsOfGrowsseth.LOGGER.error("Command exec must have a desc with the command! " + event, new Object[0]);
            return;
        }
        EventUtil.INSTANCE.runWhenServerStarted(server, true, arg_0 -> RemoteCommandExec.handleCommandExec$lambda$2(id, cmd, server, pos, arg_0));
    }

    public final void handleCommandMessage(@NotNull String message, @NotNull MinecraftServer server, @NotNull ResponseSender responseSender) {
        RemoteCommandDto remoteCommandDto;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)responseSender, (String)"responseSender");
        RuinsOfGrowsseth.LOGGER.info("LiveUpdatesConnection | Received command message " + message, new Object[0]);
        if (!WebConfig.remoteCommandExecution) {
            RuinsOfGrowsseth.LOGGER.warn("Received command message but disabled in config, ignoring! " + message, new Object[0]);
            responseSender.sendFailure("config_disabled");
            return;
        }
        try {
            remoteCommandDto = (RemoteCommandDto)json.decodeFromString((DeserializationStrategy)RemoteCommandDto.Companion.serializer(), message);
        }
        catch (Exception e) {
            RuinsOfGrowsseth.LOGGER.error("LiveUpdatesConnection | Wrong command format: " + e.getMessage(), new Object[0]);
            e.printStackTrace();
            responseSender.sendFailure(e.getMessage());
            return;
        }
        RemoteCommandDto remoteCommandDto2 = remoteCommandDto;
        boolean success = RemoteCommandExec.performCommand$default(this, remoteCommandDto2.getCommand(), server, null, 4, null);
        RuinsOfGrowsseth.LOGGER.info("LiveUpdatesConnection | Executed command, success: " + success, new Object[0]);
        if (success) {
            ResponseSender.DefaultImpls.sendSuccess$default(responseSender, null, 1, null);
        } else {
            responseSender.sendFailure("command_exception");
        }
    }

    private final boolean performCommand(String command, MinecraftServer server, Vec3 pos) {
        boolean bl;
        try {
            CommandSourceStack it = server.createCommandSourceStack();
            boolean bl2 = false;
            CommandSourceStack commandSourceStack = UtilsKt.notNull(pos) ? it.withPosition(pos) : it;
            server.getCommands().performPrefixedCommand(commandSourceStack, command);
            bl = true;
        }
        catch (Throwable e) {
            e.printStackTrace();
            RuinsOfGrowsseth.LOGGER.error("Failed remote command " + command + ": " + e.getMessage(), new Object[0]);
            bl = false;
        }
        return bl;
    }

    static /* synthetic */ boolean performCommand$default(RemoteCommandExec remoteCommandExec, String string, MinecraftServer minecraftServer, Vec3 vec3, int n, Object object) {
        if ((n & 4) != 0) {
            vec3 = null;
        }
        return remoteCommandExec.performCommand(string, minecraftServer, vec3);
    }

    private static final Unit json$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setIgnoreUnknownKeys(true);
        $this$Json.setLenient(true);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit handleCommandExec$lambda$2(String $id, String $cmd, MinecraftServer $server, BlockPos $pos, MinecraftServer srv) {
        Vec3 vec3;
        Intrinsics.checkNotNullParameter((Object)srv, (String)"srv");
        GrowssethExtraEvents.EventsSavedData savedData = GrowssethExtraEvents.EventsSavedData.Companion.get(srv);
        if (savedData.getAlreadyRan().contains($id)) {
            return Unit.INSTANCE;
        }
        savedData.getAlreadyRan().add($id);
        savedData.setDirty();
        RuinsOfGrowsseth.LOGGER.info("Executing remote command " + $cmd, new Object[0]);
        RemoteCommandExec remoteCommandExec = INSTANCE;
        String string = $cmd;
        String string2 = string;
        Intrinsics.checkNotNull((Object)string);
        MinecraftServer minecraftServer = $server;
        BlockPos blockPos = $pos;
        if (blockPos != null) {
            void it;
            BlockPos blockPos2 = blockPos;
            MinecraftServer minecraftServer2 = minecraftServer;
            String string3 = string2;
            RemoteCommandExec remoteCommandExec2 = remoteCommandExec;
            boolean bl = false;
            Vec3 vec32 = new Vec3((double)it.getX() + 0.5, (double)it.getY() + 0.5, (double)it.getZ() + 0.5);
            remoteCommandExec = remoteCommandExec2;
            string2 = string3;
            minecraftServer = minecraftServer2;
            vec3 = vec32;
        } else {
            vec3 = null;
        }
        remoteCommandExec.performCommand(string2, minecraftServer, vec3);
        RuinsOfGrowsseth.LOGGER.info("Executed remote command " + $cmd, new Object[0]);
        return Unit.INSTANCE;
    }

    @Serializable
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0083\b\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001c\u001dB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B%\b\u0010\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\u0004\u0010\nJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001J%\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0001\u00a2\u0006\u0002\b\u001bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001e"}, d2={"Lcom/ruslan/growsseth/http/RemoteCommandExec$RemoteCommandDto;", "", "command", "", "<init>", "(Ljava/lang/String;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getCommand", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$ruins_of_growsseth", "$serializer", "Companion", "ruins-of-growsseth"})
    private static final class RemoteCommandDto {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String command;

        public RemoteCommandDto(@NotNull String command) {
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            this.command = command;
        }

        @NotNull
        public final String getCommand() {
            return this.command;
        }

        @NotNull
        public final String component1() {
            return this.command;
        }

        @NotNull
        public final RemoteCommandDto copy(@NotNull String command) {
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            return new RemoteCommandDto(command);
        }

        public static /* synthetic */ RemoteCommandDto copy$default(RemoteCommandDto remoteCommandDto, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = remoteCommandDto.command;
            }
            return remoteCommandDto.copy(string);
        }

        @NotNull
        public String toString() {
            return "RemoteCommandDto(command=" + this.command + ")";
        }

        public int hashCode() {
            return this.command.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RemoteCommandDto)) {
                return false;
            }
            RemoteCommandDto remoteCommandDto = (RemoteCommandDto)other;
            return Intrinsics.areEqual((Object)this.command, (Object)remoteCommandDto.command);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$ruins_of_growsseth(RemoteCommandDto self, CompositeEncoder output, SerialDescriptor serialDesc) {
            output.encodeStringElement(serialDesc, 0, self.command);
        }

        public /* synthetic */ RemoteCommandDto(int seen0, String command, SerializationConstructorMarker serializationConstructorMarker) {
            if (1 != (1 & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)1, (SerialDescriptor)RemoteCommandDto$$serializer.INSTANCE.getDescriptor());
            }
            this.command = command;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lcom/ruslan/growsseth/http/RemoteCommandExec$RemoteCommandDto$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/ruslan/growsseth/http/RemoteCommandExec$RemoteCommandDto;", "ruins-of-growsseth"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<RemoteCommandDto> serializer() {
                return (KSerializer)RemoteCommandDto$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

