/*
 * Decompiled with CFR 0.152.
 */
package com.ruslan.growsseth.maps;

import com.filloax.fxlib.api.FxItemUtilsKt;
import com.filloax.fxlib.api.FxLibServices;
import com.filloax.fxlib.api.UtilsKt;
import com.mojang.datafixers.util.Either;
import com.ruslan.growsseth.RuinsOfGrowsseth;
import com.ruslan.growsseth.maps.DestinationType;
import com.ruslan.growsseth.maps.MapLocateContext;
import com.ruslan.growsseth.structure.locate.LocateResult;
import com.ruslan.growsseth.structure.locate.LocateTask;
import com.ruslan.growsseth.structure.locate.StoppableAsyncLocator;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.random.RandomKt;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.MapDecorations;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.saveddata.maps.MapDecorationType;
import net.minecraft.world.level.saveddata.maps.MapDecorationTypes;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000~\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a:\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n\u001a\f\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\u0002\u001aD\u0010\u0012\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\b\u001a\u00020\u00062\b\b\u0002\u0010\u0016\u001a\u00020\u00112\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\b\u0002\u0010\u000b\u001a\u00020\n\u001a\n\u0010\u0019\u001a\u00020\u0001*\u00020\u0002\u001a(\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001f\u001a.\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00132\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010\u001e\u001a\u00020\u001f\u001a.\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00132\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\"0$2\u0006\u0010\u001e\u001a\u00020\u001f\u001a0\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00132\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\"0'2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002\u001a\u0016\u0010*\u001a\u00020\u0001*\u00020\u00022\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002\u001a\f\u0010+\u001a\u00020\u0001*\u00020\u0002H\u0002\u001a$\u0010,\u001a\b\u0012\u0004\u0012\u00020\"0'2\u0006\u0010\u0003\u001a\u00020\u00132\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!H\u0002\"\u001a\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"createAndStoreMapData", "", "Lnet/minecraft/world/item/ItemStack;", "level", "Lnet/minecraft/world/level/Level;", "x", "", "z", "scale", "trackingPosition", "", "unlimitedTracking", "NON_TARGET_DECO_TYPES", "", "Lnet/minecraft/core/Holder;", "Lnet/minecraft/world/level/saveddata/maps/MapDecorationType;", "getMapTargetIcon", "Lcom/ruslan/growsseth/maps/DestinationType;", "updateMapToPos", "Lnet/minecraft/server/level/ServerLevel;", "pos", "Lnet/minecraft/core/BlockPos;", "destinationType", "displayName", "", "invalidateMap", "updateMapToStruct", "Ljava/util/concurrent/CompletableFuture;", "Lcom/ruslan/growsseth/structure/locate/LocateResult;", "destinationName", "context", "Lcom/ruslan/growsseth/maps/MapLocateContext;", "destination", "Lnet/minecraft/resources/ResourceKey;", "Lnet/minecraft/world/level/levelgen/structure/Structure;", "destinationTag", "Lnet/minecraft/tags/TagKey;", "updateMapToStructWithHolder", "destinationHolderSet", "Lnet/minecraft/core/HolderSet;", "loadingNameRandom", "Lkotlin/random/Random;", "setLoadingName", "setMapFailedName", "getHolderSet", "ruins-of-growsseth"})
@SourceDebugExtension(value={"SMAP\nCustomStructureMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CustomStructureMap.kt\ncom/ruslan/growsseth/maps/CustomStructureMapKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,286:1\n295#2,2:287\n1#3:289\n*S KotlinDebug\n*F\n+ 1 CustomStructureMap.kt\ncom/ruslan/growsseth/maps/CustomStructureMapKt\n*L\n70#1:287,2\n*E\n"})
public final class CustomStructureMapKt {
    @NotNull
    private static final Set<Holder<MapDecorationType>> NON_TARGET_DECO_TYPES;
    @NotNull
    private static final Random loadingNameRandom;

    public static final void createAndStoreMapData(@NotNull ItemStack $this$createAndStoreMapData, @NotNull Level level, int x, int z, int scale, boolean trackingPosition, boolean unlimitedTracking) {
        Intrinsics.checkNotNullParameter((Object)$this$createAndStoreMapData, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        ItemStack newMapItem = MapItem.create((Level)level, (int)x, (int)z, (byte)((byte)scale), (boolean)trackingPosition, (boolean)unlimitedTracking);
        $this$createAndStoreMapData.set(DataComponents.MAP_ID, newMapItem.get(DataComponents.MAP_ID));
    }

    @Nullable
    public static final DestinationType getMapTargetIcon(@NotNull ItemStack $this$getMapTargetIcon) {
        DestinationType destinationType;
        Intrinsics.checkNotNullParameter((Object)$this$getMapTargetIcon, (String)"<this>");
        MapDecorations mapDecorations = (MapDecorations)$this$getMapTargetIcon.get(DataComponents.MAP_DECORATIONS);
        if (mapDecorations != null) {
            Object v1;
            block5: {
                MapDecorations decorations = mapDecorations;
                boolean bl = false;
                Iterable $this$firstOrNull$iv = decorations.decorations().values();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    MapDecorations.Entry it = (MapDecorations.Entry)element$iv;
                    boolean bl2 = false;
                    if (!(!NON_TARGET_DECO_TYPES.contains(it.type()))) continue;
                    v1 = element$iv;
                    break block5;
                }
                v1 = null;
            }
            MapDecorations.Entry entry = v1;
            if (entry != null) {
                MapDecorations.Entry it = entry;
                boolean bl = false;
                Holder holder = it.type();
                Intrinsics.checkNotNullExpressionValue((Object)holder, (String)"type(...)");
                destinationType = DestinationType.Companion.withIcon((Holder<MapDecorationType>)holder);
            } else {
                destinationType = null;
            }
        } else {
            destinationType = null;
        }
        return destinationType;
    }

    public static final void updateMapToPos(@NotNull ItemStack $this$updateMapToPos, @NotNull ServerLevel level, @NotNull BlockPos pos, int scale, @NotNull DestinationType destinationType, @Nullable String displayName, boolean unlimitedTracking) {
        Intrinsics.checkNotNullParameter((Object)$this$updateMapToPos, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)destinationType, (String)"destinationType");
        CustomStructureMapKt.createAndStoreMapData($this$updateMapToPos, (Level)level, pos.getX(), pos.getZ(), scale, true, unlimitedTracking);
        MapItem.renderBiomePreviewMap((ServerLevel)level, (ItemStack)$this$updateMapToPos);
        if (destinationType.isSet()) {
            Holder<MapDecorationType> holder = destinationType.getType();
            Intrinsics.checkNotNull(holder);
            MapItemSavedData.addTargetDecoration((ItemStack)$this$updateMapToPos, (BlockPos)pos, (String)"+", holder);
        }
        String string = displayName;
        if (string != null) {
            String it = string;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)it, (Object)"reset")) {
                $this$updateMapToPos.remove(DataComponents.CUSTOM_NAME);
            } else {
                $this$updateMapToPos.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)it));
            }
        }
        FxItemUtilsKt.loreLines((ItemStack)$this$updateMapToPos).clear();
        MapDecorationType mapDecorationType = destinationType.getType();
        RuinsOfGrowsseth.LOGGER.info("Set map target to: " + pos + ", with icon: " + (mapDecorationType != null && (mapDecorationType = (MapDecorationType)mapDecorationType.value()) != null ? mapDecorationType.assetId() : null) + ", name: " + displayName + " (item is " + $this$updateMapToPos + ")", new Object[0]);
    }

    public static /* synthetic */ void updateMapToPos$default(ItemStack itemStack, ServerLevel serverLevel, BlockPos blockPos, int n, DestinationType destinationType, String string, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 1;
        }
        if ((n2 & 8) != 0) {
            Holder holder = MapDecorationTypes.TARGET_X;
            Intrinsics.checkNotNullExpressionValue((Object)holder, (String)"TARGET_X");
            destinationType = DestinationType.Companion.withIcon((Holder<MapDecorationType>)holder);
        }
        if ((n2 & 0x10) != 0) {
            string = null;
        }
        if ((n2 & 0x20) != 0) {
            bl = true;
        }
        CustomStructureMapKt.updateMapToPos(itemStack, serverLevel, blockPos, n, destinationType, string, bl);
    }

    public static final void invalidateMap(@NotNull ItemStack $this$invalidateMap) {
        Intrinsics.checkNotNullParameter((Object)$this$invalidateMap, (String)"<this>");
        CustomStructureMapKt.setMapFailedName($this$invalidateMap);
    }

    @NotNull
    public static final CompletableFuture<LocateResult> updateMapToStruct(@NotNull ItemStack $this$updateMapToStruct, @NotNull ServerLevel level, @NotNull String destinationName, @NotNull MapLocateContext context) {
        Intrinsics.checkNotNullParameter((Object)$this$updateMapToStruct, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)destinationName, (String)"destinationName");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Either structTagKey = UtilsKt.getStructTagOrKey((String)destinationName);
        Object object = structTagKey.map(arg_0 -> CustomStructureMapKt.updateMapToStruct$lambda$5(arg_0 -> CustomStructureMapKt.updateMapToStruct$lambda$4($this$updateMapToStruct, level, context, arg_0), arg_0), arg_0 -> CustomStructureMapKt.updateMapToStruct$lambda$7(arg_0 -> CustomStructureMapKt.updateMapToStruct$lambda$6($this$updateMapToStruct, level, context, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"map(...)");
        return (CompletableFuture)object;
    }

    @NotNull
    public static final CompletableFuture<LocateResult> updateMapToStruct(@NotNull ItemStack $this$updateMapToStruct, @NotNull ServerLevel level, @NotNull ResourceKey<Structure> destination, @NotNull MapLocateContext context) {
        Intrinsics.checkNotNullParameter((Object)$this$updateMapToStruct, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter(destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return CustomStructureMapKt.updateMapToStructWithHolder($this$updateMapToStruct, level, CustomStructureMapKt.getHolderSet(level, destination), context);
    }

    @NotNull
    public static final CompletableFuture<LocateResult> updateMapToStruct(@NotNull ItemStack $this$updateMapToStruct, @NotNull ServerLevel level, @NotNull TagKey<Structure> destinationTag, @NotNull MapLocateContext context) {
        Intrinsics.checkNotNullParameter((Object)$this$updateMapToStruct, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter(destinationTag, (String)"destinationTag");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        HolderSet.Named holderSet = (HolderSet.Named)level.registryAccess().registryOrThrow(Registries.STRUCTURE).getTag(destinationTag).orElseThrow();
        Intrinsics.checkNotNull((Object)holderSet);
        return CustomStructureMapKt.updateMapToStructWithHolder($this$updateMapToStruct, level, (HolderSet<Structure>)((HolderSet)holderSet), context);
    }

    private static final CompletableFuture<LocateResult> updateMapToStructWithHolder(ItemStack $this$updateMapToStructWithHolder, ServerLevel level, HolderSet<Structure> destinationHolderSet, MapLocateContext context) {
        boolean doSkipExploredChunks = context.getSkipExploredChunks();
        CompletableFuture<LocateResult> future = new CompletableFuture<LocateResult>();
        Ref.BooleanRef done = new Ref.BooleanRef();
        CustomStructureMapKt.setLoadingName($this$updateMapToStructWithHolder, context.getDisplayName());
        String destString = destinationHolderSet.toString();
        RuinsOfGrowsseth.LOGGER.info("Starting async structure '" + destString + "' search...", new Object[0]);
        Instant startTime = Instant.now();
        ThreadsKt.thread$default((boolean)true, (boolean)true, null, (String)"locator-timing-thread", (int)0, () -> CustomStructureMapKt.updateMapToStructWithHolder$lambda$8(done, destString, startTime), (int)20, null);
        Function3 signalProgress = FxLibServices.INSTANCE.getPlatform().isDevEnvironment() ? (arg_0, arg_1, arg_2) -> CustomStructureMapKt.updateMapToStructWithHolder$lambda$9(destString, arg_0, arg_1, arg_2) : null;
        LocateTask task = context.getMustContainJigsawIds() == null ? StoppableAsyncLocator.locate$default(StoppableAsyncLocator.INSTANCE, level, destinationHolderSet, context.getSearchFromPos(), context.getSearchRadius(), doSkipExploredChunks, null, null, context.getSearchTimeoutSeconds(), signalProgress, 96, null) : StoppableAsyncLocator.INSTANCE.locateJigsaw(level, destinationHolderSet, context.getMustContainJigsawIds(), context.getSearchFromPos(), context.getSearchRadius(), doSkipExploredChunks, context.getSearchTimeoutSeconds(), (Function3<? super LocateTask, ? super LocateTask.Phase, ? super Float, Unit>)signalProgress);
        task.thenOnServerThread((Function1<? super LocateResult, Unit>)((Function1)arg_0 -> CustomStructureMapKt.updateMapToStructWithHolder$lambda$10(done, context, $this$updateMapToStructWithHolder, level, destString, future, arg_0)));
        return future;
    }

    private static final void setLoadingName(ItemStack $this$setLoadingName, String displayName) {
        List list;
        $this$setLoadingName.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)"item.growsseth.map.loadingName"));
        int loadingId = loadingNameRandom.nextInt(3) + 1;
        List $this$setLoadingName_u24lambda_u2411 = list = FxItemUtilsKt.loreLines((ItemStack)$this$setLoadingName);
        boolean bl = false;
        $this$setLoadingName_u24lambda_u2411.clear();
        MutableComponent mutableComponent = Component.translatable((String)("item.growsseth.map.loading" + loadingId));
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
        $this$setLoadingName_u24lambda_u2411.add(mutableComponent);
        if (displayName != null) {
            MutableComponent mutableComponent2 = Component.translatable((String)displayName).withStyle(ChatFormatting.DARK_GRAY);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent2, (String)"withStyle(...)");
            $this$setLoadingName_u24lambda_u2411.add(mutableComponent2);
        }
    }

    private static final void setMapFailedName(ItemStack $this$setMapFailedName) {
        List list;
        $this$setMapFailedName.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)"item.growsseth.map.loadingFail").withStyle(ChatFormatting.RED));
        List $this$setMapFailedName_u24lambda_u2412 = list = FxItemUtilsKt.loreLines((ItemStack)$this$setMapFailedName);
        boolean bl = false;
        $this$setMapFailedName_u24lambda_u2412.clear();
        MutableComponent mutableComponent = Component.translatable((String)"item.growsseth.map.loadingFailLore").withStyle(ChatFormatting.RED);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"withStyle(...)");
        $this$setMapFailedName_u24lambda_u2412.add(mutableComponent);
        CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)$this$setMapFailedName, CustomStructureMapKt::setMapFailedName$lambda$13);
    }

    private static final HolderSet<Structure> getHolderSet(ServerLevel level, ResourceKey<Structure> destination) {
        Registry registry = level.registryAccess().registryOrThrow(Registries.STRUCTURE);
        Holder[] holderArray = new Holder[]{registry.getHolderOrThrow(destination)};
        HolderSet.Direct direct = HolderSet.direct((Holder[])holderArray);
        Intrinsics.checkNotNullExpressionValue((Object)direct, (String)"direct(...)");
        return (HolderSet)direct;
    }

    private static final CompletableFuture updateMapToStruct$lambda$4(ItemStack $this_updateMapToStruct, ServerLevel $level, MapLocateContext $context, TagKey it) {
        Intrinsics.checkNotNull((Object)it);
        return CustomStructureMapKt.updateMapToStruct($this_updateMapToStruct, $level, (TagKey<Structure>)it, $context);
    }

    private static final CompletableFuture updateMapToStruct$lambda$5(Function1 $tmp0, Object p0) {
        return (CompletableFuture)$tmp0.invoke(p0);
    }

    private static final CompletableFuture updateMapToStruct$lambda$6(ItemStack $this_updateMapToStruct, ServerLevel $level, MapLocateContext $context, ResourceKey it) {
        Intrinsics.checkNotNull((Object)it);
        return CustomStructureMapKt.updateMapToStruct($this_updateMapToStruct, $level, (ResourceKey<Structure>)it, $context);
    }

    private static final CompletableFuture updateMapToStruct$lambda$7(Function1 $tmp0, Object p0) {
        return (CompletableFuture)$tmp0.invoke(p0);
    }

    private static final Unit updateMapToStructWithHolder$lambda$8(Ref.BooleanRef $done, String $destString, Instant $startTime) {
        while (!$done.element) {
            Thread.sleep(10000L);
            if ($done.element) continue;
            Instant time = Instant.now();
            RuinsOfGrowsseth.LOGGER.info("Async structure '" + $destString + "' search still running, took " + Duration.between(time, $startTime).toMillis() / (long)1000 + "s", new Object[0]);
        }
        return Unit.INSTANCE;
    }

    private static final Unit updateMapToStructWithHolder$lambda$9(String $destString, LocateTask task, LocateTask.Phase phase, float pct) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)((Object)phase), (String)"phase");
        String string = "Locate " + $destString + " progress: phase %s | %.2f%% | %.2fs";
        Object[] objectArray = new Object[]{phase, Float.valueOf(pct * (float)100), (double)task.timeElapsedMs() / 1000.0};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        RuinsOfGrowsseth.LOGGER.info(string2, new Object[0]);
        return Unit.INSTANCE;
    }

    private static final Unit updateMapToStructWithHolder$lambda$10(Ref.BooleanRef $done, MapLocateContext $context, ItemStack $this_updateMapToStructWithHolder, ServerLevel $level, String $destString, CompletableFuture $future, LocateResult result) {
        $done.element = true;
        if (result != null) {
            BlockPos pos = result.getPos();
            DestinationType destinationType = $context.getOverrideDestinationType();
            if (destinationType == null) {
                destinationType = DestinationType.Companion.auto(result.getStructure());
            }
            DestinationType finalDestType = destinationType;
            int n = $context.getScale();
            String string = $context.getDisplayName();
            if (string == null) {
                string = "reset";
            }
            CustomStructureMapKt.updateMapToPos$default($this_updateMapToStructWithHolder, $level, pos, n, finalDestType, string, false, 32, null);
            RuinsOfGrowsseth.LOGGER.info("(async) Found '" + $destString + "' at " + pos, new Object[0]);
        } else {
            CustomStructureMapKt.invalidateMap($this_updateMapToStructWithHolder);
            RuinsOfGrowsseth.LOGGER.info("(async) '" + $destString + "' not found!", new Object[0]);
        }
        $future.complete(result);
        return Unit.INSTANCE;
    }

    private static final void setMapFailedName$lambda$13(CompoundTag tag) {
        tag.putBoolean("GrowssethFailedLocate", true);
    }

    static {
        Object[] objectArray = new Holder[]{MapDecorationTypes.PLAYER, MapDecorationTypes.FRAME, MapDecorationTypes.PLAYER_OFF_MAP, MapDecorationTypes.PLAYER_OFF_LIMITS, MapDecorationTypes.WHITE_BANNER, MapDecorationTypes.ORANGE_BANNER, MapDecorationTypes.MAGENTA_BANNER, MapDecorationTypes.LIGHT_BLUE_BANNER, MapDecorationTypes.YELLOW_BANNER, MapDecorationTypes.LIME_BANNER, MapDecorationTypes.PINK_BANNER, MapDecorationTypes.GRAY_BANNER, MapDecorationTypes.LIGHT_GRAY_BANNER, MapDecorationTypes.CYAN_BANNER, MapDecorationTypes.PURPLE_BANNER, MapDecorationTypes.BLUE_BANNER, MapDecorationTypes.BROWN_BANNER, MapDecorationTypes.GREEN_BANNER, MapDecorationTypes.RED_BANNER, MapDecorationTypes.BLACK_BANNER};
        NON_TARGET_DECO_TYPES = SetsKt.setOf((Object[])objectArray);
        loadingNameRandom = RandomKt.Random((long)Instant.now().toEpochMilli());
    }
}

