/*
 * Decompiled with CFR 0.152.
 */
package com.ruslan.growsseth.mixin.client;

import com.google.gson.JsonObject;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.ruslan.growsseth.client.resource.EncryptableSound;
import com.ruslan.growsseth.client.resource.EncryptedMusicResources;
import java.io.InputStream;
import java.util.Map;
import net.minecraft.client.resources.sounds.Sound;
import net.minecraft.client.resources.sounds.SoundEventRegistrationSerializer;
import net.minecraft.client.sounds.SoundBufferLibrary;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.util.GsonHelper;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

public class EncryptedSounds {

    @Mixin(value={SoundBufferLibrary.class})
    public static class SoundBufferLibraryMixin {
        @WrapOperation(method={"method_19745", "lambda$getStream$2", "method_19747", "lambda$getCompleteBuffer$0"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/packs/resources/ResourceProvider;open(Lnet/minecraft/resources/ResourceLocation;)Ljava/io/InputStream;")})
        private InputStream wrapSoundReadingStream(ResourceProvider instance, ResourceLocation resourceLocation, Operation<InputStream> original) {
            return EncryptedMusicResources.checkEncryptedSoundStream(resourceLocation, (InputStream)original.call(new Object[]{instance, resourceLocation}));
        }
    }

    @Mixin(value={Sound.class})
    public static class SoundMixin
    implements EncryptableSound {
        @Unique
        private boolean encrypted = false;
        @Shadow
        @Final
        private ResourceLocation location;

        @Override
        public boolean ruins_of_growsseth$isEncrypted() {
            return this.encrypted;
        }

        @Override
        public void ruins_of_growsseth$setEncrypted(boolean value) {
            this.encrypted = value;
        }

        @ModifyReturnValue(method={"getPath"}, at={@At(value="RETURN")})
        private ResourceLocation onGetPath(ResourceLocation original) {
            if (this.encrypted) {
                return EncryptedMusicResources.LISTER.idToFile(this.location);
            }
            return original;
        }
    }

    @Mixin(value={SoundEventRegistrationSerializer.class})
    public static class SoundEventRegistrationSerializerMixin {
        @ModifyReturnValue(method={"getSound"}, at={@At(value="RETURN")})
        private Sound onGetSound(Sound sound, @Local(argsOnly=true) JsonObject jsonObject) {
            boolean isEncrypted = GsonHelper.getAsBoolean((JsonObject)jsonObject, (String)"encrypted", (boolean)false);
            ((EncryptableSound)sound).ruins_of_growsseth$setEncrypted(isEncrypted);
            return sound;
        }
    }

    @Mixin(value={SoundManager.Preparations.class})
    public static class SoundManager_PreparationsMixin {
        @ModifyExpressionValue(method={"listResources"}, at={@At(value="INVOKE", target="Lnet/minecraft/resources/FileToIdConverter;listMatchingResources(Lnet/minecraft/server/packs/resources/ResourceManager;)Ljava/util/Map;")})
        private Map<ResourceLocation, Resource> listResourcesWithExtras(Map<ResourceLocation, Resource> original, @Local(argsOnly=true) ResourceManager resourceManager) {
            Map additionalResources = EncryptedMusicResources.LISTER.listMatchingResources(resourceManager);
            original.putAll(additionalResources);
            return original;
        }
    }
}

