/*
 * Decompiled with CFR 0.152.
 */
package com.ruslan.growsseth.mixin.client.growssethworld;

import com.llamalad7.mixinextras.sugar.Local;
import com.ruslan.growsseth.client.gui.RawSetEditBox;
import com.ruslan.growsseth.worldgen.worldpreset.GrowssethWorldPreset;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.MultiLineTextWidget;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.client.gui.screens.worldselection.WorldCreationContext;
import net.minecraft.client.gui.screens.worldselection.WorldCreationUiState;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

public class GrowssethSeedMixins {

    @Mixin(value={WorldCreationUiState.class})
    public static class WorldCreationUiStateMixin {
        @Shadow
        private String seed;
        @Shadow
        private WorldCreationContext settings;
        @Shadow
        private WorldCreationUiState.WorldTypeEntry worldType;

        @Inject(method={"setSeed"}, at={@At(value="FIELD", target="Lnet/minecraft/client/gui/screens/worldselection/WorldCreationUiState;seed:Ljava/lang/String;", opcode=181, ordinal=0, shift=At.Shift.AFTER)})
        private void onSetSeed(String seed, CallbackInfo ci) {
            if (GrowssethWorldPreset.isGrowssethPreset((Holder<WorldPreset>)this.worldType.preset())) {
                this.seed = "MelminaVerde";
            }
        }

        @Inject(method={"onChanged"}, at={@At(value="HEAD")})
        private void onOnChanged(CallbackInfo ci) {
            if (GrowssethWorldPreset.isGrowssethPreset((Holder<WorldPreset>)this.worldType.preset())) {
                this.seed = "MelminaVerde";
                this.settings = this.settings.withOptions(worldOptions -> worldOptions.withSeed(WorldOptions.parseSeed((String)this.seed)));
            }
        }
    }

    @Mixin(targets={"net.minecraft.client.gui.screens.worldselection.CreateWorldScreen$WorldTab"})
    public static class WorldTabMixin {
        @Final
        @Shadow(aliases={"field_42182", "this$0"})
        CreateWorldScreen this_CreateWorldScreen;
        @Final
        @Shadow
        private EditBox seedEdit;
        @Unique
        private MultiLineTextWidget growssethPresetWarning;

        public WorldTabMixin() {
            this.growssethPresetWarning = new MultiLineTextWidget((Component)Component.translatable((String)"growsseth.selectWorld.preset_warning"), Minecraft.getInstance().font);
        }

        @Inject(method={"<init>(Lnet/minecraft/client/gui/screens/worldselection/CreateWorldScreen;)V"}, at={@At(value="RETURN")})
        private void onInitialize(CreateWorldScreen createWorldScreen, CallbackInfo ci) {
            this.this_CreateWorldScreen.getUiState().addListener(worldCreationUiState -> {
                WorldCreationUiState.WorldTypeEntry worldType = worldCreationUiState.getWorldType();
                if (GrowssethWorldPreset.isGrowssethPreset((Holder<WorldPreset>)worldType.preset())) {
                    this.seedEdit.setEditable(false);
                    ((RawSetEditBox)this.seedEdit).growsseth_rawSetValue("MelminaVerde");
                } else {
                    this.seedEdit.setEditable(true);
                }
            });
        }

        @Inject(method={"<init>(Lnet/minecraft/client/gui/screens/worldselection/CreateWorldScreen;)V"}, at={@At(value="TAIL")})
        private void addGrowssethPresetWarning(CreateWorldScreen createWorldScreen, CallbackInfo ci, @Local GridLayout.RowHelper rowHelper) {
            this.growssethPresetWarning.setMaxWidth(308);
            rowHelper.addChild((LayoutElement)this.growssethPresetWarning, 2);
            this.this_CreateWorldScreen.getUiState().addListener(worldCreationUiState -> {
                WorldCreationUiState.WorldTypeEntry worldType = worldCreationUiState.getWorldType();
                this.growssethPresetWarning.visible = GrowssethWorldPreset.isGrowssethPreset((Holder<WorldPreset>)worldType.preset());
            });
        }
    }
}

