/*
 * Decompiled with CFR 0.152.
 */
package com.ruslan.growsseth.mixin.debug;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.ruslan.growsseth.RuinsOfGrowsseth;
import com.ruslan.growsseth.config.DebugConfig;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.WritableRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.RegistryDataLoader;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class StructureDebugMixins {

    @Mixin(value={ChunkGeneratorStructureState.class})
    public static class ChunkGeneratorStructureStateMixin {
        @Inject(method={"hasBiomesForStructureSet"}, at={@At(value="HEAD")}, cancellable=true)
        private static void hasBiomesForStructureSet(StructureSet structureSet, BiomeSource biomeSource, CallbackInfoReturnable<Boolean> cir) {
            if (DebugConfig.structuresDebugMode) {
                cir.setReturnValue((Object)true);
            }
        }
    }

    @Mixin(value={FlatLevelSource.class})
    public static abstract class FlatLevelSourceMixin
    extends ChunkGenerator {
        protected FlatLevelSourceMixin(BiomeSource biomeSource) {
            super(biomeSource);
        }

        protected FlatLevelSourceMixin(BiomeSource biomeSource, Function<Holder<Biome>, BiomeGenerationSettings> generationSettingsGetter) {
            super(biomeSource, generationSettingsGetter);
        }

        @Inject(method={"createState(Lnet/minecraft/core/HolderLookup;Lnet/minecraft/world/level/levelgen/RandomState;J)Lnet/minecraft/world/level/chunk/ChunkGeneratorStructureState;"}, at={@At(value="HEAD")}, cancellable=true)
        private void overrideStructuresInDebug(HolderLookup<StructureSet> structureSetLookup, RandomState randomState, long seed, CallbackInfoReturnable<ChunkGeneratorStructureState> cir) {
            if (DebugConfig.structuresDebugMode) {
                RuinsOfGrowsseth.LOGGER.info("(debug mode) Replaced flat worldgen structure selection", new Object[0]);
                cir.setReturnValue((Object)super.createState(structureSetLookup, randomState, seed));
            }
        }
    }

    @Mixin(value={RegistryDataLoader.class})
    public static class RegistryDataLoaderMixin {
        @WrapOperation(method={"loadElementFromResource"}, at={@At(value="INVOKE", target="Lcom/mojang/serialization/Decoder;parse(Lcom/mojang/serialization/DynamicOps;Ljava/lang/Object;)Lcom/mojang/serialization/DataResult;")})
        private static <E> DataResult<E> loadRegistryContents(Decoder<E> instance, DynamicOps<Tag> ops, Object jsonElement, Operation<DataResult<E>> original, @Local(argsOnly=true) WritableRegistry<E> registry) {
            return RegistryDataLoaderMixin.growsseth$registryWrapper(instance, ops, jsonElement, original, registry);
        }

        @WrapOperation(method={"loadContentsFromNetwork"}, at={@At(value="INVOKE", target="Lcom/mojang/serialization/Decoder;parse(Lcom/mojang/serialization/DynamicOps;Ljava/lang/Object;)Lcom/mojang/serialization/DataResult;")})
        private static <E> DataResult<E> loadRegistryContentsFromNetwork(Decoder<E> instance, DynamicOps<Tag> ops, Object jsonElement, Operation<DataResult<E>> original, @Local(argsOnly=true) WritableRegistry<E> registry) {
            return RegistryDataLoaderMixin.growsseth$registryWrapper(instance, ops, jsonElement, original, registry);
        }

        @Unique
        private static <E> DataResult<E> growsseth$registryWrapper(Decoder<E> instance, DynamicOps<Tag> ops, Object jsonElement, Operation<DataResult<E>> original, WritableRegistry<E> registry) {
            DataResult<E> result = (DataResult<E>)original.call(new Object[]{instance, ops, jsonElement});
            ResourceKey key = registry.key();
            if (DebugConfig.structuresDebugMode && key.equals(Registries.STRUCTURE_SET) && jsonElement.toString().contains("growsseth")) {
                result = RegistryDataLoaderMixin.growsseth$alterStructureSetWeight(key, result);
            }
            return result;
        }

        @Unique
        private static <E> DataResult<E> growsseth$alterStructureSetWeight(ResourceKey<?> key, DataResult<?> dataResult) {
            RuinsOfGrowsseth.LOGGER.info("(debug mode) Network | Increasing spawn frequency for {}", key);
            Optional structureSetOpt = RegistryDataLoaderMixin.growsseth$assertCast(dataResult.getOrThrow(), Optional.class);
            StructureSet structureSet = RegistryDataLoaderMixin.growsseth$assertCast(structureSetOpt.orElseThrow(), StructureSet.class);
            StructurePlacement placement = structureSet.placement();
            placement.frequency = 1.0f;
            if (placement instanceof RandomSpreadStructurePlacement) {
                RandomSpreadStructurePlacement randomSpread = (RandomSpreadStructurePlacement)placement;
                randomSpread.spacing /= 4;
                randomSpread.separation /= 4;
            }
            return DataResult.success(Optional.of(structureSet));
        }

        @Unique
        private static <E> E growsseth$assertCast(Object value, Class<E> clazz) {
            if (!value.getClass().isAssignableFrom(clazz)) {
                throw new IllegalArgumentException("Expected " + String.valueOf(value) + " to be an instance of " + clazz.getCanonicalName());
            }
            return (E)value;
        }
    }

    @Mixin(value={ChunkGenerator.class})
    public static class ChunkGeneratorMixin {
        @ModifyVariable(method={"tryGenerateStructure"}, at=@At(value="STORE"))
        private Predicate<Holder<Biome>> onSetBiomePredicate(Predicate<Holder<Biome>> value, @Local(argsOnly=true) StructureSet.StructureSelectionEntry structureSelectionEntry) {
            if (!DebugConfig.structuresDebugMode || !structureSelectionEntry.structure().unwrapKey().map(k -> k.location().getNamespace().equals("growsseth")).orElse(false).booleanValue()) {
                return value;
            }
            return h -> true;
        }
    }
}

