/*
 * Decompiled with CFR 0.152.
 */
package com.ruslan.growsseth.mixin.entity;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.ruslan.growsseth.entity.researcher.Researcher;
import com.ruslan.growsseth.item.AbstractResearcherDaggerItem;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public abstract class PlayerMixin {
    @Unique
    Player player = (Player)this;
    @Unique
    boolean lastAttackerIsResearcher = false;

    @ModifyVariable(method={"attack"}, at=@At(value="STORE"), ordinal=3)
    private boolean noSweepingEdgeForResearcherDagger(boolean bl4) {
        Item itemInHand = this.player.getItemInHand(InteractionHand.MAIN_HAND).getItem();
        if (itemInHand instanceof AbstractResearcherDaggerItem) {
            return false;
        }
        return bl4;
    }

    @Inject(method={"blockUsingShield"}, at={@At(value="HEAD")})
    private void getAttacker(LivingEntity attacker, CallbackInfo ci) {
        this.lastAttackerIsResearcher = attacker instanceof Researcher;
    }

    @ModifyConstant(method={"disableShield"}, constant={@Constant(intValue=100)})
    private int lessShieldCooldownForResearcher(int constant) {
        if (this.lastAttackerIsResearcher) {
            return 30;
        }
        return constant;
    }

    @ModifyReturnValue(method={"entityInteractionRange"}, at={@At(value="RETURN")})
    public double shortRangeForDagger(double original) {
        Item itemInHand = this.player.getItemInHand(InteractionHand.MAIN_HAND).getItem();
        if (itemInHand instanceof AbstractResearcherDaggerItem) {
            return 2.5;
        }
        return original;
    }
}

