/*
 * Decompiled with CFR 0.152.
 */
package com.ruslan.growsseth.mixin.entity.mob;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.ruslan.growsseth.config.ResearcherConfig;
import com.ruslan.growsseth.entity.researcher.Researcher;
import com.ruslan.growsseth.entity.researcher.ZombieResearcher;
import com.ruslan.growsseth.interfaces.StructureManagerExtension;
import com.ruslan.growsseth.utils.MixinHelpers;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.SwellGoal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

public abstract class CreeperMixin {

    @Mixin(value={SwellGoal.class})
    public static abstract class SwellGoalMixin {
        @Shadow
        @Final
        private Creeper creeper;
        @Unique
        private boolean creeperWasInTent;
        @Unique
        private BlockPos lastCreeperPos;
        @Unique
        private boolean researchersNearby;

        @ModifyReturnValue(at={@At(value="TAIL")}, method={"canUse"})
        private boolean preventExplosionInTent(boolean original) {
            if (!original || !ResearcherConfig.noCreeperExplosionsInResearcherTent) {
                return original;
            }
            BlockPos creeperPos = this.creeper.blockPosition();
            boolean coordsChanged = this.creeperCoordsChanged(creeperPos);
            if (this.creeperWasInTent && !coordsChanged && this.researchersNearby) {
                return false;
            }
            if (coordsChanged) {
                boolean creeperInTent;
                ServerLevel serverLevel = (ServerLevel)this.creeper.level();
                StructureManagerExtension structureManager = (StructureManagerExtension)serverLevel.structureManager();
                this.creeperWasInTent = creeperInTent = structureManager.getStructureAtExpanded(creeperPos, MixinHelpers.researcherTent, 3).isValid();
                if (creeperInTent) {
                    this.refreshResearchersNearby();
                    if (this.researchersNearby) {
                        return false;
                    }
                }
            }
            return original;
        }

        @Unique
        private boolean creeperCoordsChanged(BlockPos currentCreeperPos) {
            if (this.lastCreeperPos == null) {
                this.lastCreeperPos = currentCreeperPos;
                return true;
            }
            if (currentCreeperPos.getX() == this.lastCreeperPos.getX() && currentCreeperPos.getY() == this.lastCreeperPos.getY() && currentCreeperPos.getZ() == this.lastCreeperPos.getZ()) {
                return false;
            }
            this.lastCreeperPos = currentCreeperPos;
            return true;
        }

        @Unique
        private void refreshResearchersNearby() {
            Vec3 creeperPos = this.creeper.blockPosition().getBottomCenter();
            double bbSize = 80.0;
            AABB bbCheck = AABB.ofSize((Vec3)creeperPos, (double)bbSize, (double)bbSize, (double)bbSize);
            List researchersList = this.creeper.level().getEntitiesOfClass(Researcher.class, bbCheck);
            List zombieResearchersList = this.creeper.level().getEntitiesOfClass(ZombieResearcher.class, bbCheck);
            this.researchersNearby = !researchersList.isEmpty() || !zombieResearchersList.isEmpty();
        }
    }

    @Mixin(value={Creeper.class})
    public static abstract class CreeperMobMixin
    extends Monster {
        protected CreeperMobMixin(EntityType<? extends Monster> entityType, Level level) {
            super(entityType, level);
        }

        @Inject(at={@At(value="HEAD")}, method={"registerGoals"})
        private void avoidResearchers(CallbackInfo ci) {
            Creeper th1s = (Creeper)this;
            this.goalSelector.addGoal(3, (Goal)new AvoidEntityGoal((PathfinderMob)th1s, Researcher.class, 21.0f, 1.0, 1.2));
        }
    }
}

