/*
 * Decompiled with CFR 0.152.
 */
package com.ruslan.growsseth.network;

import com.filloax.fxlib.api.networking.ToClientContext;
import com.ruslan.growsseth.RuinsOfGrowsseth;
import com.ruslan.growsseth.client.gui.components.CustomToastsKt;
import com.ruslan.growsseth.client.gui.components.NewTradeToast;
import com.ruslan.growsseth.client.worldpreset.GrowssethWorldPresetClient;
import com.ruslan.growsseth.config.ClientConfig;
import com.ruslan.growsseth.dialogues.DialoguesClient;
import com.ruslan.growsseth.network.AmbientSoundsPacket;
import com.ruslan.growsseth.network.CustomToastPacket;
import com.ruslan.growsseth.network.IDialoguePacket;
import com.ruslan.growsseth.network.PlacesInfoPacket;
import com.ruslan.growsseth.network.ResearcherTradesNotifPacket;
import com.ruslan.growsseth.network.StopMusicPacket;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u0014"}, d2={"Lcom/ruslan/growsseth/network/ClientPacketHandlers;", "", "<init>", "()V", "handleDialogue", "", "packet", "Lcom/ruslan/growsseth/network/IDialoguePacket;", "context", "Lcom/filloax/fxlib/api/networking/ToClientContext;", "handleTradeNotification", "Lcom/ruslan/growsseth/network/ResearcherTradesNotifPacket;", "handleCustomToast", "Lcom/ruslan/growsseth/network/CustomToastPacket;", "handleStopMusic", "Lcom/ruslan/growsseth/network/StopMusicPacket;", "handleAmbientSounds", "Lcom/ruslan/growsseth/network/AmbientSoundsPacket;", "handlePlacesInfo", "Lcom/ruslan/growsseth/network/PlacesInfoPacket;", "ruins-of-growsseth"})
public final class ClientPacketHandlers {
    @NotNull
    public static final ClientPacketHandlers INSTANCE = new ClientPacketHandlers();

    private ClientPacketHandlers() {
    }

    public final void handleDialogue(@NotNull IDialoguePacket packet, @NotNull ToClientContext context) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        DialoguesClient.INSTANCE.handleNpcDialogue(context.getPlayer(), packet);
    }

    public final void handleTradeNotification(@NotNull ResearcherTradesNotifPacket packet, @NotNull ToClientContext context) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (ClientConfig.newTradeNotifications) {
            ToastComponent toastComponent = context.getClient().getToasts();
            Intrinsics.checkNotNullExpressionValue((Object)toastComponent, (String)"getToasts(...)");
            NewTradeToast.Companion.updateNewTradeToast(toastComponent, packet.getNewTrades());
            RuinsOfGrowsseth.LOGGER.info("Received trade notification", new Object[0]);
        } else {
            RuinsOfGrowsseth.LOGGER.info("Ignoring trade notification as disabled client-side", new Object[0]);
        }
    }

    public final void handleCustomToast(@NotNull CustomToastPacket packet, @NotNull ToClientContext context) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ToastComponent toastComponent = context.getClient().getToasts();
        Intrinsics.checkNotNullExpressionValue((Object)toastComponent, (String)"getToasts(...)");
        CustomToastsKt.updateCustomToast(toastComponent, packet.getTitle(), packet.getMessage(), packet.getItem());
    }

    public final void handleStopMusic(@NotNull StopMusicPacket packet, @NotNull ToClientContext context) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        context.getClient().submit(() -> ClientPacketHandlers.handleStopMusic$lambda$0(context));
    }

    public final void handleAmbientSounds(@NotNull AmbientSoundsPacket packet, @NotNull ToClientContext context) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        context.getClient().submit(() -> ClientPacketHandlers.handleAmbientSounds$lambda$2(context));
    }

    public final void handlePlacesInfo(@NotNull PlacesInfoPacket packet, @NotNull ToClientContext context) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        context.getClient().submit(() -> ClientPacketHandlers.handlePlacesInfo$lambda$3(packet));
    }

    private static final void handleStopMusic$lambda$0(ToClientContext $context) {
        $context.getClient().getMusicManager().stopPlaying();
    }

    private static final void handleAmbientSounds$lambda$2(ToClientContext $context) {
        block0: {
            LocalPlayer localPlayer = $context.getClient().player;
            if (localPlayer == null) break block0;
            LocalPlayer player = localPlayer;
            boolean bl = false;
            SimpleSoundInstance simpleSoundInstance = SimpleSoundInstance.forAmbientMood((SoundEvent)((SoundEvent)SoundEvents.AMBIENT_CAVE.value()), (RandomSource)player.getRandom(), (double)player.getX(), (double)player.getEyeY(), (double)player.getZ());
            $context.getClient().getSoundManager().play((SoundInstance)simpleSoundInstance);
        }
    }

    private static final void handlePlacesInfo$lambda$3(PlacesInfoPacket $packet) {
        GrowssethWorldPresetClient.INSTANCE.initLocationData($packet.getLocationData());
    }
}

