/*
 * Decompiled with CFR 0.152.
 */
package com.ruslan.growsseth.quests;

import com.ruslan.growsseth.quests.QuestComponent;
import com.ruslan.growsseth.quests.QuestStageTrigger;
import com.ruslan.growsseth.quests.QuestUpdateEvent;
import com.ruslan.growsseth.quests.TriggerTreeNode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001d\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lcom/ruslan/growsseth/quests/TimeTrigger;", "E", "Lnet/minecraft/world/entity/LivingEntity;", "Lcom/ruslan/growsseth/quests/QuestStageTrigger;", "questComponent", "Lcom/ruslan/growsseth/quests/QuestComponent;", "requiredTime", "", "<init>", "(Lcom/ruslan/growsseth/quests/QuestComponent;J)V", "getRequiredTime", "()J", "isActive", "", "entity", "event", "Lcom/ruslan/growsseth/quests/QuestUpdateEvent;", "(Lnet/minecraft/world/entity/LivingEntity;Lcom/ruslan/growsseth/quests/QuestUpdateEvent;)Z", "ruins-of-growsseth"})
public final class TimeTrigger<E extends LivingEntity>
implements QuestStageTrigger<E> {
    @NotNull
    private final QuestComponent<E> questComponent;
    private final long requiredTime;

    public TimeTrigger(@NotNull QuestComponent<E> questComponent, long requiredTime) {
        Intrinsics.checkNotNullParameter(questComponent, (String)"questComponent");
        this.questComponent = questComponent;
        this.requiredTime = requiredTime;
    }

    public final long getRequiredTime() {
        return this.requiredTime;
    }

    @Override
    public boolean isActive(@NotNull E entity, @NotNull QuestUpdateEvent event) {
        Intrinsics.checkNotNullParameter(entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)((Object)event), (String)"event");
        MinecraftServer minecraftServer = ((Entity)entity).getServer();
        Intrinsics.checkNotNull((Object)minecraftServer);
        long time = minecraftServer.overworld().getGameTime();
        return this.questComponent.getData().getCurrentStageTriggerTime() < 0L || time - this.questComponent.getData().getCurrentStageTriggerTime() >= this.requiredTime;
    }

    @Override
    @NotNull
    public QuestStageTrigger<E> and(@NotNull QuestStageTrigger<E> other) {
        return QuestStageTrigger.DefaultImpls.and(this, other);
    }

    @Override
    @NotNull
    public QuestStageTrigger<E> or(@NotNull QuestStageTrigger<E> other) {
        return QuestStageTrigger.DefaultImpls.or(this, other);
    }

    @Override
    @NotNull
    public QuestStageTrigger<E> andMulti(QuestStageTrigger<E> ... with) {
        return QuestStageTrigger.DefaultImpls.andMulti(this, with);
    }

    @Override
    @NotNull
    public QuestStageTrigger<E> orMulti(QuestStageTrigger<E> ... with) {
        return QuestStageTrigger.DefaultImpls.orMulti(this, with);
    }

    @Override
    @NotNull
    public TriggerTreeNode getActiveTree(@NotNull E entity, @NotNull QuestUpdateEvent event) {
        return QuestStageTrigger.DefaultImpls.getActiveTree(this, entity, event);
    }
}

