/*
 * Decompiled with CFR 0.152.
 */
package com.ruslan.growsseth.structure;

import com.filloax.fxlib.api.EventUtil;
import com.filloax.fxlib.api.FxLibServices;
import com.filloax.fxlib.api.structure.FixedStructureGeneration;
import com.ruslan.growsseth.RuinsOfGrowsseth;
import com.ruslan.growsseth.http.ApiStructureSpawn;
import com.ruslan.growsseth.http.GrowssethApi;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0010B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000e\u001a\u00020\u000fR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00058F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/ruslan/growsseth/structure/RemoteStructures;", "", "<init>", "()V", "STRUCTS_TO_SPAWN_BY_ID", "", "", "Lcom/ruslan/growsseth/structure/RemoteStructures$StructureSpawnData;", "getSTRUCTS_TO_SPAWN_BY_ID", "()Ljava/util/Map;", "structsToSpawnById", "", "fixedStructureGeneration", "Lcom/filloax/fxlib/api/structure/FixedStructureGeneration;", "init", "", "StructureSpawnData", "ruins-of-growsseth"})
@SourceDebugExtension(value={"SMAP\nRemoteStructures.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteStructures.kt\ncom/ruslan/growsseth/structure/RemoteStructures\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,54:1\n1863#2,2:55\n*S KotlinDebug\n*F\n+ 1 RemoteStructures.kt\ncom/ruslan/growsseth/structure/RemoteStructures\n*L\n32#1:55,2\n*E\n"})
public final class RemoteStructures {
    @NotNull
    public static final RemoteStructures INSTANCE = new RemoteStructures();
    @NotNull
    private static final Map<String, StructureSpawnData> structsToSpawnById = new LinkedHashMap();
    @NotNull
    private static final FixedStructureGeneration fixedStructureGeneration = FxLibServices.INSTANCE.getFixedStructureGeneration();

    private RemoteStructures() {
    }

    @NotNull
    public final Map<String, StructureSpawnData> getSTRUCTS_TO_SPAWN_BY_ID() {
        return structsToSpawnById;
    }

    public final void init() {
        GrowssethApi.Companion.getCurrent().subscribe((Function2<? super GrowssethApi, ? super MinecraftServer, Unit>)((Function2)RemoteStructures::init$lambda$2));
    }

    private static final Unit init$lambda$2$lambda$1(GrowssethApi $api, MinecraftServer $server, MinecraftServer minecraftServer) {
        Intrinsics.checkNotNullParameter((Object)minecraftServer, (String)"<unused var>");
        List<ApiStructureSpawn> newSpawns = $api.getStructureSpawns();
        structsToSpawnById.clear();
        Iterable $this$forEach$iv = newSpawns;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ApiStructureSpawn it = (ApiStructureSpawn)element$iv;
            boolean bl = false;
            ResourceLocation id = ResourceLocation.parse((String)it.getStructureId());
            if (!it.getActive() || Intrinsics.areEqual((Object)id.getNamespace(), (Object)"event")) continue;
            Structure structureRef = (Structure)$server.registryAccess().registryOrThrow(Registries.STRUCTURE).get(id);
            if (structureRef == null) {
                RuinsOfGrowsseth.LOGGER.error("Cannot queue non-existent structure " + id, new Object[0]);
                continue;
            }
            ServerLevel serverLevel = $server.overworld();
            Intrinsics.checkNotNullExpressionValue((Object)serverLevel, (String)"overworld(...)");
            String string = it.getName();
            BlockPos blockPos = it.getStartPos();
            Intrinsics.checkNotNull((Object)id);
            Rotation rotation = it.getRotation();
            if (rotation == null) {
                rotation = Rotation.NONE;
            }
            FixedStructureGeneration.DefaultImpls.register$default((FixedStructureGeneration)fixedStructureGeneration, (ServerLevel)serverLevel, (String)string, (BlockPos)blockPos, (ResourceLocation)id, (Rotation)rotation, (boolean)false, (int)32, null);
            structsToSpawnById.put(it.getName(), new StructureSpawnData(it.getStartPos(), id, it.getName(), it.getRotation()));
        }
        return Unit.INSTANCE;
    }

    private static final Unit init$lambda$2(GrowssethApi api, MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)api, (String)"api");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        EventUtil.INSTANCE.runWhenServerStarted(server, arg_0 -> RemoteStructures.init$lambda$2$lambda$1(api, server, arg_0));
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\tH\u00c6\u0003J3\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0007H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001f"}, d2={"Lcom/ruslan/growsseth/structure/RemoteStructures$StructureSpawnData;", "", "pos", "Lnet/minecraft/core/BlockPos;", "structure", "Lnet/minecraft/resources/ResourceLocation;", "spawnId", "", "rotation", "Lnet/minecraft/world/level/block/Rotation;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/resources/ResourceLocation;Ljava/lang/String;Lnet/minecraft/world/level/block/Rotation;)V", "getPos", "()Lnet/minecraft/core/BlockPos;", "getStructure", "()Lnet/minecraft/resources/ResourceLocation;", "getSpawnId", "()Ljava/lang/String;", "getRotation", "()Lnet/minecraft/world/level/block/Rotation;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "ruins-of-growsseth"})
    public static final class StructureSpawnData {
        @NotNull
        private final BlockPos pos;
        @NotNull
        private final ResourceLocation structure;
        @NotNull
        private final String spawnId;
        @Nullable
        private final Rotation rotation;

        public StructureSpawnData(@NotNull BlockPos pos, @NotNull ResourceLocation structure, @NotNull String spawnId, @Nullable Rotation rotation) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)structure, (String)"structure");
            Intrinsics.checkNotNullParameter((Object)spawnId, (String)"spawnId");
            this.pos = pos;
            this.structure = structure;
            this.spawnId = spawnId;
            this.rotation = rotation;
        }

        public /* synthetic */ StructureSpawnData(BlockPos blockPos, ResourceLocation resourceLocation, String string, Rotation rotation, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                rotation = null;
            }
            this(blockPos, resourceLocation, string, rotation);
        }

        @NotNull
        public final BlockPos getPos() {
            return this.pos;
        }

        @NotNull
        public final ResourceLocation getStructure() {
            return this.structure;
        }

        @NotNull
        public final String getSpawnId() {
            return this.spawnId;
        }

        @Nullable
        public final Rotation getRotation() {
            return this.rotation;
        }

        @NotNull
        public final BlockPos component1() {
            return this.pos;
        }

        @NotNull
        public final ResourceLocation component2() {
            return this.structure;
        }

        @NotNull
        public final String component3() {
            return this.spawnId;
        }

        @Nullable
        public final Rotation component4() {
            return this.rotation;
        }

        @NotNull
        public final StructureSpawnData copy(@NotNull BlockPos pos, @NotNull ResourceLocation structure, @NotNull String spawnId, @Nullable Rotation rotation) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)structure, (String)"structure");
            Intrinsics.checkNotNullParameter((Object)spawnId, (String)"spawnId");
            return new StructureSpawnData(pos, structure, spawnId, rotation);
        }

        public static /* synthetic */ StructureSpawnData copy$default(StructureSpawnData structureSpawnData, BlockPos blockPos, ResourceLocation resourceLocation, String string, Rotation rotation, int n, Object object) {
            if ((n & 1) != 0) {
                blockPos = structureSpawnData.pos;
            }
            if ((n & 2) != 0) {
                resourceLocation = structureSpawnData.structure;
            }
            if ((n & 4) != 0) {
                string = structureSpawnData.spawnId;
            }
            if ((n & 8) != 0) {
                rotation = structureSpawnData.rotation;
            }
            return structureSpawnData.copy(blockPos, resourceLocation, string, rotation);
        }

        @NotNull
        public String toString() {
            return "StructureSpawnData(pos=" + this.pos + ", structure=" + this.structure + ", spawnId=" + this.spawnId + ", rotation=" + this.rotation + ")";
        }

        public int hashCode() {
            int result = this.pos.hashCode();
            result = result * 31 + this.structure.hashCode();
            result = result * 31 + this.spawnId.hashCode();
            result = result * 31 + (this.rotation == null ? 0 : this.rotation.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof StructureSpawnData)) {
                return false;
            }
            StructureSpawnData structureSpawnData = (StructureSpawnData)other;
            if (!Intrinsics.areEqual((Object)this.pos, (Object)structureSpawnData.pos)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.structure, (Object)structureSpawnData.structure)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.spawnId, (Object)structureSpawnData.spawnId)) {
                return false;
            }
            return this.rotation == structureSpawnData.rotation;
        }
    }
}

