/*
 * Decompiled with CFR 0.152.
 */
package com.ruslan.growsseth.structure;

import com.ruslan.growsseth.RuinsOfGrowsseth;
import com.ruslan.growsseth.structure.GrowssethStructures;
import com.ruslan.growsseth.structure.StructureDisabler;
import com.ruslan.growsseth.worldgen.worldpreset.GrowssethWorldPreset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\f\u001a\u00020\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000eH\u0002J\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00062\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002R&\u0010\u0004\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\n\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/ruslan/growsseth/structure/StructureDisabler;", "", "<init>", "()V", "structToConfigMap", "", "Lnet/minecraft/resources/ResourceKey;", "Lnet/minecraft/world/level/levelgen/structure/Structure;", "Lkotlin/Function0;", "", "structSetToConfigMap", "Lnet/minecraft/world/level/levelgen/structure/StructureSet;", "isConfigDisabled", "structure", "Lnet/minecraft/core/Holder;", "structSet", "id", "Mixins", "ruins-of-growsseth"})
@SourceDebugExtension(value={"SMAP\nStructureDisabler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StructureDisabler.kt\ncom/ruslan/growsseth/structure/StructureDisabler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,67:1\n1#2:68\n*E\n"})
public final class StructureDisabler {
    @NotNull
    public static final StructureDisabler INSTANCE = new StructureDisabler();
    @NotNull
    private static final Map<ResourceKey<Structure>, Function0<Boolean>> structToConfigMap;
    @NotNull
    private static final Map<ResourceKey<StructureSet>, Function0<Boolean>> structSetToConfigMap;

    private StructureDisabler() {
    }

    private final boolean isConfigDisabled(Holder<Structure> structure) {
        boolean bl;
        Optional optional = structure.unwrapKey();
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"unwrapKey(...)");
        ResourceKey resourceKey = (ResourceKey)OptionalsKt.getOrNull((Optional)optional);
        if (resourceKey == null) {
            return false;
        }
        ResourceKey id = resourceKey;
        if (Intrinsics.areEqual((Object)id.location().getNamespace(), (Object)"growsseth") && !structToConfigMap.containsKey(id)) {
            RuinsOfGrowsseth.LOGGER.warn("No enabled config available for structure " + id + "!", new Object[0]);
        }
        Function0<Boolean> function0 = structToConfigMap.get(id);
        if (function0 != null) {
            Function0<Boolean> it = function0;
            boolean bl2 = false;
            bl = !((Boolean)it.invoke()).booleanValue();
        } else {
            bl = false;
        }
        return bl;
    }

    private final ResourceKey<StructureSet> structSet(ResourceKey<Structure> id) {
        ResourceKey<StructureSet> resourceKey = GrowssethStructures.INSTANCE.getStructureSetId(id);
        if (resourceKey == null) {
            throw new IllegalStateException("No structure set for structure " + id);
        }
        return resourceKey;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to(GrowssethStructures.RESEARCHER_TENT, (Object)((Object)structToConfigMap.1.INSTANCE)), TuplesKt.to(GrowssethStructures.RESEARCHER_TENT_SIMPLE, (Object)((Object)structToConfigMap.2.INSTANCE)), TuplesKt.to(GrowssethStructures.CAVE_CAMP, (Object)((Object)structToConfigMap.3.INSTANCE)), TuplesKt.to(GrowssethStructures.MARKER, (Object)((Object)structToConfigMap.4.INSTANCE)), TuplesKt.to(GrowssethStructures.BEEKEEPER_HOUSE, (Object)((Object)structToConfigMap.5.INSTANCE)), TuplesKt.to(GrowssethStructures.CONDUIT_CHURCH, (Object)((Object)structToConfigMap.6.INSTANCE)), TuplesKt.to(GrowssethStructures.CONDUIT_RUINS, (Object)((Object)structToConfigMap.7.INSTANCE)), TuplesKt.to(GrowssethStructures.ENCHANT_TOWER, (Object)((Object)structToConfigMap.8.INSTANCE)), TuplesKt.to(GrowssethStructures.ABANDONED_FORGE, (Object)((Object)structToConfigMap.9.INSTANCE)), TuplesKt.to(GrowssethStructures.NOTEBLOCK_LAB, (Object)((Object)structToConfigMap.10.INSTANCE)), TuplesKt.to(GrowssethStructures.NOTEBLOCK_SHIP, (Object)((Object)structToConfigMap.11.INSTANCE))};
        structToConfigMap = MapsKt.mapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to(INSTANCE.structSet(GrowssethStructures.RESEARCHER_TENT), (Object)((Object)structSetToConfigMap.1.INSTANCE)), TuplesKt.to(INSTANCE.structSet(GrowssethStructures.RESEARCHER_TENT_SIMPLE), (Object)((Object)structSetToConfigMap.2.INSTANCE)), TuplesKt.to(INSTANCE.structSet(GrowssethStructures.CAVE_CAMP), (Object)((Object)structSetToConfigMap.3.INSTANCE)), TuplesKt.to(INSTANCE.structSet(GrowssethStructures.BEEKEEPER_HOUSE), (Object)((Object)structSetToConfigMap.4.INSTANCE)), TuplesKt.to(INSTANCE.structSet(GrowssethStructures.CONDUIT_CHURCH), (Object)((Object)structSetToConfigMap.5.INSTANCE)), TuplesKt.to(INSTANCE.structSet(GrowssethStructures.CONDUIT_RUINS), (Object)((Object)structSetToConfigMap.6.INSTANCE)), TuplesKt.to(INSTANCE.structSet(GrowssethStructures.ENCHANT_TOWER), (Object)((Object)structSetToConfigMap.7.INSTANCE)), TuplesKt.to(INSTANCE.structSet(GrowssethStructures.ABANDONED_FORGE), (Object)((Object)structSetToConfigMap.8.INSTANCE)), TuplesKt.to(INSTANCE.structSet(GrowssethStructures.NOTEBLOCK_LAB), (Object)((Object)structSetToConfigMap.9.INSTANCE)), TuplesKt.to(INSTANCE.structSet(GrowssethStructures.NOTEBLOCK_SHIP), (Object)((Object)structSetToConfigMap.10.INSTANCE))};
        structSetToConfigMap = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0007J0\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u00070\f2\u0012\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u00070\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007\u00a8\u0006\u0011"}, d2={"Lcom/ruslan/growsseth/structure/StructureDisabler$Mixins;", "", "<init>", "()V", "shouldDisableStructure", "", "structure", "Lnet/minecraft/core/Holder;", "Lnet/minecraft/world/level/levelgen/structure/Structure;", "level", "Lnet/minecraft/server/level/ServerLevel;", "filterStructureSets", "", "Lnet/minecraft/world/level/levelgen/structure/StructureSet;", "possibleStructureSets", "biomeSource", "Lnet/minecraft/world/level/biome/BiomeSource;", "ruins-of-growsseth"})
    @SourceDebugExtension(value={"SMAP\nStructureDisabler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StructureDisabler.kt\ncom/ruslan/growsseth/structure/StructureDisabler$Mixins\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,67:1\n774#2:68\n865#2:69\n866#2:71\n1#3:70\n*S KotlinDebug\n*F\n+ 1 StructureDisabler.kt\ncom/ruslan/growsseth/structure/StructureDisabler$Mixins\n*L\n24#1:68\n24#1:69\n24#1:71\n*E\n"})
    public static final class Mixins {
        @NotNull
        public static final Mixins INSTANCE = new Mixins();

        private Mixins() {
        }

        @JvmStatic
        public static final boolean shouldDisableStructure(@NotNull Holder<Structure> structure, @NotNull ServerLevel level) {
            Intrinsics.checkNotNullParameter(structure, (String)"structure");
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            return INSTANCE.isConfigDisabled((Holder<Structure>)structure) || GrowssethWorldPreset.INSTANCE.shouldDisableStructure(structure, level);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public static final List<Holder<StructureSet>> filterStructureSets(@NotNull List<? extends Holder<StructureSet>> possibleStructureSets, @NotNull BiomeSource biomeSource) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter(possibleStructureSets, (String)"possibleStructureSets");
            Intrinsics.checkNotNullParameter((Object)biomeSource, (String)"biomeSource");
            Iterable $this$filter$iv = possibleStructureSets;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                boolean bl;
                Holder set = (Holder)element$iv$iv;
                boolean bl2 = false;
                if (GrowssethWorldPreset.INSTANCE.shouldDisableStructureSet((Holder<StructureSet>)set, biomeSource)) {
                    bl = false;
                } else {
                    Optional optional = set.unwrapKey();
                    Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"unwrapKey(...)");
                    if ((ResourceKey)OptionalsKt.getOrNull((Optional)optional) == null) {
                        bl = true;
                    } else {
                        boolean bl3;
                        ResourceKey key;
                        if ((Function0)structSetToConfigMap.get(key) != null) {
                            Function0 it;
                            boolean bl4 = false;
                            bl3 = !((Boolean)it.invoke()).booleanValue();
                        } else {
                            bl3 = false;
                        }
                        bl = !bl3;
                    }
                }
                if (!bl) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }
    }
}

