/*
 * Decompiled with CFR 0.152.
 */
package com.ruslan.growsseth.structure;

import com.mojang.datafixers.util.Pair;
import com.ruslan.growsseth.RuinsOfGrowsseth;
import com.ruslan.growsseth.compat.LithostitchedCompat;
import com.ruslan.growsseth.config.StructureConfig;
import com.ruslan.growsseth.utils.UtilsKt;
import com.ruslan.growsseth.worldgen.worldpreset.GrowssethWorldPreset;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function5;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KFunction;
import kotlin.text.StringsKt;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.levelgen.structure.pools.LegacySinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001/B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\b\u0002\u0010\u001e\u001a\u00020\u001fJ:\u0010 \u001a\u00020\u001b2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\"2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'2\u0006\u0010)\u001a\u00020\u000eJ4\u0010*\u001a\u00020\t2\u0006\u0010+\u001a\u00020\u00062\n\u0010,\u001a\u00060\u0006j\u0002`\u00072\u0006\u0010-\u001a\u00020\u00062\u0006\u0010.\u001a\u00020\u00062\u0006\u0010)\u001a\u00020\u000eH\u0002R'\u0010\u0004\u001a\u0018\u0012\b\u0012\u00060\u0006j\u0002`\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00060\u0006j\u0002`\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0011\u0010\u0014\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0011R\u0011\u0010\u0016\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0011R\u0011\u0010\u0018\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0011\u00a8\u00060"}, d2={"Lcom/ruslan/growsseth/structure/VillageBuildings;", "", "<init>", "()V", "houseEntries", "", "", "Lcom/ruslan/growsseth/structure/BuildingKey;", "", "Lcom/ruslan/growsseth/structure/VillageBuildings$VillageEntry;", "getHouseEntries", "()Ljava/util/Map;", "CATEGORY_GOLEM_HOUSE", "DEFAULT_GOLEM_WEIGHT", "", "DESERT_GOLEM", "getDESERT_GOLEM", "()Lcom/ruslan/growsseth/structure/VillageBuildings$VillageEntry;", "PLAINS_GOLEM", "getPLAINS_GOLEM", "TAIGA_GOLEM", "getTAIGA_GOLEM", "SAVANNA_GOLEM", "getSAVANNA_GOLEM", "SNOWY_GOLEM", "getSNOWY_GOLEM", "addVillageBuildings", "", "server", "Lnet/minecraft/server/MinecraftServer;", "isLithostitchedLoaded", "", "addBuildingToPool", "templatePoolRegistry", "Lnet/minecraft/core/Registry;", "Lnet/minecraft/world/level/levelgen/structure/pools/StructureTemplatePool;", "processorListRegistry", "Lnet/minecraft/world/level/levelgen/structure/templatesystem/StructureProcessorList;", "poolId", "Lnet/minecraft/resources/ResourceLocation;", "poolPieceId", "weight", "register", "name", "category", "kind", "pool", "VillageEntry", "ruins-of-growsseth"})
@SourceDebugExtension(value={"SMAP\nVillageBuildings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VillageBuildings.kt\ncom/ruslan/growsseth/structure/VillageBuildings\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,106:1\n1863#2,2:107\n1#3:109\n381#4,7:110\n*S KotlinDebug\n*F\n+ 1 VillageBuildings.kt\ncom/ruslan/growsseth/structure/VillageBuildings\n*L\n49#1:107,2\n92#1:110,7\n*E\n"})
public final class VillageBuildings {
    @NotNull
    public static final VillageBuildings INSTANCE = new VillageBuildings();
    @NotNull
    private static final Map<String, List<VillageEntry>> houseEntries = new LinkedHashMap();
    @NotNull
    public static final String CATEGORY_GOLEM_HOUSE = "golem_house";
    public static final int DEFAULT_GOLEM_WEIGHT = 3;
    @NotNull
    private static final VillageEntry DESERT_GOLEM = INSTANCE.register("desert_golem_house", "golem_house", "desert", "houses", 3);
    @NotNull
    private static final VillageEntry PLAINS_GOLEM = INSTANCE.register("plains_golem_house", "golem_house", "plains", "houses", 3);
    @NotNull
    private static final VillageEntry TAIGA_GOLEM = INSTANCE.register("taiga_golem_house", "golem_house", "taiga", "houses", 3);
    @NotNull
    private static final VillageEntry SAVANNA_GOLEM = INSTANCE.register("savanna_golem_house", "golem_house", "savanna", "houses", 3);
    @NotNull
    private static final VillageEntry SNOWY_GOLEM = INSTANCE.register("snowy_golem_house", "golem_house", "snowy", "houses", 3);

    private VillageBuildings() {
    }

    @NotNull
    public final Map<String, List<VillageEntry>> getHouseEntries() {
        return houseEntries;
    }

    @NotNull
    public final VillageEntry getDESERT_GOLEM() {
        return DESERT_GOLEM;
    }

    @NotNull
    public final VillageEntry getPLAINS_GOLEM() {
        return PLAINS_GOLEM;
    }

    @NotNull
    public final VillageEntry getTAIGA_GOLEM() {
        return TAIGA_GOLEM;
    }

    @NotNull
    public final VillageEntry getSAVANNA_GOLEM() {
        return SAVANNA_GOLEM;
    }

    @NotNull
    public final VillageEntry getSNOWY_GOLEM() {
        return SNOWY_GOLEM;
    }

    public final void addVillageBuildings(@NotNull MinecraftServer server, boolean isLithostitchedLoaded) {
        boolean shouldAddBuildings;
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        if (isLithostitchedLoaded) {
            RuinsOfGrowsseth.LOGGER.warn("Lithostitched library is loaded, RoG's village houses will also spawn in the Growsseth preset!", new Object[0]);
        }
        boolean bl = shouldAddBuildings = StructureConfig.golemHouseEnabled && (isLithostitchedLoaded || !GrowssethWorldPreset.isGrowssethPreset(server));
        if (!shouldAddBuildings) {
            return;
        }
        Object t = server.registryAccess().registry(Registries.TEMPLATE_POOL).get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
        Registry templatePools = (Registry)t;
        Object t2 = server.registryAccess().registry(Registries.PROCESSOR_LIST).get();
        Intrinsics.checkNotNullExpressionValue(t2, (String)"get(...)");
        Registry processorLists = (Registry)t2;
        KFunction addBuildingToPoolFunction2 = isLithostitchedLoaded ? (KFunction)new Function5<Registry<StructureTemplatePool>, Registry<StructureProcessorList>, ResourceLocation, ResourceLocation, Integer, Unit>((Object)LithostitchedCompat.INSTANCE){

            public final void invoke(Registry<StructureTemplatePool> p0, Registry<StructureProcessorList> p1, ResourceLocation p2, ResourceLocation p3, int p4) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                Intrinsics.checkNotNullParameter(p1, (String)"p1");
                Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                Intrinsics.checkNotNullParameter((Object)p3, (String)"p3");
                ((LithostitchedCompat)this.receiver).addBuildingToPool(p0, p1, p2, p3, p4);
            }
        } : (KFunction)new Function5<Registry<StructureTemplatePool>, Registry<StructureProcessorList>, ResourceLocation, ResourceLocation, Integer, Unit>((Object)this){

            public final void invoke(Registry<StructureTemplatePool> p0, Registry<StructureProcessorList> p1, ResourceLocation p2, ResourceLocation p3, int p4) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                Intrinsics.checkNotNullParameter(p1, (String)"p1");
                Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                Intrinsics.checkNotNullParameter((Object)p3, (String)"p3");
                ((VillageBuildings)this.receiver).addBuildingToPool(p0, p1, p2, p3, p4);
            }
        };
        List<VillageEntry> list = houseEntries.get(CATEGORY_GOLEM_HOUSE);
        Intrinsics.checkNotNull(list);
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VillageEntry entry = (VillageEntry)element$iv;
            boolean bl2 = false;
            if (RuinsOfGrowsseth.Companion.getModCompat().isImprovedVillagePlacementLoaded()) {
                entry.setWeight(entry.getWeight() * 2);
            }
            ((Function5)addBuildingToPoolFunction2).invoke((Object)templatePools, (Object)processorLists, (Object)entry.getParentPool(), (Object)entry.getNormalTemplate(), (Object)entry.getWeight());
            ((Function5)addBuildingToPoolFunction2).invoke((Object)templatePools, (Object)processorLists, (Object)entry.getParentZombiePool(), (Object)entry.getZombieTemplate(), (Object)entry.getWeight());
        }
    }

    public static /* synthetic */ void addVillageBuildings$default(VillageBuildings villageBuildings, MinecraftServer minecraftServer, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        villageBuildings.addVillageBuildings(minecraftServer, bl);
    }

    /*
     * WARNING - void declaration
     */
    public final void addBuildingToPool(@NotNull Registry<StructureTemplatePool> templatePoolRegistry, @NotNull Registry<StructureProcessorList> processorListRegistry, @NotNull ResourceLocation poolId, @NotNull ResourceLocation poolPieceId, int weight) {
        void it;
        ArrayList arrayList;
        Intrinsics.checkNotNullParameter(templatePoolRegistry, (String)"templatePoolRegistry");
        Intrinsics.checkNotNullParameter(processorListRegistry, (String)"processorListRegistry");
        Intrinsics.checkNotNullParameter((Object)poolId, (String)"poolId");
        Intrinsics.checkNotNullParameter((Object)poolPieceId, (String)"poolPieceId");
        Object object = templatePoolRegistry.getOrThrow(ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)poolId));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getOrThrow(...)");
        StructureTemplatePool pool = (StructureTemplatePool)object;
        LegacySinglePoolElement piece = (LegacySinglePoolElement)SinglePoolElement.legacy((String)poolPieceId.toString()).apply(StructureTemplatePool.Projection.RIGID);
        for (int i = 0; i < weight; ++i) {
            pool.templates.add((Object)piece);
        }
        ArrayList arrayList2 = arrayList = new ArrayList(pool.rawTemplates);
        StructureTemplatePool structureTemplatePool = pool;
        boolean bl = false;
        it.add(new Pair((Object)piece, (Object)weight));
        structureTemplatePool.rawTemplates = arrayList;
    }

    private final VillageEntry register(String name, String category, String kind, String pool, int weight) {
        List list;
        VillageEntry villageEntry;
        String prefix = "village";
        String templateName = prefix + "/" + kind + "/" + name;
        String templateNameZombie = prefix + "/" + kind + "/" + name + "_zombie";
        String poolName = StringsKt.replace$default((String)(prefix + "/" + name), (String)"house", (String)"houses", (boolean)false, (int)4, null);
        String poolNameZombie = StringsKt.replace$default((String)(prefix + "/" + name + "_zombie"), (String)"house", (String)"houses", (boolean)false, (int)4, null);
        ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)(prefix + "/" + kind + "/" + pool));
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"fromNamespaceAndPath(...)");
        ResourceLocation resourceLocation2 = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)(prefix + "/" + kind + "/zombie/" + pool));
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation2, (String)"fromNamespaceAndPath(...)");
        VillageEntry it = villageEntry = new VillageEntry(kind, resourceLocation, resourceLocation2, UtilsKt.resLoc(poolName), UtilsKt.resLoc(poolNameZombie), UtilsKt.resLoc(templateName), UtilsKt.resLoc(templateNameZombie), weight);
        boolean bl = false;
        Map<String, List<VillageEntry>> $this$getOrPut$iv = houseEntries;
        boolean $i$f$getOrPut = false;
        List value$iv = $this$getOrPut$iv.get(category);
        if (value$iv == null) {
            boolean bl2 = false;
            boolean $i$f$register$lambda$2$stub_for_inlining = false;
            List answer$iv = new ArrayList();
            $this$getOrPut$iv.put(category, answer$iv);
            list = answer$iv;
        } else {
            list = value$iv;
        }
        list.add((VillageEntry)it);
        return villageEntry;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0019\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010 \u001a\u00020\u0005H\u00c6\u0003J\t\u0010!\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0005H\u00c6\u0003J\t\u0010#\u001a\u00020\fH\u00c6\u0003JY\u0010$\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\u00052\b\b\u0002\u0010\n\u001a\u00020\u00052\b\b\u0002\u0010\u000b\u001a\u00020\fH\u00c6\u0001J\u0013\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010(\u001a\u00020\fH\u00d6\u0001J\t\u0010)\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0012R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006*"}, d2={"Lcom/ruslan/growsseth/structure/VillageBuildings$VillageEntry;", "", "kind", "", "parentPool", "Lnet/minecraft/resources/ResourceLocation;", "parentZombiePool", "normalPool", "zombiePool", "normalTemplate", "zombieTemplate", "weight", "", "<init>", "(Ljava/lang/String;Lnet/minecraft/resources/ResourceLocation;Lnet/minecraft/resources/ResourceLocation;Lnet/minecraft/resources/ResourceLocation;Lnet/minecraft/resources/ResourceLocation;Lnet/minecraft/resources/ResourceLocation;Lnet/minecraft/resources/ResourceLocation;I)V", "getKind", "()Ljava/lang/String;", "getParentPool", "()Lnet/minecraft/resources/ResourceLocation;", "getParentZombiePool", "getNormalPool", "getZombiePool", "getNormalTemplate", "getZombieTemplate", "getWeight", "()I", "setWeight", "(I)V", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "", "other", "hashCode", "toString", "ruins-of-growsseth"})
    public static final class VillageEntry {
        @NotNull
        private final String kind;
        @NotNull
        private final ResourceLocation parentPool;
        @NotNull
        private final ResourceLocation parentZombiePool;
        @NotNull
        private final ResourceLocation normalPool;
        @NotNull
        private final ResourceLocation zombiePool;
        @NotNull
        private final ResourceLocation normalTemplate;
        @NotNull
        private final ResourceLocation zombieTemplate;
        private int weight;

        public VillageEntry(@NotNull String kind, @NotNull ResourceLocation parentPool, @NotNull ResourceLocation parentZombiePool, @NotNull ResourceLocation normalPool, @NotNull ResourceLocation zombiePool, @NotNull ResourceLocation normalTemplate, @NotNull ResourceLocation zombieTemplate, int weight) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            Intrinsics.checkNotNullParameter((Object)parentPool, (String)"parentPool");
            Intrinsics.checkNotNullParameter((Object)parentZombiePool, (String)"parentZombiePool");
            Intrinsics.checkNotNullParameter((Object)normalPool, (String)"normalPool");
            Intrinsics.checkNotNullParameter((Object)zombiePool, (String)"zombiePool");
            Intrinsics.checkNotNullParameter((Object)normalTemplate, (String)"normalTemplate");
            Intrinsics.checkNotNullParameter((Object)zombieTemplate, (String)"zombieTemplate");
            this.kind = kind;
            this.parentPool = parentPool;
            this.parentZombiePool = parentZombiePool;
            this.normalPool = normalPool;
            this.zombiePool = zombiePool;
            this.normalTemplate = normalTemplate;
            this.zombieTemplate = zombieTemplate;
            this.weight = weight;
        }

        @NotNull
        public final String getKind() {
            return this.kind;
        }

        @NotNull
        public final ResourceLocation getParentPool() {
            return this.parentPool;
        }

        @NotNull
        public final ResourceLocation getParentZombiePool() {
            return this.parentZombiePool;
        }

        @NotNull
        public final ResourceLocation getNormalPool() {
            return this.normalPool;
        }

        @NotNull
        public final ResourceLocation getZombiePool() {
            return this.zombiePool;
        }

        @NotNull
        public final ResourceLocation getNormalTemplate() {
            return this.normalTemplate;
        }

        @NotNull
        public final ResourceLocation getZombieTemplate() {
            return this.zombieTemplate;
        }

        public final int getWeight() {
            return this.weight;
        }

        public final void setWeight(int n) {
            this.weight = n;
        }

        @NotNull
        public final String component1() {
            return this.kind;
        }

        @NotNull
        public final ResourceLocation component2() {
            return this.parentPool;
        }

        @NotNull
        public final ResourceLocation component3() {
            return this.parentZombiePool;
        }

        @NotNull
        public final ResourceLocation component4() {
            return this.normalPool;
        }

        @NotNull
        public final ResourceLocation component5() {
            return this.zombiePool;
        }

        @NotNull
        public final ResourceLocation component6() {
            return this.normalTemplate;
        }

        @NotNull
        public final ResourceLocation component7() {
            return this.zombieTemplate;
        }

        public final int component8() {
            return this.weight;
        }

        @NotNull
        public final VillageEntry copy(@NotNull String kind, @NotNull ResourceLocation parentPool, @NotNull ResourceLocation parentZombiePool, @NotNull ResourceLocation normalPool, @NotNull ResourceLocation zombiePool, @NotNull ResourceLocation normalTemplate, @NotNull ResourceLocation zombieTemplate, int weight) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            Intrinsics.checkNotNullParameter((Object)parentPool, (String)"parentPool");
            Intrinsics.checkNotNullParameter((Object)parentZombiePool, (String)"parentZombiePool");
            Intrinsics.checkNotNullParameter((Object)normalPool, (String)"normalPool");
            Intrinsics.checkNotNullParameter((Object)zombiePool, (String)"zombiePool");
            Intrinsics.checkNotNullParameter((Object)normalTemplate, (String)"normalTemplate");
            Intrinsics.checkNotNullParameter((Object)zombieTemplate, (String)"zombieTemplate");
            return new VillageEntry(kind, parentPool, parentZombiePool, normalPool, zombiePool, normalTemplate, zombieTemplate, weight);
        }

        public static /* synthetic */ VillageEntry copy$default(VillageEntry villageEntry, String string, ResourceLocation resourceLocation, ResourceLocation resourceLocation2, ResourceLocation resourceLocation3, ResourceLocation resourceLocation4, ResourceLocation resourceLocation5, ResourceLocation resourceLocation6, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = villageEntry.kind;
            }
            if ((n2 & 2) != 0) {
                resourceLocation = villageEntry.parentPool;
            }
            if ((n2 & 4) != 0) {
                resourceLocation2 = villageEntry.parentZombiePool;
            }
            if ((n2 & 8) != 0) {
                resourceLocation3 = villageEntry.normalPool;
            }
            if ((n2 & 0x10) != 0) {
                resourceLocation4 = villageEntry.zombiePool;
            }
            if ((n2 & 0x20) != 0) {
                resourceLocation5 = villageEntry.normalTemplate;
            }
            if ((n2 & 0x40) != 0) {
                resourceLocation6 = villageEntry.zombieTemplate;
            }
            if ((n2 & 0x80) != 0) {
                n = villageEntry.weight;
            }
            return villageEntry.copy(string, resourceLocation, resourceLocation2, resourceLocation3, resourceLocation4, resourceLocation5, resourceLocation6, n);
        }

        @NotNull
        public String toString() {
            return "VillageEntry(kind=" + this.kind + ", parentPool=" + this.parentPool + ", parentZombiePool=" + this.parentZombiePool + ", normalPool=" + this.normalPool + ", zombiePool=" + this.zombiePool + ", normalTemplate=" + this.normalTemplate + ", zombieTemplate=" + this.zombieTemplate + ", weight=" + this.weight + ")";
        }

        public int hashCode() {
            int result = this.kind.hashCode();
            result = result * 31 + this.parentPool.hashCode();
            result = result * 31 + this.parentZombiePool.hashCode();
            result = result * 31 + this.normalPool.hashCode();
            result = result * 31 + this.zombiePool.hashCode();
            result = result * 31 + this.normalTemplate.hashCode();
            result = result * 31 + this.zombieTemplate.hashCode();
            result = result * 31 + Integer.hashCode(this.weight);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof VillageEntry)) {
                return false;
            }
            VillageEntry villageEntry = (VillageEntry)other;
            if (!Intrinsics.areEqual((Object)this.kind, (Object)villageEntry.kind)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.parentPool, (Object)villageEntry.parentPool)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.parentZombiePool, (Object)villageEntry.parentZombiePool)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.normalPool, (Object)villageEntry.normalPool)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.zombiePool, (Object)villageEntry.zombiePool)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.normalTemplate, (Object)villageEntry.normalTemplate)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.zombieTemplate, (Object)villageEntry.zombieTemplate)) {
                return false;
            }
            return this.weight == villageEntry.weight;
        }
    }
}

