/*
 * Decompiled with CFR 0.152.
 */
package com.ruslan.growsseth.structure.locate;

import com.filloax.fxlib.api.FxLibServices;
import com.filloax.fxlib.api.structure.FixedStructureGeneration;
import com.filloax.fxlib.api.structure.StructureSpawnData;
import com.filloax.fxlib.api.structure.tracking.CustomPlacedStructureTracker;
import com.filloax.fxlib.api.structure.tracking.PlacedStructureData;
import com.mojang.datafixers.util.Pair;
import com.ruslan.growsseth.RuinsOfGrowsseth;
import com.ruslan.growsseth.structure.locate.LocateResult;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.lang.invoke.LambdaMetafactory;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.chunk.StructureAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureCheckResult;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.placement.ConcentricRingsStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00ee\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001qB\u00b7\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\"\u0010\u000b\u001a\u001e\u0012\u0006\u0012\u0004\u0018\u00010\r\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f\u0018\u00010\fj\u0004\u0018\u0001`\u0010\u0012\"\u0010\u0011\u001a\u001e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u0012\u0018\u00010\fj\u0004\u0018\u0001`\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u000f\u0012&\u0010\u0017\u001a\"\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u0018j\u0004\u0018\u0001`\u001c\u0012\b\b\u0002\u0010\u001d\u001a\u00020\u000f\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0006\u0010B\u001a\u00020\u001bJ\u001c\u0010C\u001a\u00020\u00002\u0014\u0010D\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0012\u0012\u0004\u0012\u00020\u001b0EJ\u001c\u0010F\u001a\u00020\u00002\u0014\u0010D\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0012\u0012\u0004\u0012\u00020\u001b0EJ+\u0010G\u001a\u00020\u001b2#\u0010D\u001a\u001f\u0012\u0013\u0012\u00110H\u00a2\u0006\f\bI\u0012\b\bJ\u0012\u0004\b\b(K\u0012\u0006\u0012\u0004\u0018\u00010\u00120EJ)\u0010L\u001a\u00020\u001b2!\u0010D\u001a\u001d\u0012\u0013\u0012\u00110H\u00a2\u0006\f\bI\u0012\b\bJ\u0012\u0004\b\b(K\u0012\u0004\u0012\u00020\u001b0EJ%\u0010M\u001a\u0004\u0018\u0001HN\"\u0004\b\u0000\u0010N2\u000e\u0010D\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001HN0OH\u0002\u00a2\u0006\u0002\u0010PJ\u0006\u0010Q\u001a\u00020:J\u0012\u0010R\u001a\u00020\u001b2\n\b\u0002\u0010S\u001a\u0004\u0018\u000108J\u0014\u0010T\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00120UH\u0002J\u000e\u0010V\u001a\u00020\u00122\u0006\u0010W\u001a\u00020\u0012J\u0014\u0010X\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00120UH\u0002J^\u0010Y\u001a\u0004\u0018\u00010\u00122\u0012\u0010Z\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\\0[2\u0006\u0010\u0004\u001a\u00020]2\u0006\u0010^\u001a\u00020_2\u0006\u0010`\u001a\u00020\u00152\u0006\u0010a\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010b\u001a\u00020:2\u0006\u0010c\u001a\u00020dH\u0002JD\u0010e\u001a\u0004\u0018\u00010\u00122\u0012\u0010Z\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\\0[2\u0006\u0010\u0004\u001a\u00020]2\u0006\u0010^\u001a\u00020_2\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010f\u001a\u00020g2\u0006\u0010h\u001a\u00020\u000eJ\u001c\u0010i\u001a\b\u0012\u0004\u0012\u00020\n0\\2\f\u0010j\u001a\b\u0012\u0004\u0012\u00020\n0kH\u0002J\u0016\u0010i\u001a\b\u0012\u0004\u0012\u00020\n0\\2\u0006\u0010l\u001a\u00020\nH\u0002J\b\u0010m\u001a\u00020\u000fH\u0002J\b\u0010n\u001a\u00020\u001bH\u0002J\u0012\u0010o\u001a\u00020\u001b2\b\u0010W\u001a\u0004\u0018\u00010\u0012H\u0002J\b\u0010p\u001a\u000208H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R-\u0010\u000b\u001a\u001e\u0012\u0006\u0012\u0004\u0018\u00010\r\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f\u0018\u00010\fj\u0004\u0018\u0001`\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R-\u0010\u0011\u001a\u001e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u0012\u0018\u00010\fj\u0004\u0018\u0001`\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010'R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0011\u0010\u0016\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R.\u0010\u0017\u001a\"\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u0018j\u0004\u0018\u0001`\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u000200X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u00101\u001a\b\u0012\u0004\u0012\u00020\u001202X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u00104\u001a\u00020\u000f2\u0006\u00103\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010,R\u000e\u00106\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00107\u001a\u0004\u0018\u000108X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u00109\u001a\u0004\u0018\u00010:X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010;R\u000e\u0010<\u001a\u00020=X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010>\u001a\u00020?X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010@\u001a\u00020AX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006r"}, d2={"Lcom/ruslan/growsseth/structure/locate/LocateTask;", "", "chunkGenerator", "Lnet/minecraft/world/level/chunk/ChunkGenerator;", "level", "Lnet/minecraft/server/level/ServerLevel;", "fromPos", "Lnet/minecraft/core/BlockPos;", "targetSet", "Lnet/minecraft/core/HolderSet;", "Lnet/minecraft/world/level/levelgen/structure/Structure;", "targetFilter", "Lkotlin/Function2;", "Lnet/minecraft/world/level/levelgen/structure/StructureStart;", "Lnet/minecraft/world/level/ChunkPos;", "", "Lcom/ruslan/growsseth/structure/locate/StructLocatePredicate;", "positionAdjustment", "Lcom/ruslan/growsseth/structure/locate/LocateResult;", "Lcom/ruslan/growsseth/structure/locate/PositionAdjustFunction;", "searchRadius", "", "skipKnownStructures", "signalProgress", "Lkotlin/Function3;", "Lcom/ruslan/growsseth/structure/locate/LocateTask$Phase;", "", "", "Lcom/ruslan/growsseth/structure/locate/SignalProgressFun;", "ignoreSearchRadiusForFixedStructs", "<init>", "(Lnet/minecraft/world/level/chunk/ChunkGenerator;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/HolderSet;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function2;IZLkotlin/jvm/functions/Function3;Z)V", "getLevel", "()Lnet/minecraft/server/level/ServerLevel;", "getFromPos", "()Lnet/minecraft/core/BlockPos;", "getTargetSet", "()Lnet/minecraft/core/HolderSet;", "getTargetFilter", "()Lkotlin/jvm/functions/Function2;", "getPositionAdjustment", "getSearchRadius", "()I", "getSkipKnownStructures", "()Z", "server", "Lnet/minecraft/server/MinecraftServer;", "startTime", "Ljava/time/Instant;", "future", "Ljava/util/concurrent/CompletableFuture;", "value", "done", "getDone", "isCancelled", "cancelReason", "", "finalTimeMs", "", "Ljava/lang/Long;", "fixedStructureGeneration", "Lcom/filloax/fxlib/api/structure/FixedStructureGeneration;", "customPlacedStructureTracker", "Lcom/filloax/fxlib/api/structure/tracking/CustomPlacedStructureTracker;", "cancelLock", "Ljava/util/concurrent/locks/ReentrantLock;", "start", "then", "action", "Lkotlin/Function1;", "thenOnServerThread", "onException", "", "Lkotlin/ParameterName;", "name", "e", "onExceptionOnServerThread", "simpleTryCatch", "T", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "timeElapsedMs", "cancel", "reason", "findNearestMapStructure", "Lcom/mojang/datafixers/util/Pair;", "finalizeResult", "result", "findNearestCustomGeneratedStructure", "getMatchingNearestGeneratedStructureSpread", "structureHoldersSet", "", "Lnet/minecraft/core/Holder;", "Lnet/minecraft/world/level/LevelReader;", "structureManager", "Lnet/minecraft/world/level/StructureManager;", "x", "z", "seed", "spreadPlacement", "Lnet/minecraft/world/level/levelgen/structure/placement/RandomSpreadStructurePlacement;", "getMatchingStructureGeneratingAt", "placement", "Lnet/minecraft/world/level/levelgen/structure/placement/StructurePlacement;", "chunkPos", "holder", "key", "Lnet/minecraft/resources/ResourceKey;", "struct", "shouldStop", "onCancel", "onFinish", "targetString", "Phase", "ruins-of-growsseth"})
@SourceDebugExtension(value={"SMAP\nGrowssethAsyncLocate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrowssethAsyncLocate.kt\ncom/ruslan/growsseth/structure/locate/LocateTask\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,522:1\n1#2:523\n1368#3:524\n1454#3,5:525\n774#3:530\n865#3,2:531\n2341#3,14:533\n774#3:547\n865#3:548\n1755#3,3:549\n1755#3,3:552\n866#3:555\n1557#3:556\n1628#3,3:557\n2341#3,14:560\n*S KotlinDebug\n*F\n+ 1 GrowssethAsyncLocate.kt\ncom/ruslan/growsseth/structure/locate/LocateTask\n*L\n376#1:524\n376#1:525,5\n383#1:530\n383#1:531,2\n386#1:533,14\n392#1:547\n392#1:548\n396#1:549,3\n398#1:552,3\n392#1:555\n401#1:556\n401#1:557,3\n407#1:560,14\n*E\n"})
public final class LocateTask {
    @NotNull
    private final ChunkGenerator chunkGenerator;
    @NotNull
    private final ServerLevel level;
    @NotNull
    private final BlockPos fromPos;
    @NotNull
    private final HolderSet<Structure> targetSet;
    @Nullable
    private final Function2<StructureStart, ChunkPos, Boolean> targetFilter;
    @Nullable
    private final Function2<LocateResult, StructureStart, LocateResult> positionAdjustment;
    private final int searchRadius;
    private final boolean skipKnownStructures;
    @Nullable
    private final Function3<LocateTask, Phase, Float, Unit> signalProgress;
    private final boolean ignoreSearchRadiusForFixedStructs;
    @NotNull
    private final MinecraftServer server;
    private Instant startTime;
    @NotNull
    private final CompletableFuture<LocateResult> future;
    private boolean done;
    private boolean isCancelled;
    @Nullable
    private String cancelReason;
    @Nullable
    private Long finalTimeMs;
    @NotNull
    private final FixedStructureGeneration fixedStructureGeneration;
    @NotNull
    private final CustomPlacedStructureTracker customPlacedStructureTracker;
    @NotNull
    private final ReentrantLock cancelLock;

    public LocateTask(@NotNull ChunkGenerator chunkGenerator, @NotNull ServerLevel level, @NotNull BlockPos fromPos, @NotNull HolderSet<Structure> targetSet, @Nullable Function2<? super StructureStart, ? super ChunkPos, Boolean> targetFilter, @Nullable Function2<? super LocateResult, ? super StructureStart, LocateResult> positionAdjustment, int searchRadius, boolean skipKnownStructures, @Nullable Function3<? super LocateTask, ? super Phase, ? super Float, Unit> signalProgress, boolean ignoreSearchRadiusForFixedStructs) {
        Intrinsics.checkNotNullParameter((Object)chunkGenerator, (String)"chunkGenerator");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)fromPos, (String)"fromPos");
        Intrinsics.checkNotNullParameter(targetSet, (String)"targetSet");
        this.chunkGenerator = chunkGenerator;
        this.level = level;
        this.fromPos = fromPos;
        this.targetSet = targetSet;
        this.targetFilter = targetFilter;
        this.positionAdjustment = positionAdjustment;
        this.searchRadius = searchRadius;
        this.skipKnownStructures = skipKnownStructures;
        this.signalProgress = signalProgress;
        this.ignoreSearchRadiusForFixedStructs = ignoreSearchRadiusForFixedStructs;
        MinecraftServer minecraftServer = this.level.getServer();
        Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
        this.server = minecraftServer;
        this.future = new CompletableFuture();
        this.fixedStructureGeneration = FxLibServices.INSTANCE.getFixedStructureGeneration();
        this.customPlacedStructureTracker = FxLibServices.INSTANCE.customPlacedStructureTracker(this.level);
        this.cancelLock = new ReentrantLock();
    }

    public /* synthetic */ LocateTask(ChunkGenerator chunkGenerator, ServerLevel serverLevel, BlockPos blockPos, HolderSet holderSet, Function2 function2, Function2 function22, int n, boolean bl, Function3 function3, boolean bl2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x200) != 0) {
            bl2 = true;
        }
        this(chunkGenerator, serverLevel, blockPos, (HolderSet<Structure>)holderSet, (Function2<? super StructureStart, ? super ChunkPos, Boolean>)function2, (Function2<? super LocateResult, ? super StructureStart, LocateResult>)function22, n, bl, (Function3<? super LocateTask, ? super Phase, ? super Float, Unit>)function3, bl2);
    }

    @NotNull
    public final ServerLevel getLevel() {
        return this.level;
    }

    @NotNull
    public final BlockPos getFromPos() {
        return this.fromPos;
    }

    @NotNull
    public final HolderSet<Structure> getTargetSet() {
        return this.targetSet;
    }

    @Nullable
    public final Function2<StructureStart, ChunkPos, Boolean> getTargetFilter() {
        return this.targetFilter;
    }

    @Nullable
    public final Function2<LocateResult, StructureStart, LocateResult> getPositionAdjustment() {
        return this.positionAdjustment;
    }

    public final int getSearchRadius() {
        return this.searchRadius;
    }

    public final boolean getSkipKnownStructures() {
        return this.skipKnownStructures;
    }

    public final boolean getDone() {
        return this.done;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        try {
            this.startTime = Instant.now();
            Object[] objectArray = new Object[]{this.targetString(), this.level, this.fromPos, this.searchRadius};
            RuinsOfGrowsseth.LOGGER.info("[chunkGenerator] Trying to locate {} in {} around {} within {} chunks", objectArray);
            Pair<Boolean, LocateResult> result = this.findNearestMapStructure();
            Boolean success = (Boolean)result.getFirst();
            if (success.booleanValue()) {
                this.onFinish((LocateResult)result.getSecond());
            } else {
                this.onCancel();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.future.complete(null);
        }
        finally {
            this.done = true;
        }
    }

    @NotNull
    public final LocateTask then(@NotNull Function1<? super LocateResult, Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        this.future.thenAccept(arg_0 -> LocateTask.then$lambda$0(action, arg_0));
        return this;
    }

    @NotNull
    public final LocateTask thenOnServerThread(@NotNull Function1<? super LocateResult, Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        this.future.thenAccept(arg_0 -> LocateTask.thenOnServerThread$lambda$4(arg_0 -> LocateTask.thenOnServerThread$lambda$3(this, action, arg_0), arg_0));
        return this;
    }

    public final void onException(@NotNull Function1<? super Throwable, LocateResult> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        this.future.exceptionally(arg_0 -> LocateTask.onException$lambda$5(action, arg_0));
    }

    public final void onExceptionOnServerThread(@NotNull Function1<? super Throwable, Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        this.future.exceptionally(arg_0 -> LocateTask.onExceptionOnServerThread$lambda$8(this, action, arg_0));
    }

    private final <T> T simpleTryCatch(Function0<? extends T> action) {
        Object object;
        try {
            object = action.invoke();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return (T)object;
    }

    public final long timeElapsedMs() {
        Temporal temporal = Instant.now();
        Instant instant = this.startTime;
        if (instant == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"startTime");
            instant = null;
        }
        return Duration.between(temporal, instant).toMillis();
    }

    public final void cancel(@Nullable String reason) {
        ReentrantLock reentrantLock;
        String string = reason;
        RuinsOfGrowsseth.LOGGER.warn("Stopping async locate for structure " + this.targetString() + " from pos " + this.fromPos + " after " + (double)this.timeElapsedMs() / 1000.0 + "s, " + (String)(string != null ? "reason: " + string + ", " : "") + "params were searchRadius=" + this.searchRadius + " skipKnownStructures=" + this.skipKnownStructures, new Object[0]);
        ReentrantLock $this$cancel_u24lambda_u249 = reentrantLock = this.cancelLock;
        boolean bl = false;
        this.cancelReason = reason;
        this.isCancelled = true;
    }

    public static /* synthetic */ void cancel$default(LocateTask locateTask, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        locateTask.cancel(string);
    }

    private final Pair<Boolean, LocateResult> findNearestMapStructure() {
        ChunkGeneratorStructureState structureState = this.level.getChunkSource().getGeneratorState();
        Map placementsSets = (Map)new Object2ObjectArrayMap();
        Pair<Boolean, LocateResult> customPlacedStructuresResult = this.findNearestCustomGeneratedStructure();
        if (((Boolean)customPlacedStructuresResult.getFirst()).booleanValue()) {
            RuinsOfGrowsseth.LOGGER.info("Found search structure among custom placed structures!", new Object[0]);
            return customPlacedStructuresResult;
        }
        for (Holder holder : this.targetSet) {
            for (StructurePlacement structurePlacement : structureState.getPlacementsForStructure(holder)) {
                Intrinsics.checkNotNull((Object)holder);
                placementsSets.computeIfAbsent(structurePlacement, arg_0 -> LocateTask.findNearestMapStructure$lambda$11(LocateTask::findNearestMapStructure$lambda$10, arg_0)).add(holder);
            }
        }
        if (placementsSets.isEmpty()) {
            return new Pair((Object)true, null);
        }
        LocateResult output = null;
        double currentDistance = Double.MAX_VALUE;
        StructureManager structureManager = this.level.structureManager();
        List randomSpreadStructures = new ArrayList(placementsSets.size());
        List concentricRingsStructures = new ArrayList(placementsSets.size());
        for (Map.Entry entry : placementsSets.entrySet()) {
            StructurePlacement key = (StructurePlacement)entry.getKey();
            if (key instanceof ConcentricRingsStructurePlacement) {
                concentricRingsStructures.add(entry);
                continue;
            }
            if (!(key instanceof RandomSpreadStructurePlacement)) continue;
            randomSpreadStructures.add(entry);
        }
        if (!((Collection)concentricRingsStructures).isEmpty()) {
            Map.Entry entry;
            if (this.targetFilter != null) {
                RuinsOfGrowsseth.LOGGER.warn("Filter (eg jigsaw) for concentric rings NYI, but only needed for villages (random spread) right now", new Object[0]);
            }
            int structuresSize = concentricRingsStructures.size();
            entry = ((Iterable)concentricRingsStructures).iterator();
            int key = 0;
            while (entry.hasNext()) {
                BlockPos foundPos;
                double dist;
                int i = key++;
                Map.Entry entry2 = (Map.Entry)entry.next();
                if (this.shouldStop()) {
                    return new Pair((Object)false, null);
                }
                Object k = entry2.getKey();
                Intrinsics.checkNotNull(k, (String)"null cannot be cast to non-null type net.minecraft.world.level.levelgen.structure.placement.ConcentricRingsStructurePlacement");
                ConcentricRingsStructurePlacement structurePlacement = (ConcentricRingsStructurePlacement)k;
                Pair ringsResult = this.chunkGenerator.getNearestGeneratedStructure((Set)entry2.getValue(), this.level, structureManager, this.fromPos, this.skipKnownStructures, structurePlacement);
                if (ringsResult != null && (dist = this.fromPos.distSqr((Vec3i)(foundPos = (BlockPos)ringsResult.getFirst()))) < currentDistance) {
                    currentDistance = dist;
                    Object object = ringsResult.getFirst();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getFirst(...)");
                    BlockPos blockPos = (BlockPos)object;
                    Object object2 = ringsResult.getSecond();
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getSecond(...)");
                    output = new LocateResult(blockPos, (Holder)object2, null, 4, null);
                }
                if (this.signalProgress != null) {
                    Function3<LocateTask, Phase, Float, Unit> it;
                    boolean bl = false;
                    it.invoke((Object)this, (Object)Phase.CONCENTRIC_RINGS, (Object)Float.valueOf(((float)i + 1.0f) / (float)structuresSize));
                }
            }
        }
        if (!((Collection)randomSpreadStructures).isEmpty()) {
            int sectionX = SectionPos.blockToSectionCoord((int)this.fromPos.getX());
            int sectionZ = SectionPos.blockToSectionCoord((int)this.fromPos.getZ());
            int searchSize = randomSpreadStructures.size() * (this.searchRadius + 1);
            float i = 0.0f;
            int currentSearchRadius = 0;
            int n = this.searchRadius;
            if (currentSearchRadius <= n) {
                while (true) {
                    boolean found = false;
                    for (Map.Entry entry2 : randomSpreadStructures) {
                        Function3<LocateTask, Phase, Float, Unit> it;
                        if (this.shouldStop()) {
                            return new Pair((Object)false, null);
                        }
                        Object k = entry2.getKey();
                        Intrinsics.checkNotNull(k, (String)"null cannot be cast to non-null type net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement");
                        RandomSpreadStructurePlacement randomSpreadStructurePlacement = (RandomSpreadStructurePlacement)k;
                        Set set = (Set)entry2.getValue();
                        LevelReader levelReader = (LevelReader)this.level;
                        Intrinsics.checkNotNull((Object)structureManager);
                        LocateResult spreadResult = this.getMatchingNearestGeneratedStructureSpread(set, levelReader, structureManager, sectionX, sectionZ, currentSearchRadius, this.skipKnownStructures, structureState.getLevelSeed(), randomSpreadStructurePlacement);
                        if (spreadResult != null) {
                            found = true;
                            double dist = this.fromPos.distSqr((Vec3i)spreadResult.getPos());
                            if (dist < currentDistance) {
                                currentDistance = dist;
                                output = spreadResult;
                            }
                        }
                        float f = i;
                        i = f + 1.0f;
                        if (this.signalProgress == null) continue;
                        boolean bl = false;
                        it.invoke((Object)this, (Object)Phase.RANDOM_SPREAD, (Object)Float.valueOf(i / (float)searchSize));
                    }
                    if (found) {
                        Boolean bl = true;
                        LocateResult locateResult = output;
                        Intrinsics.checkNotNull(locateResult);
                        return new Pair((Object)bl, (Object)this.finalizeResult(locateResult));
                    }
                    if (currentSearchRadius == n) break;
                    ++currentSearchRadius;
                }
            }
        }
        Boolean bl = true;
        LocateResult locateResult = output;
        Intrinsics.checkNotNull(locateResult);
        return new Pair((Object)bl, (Object)this.finalizeResult(locateResult));
    }

    @NotNull
    public final LocateResult finalizeResult(@NotNull LocateResult result) {
        Object object;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                if (result.getStructureStart() == null) {
                    return result;
                }
                object = this.positionAdjustment;
                if (object == null) break block4;
                Function2<LocateResult, StructureStart, LocateResult> it = object;
                boolean bl = false;
                LocateResult locateResult = (LocateResult)it.invoke((Object)result, (Object)result.getStructureStart());
                object = locateResult;
                if (locateResult != null) break block5;
            }
            object = result;
        }
        return object;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final Pair<Boolean, LocateResult> findNearestCustomGeneratedStructure() {
        var2_1 = this.targetSet.unwrap().map((Function<Object, Set>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, findNearestCustomGeneratedStructure$lambda$16(kotlin.jvm.functions.Function1 java.lang.Object ), (Ljava/lang/Object;)Ljava/util/Set;)((Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, findNearestCustomGeneratedStructure$lambda$15(com.ruslan.growsseth.structure.locate.LocateTask net.minecraft.tags.TagKey ), (Lnet/minecraft/tags/TagKey;)Ljava/util/Set;)((LocateTask)this)), (Function<Object, Set>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, findNearestCustomGeneratedStructure$lambda$18(kotlin.jvm.functions.Function1 java.lang.Object ), (Ljava/lang/Object;)Ljava/util/Set;)((Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, findNearestCustomGeneratedStructure$lambda$17(java.util.List ), (Ljava/util/List;)Ljava/util/Set;)()));
        Intrinsics.checkNotNullExpressionValue((Object)var2_1, (String)"map(...)");
        $this$flatMap$iv = (Iterable)var2_1;
        $i$f$flatMap = false;
        var4_4 = $this$flatMap$iv;
        destination$iv$iv /* !! */  = new ArrayList<E>();
        $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            holder = (Holder)element$iv$iv;
            $i$a$-flatMap-LocateTask$findNearestCustomGeneratedStructure$customPlacements$3 = false;
            var11_34 = holder.unwrap().map((Function<Object, List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, findNearestCustomGeneratedStructure$lambda$23$lambda$20(kotlin.jvm.functions.Function1 java.lang.Object ), (Ljava/lang/Object;)Ljava/util/List;)((Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, findNearestCustomGeneratedStructure$lambda$23$lambda$19(com.ruslan.growsseth.structure.locate.LocateTask net.minecraft.resources.ResourceKey ), (Lnet/minecraft/resources/ResourceKey;)Ljava/util/List;)((LocateTask)this)), (Function<Object, List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, findNearestCustomGeneratedStructure$lambda$23$lambda$22(kotlin.jvm.functions.Function1 java.lang.Object ), (Ljava/lang/Object;)Ljava/util/List;)((Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, findNearestCustomGeneratedStructure$lambda$23$lambda$21(com.ruslan.growsseth.structure.locate.LocateTask net.minecraft.world.level.levelgen.structure.Structure ), (Lnet/minecraft/world/level/levelgen/structure/Structure;)Ljava/util/List;)((LocateTask)this)));
            Intrinsics.checkNotNullExpressionValue((Object)var11_34, (String)"map(...)");
            list$iv$iv = (Iterable)var11_34;
            CollectionsKt.addAll((Collection)destination$iv$iv /* !! */ , (Iterable)list$iv$iv);
        }
        customPlacements = (List)destination$iv$iv /* !! */ ;
        $this$filter$iv = customPlacements;
        $i$f$filter = false;
        destination$iv$iv /* !! */  = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (E element$iv$iv : $this$filterTo$iv$iv) {
            customPlacement = (PlacedStructureData)element$iv$iv;
            $i$a$-filter-LocateTask$findNearestCustomGeneratedStructure$matchedCustomPlacement$1 = false;
            if (!this.ignoreSearchRadiusForFixedStructs && customPlacement.getPos().distManhattan((Vec3i)this.fromPos) >= this.searchRadius) ** GOTO lbl-1000
            if (this.targetFilter != null) {
                $i$a$-let-LocateTask$findNearestCustomGeneratedStructure$matchedCustomPlacement$1$1 = false;
                v0 = !((Boolean)it.invoke((Object)customPlacement.getStructureStart(), (Object)new ChunkPos(customPlacement.getPos()))).booleanValue();
            } else {
                v0 = false;
            }
            if (!v0) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
            if (!v1) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$minByOrNull$iv = (List)destination$iv$iv;
        $i$f$minByOrNull = false;
        iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v2 = null;
        } else {
            minElem$iv /* !! */  = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v2 = minElem$iv /* !! */ ;
            } else {
                it = (PlacedStructureData)minElem$iv /* !! */ ;
                $i$a$-minByOrNull-LocateTask$findNearestCustomGeneratedStructure$matchedCustomPlacement$2 = false;
                minValue$iv = it.getPos().distManhattan((Vec3i)this.fromPos);
                do {
                    e$iv = iterator$iv.next();
                    it = (PlacedStructureData)e$iv;
                    $i$a$-minByOrNull-LocateTask$findNearestCustomGeneratedStructure$matchedCustomPlacement$2 = false;
                    v$iv = it.getPos().distManhattan((Vec3i)this.fromPos);
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv /* !! */  = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v2 = minElem$iv /* !! */ ;
            }
        }
        matchedCustomPlacement = v2;
        if (matchedCustomPlacement != null) {
            return new Pair((Object)true, (Object)new LocateResult(matchedCustomPlacement.getPos(), this.holder(matchedCustomPlacement.getStructure()), matchedCustomPlacement.getStructureStart()));
        }
        $this$filter$iv = this.fixedStructureGeneration.getRegisteredStructureSpawns().values();
        $i$f$filter = false;
        minElem$iv /* !! */  = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            block32: {
                block31: {
                    spawnData = (StructureSpawnData)element$iv$iv;
                    $i$a$-filter-LocateTask$findNearestCustomGeneratedStructure$1 = false;
                    $this$any$iv = customPlacements;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        v3 = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            it = (PlacedStructureData)element$iv;
                            $i$a$-any-LocateTask$findNearestCustomGeneratedStructure$1$1 = false;
                            if (!Intrinsics.areEqual((Object)it.getPos(), (Object)spawnData.getPos())) continue;
                            v3 = true;
                            break block31;
                        }
                        v3 = false;
                    }
                }
                if (v3 || !this.ignoreSearchRadiusForFixedStructs && spawnData.getPos().distManhattan((Vec3i)this.fromPos) >= this.searchRadius) ** GOTO lbl-1000
                $this$any$iv = (Iterable)this.targetSet;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v4 = false;
                } else {
                    for (T element$iv : $this$any$iv) {
                        it = (Holder)element$iv;
                        $i$a$-any-LocateTask$findNearestCustomGeneratedStructure$1$2 = false;
                        if (!it.is(spawnData.getStructure())) continue;
                        v4 = true;
                        break block32;
                    }
                    v4 = false;
                }
            }
            if (!v4) ** GOTO lbl-1000
            if (this.targetFilter != null) {
                $i$a$-let-LocateTask$findNearestCustomGeneratedStructure$1$3 = false;
                v5 = !((Boolean)it.invoke(null, (Object)new ChunkPos(spawnData.getPos()))).booleanValue();
            } else {
                v5 = false;
            }
            if (!v5) {
                v6 = true;
            } else lbl-1000:
            // 3 sources

            {
                v6 = false;
            }
            if (!v6) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            block33: {
                spawnData = (StructureSpawnData)item$iv$iv;
                var25_60 = destination$iv$iv;
                $i$a$-map-LocateTask$findNearestCustomGeneratedStructure$2 = false;
                var13_45 = (Iterable)this.targetSet;
                var14_48 = spawnData.getPos();
                var17_52 = true;
                var19_54 = var13_45;
                for (T var21_56 : var19_54) {
                    it = (Holder)var21_56;
                    $i$a$-find-LocateTask$findNearestCustomGeneratedStructure$2$1 = false;
                    if (!it.is(spawnData.getStructure())) continue;
                    v7 = var21_56;
                    break block33;
                }
                v7 = null;
            }
            v8 = var24_59 = v7;
            Intrinsics.checkNotNull(v8);
            var26_61 = null;
            var27_62 = v8;
            var28_63 = var14_48;
            var29_64 = new LocateResult(var28_63, (Holder<Structure>)var27_62, var26_61);
            var30_65 = var17_52;
            var25_60.add(new Pair((Object)var30_65, (Object)var29_64));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$minByOrNull = false;
        iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v9 = null;
        } else {
            minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v9 = minElem$iv;
            } else {
                it = (Pair)minElem$iv;
                $i$a$-minByOrNull-LocateTask$findNearestCustomGeneratedStructure$3 = false;
                minValue$iv = ((LocateResult)it.getSecond()).getPos().distManhattan((Vec3i)this.fromPos);
                do {
                    e$iv = iterator$iv.next();
                    it = (Pair)e$iv;
                    $i$a$-minByOrNull-LocateTask$findNearestCustomGeneratedStructure$3 = false;
                    v$iv = ((LocateResult)it.getSecond()).getPos().distManhattan((Vec3i)this.fromPos);
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v9 = minElem$iv;
            }
        }
        if ((v10 = (Pair)v9) == null) {
            v10 = new Pair((Object)false, null);
        }
        return v10;
    }

    private final LocateResult getMatchingNearestGeneratedStructureSpread(Set<? extends Holder<Structure>> structureHoldersSet, LevelReader level, StructureManager structureManager, int x, int z, int searchRadius, boolean skipKnownStructures, long seed, RandomSpreadStructurePlacement spreadPlacement) {
        int i = spreadPlacement.spacing();
        int j = -searchRadius;
        if (j <= searchRadius) {
            while (true) {
                boolean bl = j == -searchRadius || j == searchRadius;
                int k = -searchRadius;
                if (k <= searchRadius) {
                    while (true) {
                        boolean bl2;
                        boolean bl3 = bl2 = k == -searchRadius || k == searchRadius;
                        if (bl || bl2) {
                            int l = x + i * j;
                            int m = z + i * k;
                            ChunkPos chunkPos = spreadPlacement.getPotentialStructureChunk(seed, l, m);
                            StructurePlacement structurePlacement = (StructurePlacement)spreadPlacement;
                            Intrinsics.checkNotNull((Object)chunkPos);
                            LocateResult result = this.getMatchingStructureGeneratingAt(structureHoldersSet, level, structureManager, skipKnownStructures, structurePlacement, chunkPos);
                            if (result != null) {
                                return result;
                            }
                        }
                        if (k == searchRadius) break;
                        ++k;
                    }
                }
                if (j == searchRadius) break;
                ++j;
            }
        }
        return null;
    }

    @Nullable
    public final LocateResult getMatchingStructureGeneratingAt(@NotNull Set<? extends Holder<Structure>> structureHoldersSet, @NotNull LevelReader level, @NotNull StructureManager structureManager, boolean skipKnownStructures, @NotNull StructurePlacement placement, @NotNull ChunkPos chunkPos) {
        Intrinsics.checkNotNullParameter(structureHoldersSet, (String)"structureHoldersSet");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)structureManager, (String)"structureManager");
        Intrinsics.checkNotNullParameter((Object)placement, (String)"placement");
        Intrinsics.checkNotNullParameter((Object)chunkPos, (String)"chunkPos");
        for (Holder<Structure> holder : structureHoldersSet) {
            boolean bl;
            ChunkAccess chunkAccess;
            StructureStart structureStart;
            StructureCheckResult structureCheckResult = structureManager.checkStructurePresence(chunkPos, (Structure)holder.value(), placement, skipKnownStructures);
            if (structureCheckResult == StructureCheckResult.START_NOT_PRESENT || (structureStart = structureManager.getStartForStructure(SectionPos.bottomOf((ChunkAccess)(chunkAccess = level.getChunk(chunkPos.x, chunkPos.z, ChunkStatus.STRUCTURE_STARTS))), (Structure)holder.value(), (StructureAccess)chunkAccess)) == null || !structureStart.isValid()) continue;
            if (this.targetFilter != null) {
                Function2<StructureStart, ChunkPos, Boolean> it;
                boolean bl2 = false;
                bl = !((Boolean)it.invoke((Object)structureStart, (Object)chunkPos)).booleanValue();
            } else {
                bl = false;
            }
            if (bl || skipKnownStructures && !ChunkGenerator.tryAddReference((StructureManager)structureManager, (StructureStart)structureStart)) continue;
            BlockPos blockPos = placement.getLocatePos(structureStart.getChunkPos());
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getLocatePos(...)");
            return new LocateResult(blockPos, holder, structureStart);
        }
        return null;
    }

    private final Holder<Structure> holder(ResourceKey<Structure> key) {
        Object v0;
        block1: {
            Iterable iterable = (Iterable)this.targetSet;
            for (Object t : iterable) {
                Holder it = (Holder)t;
                boolean bl = false;
                if (!it.is(key)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        Intrinsics.checkNotNull(v0);
        return v0;
    }

    private final Holder<Structure> holder(Structure struct) {
        Object v0;
        block1: {
            Iterable iterable = (Iterable)this.targetSet;
            for (Object t : iterable) {
                Holder holder = (Holder)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)holder.value(), (Object)struct)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        Intrinsics.checkNotNull(v0);
        return v0;
    }

    private final boolean shouldStop() {
        ReentrantLock it = this.cancelLock;
        boolean bl = false;
        return this.isCancelled;
    }

    private final void onCancel() {
        ReentrantLock it = this.cancelLock;
        boolean bl = false;
        String reason = this.cancelReason;
        String string = reason;
        RuinsOfGrowsseth.LOGGER.error("Stopped async locate early from " + this.fromPos + " to " + this.targetString() + " " + (String)(string != null ? "reason: " + string + ", " : "") + "params were searchRadius=" + this.searchRadius + " skipKnownStructures=" + this.skipKnownStructures, new Object[0]);
        this.future.complete(null);
    }

    private final void onFinish(LocateResult result) {
        long time = this.timeElapsedMs();
        this.finalTimeMs = time;
        RuinsOfGrowsseth.LOGGER.info("Finish async locate early from " + this.fromPos + " to " + this.targetString() + " in " + (double)time / 1000.0 + "sparams were searchRadius=" + this.searchRadius + " skipKnownStructures=" + this.skipKnownStructures, new Object[0]);
        if (result != null) {
            RuinsOfGrowsseth.LOGGER.info("Found " + result + " (took " + time + " ms)", new Object[0]);
        } else {
            RuinsOfGrowsseth.LOGGER.info("Not found " + this.targetString() + " (took " + time + " ms)", new Object[0]);
        }
        this.future.complete(result);
    }

    private final String targetString() {
        List list = this.targetSet.stream().toList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"toList(...)");
        return "[" + CollectionsKt.joinToString$default((Iterable)list, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + ", filtered=" + (this.targetFilter != null) + "]";
    }

    private static final void then$lambda$0(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit thenOnServerThread$lambda$3$lambda$2$lambda$1(Function1 $action, LocateResult $result) {
        $action.invoke((Object)$result);
        return Unit.INSTANCE;
    }

    private static final void thenOnServerThread$lambda$3$lambda$2(LocateTask this$0, Function1 $action, LocateResult $result) {
        this$0.simpleTryCatch(() -> LocateTask.thenOnServerThread$lambda$3$lambda$2$lambda$1($action, $result));
    }

    private static final Unit thenOnServerThread$lambda$3(LocateTask this$0, Function1 $action, LocateResult result) {
        this$0.server.submit(() -> LocateTask.thenOnServerThread$lambda$3$lambda$2(this$0, $action, result));
        return Unit.INSTANCE;
    }

    private static final void thenOnServerThread$lambda$4(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final LocateResult onException$lambda$5(Function1 $tmp0, Throwable p0) {
        return (LocateResult)$tmp0.invoke((Object)p0);
    }

    private static final Unit onExceptionOnServerThread$lambda$8$lambda$7$lambda$6(Function1 $action, Throwable $e) {
        Intrinsics.checkNotNull((Object)$e);
        $action.invoke((Object)$e);
        return Unit.INSTANCE;
    }

    private static final void onExceptionOnServerThread$lambda$8$lambda$7(LocateTask this$0, Function1 $action, Throwable $e) {
        this$0.simpleTryCatch(() -> LocateTask.onExceptionOnServerThread$lambda$8$lambda$7$lambda$6($action, $e));
    }

    private static final LocateResult onExceptionOnServerThread$lambda$8(LocateTask this$0, Function1 $action, Throwable e) {
        this$0.server.submit(() -> LocateTask.onExceptionOnServerThread$lambda$8$lambda$7(this$0, $action, e));
        return null;
    }

    private static final Set findNearestMapStructure$lambda$10(StructurePlacement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Set)new ObjectArraySet();
    }

    private static final Set findNearestMapStructure$lambda$11(Function1 $tmp0, Object p0) {
        return (Set)$tmp0.invoke(p0);
    }

    private static final Set findNearestCustomGeneratedStructure$lambda$15(LocateTask this$0, TagKey tag) {
        Object t = this$0.level.registryAccess().registryOrThrow(Registries.STRUCTURE).getTag(tag).orElseThrow();
        Intrinsics.checkNotNullExpressionValue(t, (String)"orElseThrow(...)");
        return CollectionsKt.toSet((Iterable)((Iterable)t));
    }

    private static final Set findNearestCustomGeneratedStructure$lambda$16(Function1 $tmp0, Object p0) {
        return (Set)$tmp0.invoke(p0);
    }

    private static final Set findNearestCustomGeneratedStructure$lambda$17(List structureHolders) {
        Intrinsics.checkNotNull((Object)structureHolders);
        return CollectionsKt.toSet((Iterable)structureHolders);
    }

    private static final Set findNearestCustomGeneratedStructure$lambda$18(Function1 $tmp0, Object p0) {
        return (Set)$tmp0.invoke(p0);
    }

    private static final List findNearestCustomGeneratedStructure$lambda$23$lambda$19(LocateTask this$0, ResourceKey key) {
        CustomPlacedStructureTracker customPlacedStructureTracker = this$0.customPlacedStructureTracker;
        Intrinsics.checkNotNull((Object)key);
        return customPlacedStructureTracker.getByStructure(key);
    }

    private static final List findNearestCustomGeneratedStructure$lambda$23$lambda$20(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final List findNearestCustomGeneratedStructure$lambda$23$lambda$21(LocateTask this$0, Structure struct) {
        CustomPlacedStructureTracker customPlacedStructureTracker = this$0.customPlacedStructureTracker;
        Intrinsics.checkNotNull((Object)struct);
        return customPlacedStructureTracker.getByStructure(struct);
    }

    private static final List findNearestCustomGeneratedStructure$lambda$23$lambda$22(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lcom/ruslan/growsseth/structure/locate/LocateTask$Phase;", "", "int", "", "<init>", "(Ljava/lang/String;II)V", "getInt", "()I", "CONCENTRIC_RINGS", "RANDOM_SPREAD", "ruins-of-growsseth"})
    public static final class Phase
    extends Enum<Phase> {
        private final int int;
        public static final /* enum */ Phase CONCENTRIC_RINGS = new Phase(0);
        public static final /* enum */ Phase RANDOM_SPREAD = new Phase(1);
        private static final /* synthetic */ Phase[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Phase(int n) {
            this.int = n;
        }

        public final int getInt() {
            return this.int;
        }

        public static Phase[] values() {
            return (Phase[])$VALUES.clone();
        }

        public static Phase valueOf(String value) {
            return Enum.valueOf(Phase.class, value);
        }

        @NotNull
        public static EnumEntries<Phase> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = phaseArray = new Phase[]{Phase.CONCENTRIC_RINGS, Phase.RANDOM_SPREAD};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

