/*
 * Decompiled with CFR 0.152.
 */
package com.ruslan.growsseth.structure.structure;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.ruslan.growsseth.structure.GrowssethStructures;
import com.ruslan.growsseth.structure.pieces.ResearcherTent;
import com.ruslan.growsseth.structure.structure.SimpleStructure;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 !2\u00020\u0001:\u0001!B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ0\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\f\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001dH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u001e\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006\""}, d2={"Lcom/ruslan/growsseth/structure/structure/ResearcherTentStructure;", "Lcom/ruslan/growsseth/structure/structure/SimpleStructure;", "structureSettings", "Lnet/minecraft/world/level/levelgen/structure/Structure$StructureSettings;", "templatePath", "Lnet/minecraft/resources/ResourceLocation;", "offsetY", "", "forcePosUseY", "", "<init>", "(Lnet/minecraft/world/level/levelgen/structure/Structure$StructureSettings;Lnet/minecraft/resources/ResourceLocation;IZ)V", "getTemplatePath", "()Lnet/minecraft/resources/ResourceLocation;", "getOffsetY", "()I", "getFirstPiece", "Lnet/minecraft/world/level/levelgen/structure/StructurePiece;", "context", "Lnet/minecraft/world/level/levelgen/structure/Structure$GenerationContext;", "random", "Lnet/minecraft/util/RandomSource;", "chunkPos", "Lnet/minecraft/world/level/ChunkPos;", "pos", "Lnet/minecraft/core/BlockPos;", "rotation", "Lnet/minecraft/world/level/block/Rotation;", "type", "Lnet/minecraft/world/level/levelgen/structure/StructureType;", "nextPlaceUseY", "getNextPlaceUseY", "()Z", "Companion", "ruins-of-growsseth"})
public final class ResearcherTentStructure
extends SimpleStructure {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ResourceLocation templatePath;
    private final int offsetY;
    private final boolean nextPlaceUseY;
    @NotNull
    private static final MapCodec<ResearcherTentStructure> CODEC;
    @NotNull
    private static final Vec3i SIZE;
    public static final int BASEMENT_HEIGHT = 10;

    public ResearcherTentStructure(@NotNull Structure.StructureSettings structureSettings, @NotNull ResourceLocation templatePath, int offsetY, boolean forcePosUseY) {
        Intrinsics.checkNotNullParameter((Object)structureSettings, (String)"structureSettings");
        Intrinsics.checkNotNullParameter((Object)templatePath, (String)"templatePath");
        super(structureSettings, forcePosUseY);
        this.templatePath = templatePath;
        this.offsetY = offsetY;
        this.nextPlaceUseY = forcePosUseY;
    }

    public /* synthetic */ ResearcherTentStructure(Structure.StructureSettings structureSettings, ResourceLocation resourceLocation, int n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            resourceLocation = ResearcherTent.Companion.getDEFAULT_ID();
        }
        if ((n2 & 4) != 0) {
            n = -10;
        }
        if ((n2 & 8) != 0) {
            bl = true;
        }
        this(structureSettings, resourceLocation, n, bl);
    }

    @NotNull
    public final ResourceLocation getTemplatePath() {
        return this.templatePath;
    }

    public final int getOffsetY() {
        return this.offsetY;
    }

    @Override
    @NotNull
    protected StructurePiece getFirstPiece(@NotNull Structure.GenerationContext context, @NotNull RandomSource random, @NotNull ChunkPos chunkPos, @NotNull BlockPos pos, @NotNull Rotation rotation) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        Intrinsics.checkNotNullParameter((Object)chunkPos, (String)"chunkPos");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)rotation, (String)"rotation");
        BlockPos offset = new BlockPos(-SIZE.getX() / 2, 0, -8).rotate(rotation);
        StructureTemplateManager structureTemplateManager = context.structureTemplateManager();
        Intrinsics.checkNotNullExpressionValue((Object)structureTemplateManager, (String)"structureTemplateManager(...)");
        return (StructurePiece)new ResearcherTent(structureTemplateManager, new BlockPos(pos.getX() + offset.getX(), pos.getY() + this.offsetY, pos.getZ() + offset.getZ()), rotation, this.templatePath);
    }

    @NotNull
    public StructureType<?> type() {
        return GrowssethStructures.Types.INSTANCE.getRESEARCHER_TENT();
    }

    @Override
    public boolean getNextPlaceUseY() {
        return this.nextPlaceUseY;
    }

    private static final Optional CODEC$lambda$4$lambda$0(ResearcherTentStructure it) {
        return Optional.of(it.getNextPlaceUseY());
    }

    private static final ResourceLocation CODEC$lambda$4$lambda$1(ResearcherTentStructure it) {
        return it.templatePath;
    }

    private static final Integer CODEC$lambda$4$lambda$2(ResearcherTentStructure it) {
        return it.offsetY;
    }

    private static final ResearcherTentStructure CODEC$lambda$4$lambda$3(Structure.StructureSettings structureSettings, Optional forcePosUseY, ResourceLocation templatePath, Integer offsetY) {
        Intrinsics.checkNotNull((Object)structureSettings);
        Intrinsics.checkNotNull((Object)templatePath);
        Intrinsics.checkNotNull((Object)offsetY);
        int n = offsetY;
        Boolean bl = forcePosUseY.orElse(false);
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"orElse(...)");
        return new ResearcherTentStructure(structureSettings, templatePath, n, bl);
    }

    private static final App CODEC$lambda$4(RecordCodecBuilder.Instance builder) {
        return builder.group((App)Structure.settingsCodec((RecordCodecBuilder.Instance)builder), (App)Codec.BOOL.optionalFieldOf("force_pos_uses_y").forGetter(ResearcherTentStructure::CODEC$lambda$4$lambda$0), (App)ResourceLocation.CODEC.optionalFieldOf("templatePath", (Object)ResearcherTent.Companion.getDEFAULT_ID()).forGetter(ResearcherTentStructure::CODEC$lambda$4$lambda$1), (App)Codec.INT.optionalFieldOf("offsetY", (Object)-10).forGetter(ResearcherTentStructure::CODEC$lambda$4$lambda$2)).apply((Applicative)builder, ResearcherTentStructure::CODEC$lambda$4$lambda$3);
    }

    @NotNull
    public static final MapCodec<ResearcherTentStructure> getCODEC() {
        return Companion.getCODEC();
    }

    @NotNull
    public static final Vec3i getSIZE() {
        return Companion.getSIZE();
    }

    static {
        MapCodec mapCodec = RecordCodecBuilder.mapCodec(ResearcherTentStructure::CODEC$lambda$4);
        Intrinsics.checkNotNullExpressionValue((Object)mapCodec, (String)"mapCodec(...)");
        CODEC = mapCodec;
        SIZE = new Vec3i(15, 18, 20);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0011\u001a\u00020\u00062\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\b\b\u0002\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u0010R\"\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0003\u001a\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\f\u0010\u0003\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/ruslan/growsseth/structure/structure/ResearcherTentStructure$Companion;", "", "<init>", "()V", "CODEC", "Lcom/mojang/serialization/MapCodec;", "Lcom/ruslan/growsseth/structure/structure/ResearcherTentStructure;", "getCODEC$annotations", "getCODEC", "()Lcom/mojang/serialization/MapCodec;", "SIZE", "Lnet/minecraft/core/Vec3i;", "getSIZE$annotations", "getSIZE", "()Lnet/minecraft/core/Vec3i;", "BASEMENT_HEIGHT", "", "build", "ctx", "Lnet/minecraft/data/worldgen/BootstrapContext;", "Lnet/minecraft/world/level/levelgen/structure/Structure;", "templatePath", "Lnet/minecraft/resources/ResourceLocation;", "offsetY", "ruins-of-growsseth"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MapCodec<ResearcherTentStructure> getCODEC() {
            return CODEC;
        }

        @JvmStatic
        public static /* synthetic */ void getCODEC$annotations() {
        }

        @NotNull
        public final Vec3i getSIZE() {
            return SIZE;
        }

        @JvmStatic
        public static /* synthetic */ void getSIZE$annotations() {
        }

        @NotNull
        public final ResearcherTentStructure build(@NotNull BootstrapContext<Structure> ctx, @NotNull ResourceLocation templatePath, int offsetY) {
            Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
            Intrinsics.checkNotNullParameter((Object)templatePath, (String)"templatePath");
            ResourceLocation biomesTag = ResourceLocation.parse((String)"growsseth:has_structure/researcher_tent");
            if (Intrinsics.areEqual((Object)templatePath, (Object)ResearcherTent.Companion.getCYDONIA_ID())) {
                biomesTag = ResourceLocation.parse((String)"growsseth:has_structure/none");
            }
            return new ResearcherTentStructure(new Structure.StructureSettings((HolderSet)ctx.lookup(Registries.BIOME).getOrThrow(TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)biomesTag)), MapsKt.emptyMap(), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.NONE), templatePath, offsetY, false, 8, null);
        }

        public static /* synthetic */ ResearcherTentStructure build$default(Companion companion, BootstrapContext bootstrapContext, ResourceLocation resourceLocation, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                resourceLocation = ResearcherTent.Companion.getDEFAULT_ID();
            }
            if ((n2 & 4) != 0) {
                n = -10;
            }
            return companion.build((BootstrapContext<Structure>)bootstrapContext, resourceLocation, n);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

