/*
 * Decompiled with CFR 0.152.
 */
package com.ruslan.growsseth.templates;

import com.filloax.fxlib.api.nbt.NbtUtilsKt;
import com.ruslan.growsseth.templates.SignData;
import com.ruslan.growsseth.templates.TemplateListener;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.block.entity.SignText;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u000b\u001a\u00020\u0005J\u0013\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\u0005H\u0086\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0007J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0005H\u0002J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u0005J\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u0018J\u001e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001dR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000f0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/ruslan/growsseth/templates/SignTemplates;", "", "<init>", "()V", "LINE_TEMPLATE_PREFIX", "", "templates", "", "Lcom/ruslan/growsseth/templates/SignData;", "getTemplates", "()Ljava/util/Map;", "lang", "get", "key", "dyeColors", "Lnet/minecraft/world/item/DyeColor;", "processSign", "Lnet/minecraft/world/level/block/entity/SignText;", "originalText", "getSignTemplate", "templateId", "templateExists", "", "getAvailableTemplates", "", "loadTemplate", "Lnet/minecraft/world/item/ItemStack;", "sign", "registries", "Lnet/minecraft/core/RegistryAccess;", "ruins-of-growsseth"})
public final class SignTemplates {
    @NotNull
    public static final SignTemplates INSTANCE = new SignTemplates();
    @NotNull
    private static final String LINE_TEMPLATE_PREFIX = "%TEMPLATE%";
    @NotNull
    private static final Map<String, DyeColor> dyeColors;

    private SignTemplates() {
    }

    @NotNull
    public final Map<String, SignData> getTemplates() {
        return TemplateListener.INSTANCE.signs();
    }

    @NotNull
    public final Map<String, SignData> templates(@NotNull String lang) {
        Intrinsics.checkNotNullParameter((Object)lang, (String)"lang");
        return TemplateListener.INSTANCE.signs(lang);
    }

    @Nullable
    public final SignData get(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.getTemplates().get(key);
    }

    @JvmStatic
    @NotNull
    public static final SignText processSign(@NotNull SignText originalText) {
        Intrinsics.checkNotNullParameter((Object)originalText, (String)"originalText");
        Component[] componentArray = originalText.getMessages(false);
        Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getMessages(...)");
        Component[] messages = componentArray;
        if (Intrinsics.areEqual((Object)messages[0].getString(), (Object)LINE_TEMPLATE_PREFIX)) {
            String templateId = messages[1].getString() + messages[2].getString() + messages[3].getString();
            SignText templateText = INSTANCE.getSignTemplate(templateId);
            return templateText;
        }
        return originalText;
    }

    private final SignText getSignTemplate(String templateId) {
        if (this.templateExists(templateId)) {
            SignData signData = this.getTemplates().get(templateId);
            Intrinsics.checkNotNull((Object)signData);
            SignData template = signData;
            List<Component> signLines = template.getLinesComponents();
            DyeColor dyeColor = dyeColors.get(template.getColor());
            if (dyeColor == null) {
                dyeColor = DyeColor.BLACK;
            }
            DyeColor signColor = dyeColor;
            Boolean bl = template.getGlowing();
            Intrinsics.checkNotNull((Object)bl);
            boolean isGlowing = bl;
            int n = 0;
            MutableComponent[] mutableComponentArray = new MutableComponent[4];
            while (n < 4) {
                int n2 = n++;
                mutableComponentArray[n2] = Component.empty();
            }
            MutableComponent[] newLines = mutableComponentArray;
            for (int i = 0; i < 4 && CollectionsKt.getOrNull(signLines, (int)i) != null; ++i) {
                newLines[i] = signLines.get(i).copy();
            }
            return new SignText((Component[])newLines, (Component[])newLines, signColor, isGlowing);
        }
        int n = 0;
        MutableComponent[] mutableComponentArray = new MutableComponent[4];
        while (n < 4) {
            int n3 = n++;
            mutableComponentArray[n3] = Component.empty();
        }
        MutableComponent[] errorLines = mutableComponentArray;
        errorLines[1] = Component.literal((String)"TEMPLATE");
        errorLines[2] = Component.literal((String)"NOT FOUND");
        return new SignText((Component[])errorLines, (Component[])errorLines, DyeColor.RED, true);
    }

    public final boolean templateExists(@NotNull String templateId) {
        Intrinsics.checkNotNullParameter((Object)templateId, (String)"templateId");
        return this.getTemplates().get(templateId) != null;
    }

    @NotNull
    public final List<String> getAvailableTemplates() {
        Map<String, SignData> languageSigns = this.getTemplates();
        Map<String, SignData> defaultLanguageSigns = this.templates("en_us");
        return CollectionsKt.toList((Iterable)SetsKt.plus(languageSigns.keySet(), (Iterable)defaultLanguageSigns.keySet()));
    }

    @NotNull
    public final ItemStack loadTemplate(@NotNull ItemStack sign, @NotNull String templateId, @NotNull RegistryAccess registries) {
        Intrinsics.checkNotNullParameter((Object)sign, (String)"sign");
        Intrinsics.checkNotNullParameter((Object)templateId, (String)"templateId");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        SignData signData = this.getTemplates().get(templateId);
        Intrinsics.checkNotNull((Object)signData);
        SignData template = signData;
        List<Component> signLines = template.getLinesComponents();
        sign.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)templateId));
        CustomData.update((DataComponentType)DataComponents.BLOCK_ENTITY_DATA, (ItemStack)sign, arg_0 -> SignTemplates.loadTemplate$lambda$0(signLines, registries, template, arg_0));
        return sign;
    }

    private static final void loadTemplate$lambda$0(List $signLines, RegistryAccess $registries, SignData $template, CompoundTag blockEntityDataTag) {
        CompoundTag frontTextTag = new CompoundTag();
        ListTag messagesList = new ListTag();
        String message = null;
        for (int i = 0; i < 4; ++i) {
            message = CollectionsKt.getOrNull((List)$signLines, (int)i) != null ? Component.Serializer.toJson((Component)((Component)$signLines.get(i)), (HolderLookup.Provider)((HolderLookup.Provider)$registries)) : "[\"\"]";
            messagesList.add((Object)StringTag.valueOf((String)message));
        }
        NbtUtilsKt.putIfAbsent((CompoundTag)frontTextTag, (String)"messages", (Tag)((Tag)messagesList));
        String string = $template.getColor();
        Intrinsics.checkNotNull((Object)string);
        frontTextTag.putString("color", string);
        Boolean bl = $template.getGlowing();
        Intrinsics.checkNotNull((Object)bl);
        frontTextTag.putBoolean("has_glowing_text", bl.booleanValue());
        blockEntityDataTag.putString("id", "oak_sign");
        Intrinsics.checkNotNull((Object)blockEntityDataTag);
        NbtUtilsKt.putIfAbsent((CompoundTag)blockEntityDataTag, (String)"front_text", (Tag)((Tag)frontTextTag));
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"white", (Object)DyeColor.WHITE), TuplesKt.to((Object)"orange", (Object)DyeColor.ORANGE), TuplesKt.to((Object)"magenta", (Object)DyeColor.MAGENTA), TuplesKt.to((Object)"light_blue", (Object)DyeColor.LIGHT_BLUE), TuplesKt.to((Object)"yellow", (Object)DyeColor.YELLOW), TuplesKt.to((Object)"lime", (Object)DyeColor.LIME), TuplesKt.to((Object)"pink", (Object)DyeColor.PINK), TuplesKt.to((Object)"gray", (Object)DyeColor.GRAY), TuplesKt.to((Object)"light_gray", (Object)DyeColor.LIGHT_GRAY), TuplesKt.to((Object)"cyan", (Object)DyeColor.CYAN), TuplesKt.to((Object)"purple", (Object)DyeColor.PURPLE), TuplesKt.to((Object)"blue", (Object)DyeColor.BLUE), TuplesKt.to((Object)"brown", (Object)DyeColor.BROWN), TuplesKt.to((Object)"green", (Object)DyeColor.GREEN), TuplesKt.to((Object)"red", (Object)DyeColor.RED), TuplesKt.to((Object)"black", (Object)DyeColor.BLACK)};
        dyeColors = MapsKt.mapOf((Pair[])pairArray);
    }
}

