/*
 * Decompiled with CFR 0.152.
 */
package com.ruslan.growsseth.utils;

import com.ruslan.growsseth.RuinsOfGrowsseth;
import com.ruslan.growsseth.structure.GrowssethStructures;
import java.util.Stack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.jetbrains.annotations.Nullable;

public class MixinHelpers {
    public static boolean loadingFromStructureBlock = false;
    public static boolean placingBlockEntityInStructure = false;
    public static boolean savingPersistentEntities = false;
    @Nullable
    public static Structure researcherTent;
    public static final ResourceLoading RESOURCE_LOADING;

    private MixinHelpers() {
    }

    public static void serverInit(MinecraftServer server) {
        Registry registry = server.registryAccess().registryOrThrow(Registries.STRUCTURE);
        researcherTent = (Structure)registry.getOrThrow(GrowssethStructures.RESEARCHER_TENT);
    }

    public static void fixPaintingPlacement(Entity entity) {
        if (entity instanceof Painting) {
            Painting painting = (Painting)entity;
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            pos.set((Vec3i)painting.getPos());
            PaintingVariant variant = (PaintingVariant)painting.getVariant().value();
            int width = variant.width() / 16;
            int height = variant.height() / 16;
            Direction direction = painting.getDirection();
            if (height % 2 == 0) {
                pos.move(0, -1, 0);
            }
            if (width % 2 == 0 && (direction == Direction.WEST || direction == Direction.SOUTH)) {
                Vec3i moveTo = direction.getClockWise().getNormal();
                pos.move(moveTo);
            }
            painting.setPos(pos.getCenter());
        }
        RuinsOfGrowsseth.LOGGER.info("Fixed painting placement in newly created structure", new Object[0]);
    }

    static {
        RESOURCE_LOADING = new ResourceLoading();
    }

    public static class ResourceLoading {
        @Nullable
        private static ResourceLocation currentlyDecoding;
        private static final Stack<ResourceLocation> parentDecoding;

        public void startResource(ResourceLocation id) {
            if (currentlyDecoding != null) {
                parentDecoding.add(currentlyDecoding);
            }
            currentlyDecoding = id;
        }

        public void endResource() {
            currentlyDecoding = parentDecoding.empty() ? null : parentDecoding.pop();
        }

        @Nullable
        public ResourceLocation getCurrent() {
            return currentlyDecoding;
        }

        static {
            parentDecoding = new Stack();
        }
    }
}

