/*
 * Decompiled with CFR 0.152.
 */
package com.ruslan.growsseth.utils;

import com.filloax.fxlib.api.FxLibServices;
import com.filloax.fxlib.api.lang.server.ServerLanguageManager;
import com.ruslan.growsseth.config.GrowssethConfig;
import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.locale.Language;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pools.ListPoolElement;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0005\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0014\u0010\u0007\u001a\u00020\b*\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u001a\u0018\u0010\f\u001a\u00020\b*\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00010\u000f\u001a\u0018\u0010\u0010\u001a\u00020\b*\u00020\u00112\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00010\u000f\u001a\u0010\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00010\u000f*\u00020\u0011\u001a\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00142\u0006\u0010\u0015\u001a\u00020\u0003\u001a/\u0010\u0016\u001a\u00020\b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u000b\u0082\u0002\u001c\n\f\b\u0000\u0012\u0002\u0018\u0000\u001a\u0004\b\u0002\u0010\u0001\n\f\b\u0000\u0012\u0002\u0018\u0001\u001a\u0004\b\u0003\u0010\u0001\u001a/\u0010\u0018\u001a\u00020\b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u000b\u0082\u0002\u001c\n\f\b\u0000\u0012\u0002\u0018\u0000\u001a\u0004\b\u0003\u0010\u0001\n\f\b\u0000\u0012\u0002\u0018\u0001\u001a\u0004\b\u0002\u0010\u0001\u00a8\u0006\u0019"}, d2={"resLoc", "Lnet/minecraft/resources/ResourceLocation;", "str", "", "resLocVanilla", "serverLang", "Lnet/minecraft/locale/Language;", "contentEquals", "", "Lnet/minecraft/world/item/trading/MerchantOffer;", "other", "", "matchesJigsaw", "Lnet/minecraft/world/level/levelgen/structure/StructurePiece;", "pieceIds", "", "matches", "Lnet/minecraft/world/level/levelgen/structure/pools/StructurePoolElement;", "getTemplateIds", "loadPropertiesFile", "", "fileName", "isNull", "x", "notNull", "ruins-of-growsseth"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\ncom/ruslan/growsseth/utils/UtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,147:1\n1755#2,3:148\n1368#2:151\n1454#2,5:152\n*S KotlinDebug\n*F\n+ 1 Utils.kt\ncom/ruslan/growsseth/utils/UtilsKt\n*L\n74#1:148,3\n83#1:151\n83#1:152,5\n*E\n"})
public final class UtilsKt {
    @NotNull
    public static final ResourceLocation resLoc(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)"growsseth", (String)str);
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"fromNamespaceAndPath(...)");
        return resourceLocation;
    }

    @NotNull
    public static final ResourceLocation resLocVanilla(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)str);
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"fromNamespaceAndPath(...)");
        return resourceLocation;
    }

    @NotNull
    public static final Language serverLang() {
        ServerLanguageManager serverLanguageManager = FxLibServices.INSTANCE.getServerLanguage();
        String string = GrowssethConfig.serverLanguage;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"serverLanguage");
        return serverLanguageManager.get(string);
    }

    public static final boolean contentEquals(@NotNull MerchantOffer $this$contentEquals, @Nullable Object other) {
        Intrinsics.checkNotNullParameter((Object)$this$contentEquals, (String)"<this>");
        if ($this$contentEquals == other) {
            return true;
        }
        if (!(other instanceof MerchantOffer)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)$this$contentEquals.getBaseCostA(), (Object)((MerchantOffer)other).getBaseCostA())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)$this$contentEquals.getCostB(), (Object)((MerchantOffer)other).getCostB())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)$this$contentEquals.getResult(), (Object)((MerchantOffer)other).getResult())) {
            return false;
        }
        if ($this$contentEquals.getUses() != ((MerchantOffer)other).getUses()) {
            return false;
        }
        if ($this$contentEquals.getMaxUses() != ((MerchantOffer)other).getMaxUses()) {
            return false;
        }
        if ($this$contentEquals.rewardExp != ((MerchantOffer)other).rewardExp) {
            return false;
        }
        if ($this$contentEquals.getSpecialPriceDiff() != ((MerchantOffer)other).getSpecialPriceDiff()) {
            return false;
        }
        if ($this$contentEquals.getDemand() != ((MerchantOffer)other).getDemand()) {
            return false;
        }
        if (!($this$contentEquals.getPriceMultiplier() == ((MerchantOffer)other).getPriceMultiplier())) {
            return false;
        }
        return $this$contentEquals.getXp() == ((MerchantOffer)other).getXp();
    }

    public static final boolean matchesJigsaw(@NotNull StructurePiece $this$matchesJigsaw, @NotNull Collection<ResourceLocation> pieceIds) {
        Intrinsics.checkNotNullParameter((Object)$this$matchesJigsaw, (String)"<this>");
        Intrinsics.checkNotNullParameter(pieceIds, (String)"pieceIds");
        if ($this$matchesJigsaw instanceof PoolElementStructurePiece) {
            StructurePoolElement structurePoolElement = ((PoolElementStructurePiece)$this$matchesJigsaw).getElement();
            Intrinsics.checkNotNullExpressionValue((Object)structurePoolElement, (String)"getElement(...)");
            return UtilsKt.matches(structurePoolElement, pieceIds);
        }
        return false;
    }

    public static final boolean matches(@NotNull StructurePoolElement $this$matches, @NotNull Collection<ResourceLocation> pieceIds) {
        boolean bl;
        block7: {
            Intrinsics.checkNotNullParameter((Object)$this$matches, (String)"<this>");
            Intrinsics.checkNotNullParameter(pieceIds, (String)"pieceIds");
            StructurePoolElement structurePoolElement = $this$matches;
            if (structurePoolElement instanceof SinglePoolElement) {
                Boolean bl2 = ((SinglePoolElement)$this$matches).template.left().map(arg_0 -> UtilsKt.matches$lambda$1(arg_0 -> UtilsKt.matches$lambda$0(pieceIds, arg_0), arg_0)).orElse(false);
                Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"orElse(...)");
                bl = bl2;
            } else if (structurePoolElement instanceof ListPoolElement) {
                List list = ((ListPoolElement)$this$matches).elements;
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"elements");
                Iterable $this$any$iv = list;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        StructurePoolElement it = (StructurePoolElement)element$iv;
                        boolean bl3 = false;
                        Intrinsics.checkNotNull((Object)it);
                        if (!UtilsKt.matches(it, pieceIds)) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            } else {
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<ResourceLocation> getTemplateIds(@NotNull StructurePoolElement $this$getTemplateIds) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)$this$getTemplateIds, (String)"<this>");
        StructurePoolElement structurePoolElement = $this$getTemplateIds;
        if (structurePoolElement instanceof SinglePoolElement) {
            List list = ((SinglePoolElement)$this$getTemplateIds).template.left().map(arg_0 -> UtilsKt.getTemplateIds$lambda$4(UtilsKt::getTemplateIds$lambda$3, arg_0)).orElse(CollectionsKt.emptyList());
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"orElse(...)");
            collection = list;
        } else if (structurePoolElement instanceof ListPoolElement) {
            void $this$flatMapTo$iv$iv;
            List list = ((ListPoolElement)$this$getTemplateIds).elements;
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"elements");
            Iterable $this$flatMap$iv = list;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                StructurePoolElement it = (StructurePoolElement)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                Iterable list$iv$iv = UtilsKt.getTemplateIds(it);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            collection = (List)destination$iv$iv;
        } else {
            collection = CollectionsKt.emptyList();
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final Map<String, String> loadPropertiesFile(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Properties properties = new Properties();
        Map propertiesMap = new LinkedHashMap();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(fileName);
        if (inputStream == null) {
            throw new IllegalArgumentException("Properties file not found: " + fileName);
        }
        InputStream inputStream2 = inputStream;
        Closeable closeable = inputStream2;
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            properties.load(it);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        for (String key : properties.stringPropertyNames()) {
            propertiesMap.put(key, properties.getProperty(key));
        }
        return propertiesMap;
    }

    public static final boolean isNull(@Nullable Object x) {
        return x == null;
    }

    public static final boolean notNull(@Nullable Object x) {
        return x != null;
    }

    private static final Boolean matches$lambda$0(Collection $pieceIds, ResourceLocation it) {
        return $pieceIds.contains(it);
    }

    private static final Boolean matches$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final List getTemplateIds$lambda$3(ResourceLocation it) {
        return CollectionsKt.listOf((Object)it);
    }

    private static final List getTemplateIds$lambda$4(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }
}

