/*
 * Decompiled with CFR 0.152.
 */
package com.ruslan.growsseth.worldgen.worldpreset;

import com.filloax.fxlib.api.FxLibServices;
import com.filloax.fxlib.api.networking.NetworkingUtilsKt;
import com.filloax.fxlib.api.structure.FixedStructureGeneration;
import com.mojang.datafixers.util.Either;
import com.ruslan.growsseth.config.WorldPresetConfig;
import com.ruslan.growsseth.network.PlacesInfoPacket;
import com.ruslan.growsseth.utils.UtilsKt;
import com.ruslan.growsseth.worldgen.GrowssethModBiomeSources;
import com.ruslan.growsseth.worldgen.GrowssethModWorldPresets;
import com.ruslan.growsseth.worldgen.worldpreset.LocationNotifListener;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterList;
import net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterLists;
import net.minecraft.world.level.biome.TheEndBiomeSource;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001#B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bH\u0007J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u001c\u0010\u0014\u001a\u00020\t2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u000b2\u0006\u0010\u0017\u001a\u00020\u0018J\u001c\u0010\u0019\u001a\u00020\t2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u000b2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u001c\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011J\u0014\u0010\u001d\u001a\u00020\f2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\f0\u001fJ\u0014\u0010 \u001a\u00020!2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\"0\u001fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/ruslan/growsseth/worldgen/worldpreset/GrowssethWorldPreset;", "", "<init>", "()V", "GROWSSETH_SEED", "", "fixedStructureGeneration", "Lcom/filloax/fxlib/api/structure/FixedStructureGeneration;", "isGrowssethPreset", "", "preset", "Lnet/minecraft/core/Holder;", "Lnet/minecraft/world/level/levelgen/presets/WorldPreset;", "isGrowssethPresetFromOverworldBiomeSource", "biomeSource", "Lnet/minecraft/world/level/biome/BiomeSource;", "server", "Lnet/minecraft/server/MinecraftServer;", "levelAcc", "Lnet/minecraft/world/level/ServerLevelAccessor;", "shouldDisableStructure", "structure", "Lnet/minecraft/world/level/levelgen/structure/Structure;", "level", "Lnet/minecraft/server/level/ServerLevel;", "shouldDisableStructureSet", "structureSet", "Lnet/minecraft/world/level/levelgen/structure/StructureSet;", "shouldDisableVillagePresets", "build", "ctx", "Lnet/minecraft/data/worldgen/BootstrapContext;", "bootstrapNoiseBiomeSourcesSettings", "", "Lnet/minecraft/world/level/biome/MultiNoiseBiomeSourceParameterList;", "Callbacks", "ruins-of-growsseth"})
public final class GrowssethWorldPreset {
    @NotNull
    public static final GrowssethWorldPreset INSTANCE = new GrowssethWorldPreset();
    @NotNull
    public static final String GROWSSETH_SEED = "MelminaVerde";
    @NotNull
    private static final FixedStructureGeneration fixedStructureGeneration = FxLibServices.INSTANCE.getFixedStructureGeneration();

    private GrowssethWorldPreset() {
    }

    @JvmStatic
    public static final boolean isGrowssethPreset(@Nullable Holder<WorldPreset> preset) {
        ResourceKey resourceKey = preset;
        return resourceKey != null && (resourceKey = resourceKey.unwrapKey()) != null && (resourceKey = (ResourceKey)OptionalsKt.getOrNull(resourceKey)) != null ? resourceKey.equals(GrowssethModWorldPresets.GROWSSETH) : false;
    }

    @JvmStatic
    public static final boolean isGrowssethPresetFromOverworldBiomeSource(@NotNull BiomeSource biomeSource) {
        Intrinsics.checkNotNullParameter((Object)biomeSource, (String)"biomeSource");
        if (biomeSource instanceof MultiNoiseBiomeSource) {
            Either parameters = ((MultiNoiseBiomeSource)biomeSource).parameters;
            Object object = parameters.map(arg_0 -> GrowssethWorldPreset.isGrowssethPresetFromOverworldBiomeSource$lambda$1(GrowssethWorldPreset::isGrowssethPresetFromOverworldBiomeSource$lambda$0, arg_0), arg_0 -> GrowssethWorldPreset.isGrowssethPresetFromOverworldBiomeSource$lambda$3(GrowssethWorldPreset::isGrowssethPresetFromOverworldBiomeSource$lambda$2, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"map(...)");
            return (Boolean)object;
        }
        return false;
    }

    @JvmStatic
    public static final boolean isGrowssethPreset(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        BiomeSource biomeSource = server.overworld().getChunkSource().getGenerator().getBiomeSource();
        Intrinsics.checkNotNullExpressionValue((Object)biomeSource, (String)"getBiomeSource(...)");
        return GrowssethWorldPreset.isGrowssethPresetFromOverworldBiomeSource(biomeSource);
    }

    @JvmStatic
    public static final boolean isGrowssethPreset(@NotNull ServerLevelAccessor levelAcc) {
        Intrinsics.checkNotNullParameter((Object)levelAcc, (String)"levelAcc");
        MinecraftServer minecraftServer = levelAcc.getLevel().getServer();
        Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
        return GrowssethWorldPreset.isGrowssethPreset(minecraftServer);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean shouldDisableStructure(@NotNull Holder<Structure> structure, @NotNull ServerLevel level) {
        Intrinsics.checkNotNullParameter(structure, (String)"structure");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        if (!GrowssethWorldPreset.isGrowssethPreset((ServerLevelAccessor)level)) return false;
        Optional optional = structure.unwrapKey();
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"unwrapKey(...)");
        ResourceKey resourceKey = (ResourceKey)OptionalsKt.getOrNull((Optional)optional);
        if (!Intrinsics.areEqual((Object)(resourceKey != null && (resourceKey = resourceKey.location()) != null ? resourceKey.getNamespace() : null), (Object)"growsseth")) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean shouldDisableStructureSet(@NotNull Holder<StructureSet> structureSet, @NotNull BiomeSource biomeSource) {
        Intrinsics.checkNotNullParameter(structureSet, (String)"structureSet");
        Intrinsics.checkNotNullParameter((Object)biomeSource, (String)"biomeSource");
        Optional optional = structureSet.unwrapKey();
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"unwrapKey(...)");
        ResourceKey resourceKey = (ResourceKey)OptionalsKt.getOrNull((Optional)optional);
        ResourceLocation setLocation = resourceKey != null ? resourceKey.location() : null;
        if (!GrowssethWorldPreset.isGrowssethPresetFromOverworldBiomeSource(biomeSource)) return false;
        ResourceLocation resourceLocation = setLocation;
        if (Intrinsics.areEqual((Object)(resourceLocation != null ? resourceLocation.getNamespace() : null), (Object)"growsseth")) return true;
        if (!WorldPresetConfig.disableTrialChambers) return false;
        if (!Intrinsics.areEqual((Object)setLocation, (Object)UtilsKt.resLocVanilla("trial_chambers"))) return false;
        return true;
    }

    public final boolean shouldDisableVillagePresets(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        return GrowssethWorldPreset.isGrowssethPreset(server);
    }

    @NotNull
    public final WorldPreset build(@NotNull BootstrapContext<WorldPreset> ctx) {
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        HolderGetter noiseSettings = ctx.lookup(Registries.NOISE_SETTINGS);
        HolderGetter biomes = ctx.lookup(Registries.BIOME);
        HolderGetter multiNoiseBiomeSourceParameterLists = ctx.lookup(Registries.MULTI_NOISE_BIOME_SOURCE_PARAMETER_LIST);
        HolderGetter dimTypes = ctx.lookup(Registries.DIMENSION_TYPE);
        Holder.Reference overworldType = dimTypes.getOrThrow(BuiltinDimensionTypes.OVERWORLD);
        Holder.Reference netherType = dimTypes.getOrThrow(BuiltinDimensionTypes.NETHER);
        Holder.Reference endType = dimTypes.getOrThrow(BuiltinDimensionTypes.END);
        Holder.Reference overworldBiomeParameters = multiNoiseBiomeSourceParameterLists.getOrThrow(GrowssethModBiomeSources.GROWSSETH_OVERWORLD_SETTINGS);
        Holder.Reference overworldNoiseSettings = noiseSettings.getOrThrow(NoiseGeneratorSettings.OVERWORLD);
        LevelStem overworldStem = new LevelStem((Holder)overworldType, (ChunkGenerator)new NoiseBasedChunkGenerator((BiomeSource)MultiNoiseBiomeSource.createFromPreset((Holder)((Holder)overworldBiomeParameters)), (Holder)overworldNoiseSettings));
        Holder.Reference netherBiomeParameters = multiNoiseBiomeSourceParameterLists.getOrThrow(MultiNoiseBiomeSourceParameterLists.NETHER);
        Holder.Reference netherNoiseSettings = noiseSettings.getOrThrow(NoiseGeneratorSettings.NETHER);
        LevelStem netherStem = new LevelStem((Holder)netherType, (ChunkGenerator)new NoiseBasedChunkGenerator((BiomeSource)MultiNoiseBiomeSource.createFromPreset((Holder)((Holder)netherBiomeParameters)), (Holder)netherNoiseSettings));
        Holder.Reference endNoiseSettings = noiseSettings.getOrThrow(NoiseGeneratorSettings.END);
        LevelStem endStem = new LevelStem((Holder)endType, (ChunkGenerator)new NoiseBasedChunkGenerator((BiomeSource)TheEndBiomeSource.create((HolderGetter)biomes), (Holder)endNoiseSettings));
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)LevelStem.OVERWORLD, (Object)overworldStem), TuplesKt.to((Object)LevelStem.NETHER, (Object)netherStem), TuplesKt.to((Object)LevelStem.END, (Object)endStem)};
        return new WorldPreset(MapsKt.mutableMapOf((Pair[])pairArray));
    }

    public final void bootstrapNoiseBiomeSourcesSettings(@NotNull BootstrapContext<MultiNoiseBiomeSourceParameterList> ctx) {
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        HolderGetter biomes = ctx.lookup(Registries.BIOME);
        ctx.register(GrowssethModBiomeSources.GROWSSETH_OVERWORLD_SETTINGS, (Object)new MultiNoiseBiomeSourceParameterList(MultiNoiseBiomeSourceParameterList.Preset.OVERWORLD, biomes));
    }

    private static final Boolean isGrowssethPresetFromOverworldBiomeSource$lambda$0(Climate.ParameterList it) {
        return false;
    }

    private static final Boolean isGrowssethPresetFromOverworldBiomeSource$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Boolean isGrowssethPresetFromOverworldBiomeSource$lambda$2(Holder parametersHolder) {
        Optional optional = parametersHolder.unwrapKey();
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"unwrapKey(...)");
        return Intrinsics.areEqual((Object)OptionalsKt.getOrNull((Optional)optional), GrowssethModBiomeSources.GROWSSETH_OVERWORLD_SETTINGS);
    }

    private static final Boolean isGrowssethPresetFromOverworldBiomeSource$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\u000b"}, d2={"Lcom/ruslan/growsseth/worldgen/worldpreset/GrowssethWorldPreset$Callbacks;", "", "<init>", "()V", "onServerStarted", "", "server", "Lnet/minecraft/server/MinecraftServer;", "onServerPlayerJoin", "player", "Lnet/minecraft/server/level/ServerPlayer;", "ruins-of-growsseth"})
    @SourceDebugExtension(value={"SMAP\nGrowssethWorldPreset.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrowssethWorldPreset.kt\ncom/ruslan/growsseth/worldgen/worldpreset/GrowssethWorldPreset$Callbacks\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,147:1\n1863#2,2:148\n*S KotlinDebug\n*F\n+ 1 GrowssethWorldPreset.kt\ncom/ruslan/growsseth/worldgen/worldpreset/GrowssethWorldPreset$Callbacks\n*L\n41#1:148,2\n*E\n"})
    public static final class Callbacks {
        @NotNull
        public static final Callbacks INSTANCE = new Callbacks();

        private Callbacks() {
        }

        public final void onServerStarted(@NotNull MinecraftServer server) {
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            if (GrowssethWorldPreset.isGrowssethPreset(server)) {
                List<WorldPresetConfig.StructureInWorldConfig> list = WorldPresetConfig.getAll();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getAll(...)");
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    WorldPresetConfig.StructureInWorldConfig cfg = (WorldPresetConfig.StructureInWorldConfig)element$iv;
                    boolean bl = false;
                    FixedStructureGeneration fixedStructureGeneration = fixedStructureGeneration;
                    ServerLevel serverLevel = server.overworld();
                    Intrinsics.checkNotNullExpressionValue((Object)serverLevel, (String)"overworld(...)");
                    String string = cfg.structureId + "_grworldgen";
                    BlockPos blockPos = new BlockPos(cfg.x, cfg.y, cfg.z);
                    ResourceLocation resourceLocation = cfg.structureId();
                    Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"structureId(...)");
                    Rotation rotation = cfg.rotation;
                    Intrinsics.checkNotNullExpressionValue((Object)rotation, (String)"rotation");
                    FixedStructureGeneration.DefaultImpls.register$default((FixedStructureGeneration)fixedStructureGeneration, (ServerLevel)serverLevel, (String)string, (BlockPos)blockPos, (ResourceLocation)resourceLocation, (Rotation)rotation, (boolean)false, (int)32, null);
                }
            }
        }

        public final void onServerPlayerJoin(@NotNull ServerPlayer player, @NotNull MinecraftServer server) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            if (GrowssethWorldPreset.isGrowssethPreset(server)) {
                if (LocationNotifListener.Companion.getLoaded()) {
                    NetworkingUtilsKt.sendPacket$default((ServerPlayer)player, (CustomPacketPayload)new PlacesInfoPacket(LocationNotifListener.Companion.getLOCALISED_PLACES_DATA()), null, (int)2, null);
                } else {
                    throw new Exception("Location notification listener not loaded!");
                }
            }
        }
    }
}

