package com.ruslan.growsseth.config;

import com.teamresourceful.resourcefulconfig.api.annotations.Category;
import com.teamresourceful.resourcefulconfig.api.annotations.Comment;
import com.teamresourceful.resourcefulconfig.api.annotations.ConfigEntry;

import static com.ruslan.growsseth.config.GrowssethConfig.T_PREF;

@Category("web")
public final class WebConfig {
    @ConfigEntry(id = "webDataSync", translation = T_PREF + "webDataSync.name")
    @Comment(value = "CAREFUL: check the Wiki on GitHub for how to use this. Enables gamemaster-mode, allowing the " +
            "player you decide to connect to to control the mod's features and more. Requires reloading the world.", translation = T_PREF + "webDataSync.comment")
    public static boolean webDataSync = false;
    @ConfigEntry(id = "dataSyncUrl", translation = T_PREF + "dataSyncUrl.name")
    @Comment(value = "Only connect to trusted sources!", translation = T_PREF + "dataSyncUrl.comment")
    public static String dataSyncUrl = "http://localhost:5000";
    @ConfigEntry(id = "dataSyncEndpoint", translation = T_PREF + "dataSyncEndpoint.name")
    public static String dataSyncEndpoint = "server_data";
    @ConfigEntry(id = "dataSyncApiKey", translation = T_PREF + "dataSyncApiKey.name")
    public static String dataSyncApiKey = "";
    @ConfigEntry(id = "dataSyncReloadTime", translation = T_PREF + "dataSyncReloadTime.name")
    @Comment(value = "How much time (in minutes) must pass between each server query. Must be at least 10 seconds.", translation = T_PREF + "dataSyncReloadTime.comment")
    public static float dataSyncReloadTime = 5f;

    @ConfigEntry(id = "liveUpdateService", translation = T_PREF + "liveUpdateService.name")
    @Comment(value = "CAREFUL: check the Wiki on GitHub for how to use this. Creates a websocket connection with the gamemaster, " +
            "allowing them to control the mod in real time. Requires reloading the world.", translation = T_PREF + "liveUpdateService.comment")
    public static boolean liveUpdateService = false;
    @ConfigEntry(id = "liveUpdateUrl", translation = T_PREF + "liveUpdateUrl.name")
    @Comment(value = "Only connect to trusted sources!", translation = T_PREF + "liveUpdateUrl.comment")
    public static String liveUpdateUrl = "http://localhost:5000";
    @ConfigEntry(id = "liveUpdatePort", translation = T_PREF + "liveUpdatePort.name")
    public static int liveUpdatePort = -1;

    @ConfigEntry(id = "remoteCommandExecution", translation = T_PREF + "remoteCommandExecution.name")
    @Comment(value = "Allow the gamemaster to execute any arbitrary command.", translation = T_PREF + "remoteCommandExecution.comment")
    public static boolean remoteCommandExecution = false;
}
