package com.ruslan.growsseth.maps;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1806;

public class CustomMapItems {
    /**
     * Replace checks for Items.FILLED_MAP in various classes with any item that extends MapItem.
     *
     * Not needed in Neoforge as it already fixes this.
     * @param itemStack Item instance to check for
     * @param compareItem Item that was used in the check in the original call
     * @return True if the item should be treated like a map.
     */
    public static Optional<Boolean> checkCustomMapItem(class_1799 itemStack, class_1792 compareItem) {
        if (compareItem == class_1802.field_8204) {
            return Optional.of(itemStack.method_7909() instanceof class_1806);
        }
        return Optional.empty();
    }

    public static boolean checkMapItemWrapper(class_1799 instance, class_1792 item, Operation<Boolean> original) {
        var opt = CustomMapItems.checkCustomMapItem(instance, item);
        if (opt.isPresent()) return opt.orElseThrow();
        return original.call(instance, item);
    }
}
