package com.ruslan.growsseth.mixin.block;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.ruslan.growsseth.entity.researcher.Researcher;
import net.minecraft.class_1267;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2563;
import net.minecraft.class_2680;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_2563.class)
public abstract class WitherRoseBlockMixin {
    @Unique
    boolean researcherInside = false;

    @Inject(method = "entityInside", at = @At("HEAD"))
    private void checkIfResearcherInside(class_2680 state, class_1937 level, class_2338 pos, class_1297 entity, CallbackInfo ci) {
        if (!level.field_9236 && level.method_8407() != class_1267.field_5801)
            researcherInside = entity instanceof Researcher;
    }

    @ModifyExpressionValue(method = "entityInside",
            at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/LivingEntity;isInvulnerableTo(Lnet/minecraft/world/damagesource/DamageSource;)Z"))
    private boolean researcherDoesNotStepOnRose (boolean original) {
        return original || researcherInside;
    }
}
