package com.ruslan.growsseth.mixin.client;

import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.ruslan.growsseth.advancements.GrowssethAdvancements;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

import java.util.Locale;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_454;

@Mixin(class_454.class)
public abstract class AdvancementTabMixin {
    @Unique
    private boolean isNonTiledBackground(class_454 tab) {
        String tabName = tab.method_53813().method_53649().comp_1919().method_12832().split("/")[0].strip().toLowerCase(Locale.ROOT);
        return GrowssethAdvancements.TABS_WITH_SINGLE_BACKGROUND.contains(tabName);
    }

    @WrapWithCondition(
        method = "drawContents",
        at = @At(value = "INVOKE", ordinal = 0, target = "Lnet/minecraft/client/gui/GuiGraphics;blit(Lnet/minecraft/resources/ResourceLocation;IIFFIIII)V")
    )
    private boolean drawContentsCancelBackgroundBlit(class_332 instance, class_2960 atlasLocation, int x, int y, float uOffset, float vOffset, int width, int height, int textureWidth, int textureHeight) {
        class_454 th1s = (class_454) (Object) this;
        return !isNonTiledBackground(th1s);
    }

    @Inject(
        method = "drawContents",
        at = @At(value = "INVOKE", ordinal = 0, target = "Lnet/minecraft/client/gui/screens/advancements/AdvancementWidget;drawConnectivity(Lnet/minecraft/client/gui/GuiGraphics;IIZ)V"),
        locals = LocalCapture.CAPTURE_FAILHARD
    )
    private void drawContentsCustomBackground(class_332 guiGraphics, int x, int y, CallbackInfo ci, class_2960 resourceLocation, int i, int j) {
        class_454 th1s = (class_454) (Object) this;
        if (isNonTiledBackground(th1s)) {
            int k = 0; //i % 16; ignore scroll
            int l = 0; //j % 16; ignore scroll
            guiGraphics.method_25290(resourceLocation, k, l, 0, 0, 240, 120, 240, 120);
        }
    }
}
