package com.ruslan.growsseth.mixin.client;

import com.ruslan.growsseth.RuinsOfGrowsseth;
import com.ruslan.growsseth.interfaces.ZombieWithEasterEgg;
import net.minecraft.class_1642;
import net.minecraft.class_2960;
import net.minecraft.class_968;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class EasterEggMixinClient {
    @Mixin(class_968.class)
    public static class AbstractZombieRendererMixin {
        @Unique
        private static final class_2960 GUBER_ZOMBIE_PATH = class_2960.method_60655(RuinsOfGrowsseth.MOD_ID, "textures/entity/zombie/guber_zombie.png");

        @Inject(
            method = "getTextureLocation(Lnet/minecraft/world/entity/monster/Zombie;)Lnet/minecraft/resources/ResourceLocation;",
            at = @At("HEAD"),
            cancellable = true
        )
        private void onGetTexture(class_1642 zombie, CallbackInfoReturnable<class_2960> ci) {
            boolean isGuber = ((ZombieWithEasterEgg) zombie).gr$isGuber();

            if (isGuber) {
                ci.setReturnValue(GUBER_ZOMBIE_PATH);
            }
        }
    }
}
