package com.ruslan.growsseth.mixin.client;

import com.google.gson.JsonObject;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.ruslan.growsseth.client.resource.EncryptableSound;
import com.ruslan.growsseth.client.resource.EncryptedMusicResources;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

import java.io.InputStream;
import java.util.Map;
import net.minecraft.class_1111;
import net.minecraft.class_1115;
import net.minecraft.class_1144;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_4237;
import net.minecraft.class_5912;

/**
 * See [EncryptedMusicResources].
 */
public class EncryptedSounds {
    @Mixin(class_1144.class_4009.class)
    public static class SoundManager_PreparationsMixin {
        @ModifyExpressionValue(
            method = "listResources",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/resources/FileToIdConverter;listMatchingResources(Lnet/minecraft/server/packs/resources/ResourceManager;)Ljava/util/Map;"
            )
        )
        private Map<class_2960, class_3298> listResourcesWithExtras(Map<class_2960, class_3298> original, @Local(argsOnly = true) class_3300 resourceManager) {
            var additionalResources = EncryptedMusicResources.LISTER.method_45113(resourceManager);
            original.putAll(additionalResources);
            return original;
        }
    }

    @Mixin(class_1115.class)
    public static class SoundEventRegistrationSerializerMixin {
        @ModifyReturnValue(
            method = "getSound",
            at = @At("RETURN")
        )
        private class_1111 onGetSound(class_1111 sound, @Local(argsOnly = true)JsonObject jsonObject) {
            boolean isEncrypted = class_3518.method_15258(jsonObject, "encrypted", false);
            ((EncryptableSound) sound).ruins_of_growsseth$setEncrypted(isEncrypted);
            return sound;
        }
    }

    @Mixin(class_1111.class)
    public static class SoundMixin implements EncryptableSound {
        @Unique
        private boolean encrypted = false;
        @Shadow
        private @Final class_2960 location;

        @Override
        public boolean ruins_of_growsseth$isEncrypted() {
            return encrypted;
        }

        @Override
        public void ruins_of_growsseth$setEncrypted(boolean value) {
            encrypted = value;
        }

        @ModifyReturnValue(
            method = "getPath",
            at = @At("RETURN")
        )
        private class_2960 onGetPath(class_2960 original) {
            if (encrypted) {
                return EncryptedMusicResources.LISTER.method_45112(this.location);
            }
            return original;
        }
    }

    @Mixin(class_4237.class)
    public static class SoundBufferLibraryMixin {
        // inside getStream and getCompleteBuffer
        @SuppressWarnings("UnresolvedMixinReference")
        @WrapOperation(
                method = {
                    "method_19745",
                    "lambda$getStream$2",
                    "method_19747",
                    "lambda$getCompleteBuffer$0"
                },
                at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/server/packs/resources/ResourceProvider;open(Lnet/minecraft/resources/ResourceLocation;)Ljava/io/InputStream;"
                )
        )
        private InputStream wrapSoundReadingStream(class_5912 instance, class_2960 resourceLocation, Operation<InputStream> original) {
            return EncryptedMusicResources.checkEncryptedSoundStream(resourceLocation, original.call(instance, resourceLocation));
        }
    }
}
