package com.ruslan.growsseth.mixin.entity.mob;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.ruslan.growsseth.config.ResearcherConfig;
import com.ruslan.growsseth.entity.researcher.Researcher;
import com.ruslan.growsseth.entity.researcher.ZombieResearcher;
import com.ruslan.growsseth.interfaces.StructureManagerExtension;
import com.ruslan.growsseth.utils.MixinHelpers;
import net.minecraft.class_1299;
import net.minecraft.class_1338;
import net.minecraft.class_1389;
import net.minecraft.class_1548;
import net.minecraft.class_1588;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

public abstract class CreeperMixin {

    @Mixin(class_1548.class)
    public abstract static class CreeperMobMixin extends class_1588 {
        protected CreeperMobMixin(class_1299<? extends class_1588> entityType, class_1937 level) {
            super(entityType, level);
        }

        @Inject(at = @At("HEAD"), method = "registerGoals")
        private void avoidResearchers(CallbackInfo ci) {
            class_1548 th1s = (class_1548)(Object)this;
            field_6201.method_6277(3, new class_1338<>(th1s, Researcher.class, Researcher.WALK_LIMIT_DISTANCE + 6, 1.0, 1.2));
        }
    }

    @Mixin(class_1389.class)
    public abstract static class SwellGoalMixin {
        @Shadow @Final private class_1548 creeper;
        @Unique private boolean creeperWasInTent;
        @Unique private class_2338 lastCreeperPos;
        @Unique private boolean researchersNearby;

        @ModifyReturnValue(at = @At("TAIL"), method = "canUse")
        private boolean preventExplosionInTent(boolean original) {
            if (!original || !ResearcherConfig.noCreeperExplosionsInResearcherTent) {
                // Skip check if already false or config disabled
                return original;
            }
            class_2338 creeperPos = creeper.method_24515();
            boolean coordsChanged = creeperCoordsChanged(creeperPos);
            if (creeperWasInTent && !coordsChanged && researchersNearby) {
                // Creeper was in tent at last check and did not change position: skip tent check
                return false;
            }
            else if (coordsChanged) {
                // Creeper changed its position: we check if it's inside the Researcher tent
                class_3218 serverLevel = (class_3218) creeper.method_37908();        // Already server side from vanilla code
                StructureManagerExtension structureManager = (StructureManagerExtension) serverLevel.method_27056();
                // We expand the bounding box of the tent, since it still might explode too close to it
                boolean creeperInTent = structureManager
                        .getStructureAtExpanded(creeperPos, MixinHelpers.researcherTent, 3).method_16657();
                creeperWasInTent = creeperInTent;
                if (creeperInTent) {
                    // Every time the coordinates change while the creeper is inside the tent we refresh the nearby researchers boolean
                    refreshResearchersNearby();
                    if (researchersNearby)
                        return false;   // The creeper explosion should only be prevented when a researcher is present
                }
            }
            return original;
        }

        @Unique
        private boolean creeperCoordsChanged(class_2338 currentCreeperPos) {
            // We keep track of the last block pos for optimization purposes, we don't want to check
            // if the creeper is inside the Researcher tent every two ticks
            if (lastCreeperPos == null) {
                lastCreeperPos = currentCreeperPos;
                return true;
            }
            else if (currentCreeperPos.method_10263() == lastCreeperPos.method_10263() && currentCreeperPos.method_10264() == lastCreeperPos.method_10264() && currentCreeperPos.method_10260() == lastCreeperPos.method_10260()) {
                return false;
            }
            else {
                lastCreeperPos = currentCreeperPos;
                return true;
            }
        }

        @Unique
        private void refreshResearchersNearby() {
            class_243 creeperPos = creeper.method_24515().method_61082();
            double bbSize = 80;     // To be 100% sure
            class_238 bbCheck = class_238.method_30048(creeperPos, bbSize, bbSize, bbSize);
            var researchersList = creeper.method_37908().method_18467(Researcher.class, bbCheck);
            var zombieResearchersList = creeper.method_37908().method_18467(ZombieResearcher.class, bbCheck);
            researchersNearby = !researchersList.isEmpty() || !zombieResearchersList.isEmpty();
        }
    }
}
