package com.ruslan.growsseth.mixin.structuretext;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.ruslan.growsseth.structure.StructureBooks;
import com.ruslan.growsseth.utils.MixinHelpers;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

import java.util.Optional;
import net.minecraft.class_1533;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2520;
import net.minecraft.class_7225;

@Mixin(class_1533.class)
public abstract class ItemFrameStructureBookMixin {
    @Unique
    class_1533 thisItemFrame = (class_1533)(Object)this;

    @WrapOperation(
        method = "readAdditionalSaveData",
        at = @At(
            value = "INVOKE",
            target = "Lnet/minecraft/world/item/ItemStack;parse(Lnet/minecraft/core/HolderLookup$Provider;Lnet/minecraft/nbt/Tag;)Ljava/util/Optional;"
        )
    )
    private Optional<class_1799> convertDroppedBook(class_7225.class_7874 lookupProvider, class_2520 tag, Operation<Optional<class_1799>> original){
        var itemOpt = original.call(lookupProvider, tag);
        return itemOpt.map(item -> {
            if (
                !MixinHelpers.loadingFromStructureBlock &&
                (item.method_31574(class_1802.field_8674) || item.method_31574(class_1802.field_8360))
                && StructureBooks.bookIsTemplate(item)
            ) {
                return StructureBooks.loadTemplate(item);
            }
            return item;
        });
    }
}
