package com.ruslan.growsseth.mixin.structuretext;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.ruslan.growsseth.structure.StructureBooks;
import com.ruslan.growsseth.utils.MixinHelpers;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1802;

@Mixin(class_1799.class)
public abstract class ItemStackStructureBookMixin {
    @SuppressWarnings("OptionalUsedAsFieldOrParameterType")
    @ModifyReturnValue(method = "parse", at = @At("RETURN"))
    private static Optional<class_1799> onCreateFromTag(Optional<class_1799> original) {
        if (MixinHelpers.placingBlockEntityInStructure) {
            return original.map(item -> {
                if (
                    (item.method_31574(class_1802.field_8674) || item.method_31574(class_1802.field_8360))
                    && StructureBooks.bookIsTemplate(item)
                ) {
                    return StructureBooks.loadTemplate(item);
                }
                return item;
            });
        }
        return original;
    }
}
