package com.ruslan.growsseth.utils;

import com.ruslan.growsseth.RuinsOfGrowsseth;
import com.ruslan.growsseth.structure.GrowssethStructures;
import net.minecraft.class_1297;
import net.minecraft.class_1534;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

import java.util.Stack;

public class MixinHelpers {
    private MixinHelpers() {}

    public static boolean loadingFromStructureBlock = false;
    public static boolean placingBlockEntityInStructure = false;
    public static boolean savingPersistentEntities = false;

    @Nullable public static class_3195 researcherTent;

    public static void serverInit(MinecraftServer server) {
        class_2378<class_3195> registry = server.method_30611().method_30530(class_7924.field_41246);
        researcherTent = registry.method_31140(GrowssethStructures.RESEARCHER_TENT);
    }

    public static final ResourceLoading RESOURCE_LOADING = new ResourceLoading();

    public static class ResourceLoading {
        @Nullable private static class_2960 currentlyDecoding;
        private static final Stack<class_2960> parentDecoding = new Stack<>(); // just in case


        public void startResource(class_2960 id) {
            if (currentlyDecoding != null) parentDecoding.add(currentlyDecoding);
            currentlyDecoding = id;
        }

        public void endResource() {
            currentlyDecoding = parentDecoding.empty() ? null : parentDecoding.pop();
        }

        public @Nullable class_2960 getCurrent() { return currentlyDecoding; }
    }

    // Big thanks to Naz Ikhsan from https://bugs.mojang.com/browse/MC-102223 for the painting fix
    public static void fixPaintingPlacement(class_1297 entity) {
        if (entity instanceof class_1534 painting) {
            var pos = new class_2338.class_2339();
            pos.method_10101(painting.method_59940());
            var variant = painting.method_43404().comp_349();

            var width = variant.comp_2670() / 16;
            var height = variant.comp_2671() / 16;
            var direction = painting.method_5735();

            // paintings with an even height seem to always be moved upwards...
            if (height % 2 == 0) {
                pos.method_10100(0, -1, 0);
            }

            // paintings with an even width seem to be moved in the clockwise direction of their facing direction,
            // if they're west or south.
            if (width % 2 == 0 && (direction == class_2350.field_11039 || direction == class_2350.field_11035)) {
                var moveTo = direction.method_10170().method_10163();
                pos.method_30927(moveTo);
            }

            painting.method_33574(pos.method_46558());
        }
        RuinsOfGrowsseth.LOGGER.info("Fixed painting placement in newly created structure");
    }
}
