/*
 * Decompiled with CFR 0.152.
 */
package com.ruslan.growsseth;

import com.filloax.fxlib.api.FxLibServices;
import com.filloax.fxlib.api.platform.ServiceUtil;
import com.ruslan.growsseth.ModEvents;
import com.ruslan.growsseth.compat.ModCompatChecker;
import com.ruslan.growsseth.config.GrowssethConfigHandler;
import com.ruslan.growsseth.dialogues.ResearcherDialogueApiListener;
import com.ruslan.growsseth.entity.researcher.CustomRemoteDiaries;
import com.ruslan.growsseth.entity.researcher.ResearcherDiaryComponent;
import com.ruslan.growsseth.entity.researcher.trades.GameMasterResearcherTradesProvider;
import com.ruslan.growsseth.http.GrowssethApi;
import com.ruslan.growsseth.http.GrowssethExtraEvents;
import com.ruslan.growsseth.network.GrowssethPackets;
import com.ruslan.growsseth.resource.MusicCommon;
import com.ruslan.growsseth.structure.RemoteStructureBooks;
import com.ruslan.growsseth.structure.RemoteStructures;
import com.ruslan.growsseth.utils.GrowssethLogger;
import com.ruslan.growsseth.utils.UtilsKt;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b&\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u000f\u0010\u0006\u001a\u00020\u0004H&\u00a2\u0006\u0004\b\u0006\u0010\u0003J\u000f\u0010\u0007\u001a\u00020\u0004H&\u00a2\u0006\u0004\b\u0007\u0010\u0003J\u000f\u0010\b\u001a\u00020\u0004H&\u00a2\u0006\u0004\b\b\u0010\u0003\u00a8\u0006\n"}, d2={"Lcom/ruslan/growsseth/RuinsOfGrowsseth;", "", "<init>", "()V", "", "initialize", "initItemGroups", "registerResourceListeners", "initRegistries", "Companion", "ruins-of-growsseth"})
public abstract class RuinsOfGrowsseth {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String MOD_ID = "growsseth";
    @NotNull
    public static final String MOD_NAME = "Ruins of Growsseth";
    @JvmField
    @NotNull
    public static final GrowssethLogger LOGGER;
    @NotNull
    private static final Map<String, String> cydoniaProperties;
    private static final boolean cydoniaMode;
    private static final ModCompatChecker modCompat;

    public final void initialize() {
        LOGGER.info("Initializing", new Object[0]);
        ModEvents.Companion.get().initCallbacks();
        GrowssethApi.Companion.getCurrent().init();
        this.initRegistries();
        RemoteStructures.INSTANCE.init();
        CustomRemoteDiaries.INSTANCE.init();
        RemoteStructureBooks.INSTANCE.init();
        GameMasterResearcherTradesProvider.INSTANCE.subscribe();
        GrowssethExtraEvents.INSTANCE.init();
        ResearcherDialogueApiListener.INSTANCE.init();
        ResearcherDiaryComponent.Companion.init();
        GrowssethPackets.INSTANCE.registerPacketsC2S();
        GrowssethPackets.INSTANCE.registerPacketsS2C();
        this.initItemGroups();
        this.registerResourceListeners();
        GrowssethConfigHandler.INSTANCE.initConfig();
        MusicCommon.INSTANCE.initCheck();
        if (cydoniaMode) {
            LOGGER.info("Cydonia mode enabled, structures won't spawn and API v1 will be used", new Object[0]);
        }
        LOGGER.info("Initialized! :saidogPipo: :saidogRitto: :saidogMax:", new Object[0]);
    }

    public abstract void initItemGroups();

    public abstract void registerResourceListeners();

    public abstract void initRegistries();

    static {
        Logger logger = LogManager.getLogger((String)MOD_NAME);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOGGER = new GrowssethLogger(logger);
        cydoniaProperties = UtilsKt.loadPropertiesFile("cydonia.properties");
        String string = cydoniaProperties.get("cydoniaMode");
        Intrinsics.checkNotNull((Object)string);
        cydoniaMode = Boolean.parseBoolean(string);
        modCompat = (ModCompatChecker)ServiceUtil.findService(ModCompatChecker.class);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u00068\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u00068\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\r\u0010\fR\u0014\u0010\u000f\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010R#\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00118\u0006\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0017\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001aR\u001f\u0010\u001d\u001a\n \u001c*\u0004\u0018\u00010\u001b0\u001b8\u0006\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010 \u00a8\u0006!"}, d2={"Lcom/ruslan/growsseth/RuinsOfGrowsseth$Companion;", "", "<init>", "()V", "Lorg/apache/logging/log4j/Level;", "level", "", "message", "", "logDev", "(Lorg/apache/logging/log4j/Level;Ljava/lang/String;)V", "MOD_ID", "Ljava/lang/String;", "MOD_NAME", "Lcom/ruslan/growsseth/utils/GrowssethLogger;", "LOGGER", "Lcom/ruslan/growsseth/utils/GrowssethLogger;", "", "cydoniaProperties", "Ljava/util/Map;", "getCydoniaProperties", "()Ljava/util/Map;", "", "cydoniaMode", "Z", "getCydoniaMode", "()Z", "Lcom/ruslan/growsseth/compat/ModCompatChecker;", "kotlin.jvm.PlatformType", "modCompat", "Lcom/ruslan/growsseth/compat/ModCompatChecker;", "getModCompat", "()Lcom/ruslan/growsseth/compat/ModCompatChecker;", "ruins-of-growsseth"})
    public static final class Companion {
        private Companion() {
        }

        public final void logDev(@NotNull Level level, @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            if (FxLibServices.INSTANCE.getPlatform().isDevEnvironment()) {
                LOGGER.log(level, message, new Object[0]);
            }
        }

        @NotNull
        public final Map<String, String> getCydoniaProperties() {
            return cydoniaProperties;
        }

        public final boolean getCydoniaMode() {
            return cydoniaMode;
        }

        public final ModCompatChecker getModCompat() {
            return modCompat;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

