/*
 * Decompiled with CFR 0.152.
 */
package com.ruslan.growsseth.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.ruslan.growsseth.config.GrowssethConfigHandler;
import com.ruslan.growsseth.config.WebConfig;
import com.ruslan.growsseth.entity.researcher.trades.GlobalResearcherTradesProvider;
import com.ruslan.growsseth.http.DataRemoteSync;
import com.ruslan.growsseth.http.GrowssethApi;
import java.net.URI;
import java.net.URL;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\f\u001a\u00020\u000b2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0011J\u0019\u0010\u0016\u001a\u00020\u00152\b\u0010\u0014\u001a\u0004\u0018\u00010\u0013H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0011J\u001f\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0019H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001f\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0017\u0010!\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010%\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020#H\u0002\u00a2\u0006\u0004\b%\u0010&\u00a8\u0006'"}, d2={"Lcom/ruslan/growsseth/commands/GamemasterCommand;", "", "<init>", "()V", "Lcom/mojang/brigadier/CommandDispatcher;", "Lnet/minecraft/class_2168;", "dispatcher", "Lnet/minecraft/class_7157;", "registryAccess", "Lnet/minecraft/class_2170$class_5364;", "environment", "", "register", "(Lcom/mojang/brigadier/CommandDispatcher;Lnet/minecraft/class_7157;Lnet/minecraft/class_2170$class_5364;)V", "source", "", "printHelp", "(Lnet/minecraft/class_2168;)I", "printStatus", "Ljava/time/LocalDateTime;", "time", "", "formatTime", "(Ljava/time/LocalDateTime;)Ljava/lang/String;", "reload", "", "value", "setEnabled", "(Lnet/minecraft/class_2168;Z)I", "url", "setUrl", "(Lnet/minecraft/class_2168;Ljava/lang/String;)I", "urlString", "isValidUrl", "(Ljava/lang/String;)Z", "Lnet/minecraft/server/MinecraftServer;", "server", "restartAndReloadTrades", "(Lnet/minecraft/server/MinecraftServer;)V", "ruins-of-growsseth"})
@SourceDebugExtension(value={"SMAP\nGamemasterCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GamemasterCommand.kt\ncom/ruslan/growsseth/commands/GamemasterCommand\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,147:1\n1#2:148\n*E\n"})
public final class GamemasterCommand {
    @NotNull
    public static final GamemasterCommand INSTANCE = new GamemasterCommand();

    private GamemasterCommand() {
    }

    public final void register(@NotNull CommandDispatcher<class_2168> dispatcher, @NotNull class_7157 registryAccess, @NotNull class_2170.class_5364 environment) {
        Intrinsics.checkNotNullParameter(dispatcher, (String)"dispatcher");
        Intrinsics.checkNotNullParameter((Object)registryAccess, (String)"registryAccess");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"gmaster").requires(GamemasterCommand::register$lambda$0)).then(class_2170.method_9247((String)"help").executes(GamemasterCommand::register$lambda$1))).then(class_2170.method_9247((String)"status").executes(GamemasterCommand::register$lambda$2))).then(class_2170.method_9247((String)"reload").executes(GamemasterCommand::register$lambda$3))).then(class_2170.method_9247((String)"enable").executes(GamemasterCommand::register$lambda$4))).then(class_2170.method_9247((String)"disable").executes(GamemasterCommand::register$lambda$5))).then(class_2170.method_9247((String)"url").then(class_2170.method_9244((String)"webUrl", (ArgumentType)((ArgumentType)StringArgumentType.string())).executes(GamemasterCommand::register$lambda$6))));
    }

    private final int printHelp(class_2168 source) {
        source.method_9226(GamemasterCommand::printHelp$lambda$8, false);
        return 1;
    }

    private final int printStatus(class_2168 source) {
        if (!WebConfig.webDataSync) {
            source.method_45068((class_2561)class_2561.method_43471((String)"growsseth.commands.gmaster.status_off"));
            return 0;
        }
        String suffix = DataRemoteSync.INSTANCE.getLastSyncSuccessful() ? "ok" : "ko";
        Object[] objectArray = new Object[]{WebConfig.dataSyncUrl, DataRemoteSync.INSTANCE.getLastSyncSuccessful()};
        source.method_45068((class_2561)class_2561.method_43469((String)("growsseth.commands.gmaster.status_on_" + suffix), (Object[])objectArray));
        objectArray = new Object[]{this.formatTime(DataRemoteSync.INSTANCE.getLastSuccessfulUpdateTime()), this.formatTime(DataRemoteSync.INSTANCE.getLastUpdateTime())};
        source.method_45068((class_2561)class_2561.method_43469((String)"growsseth.commands.gmaster.status_time", (Object[])objectArray));
        return 1;
    }

    private final String formatTime(LocalDateTime time) {
        Object object;
        block3: {
            block2: {
                object = time;
                if (object == null) break block2;
                LocalDateTime it = object;
                boolean bl = false;
                String string = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").format(it);
                object = string;
                if (string != null) break block3;
            }
            object = "-";
        }
        return object;
    }

    private final int reload(class_2168 source) {
        if (WebConfig.webDataSync) {
            source.method_45068((class_2561)class_2561.method_43471((String)"growsseth.commands.gmaster.reload_start"));
            try {
                GrowssethApi.Companion.getCurrent().reload().thenAccept(arg_0 -> GamemasterCommand.reload$lambda$12(arg_0 -> GamemasterCommand.reload$lambda$11(source, arg_0), arg_0));
            }
            catch (Throwable e) {
                e.printStackTrace();
                source.method_9213((class_2561)class_2561.method_43471((String)"growsseth.commands.gmaster.reload_failure"));
                return 0;
            }
            return 1;
        }
        source.method_9213((class_2561)class_2561.method_43471((String)"growsseth.commands.gmaster.disabled"));
        return 0;
    }

    private final int setEnabled(class_2168 source, boolean value) {
        String suffix;
        String string = suffix = value ? "on" : "off";
        if (WebConfig.webDataSync != value) {
            WebConfig.webDataSync = value;
            GrowssethConfigHandler.INSTANCE.saveConfig();
            MinecraftServer minecraftServer = source.method_9211();
            Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
            this.restartAndReloadTrades(minecraftServer);
            source.method_9226(() -> GamemasterCommand.setEnabled$lambda$13(suffix), true);
        } else {
            source.method_9226(() -> GamemasterCommand.setEnabled$lambda$14(suffix), true);
        }
        return 1;
    }

    private final int setUrl(class_2168 source, String url) {
        if (!this.isValidUrl(url)) {
            Object[] objectArray = new Object[]{url};
            source.method_9213((class_2561)class_2561.method_43469((String)"growsseth.commands.gmaster.url_not_valid", (Object[])objectArray));
            return 0;
        }
        WebConfig.dataSyncUrl = url;
        GrowssethConfigHandler.INSTANCE.saveConfig();
        MinecraftServer minecraftServer = source.method_9211();
        Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
        this.restartAndReloadTrades(minecraftServer);
        source.method_9226(() -> GamemasterCommand.setUrl$lambda$15(url), true);
        return 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isValidUrl(String urlString) {
        try {
            URL url = new URI(urlString).toURL();
            if (!Intrinsics.areEqual((Object)url.getProtocol(), (Object)"http")) {
                if (!Intrinsics.areEqual((Object)url.getProtocol(), (Object)"https")) return false;
            }
            String string = url.getHost();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHost(...)");
            if (((CharSequence)string).length() <= 0) return false;
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private final void restartAndReloadTrades(MinecraftServer server) {
        GlobalResearcherTradesProvider.Companion.reloadAll(server);
    }

    private static final boolean register$lambda$0(class_2168 it) {
        return it.method_9259(2);
    }

    private static final int register$lambda$1(CommandContext ctx) {
        Object object = ctx.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        return INSTANCE.printHelp((class_2168)object);
    }

    private static final int register$lambda$2(CommandContext ctx) {
        Object object = ctx.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        return INSTANCE.printStatus((class_2168)object);
    }

    private static final int register$lambda$3(CommandContext ctx) {
        Object object = ctx.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        return INSTANCE.reload((class_2168)object);
    }

    private static final int register$lambda$4(CommandContext ctx) {
        Object object = ctx.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        return INSTANCE.setEnabled((class_2168)object, true);
    }

    private static final int register$lambda$5(CommandContext ctx) {
        Object object = ctx.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        return INSTANCE.setEnabled((class_2168)object, false);
    }

    private static final int register$lambda$6(CommandContext ctx) {
        Object object = ctx.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        class_2168 class_21682 = (class_2168)object;
        String string = StringArgumentType.getString((CommandContext)ctx, (String)"webUrl");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        return INSTANCE.setUrl(class_21682, string);
    }

    private static final class_2583 printHelp$lambda$8$lambda$7(class_2583 style) {
        return style.method_10958(new class_2558(class_2558.class_2559.field_11749, "https://github.com/filloax/ruins-of-growsseth/wiki/EN-%E2%80%90-Gamemaster-Mode"));
    }

    private static final class_2561 printHelp$lambda$8() {
        class_5250 wikiLink = class_2561.method_43470((String)"https://github.com/filloax/ruins-of-growsseth/wiki/EN---Gamemaster-Mode").method_27692(class_124.field_1073).method_27694(GamemasterCommand::printHelp$lambda$8$lambda$7);
        return (class_2561)class_2561.method_43471((String)"growsseth.commands.gmaster.help").method_10852((class_2561)wikiLink);
    }

    private static final class_2561 reload$lambda$11$lambda$10() {
        return (class_2561)class_2561.method_43471((String)"growsseth.commands.gmaster.reload_success");
    }

    private static final Unit reload$lambda$11(class_2168 $source, Boolean it) {
        if (it.booleanValue()) {
            $source.method_9226(GamemasterCommand::reload$lambda$11$lambda$10, true);
        } else {
            $source.method_9213((class_2561)class_2561.method_43471((String)"growsseth.commands.gmaster.reload_failure"));
        }
        return Unit.INSTANCE;
    }

    private static final void reload$lambda$12(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final class_2561 setEnabled$lambda$13(String $suffix) {
        Object[] objectArray = new Object[]{WebConfig.dataSyncUrl};
        return (class_2561)class_2561.method_43469((String)("growsseth.commands.gmaster.set_" + $suffix), (Object[])objectArray).method_27692(class_124.field_1054);
    }

    private static final class_2561 setEnabled$lambda$14(String $suffix) {
        Object[] objectArray = new Object[]{WebConfig.dataSyncUrl};
        return (class_2561)class_2561.method_43469((String)("growsseth.commands.gmaster.already_" + $suffix), (Object[])objectArray);
    }

    private static final class_2561 setUrl$lambda$15(String $url) {
        Object[] objectArray = new Object[]{$url};
        return (class_2561)class_2561.method_43469((String)"growsseth.commands.gmaster.url_set", (Object[])objectArray).method_27692(class_124.field_1054);
    }
}

