/*
 * Decompiled with CFR 0.152.
 */
package com.ruslan.growsseth.data;

import com.ruslan.growsseth.RuinsOfGrowsseth;
import com.ruslan.growsseth.resource.MusicCommon;
import com.ruslan.growsseth.utils.DecryptUtil;
import com.ruslan.growsseth.utils.GrowssethLogger;
import java.io.File;
import javax.crypto.AEADBadTagException;
import javax.crypto.SecretKey;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\b\n\u0002\u0010\u0002\n\u0002\b\u0003\u001a\r\u0010\u0001\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0001\u0010\u0002\u00a8\u0006\u0003"}, d2={"", "main", "()V", "ruins-of-growsseth"})
@SourceDebugExtension(value={"SMAP\nMusicEncrypt.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MusicEncrypt.kt\ncom/ruslan/growsseth/data/MusicEncryptKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,57:1\n13409#2,2:58\n1#3:60\n*S KotlinDebug\n*F\n+ 1 MusicEncrypt.kt\ncom/ruslan/growsseth/data/MusicEncryptKt\n*L\n44#1:58,2\n*E\n"})
public final class MusicEncryptKt {
    public static final void main() {
        GrowssethLogger log = RuinsOfGrowsseth.LOGGER;
        MusicCommon.INSTANCE.initCheck();
        if (!MusicCommon.INSTANCE.getHasMusicKey()) {
            log.error("Cannot encrypt music with no password set! Put password in environment as GROWSSETH_MUSIC_PW before building", new Object[0]);
            System.exit(-1);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        File folder = new File("");
        File musFolder = FilesKt.resolve((File)folder, (String)"plain-music");
        File assetsFolder = FilesKt.resolve((File)folder, (String)"../base/src/main/resources/assets/growsseth/");
        File outFolder = FilesKt.resolve((File)assetsFolder, (String)"./soundsx");
        musFolder.mkdirs();
        outFolder.mkdirs();
        log.info("Encrypting music found in " + musFolder.getAbsolutePath(), new Object[0]);
        log.info("Loading key...", new Object[0]);
        File keyFile = FilesKt.resolve((File)assetsFolder, (String)"sounds.key");
        try {
            SecretKey key = DecryptUtil.INSTANCE.readKey(keyFile, MusicCommon.INSTANCE.getMusicPw$ruins_of_growsseth());
            log.info("Loaded key", new Object[0]);
            String[] stringArray = musFolder.list();
            if (stringArray != null) {
                String[] $this$forEach$iv = stringArray;
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int i = 0; i < n; ++i) {
                    String element$iv;
                    String fn = element$iv = $this$forEach$iv[i];
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)fn);
                    File file = FilesKt.resolve((File)musFolder, (String)fn);
                    log.info("File: " + file, new Object[0]);
                    File outFile = FilesKt.resolve((File)outFolder, (String)StringsKt.replace$default((String)fn, (String)".ogg", (String)".oggx", (boolean)false, (int)4, null));
                    DecryptUtil.INSTANCE.encryptFile(key, file, outFile);
                    log.info("Saved to " + outFile.getAbsolutePath(), new Object[0]);
                }
            } else {
                boolean bl = false;
                log.warn("No music files!", new Object[0]);
            }
            log.info("Done!", new Object[0]);
        }
        catch (AEADBadTagException aEADBadTagException) {
            RuinsOfGrowsseth.LOGGER.error("Music key taken from env could not be used to decrypt sounds.key file! Did you change it without running growssethMusicKeyCreate afterward?", new Object[0]);
        }
    }

    public static /* synthetic */ void main(String[] args) {
        MusicEncryptKt.main();
    }
}

