/*
 * Decompiled with CFR 0.152.
 */
package com.ruslan.growsseth.entity.researcher;

import com.filloax.fxlib.api.EventUtil;
import com.filloax.fxlib.api.FxItemUtilsKt;
import com.filloax.fxlib.api.UtilsKt;
import com.filloax.fxlib.api.codec.CodecUtilsKt;
import com.filloax.fxlib.api.enums.SetBlockFlag;
import com.filloax.fxlib.api.nbt.NbtUtilsKt;
import com.mojang.datafixers.util.Pair;
import com.ruslan.growsseth.GrowssethTags;
import com.ruslan.growsseth.RuinsOfGrowsseth;
import com.ruslan.growsseth.config.ResearcherConfig;
import com.ruslan.growsseth.dialogues.BasicDialoguesComponent;
import com.ruslan.growsseth.entity.GrowssethEntities;
import com.ruslan.growsseth.entity.researcher.DiaryHelper;
import com.ruslan.growsseth.entity.researcher.Researcher;
import com.ruslan.growsseth.entity.researcher.ResearcherDialoguesComponent;
import com.ruslan.growsseth.entity.researcher.ResearcherDonkey;
import com.ruslan.growsseth.entity.researcher.ResearcherQuestComponent;
import com.ruslan.growsseth.entity.researcher.ResearcherSavedData;
import com.ruslan.growsseth.entity.researcher.ZombieResearcher;
import com.ruslan.growsseth.entity.researcher.trades.AbstractResearcherTradesProvider;
import com.ruslan.growsseth.entity.researcher.trades.ProgressResearcherTradesProvider;
import com.ruslan.growsseth.entity.researcher.trades.ResearcherTradeMode;
import com.ruslan.growsseth.item.GrowssethItems;
import com.ruslan.growsseth.quests.ApiEventTrigger;
import com.ruslan.growsseth.quests.DialogueGroupTrigger;
import com.ruslan.growsseth.quests.EventTrigger;
import com.ruslan.growsseth.quests.NoPlayersInRadiusTrigger;
import com.ruslan.growsseth.quests.QuestComponent;
import com.ruslan.growsseth.quests.QuestStage;
import com.ruslan.growsseth.quests.QuestStageTrigger;
import com.ruslan.growsseth.quests.QuestTriggersKt;
import com.ruslan.growsseth.quests.QuestUpdateEvent;
import com.ruslan.growsseth.quests.TriggerTreeNode;
import com.ruslan.growsseth.structure.pieces.ResearcherTent;
import com.ruslan.growsseth.templates.BookData;
import com.ruslan.growsseth.templates.BookTemplates;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2624;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3449;
import net.minecraft.class_3722;
import net.minecraft.class_3829;
import net.minecraft.class_3852;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5575;
import net.minecraft.class_6880;
import net.minecraft.class_7430;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\r\u0018\u0000 \u001c2\b\u0012\u0004\u0012\u00020\u00020\u0001:\n\u001d\u001c\u001e\u001f !\"#$%B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u000b\u0010\nR \u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\r8\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\r8\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0013R\u0014\u0010\u0015\u001a\u00020\r8\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0013R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018R\u0016\u0010\u001a\u001a\u00020\u00198\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001b\u00a8\u0006&"}, d2={"Lcom/ruslan/growsseth/entity/researcher/ResearcherQuestComponent;", "Lcom/ruslan/growsseth/quests/QuestComponent;", "Lcom/ruslan/growsseth/entity/researcher/Researcher;", "researcher", "<init>", "(Lcom/ruslan/growsseth/entity/researcher/Researcher;)V", "Lnet/minecraft/class_2487;", "tag", "", "writeCustomNbt", "(Lnet/minecraft/class_2487;)V", "readCustomNbt", "", "", "availableStages", "Ljava/util/List;", "getAvailableStages", "()Ljava/util/List;", "finalQuestStartName", "Ljava/lang/String;", "finalQuestZombieName", "finalQuestLeaveName", "Lcom/ruslan/growsseth/quests/QuestStageTrigger;", "commonReloadTrigger", "Lcom/ruslan/growsseth/quests/QuestStageTrigger;", "", "alreadyRemovedTent", "Z", "Companion", "Stages", "StartStage", "ZombieStage", "HealedStage", "HealedWaitForDialogueStage", "HomeLastDialogueStage", "WaitBeforeLeaveStage", "EndingStage", "ProgressTradesTrigger", "ruins-of-growsseth"})
@SourceDebugExtension(value={"SMAP\nResearcherQuestComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResearcherQuestComponent.kt\ncom/ruslan/growsseth/entity/researcher/ResearcherQuestComponent\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,445:1\n3829#2:446\n4344#2,2:447\n1053#3:449\n1557#3:450\n1628#3,3:451\n*S KotlinDebug\n*F\n+ 1 ResearcherQuestComponent.kt\ncom/ruslan/growsseth/entity/researcher/ResearcherQuestComponent\n*L\n74#1:446\n74#1:447,2\n75#1:449\n76#1:450\n76#1:451,3\n*E\n"})
public final class ResearcherQuestComponent
extends QuestComponent<Researcher> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<String> availableStages;
    @NotNull
    private final String finalQuestStartName;
    @NotNull
    private final String finalQuestZombieName;
    @NotNull
    private final String finalQuestLeaveName;
    @NotNull
    private final QuestStageTrigger<Researcher> commonReloadTrigger;
    private boolean alreadyRemovedTent;
    @NotNull
    public static final String QUEST_NAME = "researcherIllness";
    @NotNull
    public static final String TAG_ALREADY_REMOVED_TENT = "alreadyRemovedTent";
    private static boolean playerSkippedQuest;

    /*
     * WARNING - void declaration
     */
    public ResearcherQuestComponent(@NotNull Researcher researcher) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)researcher, (String)"researcher");
        super((class_1309)researcher, QUEST_NAME);
        Field[] fieldArray = Stages.class.getDeclaredFields();
        Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"getDeclaredFields(...)");
        Object[] objectArray = fieldArray;
        ResearcherQuestComponent researcherQuestComponent = this;
        boolean $i$f$filter = false;
        void var4_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Field element$iv$iv : $this$filterTo$iv$iv) {
            Field it = element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getType(), String.class)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Field it = (Field)a;
                boolean bl = false;
                Field[] fieldArray = it.getDeclaringClass().getDeclaredFields();
                Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"getDeclaredFields(...)");
                Comparable comparable = Integer.valueOf(ArraysKt.indexOf((Object[])fieldArray, (Object)it));
                it = (Field)b;
                Comparable comparable2 = comparable;
                bl = false;
                Field[] fieldArray2 = it.getDeclaringClass().getDeclaredFields();
                Intrinsics.checkNotNullExpressionValue((Object)fieldArray2, (String)"getDeclaredFields(...)");
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(ArraysKt.indexOf((Object[])fieldArray2, (Object)it)));
            }
        });
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Field element$iv$iv;
            element$iv$iv = (Field)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object object = it.get(null);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
            collection.add((String)object);
        }
        researcherQuestComponent.availableStages = (List)destination$iv$iv;
        this.finalQuestStartName = "researcher_end_quest_start";
        this.finalQuestZombieName = "researcher_end_quest_zombie";
        this.finalQuestLeaveName = "researcher_end_quest_leave";
        objectArray = new QuestUpdateEvent[]{QuestUpdateEvent.LOAD};
        this.commonReloadTrigger = new EventTrigger((QuestUpdateEvent[])objectArray).or(new NoPlayersInRadiusTrigger(this, null, 8, 2, null)).or(QuestTriggersKt.TimeOrDayTimeTrigger(this, 24000L));
        QuestComponent.addStage$default(this, "start", new StartStage(), new String[0], 0, false, false, 56, null);
        objectArray = new String[]{"start", "init"};
        QuestComponent.addStage$default(this, "zombie", new ZombieStage(), (String[])objectArray, -10, true, false, 32, null);
        objectArray = new String[]{"zombie"};
        QuestComponent.addStage$default(this, "healed", new HealedStage(), (String[])objectArray, 0, false, false, 56, null);
        objectArray = new String[]{"zombie"};
        QuestComponent.addStage$default(this, "healed_wait", new HealedWaitForDialogueStage(), (String[])objectArray, 0, false, false, 56, null);
        objectArray = new String[]{"healed"};
        QuestComponent.addStage$default(this, "home", new HomeLastDialogueStage(), (String[])objectArray, 0, false, true, 24, null);
        objectArray = new String[]{"home"};
        QuestComponent.addStage$default(this, "home_wait", new WaitBeforeLeaveStage(), (String[])objectArray, 0, false, true, 24, null);
        objectArray = new String[]{"home_wait"};
        QuestComponent.addStage$default(this, "ending", new EndingStage(), (String[])objectArray, 0, false, false, 56, null);
    }

    @Override
    @NotNull
    public List<String> getAvailableStages() {
        return this.availableStages;
    }

    @Override
    public void writeCustomNbt(@NotNull class_2487 tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        tag.method_10556(TAG_ALREADY_REMOVED_TENT, this.alreadyRemovedTent);
    }

    @Override
    public void readCustomNbt(@NotNull class_2487 tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.alreadyRemovedTent = tag.method_10577(TAG_ALREADY_REMOVED_TENT);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001d\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\r\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0015\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0015\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0012\u0010\u0011J\u001d\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0015\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0017\u0010\u0011J\u0015\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u0018\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0015\u0010\u001c\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u0018\u00a2\u0006\u0004\b\u001c\u0010\u001bJ%\u0010#\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020!\u00a2\u0006\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020\u00138\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b%\u0010&R\u0014\u0010'\u001a\u00020\u00138\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b'\u0010&R\u0016\u0010(\u001a\u00020\u000f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b(\u0010)\u00a8\u0006*"}, d2={"Lcom/ruslan/growsseth/entity/researcher/ResearcherQuestComponent$Companion;", "", "<init>", "()V", "Lnet/minecraft/server/MinecraftServer;", "server", "Lcom/ruslan/growsseth/quests/QuestComponent$QuestData;", "getPersistentData", "(Lnet/minecraft/server/MinecraftServer;)Lcom/ruslan/growsseth/quests/QuestComponent$QuestData;", "data", "", "writePersistentData", "(Lnet/minecraft/server/MinecraftServer;Lcom/ruslan/growsseth/quests/QuestComponent$QuestData;)V", "updateCurrentResearchers", "(Lnet/minecraft/server/MinecraftServer;)V", "", "isHealed", "(Lnet/minecraft/server/MinecraftServer;)Z", "shouldRemoveTent", "", "stage", "setStage", "(Lnet/minecraft/server/MinecraftServer;Ljava/lang/String;)V", "backOneStage", "Lcom/ruslan/growsseth/entity/researcher/Researcher;", "researcher", "removeTentAndResearcher", "(Lcom/ruslan/growsseth/entity/researcher/Researcher;)V", "removeResearcher", "Lnet/minecraft/class_3218;", "level", "Lnet/minecraft/class_2338;", "pos", "Lnet/minecraft/class_2470;", "tentRotation", "spawnRewardChest", "(Lnet/minecraft/class_3218;Lnet/minecraft/class_2338;Lnet/minecraft/class_2470;)V", "QUEST_NAME", "Ljava/lang/String;", "TAG_ALREADY_REMOVED_TENT", "playerSkippedQuest", "Z", "ruins-of-growsseth"})
    @SourceDebugExtension(value={"SMAP\nResearcherQuestComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResearcherQuestComponent.kt\ncom/ruslan/growsseth/entity/researcher/ResearcherQuestComponent$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 NbtUtils.kt\ncom/filloax/fxlib/api/nbt/NbtUtilsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,445:1\n1#2:446\n42#3,8:447\n1863#4:455\n1863#4,2:456\n1864#4:458\n*S KotlinDebug\n*F\n+ 1 ResearcherQuestComponent.kt\ncom/ruslan/growsseth/entity/researcher/ResearcherQuestComponent$Companion\n*L\n136#1:447,8\n143#1:455\n144#1:456,2\n143#1:458\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final QuestComponent.QuestData getPersistentData(@NotNull MinecraftServer server) {
            Object object;
            block5: {
                block4: {
                    Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                    if (!ResearcherConfig.singleResearcher) {
                        RuinsOfGrowsseth.LOGGER.error("Tried getting researcher quest data when not in single researcher mode!", new Object[0]);
                        return new QuestComponent.QuestData(null, null, false, 0L, 0L, 31, null);
                    }
                    class_2487 class_24872 = ResearcherSavedData.Companion.getPersistent(server).getData().method_10562("Quests").method_10562(ResearcherQuestComponent.QUEST_NAME);
                    Intrinsics.checkNotNullExpressionValue((Object)class_24872, (String)"getCompound(...)");
                    class_2487 tag = NbtUtilsKt.getCompoundOrNull((class_2487)class_24872, (String)"status");
                    object = tag;
                    if (object == null) break block4;
                    class_2487 it = object;
                    boolean bl = false;
                    QuestComponent.QuestData questData = (QuestComponent.QuestData)((Pair)CodecUtilsKt.decodeNbt(QuestComponent.Companion.getPERSIST_CODEC(), (class_2520)((class_2520)it)).getOrThrow(arg_0 -> Companion.getPersistentData$lambda$1$lambda$0(CodecUtilsKt.throwableCodecErr((String)"ResearcherQuestComponent getPersistentData"), arg_0))).getFirst();
                    object = questData;
                    if (questData != null) break block5;
                }
                object = new QuestComponent.QuestData(null, null, false, 0L, 0L, 31, null);
            }
            return object;
        }

        public final void writePersistentData(@NotNull MinecraftServer server, @NotNull QuestComponent.QuestData data) {
            String key$iv;
            class_2487 $this$getOrPut$iv;
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            if (!ResearcherConfig.singleResearcher) {
                RuinsOfGrowsseth.LOGGER.error("Tried writing researcher quest data when not in single researcher mode!", new Object[0]);
            }
            ResearcherSavedData researcherData = ResearcherSavedData.Companion.getPersistent(server);
            class_2487 class_24872 = researcherData.getData();
            String string = "Quests";
            class_2520 default$iv = (class_2520)new class_2487();
            boolean $i$f$getOrPut = false;
            class_2520 value$iv = $this$getOrPut$iv.method_10580(key$iv);
            if (value$iv == null) {
                class_2520 class_25202 = default$iv.method_10707();
                if (class_25202 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type net.minecraft.nbt.CompoundTag");
                }
                value$iv = (class_2520)((class_2487)class_25202);
                $this$getOrPut$iv.method_10566(key$iv, value$iv);
            } else if (!(value$iv instanceof class_2487)) {
                throw new ClassCastException("Existing tag is of wrong type! " + value$iv.getClass());
            }
            $this$getOrPut$iv = (class_2487)value$iv;
            key$iv = ResearcherQuestComponent.QUEST_NAME;
            default$iv = (class_2520)new class_2487();
            $i$f$getOrPut = false;
            value$iv = $this$getOrPut$iv.method_10580(key$iv);
            if (value$iv == null) {
                class_2520 class_25203 = default$iv.method_10707();
                if (class_25203 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type net.minecraft.nbt.CompoundTag");
                }
                value$iv = (class_2520)((class_2487)class_25203);
                $this$getOrPut$iv.method_10566(key$iv, value$iv);
            } else if (!(value$iv instanceof class_2487)) {
                throw new ClassCastException("Existing tag is of wrong type! " + value$iv.getClass());
            }
            class_2487 questsTag = (class_2487)value$iv;
            questsTag.method_10566("status", (class_2520)CodecUtilsKt.encodeNbt(QuestComponent.Companion.getPERSIST_CODEC(), (Object)data).getOrThrow(arg_0 -> Companion.writePersistentData$lambda$2(CodecUtilsKt.throwableCodecErr((String)"writePersistentData quest"), arg_0)));
            researcherData.method_80();
            this.updateCurrentResearchers(server);
        }

        private final void updateCurrentResearchers(MinecraftServer server) {
            Iterable iterable = server.method_3738();
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getAllLevels(...)");
            Iterable $this$forEach$iv = iterable;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                class_3218 level = (class_3218)element$iv;
                boolean bl = false;
                List list = level.method_18198((class_5575)GrowssethEntities.INSTANCE.getRESEARCHER(), arg_0 -> Companion.updateCurrentResearchers$lambda$5$lambda$3(UtilsKt.alwaysTruePredicate(), arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEntities(...)");
                Iterable $this$forEach$iv2 = list;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    Researcher researcher = (Researcher)element$iv2;
                    boolean bl2 = false;
                    researcher.readSavedData(ResearcherSavedData.Companion.getPersistent(server));
                }
            }
        }

        public final boolean isHealed(@NotNull MinecraftServer server) {
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            return this.getPersistentData(server).getStageHistory().contains("healed");
        }

        public final boolean shouldRemoveTent(@NotNull MinecraftServer server) {
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            return this.getPersistentData(server).getStageHistory().contains("ending");
        }

        public final void setStage(@NotNull MinecraftServer server, @NotNull String stage) {
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            Intrinsics.checkNotNullParameter((Object)stage, (String)"stage");
            Object[] objectArray = new String[]{"home", "home_wait", "start", "healed", "zombie", "ending"};
            boolean bl = CollectionsKt.listOf((Object[])objectArray).contains(stage);
            if (_Assertions.ENABLED && !bl) {
                boolean bl2 = false;
                String string = "Stage " + stage + " not included in stages for researcher!";
                throw new AssertionError((Object)string);
            }
            QuestComponent.QuestData data = this.getPersistentData(server);
            data.setCurrentStageId(stage);
            data.getStageHistory().add(stage);
            data.setCurrentStageTriggerTime(server.method_30002().method_8510());
            this.writePersistentData(server, data);
        }

        public final boolean backOneStage(@NotNull MinecraftServer server) {
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            QuestComponent.QuestData data = this.getPersistentData(server);
            String string = (String)CollectionsKt.removeLastOrNull(data.getStageHistory());
            if (string == null) {
                return false;
            }
            data.setCurrentStageId(string);
            this.writePersistentData(server, data);
            return true;
        }

        public final void removeTentAndResearcher(@NotNull Researcher researcher) {
            Intrinsics.checkNotNullParameter((Object)researcher, (String)"researcher");
            class_1937 class_19372 = researcher.method_37908();
            Intrinsics.checkNotNull((Object)class_19372, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            class_3218 level = (class_3218)class_19372;
            RuinsOfGrowsseth.LOGGER.info("Removing tent and researcher " + this, new Object[0]);
            MinecraftServer $this$removeTentAndResearcher_u24lambda_u248 = level.method_8503();
            boolean bl = false;
            ResearcherTent researcherTent = researcher.getTent();
            if (researcherTent != null) {
                ResearcherTent tent = researcherTent;
                boolean bl2 = false;
                class_2338 giftPos = tent.method_14935().method_22874().method_10086(2);
                class_2470 tentRotation = tent.method_41626().method_15113();
                ResearcherTent.remove$default(tent, level, null, true, 2, null);
                Intrinsics.checkNotNull((Object)giftPos);
                Intrinsics.checkNotNull((Object)tentRotation);
                Companion.spawnRewardChest(level, giftPos, tentRotation);
            }
            Companion.removeResearcher(researcher);
        }

        public final void removeResearcher(@NotNull Researcher researcher) {
            Intrinsics.checkNotNullParameter((Object)researcher, (String)"researcher");
            class_1937 class_19372 = researcher.method_37908();
            Intrinsics.checkNotNull((Object)class_19372, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            class_3218 level = (class_3218)class_19372;
            if (!researcher.getDonkeyWasBorrowed()) {
                ResearcherDonkey.removeDonkey$default(ResearcherDonkey.INSTANCE, researcher, level, null, 4, null);
            }
            MinecraftServer minecraftServer = level.method_8503();
            Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
            ResearcherSavedData savedData = ResearcherSavedData.Companion.getPersistent(minecraftServer);
            Researcher.writeSavedData$default(researcher, savedData, null, false, 6, null);
            savedData.method_80();
            researcher.method_31472();
        }

        public final void spawnRewardChest(@NotNull class_3218 level, @NotNull class_2338 pos, @NotNull class_2470 tentRotation) {
            class_1799 class_17992;
            class_1799 class_17993;
            String finalDiaryTemplate;
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)tentRotation, (String)"tentRotation");
            class_2586 prevBlockEntity = level.method_8321(pos);
            class_3829.method_16825((Object)prevBlockEntity);
            Object object = class_2246.field_10034.method_9564().method_11657((class_2769)class_2281.field_10768, (Comparable)tentRotation.method_10503(class_2350.field_11043));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"setValue(...)");
            class_2680 chestState = (class_2680)object;
            SetBlockFlag[] setBlockFlagArray = new SetBlockFlag[]{SetBlockFlag.NOTIFY_CLIENTS, SetBlockFlag.NO_NEIGHBOR_REACTIONS, SetBlockFlag.NO_NEIGHBOR_REACTION_DROPS};
            level.method_8652(pos, chestState, SetBlockFlag.Companion.or(setBlockFlagArray));
            class_2586 blockEntity = level.method_8321(pos);
            if (blockEntity == null || !(blockEntity instanceof class_2624)) {
                RuinsOfGrowsseth.LOGGER.error("No blockentity at reward chest pos " + pos + ", error in spawning?", new Object[0]);
                return;
            }
            class_6880.class_6883 resInstrumentHolder = (class_6880.class_6883)class_7923.field_41166.method_40264(class_5321.method_29179((class_5321)class_7924.field_41275, (class_2960)((class_2960)GrowssethItems.Instruments.INSTANCE.getRESEARCHER_HORN().getFirst()))).orElseThrow();
            class_1799 hornItem = class_7430.method_43558((class_1792)((class_1792)GrowssethItems.INSTANCE.getRESEARCHER_HORN()), (class_6880)((class_6880)resInstrumentHolder));
            Intrinsics.checkNotNull((Object)hornItem);
            List list = FxItemUtilsKt.loreLines((class_1799)hornItem);
            class_5250 class_52502 = class_2561.method_43471((String)"item.growsseth.researcher_horn.description1");
            Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"translatable(...)");
            list.add(class_52502);
            List list2 = FxItemUtilsKt.loreLines((class_1799)hornItem);
            class_5250 class_52503 = class_2561.method_43471((String)"item.growsseth.researcher_horn.description2");
            Intrinsics.checkNotNullExpressionValue((Object)class_52503, (String)"translatable(...)");
            list2.add(class_52503);
            MinecraftServer minecraftServer = level.method_8503();
            Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
            class_2561 class_25612 = ResearcherSavedData.Companion.getPersistent(minecraftServer).getName();
            if (class_25612 == null) {
                class_25612 = (class_2561)class_2561.method_43471((String)"entity.growsseth.researcher");
            }
            class_2561 researcherName = class_25612;
            String string = finalDiaryTemplate = !playerSkippedQuest ? "quest_good_ending" : "quest_good_ending_skip";
            if (DiaryHelper.INSTANCE.hasCustomEndDiary()) {
                Intrinsics.checkNotNull((Object)researcherName);
                class_17993 = DiaryHelper.INSTANCE.getCustomEndDiary(researcherName);
            } else {
                class_17993 = class_17992 = null;
            }
            if (class_17993 == null && (class_17992 = BookTemplates.createTemplatedBook$default(BookTemplates.INSTANCE, finalDiaryTemplate, null, null, arg_0 -> Companion.spawnRewardChest$lambda$9(researcherName, arg_0), 6, null)) == null) {
                class_1799 class_17994;
                class_1799 itemStack = class_17994 = class_1802.field_8407.method_7854().method_46651(1);
                boolean bl = false;
                itemStack.method_57379(class_9334.field_49631, (Object)class_2561.method_43471((String)"growsseth.final_diary_fallback"));
                RuinsOfGrowsseth.LOGGER.warn("Couldn't load final diary, researcher used a piece of paper instead!", new Object[0]);
                class_17992 = class_17994;
            }
            class_1799 endTextItem = class_17992;
            ((class_2624)blockEntity).method_5447(4, endTextItem);
            ((class_2624)blockEntity).method_5447(13, hornItem);
            level.method_8408(pos, chestState.method_26204());
            RuinsOfGrowsseth.LOGGER.info("Spawned researcher reward chest at " + pos, new Object[0]);
        }

        private static final Exception getPersistentData$lambda$1$lambda$0(Function1 $tmp0, String p0) {
            return (Exception)$tmp0.invoke((Object)p0);
        }

        private static final Exception writePersistentData$lambda$2(Function1 $tmp0, String p0) {
            return (Exception)$tmp0.invoke((Object)p0);
        }

        private static final boolean updateCurrentResearchers$lambda$5$lambda$3(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final BookData spawnRewardChest$lambda$9(class_2561 $researcherName, BookData $this$createTemplatedBook) {
            Intrinsics.checkNotNullParameter((Object)$this$createTemplatedBook, (String)"$this$createTemplatedBook");
            String string = $researcherName.getString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            return $this$createTemplatedBook.withAuthor(string);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\t\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\t\u0010\bR \u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\n8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/ruslan/growsseth/entity/researcher/ResearcherQuestComponent$EndingStage;", "Lcom/ruslan/growsseth/quests/QuestStage;", "Lcom/ruslan/growsseth/entity/researcher/Researcher;", "<init>", "(Lcom/ruslan/growsseth/entity/researcher/ResearcherQuestComponent;)V", "entity", "", "onActivated", "(Lcom/ruslan/growsseth/entity/researcher/Researcher;)V", "onUpdate", "Lcom/ruslan/growsseth/quests/QuestStageTrigger;", "trigger", "Lcom/ruslan/growsseth/quests/QuestStageTrigger;", "getTrigger", "()Lcom/ruslan/growsseth/quests/QuestStageTrigger;", "ruins-of-growsseth"})
    public final class EndingStage
    implements QuestStage<Researcher> {
        @NotNull
        private final QuestStageTrigger<Researcher> trigger;

        public EndingStage() {
            this.trigger = ResearcherQuestComponent.this.commonReloadTrigger.and(QuestTriggersKt.TimeOrDayTimeTrigger(ResearcherQuestComponent.this, 48000L).or(new ApiEventTrigger(ResearcherQuestComponent.this.finalQuestLeaveName)));
        }

        @Override
        @NotNull
        public QuestStageTrigger<Researcher> getTrigger() {
            return this.trigger;
        }

        @Override
        public void onActivated(@NotNull Researcher entity) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            entity.setHealed(true);
        }

        @Override
        public void onUpdate(@NotNull Researcher entity) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            ResearcherDialoguesComponent researcherDialoguesComponent = entity.getDialogues();
            Intrinsics.checkNotNull((Object)researcherDialoguesComponent);
            if (researcherDialoguesComponent.getTriggeredDialogues().isEmpty()) {
                playerSkippedQuest = true;
            }
            if (!ResearcherQuestComponent.this.alreadyRemovedTent) {
                Companion.removeTentAndResearcher(entity);
            } else {
                Companion.removeResearcher(entity);
            }
        }

        @Override
        public void onStep(@NotNull Researcher entity) {
            QuestStage.DefaultImpls.onStep(this, (class_1309)entity);
        }

        @Override
        @NotNull
        public TriggerTreeNode getTriggerStatusTree(@NotNull Researcher entity, @NotNull QuestUpdateEvent event) {
            return QuestStage.DefaultImpls.getTriggerStatusTree(this, (class_1309)entity, event);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bR \u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\t8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/ruslan/growsseth/entity/researcher/ResearcherQuestComponent$HealedStage;", "Lcom/ruslan/growsseth/quests/QuestStage;", "Lcom/ruslan/growsseth/entity/researcher/Researcher;", "<init>", "()V", "entity", "", "onActivated", "(Lcom/ruslan/growsseth/entity/researcher/Researcher;)V", "Lcom/ruslan/growsseth/quests/QuestStageTrigger;", "trigger", "Lcom/ruslan/growsseth/quests/QuestStageTrigger;", "getTrigger", "()Lcom/ruslan/growsseth/quests/QuestStageTrigger;", "ruins-of-growsseth"})
    public static final class HealedStage
    implements QuestStage<Researcher> {
        @NotNull
        private final QuestStageTrigger<Researcher> trigger = trigger.1.INSTANCE;

        @Override
        @NotNull
        public QuestStageTrigger<Researcher> getTrigger() {
            return this.trigger;
        }

        @Override
        public void onActivated(@NotNull Researcher entity) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            entity.setHealed(true);
        }

        @Override
        public void onStep(@NotNull Researcher entity) {
            QuestStage.DefaultImpls.onStep(this, (class_1309)entity);
        }

        @Override
        public void onUpdate(@NotNull Researcher entity) {
            QuestStage.DefaultImpls.onUpdate(this, (class_1309)entity);
        }

        @Override
        @NotNull
        public TriggerTreeNode getTriggerStatusTree(@NotNull Researcher entity, @NotNull QuestUpdateEvent event) {
            return QuestStage.DefaultImpls.getTriggerStatusTree(this, (class_1309)entity, event);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bR \u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\t8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/ruslan/growsseth/entity/researcher/ResearcherQuestComponent$HealedWaitForDialogueStage;", "Lcom/ruslan/growsseth/quests/QuestStage;", "Lcom/ruslan/growsseth/entity/researcher/Researcher;", "<init>", "(Lcom/ruslan/growsseth/entity/researcher/ResearcherQuestComponent;)V", "entity", "", "onActivated", "(Lcom/ruslan/growsseth/entity/researcher/Researcher;)V", "Lcom/ruslan/growsseth/quests/QuestStageTrigger;", "trigger", "Lcom/ruslan/growsseth/quests/QuestStageTrigger;", "getTrigger", "()Lcom/ruslan/growsseth/quests/QuestStageTrigger;", "ruins-of-growsseth"})
    public final class HealedWaitForDialogueStage
    implements QuestStage<Researcher> {
        @NotNull
        private final QuestStageTrigger<Researcher> trigger = new DialogueGroupTrigger("group-cure-dialogue");

        @Override
        @NotNull
        public QuestStageTrigger<Researcher> getTrigger() {
            return this.trigger;
        }

        @Override
        public void onActivated(@NotNull Researcher entity) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            entity.setHealed(true);
        }

        @Override
        public void onStep(@NotNull Researcher entity) {
            QuestStage.DefaultImpls.onStep(this, (class_1309)entity);
        }

        @Override
        public void onUpdate(@NotNull Researcher entity) {
            QuestStage.DefaultImpls.onUpdate(this, (class_1309)entity);
        }

        @Override
        @NotNull
        public TriggerTreeNode getTriggerStatusTree(@NotNull Researcher entity, @NotNull QuestUpdateEvent event) {
            return QuestStage.DefaultImpls.getTriggerStatusTree(this, (class_1309)entity, event);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bR \u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\t8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/ruslan/growsseth/entity/researcher/ResearcherQuestComponent$HomeLastDialogueStage;", "Lcom/ruslan/growsseth/quests/QuestStage;", "Lcom/ruslan/growsseth/entity/researcher/Researcher;", "<init>", "(Lcom/ruslan/growsseth/entity/researcher/ResearcherQuestComponent;)V", "entity", "", "onActivated", "(Lcom/ruslan/growsseth/entity/researcher/Researcher;)V", "Lcom/ruslan/growsseth/quests/QuestStageTrigger;", "trigger", "Lcom/ruslan/growsseth/quests/QuestStageTrigger;", "getTrigger", "()Lcom/ruslan/growsseth/quests/QuestStageTrigger;", "ruins-of-growsseth"})
    @SourceDebugExtension(value={"SMAP\nResearcherQuestComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResearcherQuestComponent.kt\ncom/ruslan/growsseth/entity/researcher/ResearcherQuestComponent$HomeLastDialogueStage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,445:1\n1#2:446\n*E\n"})
    public final class HomeLastDialogueStage
    implements QuestStage<Researcher> {
        @NotNull
        private final QuestStageTrigger<Researcher> trigger;

        public HomeLastDialogueStage() {
            this.trigger = ResearcherQuestComponent.this.commonReloadTrigger;
        }

        @Override
        @NotNull
        public QuestStageTrigger<Researcher> getTrigger() {
            return this.trigger;
        }

        @Override
        public void onActivated(@NotNull Researcher entity) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                entity.setHealed(true);
                class_2338 class_23382 = entity.getStartingPos();
                if (class_23382 != null) {
                    class_2338 it = class_23382;
                    boolean bl = false;
                    entity.method_5725(it, entity.method_36454(), entity.method_36455());
                }
                ResearcherDialoguesComponent researcherDialoguesComponent = entity.getDialogues();
                if (researcherDialoguesComponent == null) break block1;
                researcherDialoguesComponent.resetNearbyPlayers();
            }
        }

        @Override
        public void onStep(@NotNull Researcher entity) {
            QuestStage.DefaultImpls.onStep(this, (class_1309)entity);
        }

        @Override
        public void onUpdate(@NotNull Researcher entity) {
            QuestStage.DefaultImpls.onUpdate(this, (class_1309)entity);
        }

        @Override
        @NotNull
        public TriggerTreeNode getTriggerStatusTree(@NotNull Researcher entity, @NotNull QuestUpdateEvent event) {
            return QuestStage.DefaultImpls.getTriggerStatusTree(this, (class_1309)entity, event);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0019\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001f\u0010\f\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\f\u0010\rR\u0017\u0010\u0004\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0006\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/ruslan/growsseth/entity/researcher/ResearcherQuestComponent$ProgressTradesTrigger;", "Lcom/ruslan/growsseth/quests/QuestStageTrigger;", "Lcom/ruslan/growsseth/entity/researcher/Researcher;", "Lnet/minecraft/server/MinecraftServer;", "server", "", "onlyOne", "<init>", "(Lnet/minecraft/server/MinecraftServer;Z)V", "entity", "Lcom/ruslan/growsseth/quests/QuestUpdateEvent;", "event", "isActive", "(Lcom/ruslan/growsseth/entity/researcher/Researcher;Lcom/ruslan/growsseth/quests/QuestUpdateEvent;)Z", "Lnet/minecraft/server/MinecraftServer;", "getServer", "()Lnet/minecraft/server/MinecraftServer;", "Z", "getOnlyOne", "()Z", "ruins-of-growsseth"})
    private static final class ProgressTradesTrigger
    implements QuestStageTrigger<Researcher> {
        @NotNull
        private final MinecraftServer server;
        private final boolean onlyOne;

        public ProgressTradesTrigger(@NotNull MinecraftServer server, boolean onlyOne) {
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            this.server = server;
            this.onlyOne = onlyOne;
        }

        public /* synthetic */ ProgressTradesTrigger(MinecraftServer minecraftServer, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = false;
            }
            this(minecraftServer, bl);
        }

        @NotNull
        public final MinecraftServer getServer() {
            return this.server;
        }

        public final boolean getOnlyOne() {
            return this.onlyOne;
        }

        @Override
        public boolean isActive(@NotNull Researcher entity, @NotNull QuestUpdateEvent event) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            Intrinsics.checkNotNullParameter((Object)((Object)event), (String)"event");
            AbstractResearcherTradesProvider tradesProvider = ResearcherTradeMode.Companion.providerFromSettings(this.server);
            if (!(tradesProvider instanceof ProgressResearcherTradesProvider)) {
                return false;
            }
            return this.onlyOne ? ((ProgressResearcherTradesProvider)tradesProvider).onlyOneLeft(this.server) : ((ProgressResearcherTradesProvider)tradesProvider).isFinished(this.server);
        }

        @Override
        @NotNull
        public QuestStageTrigger<Researcher> and(@NotNull QuestStageTrigger<Researcher> other) {
            return QuestStageTrigger.DefaultImpls.and(this, other);
        }

        @Override
        @NotNull
        public QuestStageTrigger<Researcher> or(@NotNull QuestStageTrigger<Researcher> other) {
            return QuestStageTrigger.DefaultImpls.or(this, other);
        }

        @Override
        @NotNull
        public QuestStageTrigger<Researcher> andMulti(QuestStageTrigger<Researcher> ... with) {
            return QuestStageTrigger.DefaultImpls.andMulti(this, with);
        }

        @Override
        @NotNull
        public QuestStageTrigger<Researcher> orMulti(QuestStageTrigger<Researcher> ... with) {
            return QuestStageTrigger.DefaultImpls.orMulti(this, with);
        }

        @Override
        @NotNull
        public TriggerTreeNode getActiveTree(@NotNull Researcher entity, @NotNull QuestUpdateEvent event) {
            return QuestStageTrigger.DefaultImpls.getActiveTree(this, (class_1309)entity, event);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0006R\u0014\u0010\b\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0006R\u0014\u0010\n\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\u0006R\u0014\u0010\f\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\f\u0010\u0006\u00a8\u0006\r"}, d2={"Lcom/ruslan/growsseth/entity/researcher/ResearcherQuestComponent$Stages;", "", "<init>", "()V", "", "START", "Ljava/lang/String;", "ZOMBIE", "HEALED", "HEALED_WAIT", "HOME", "HOME_WAIT", "ENDING", "ruins-of-growsseth"})
    public static final class Stages {
        @NotNull
        public static final Stages INSTANCE = new Stages();
        @NotNull
        public static final String START = "start";
        @NotNull
        public static final String ZOMBIE = "zombie";
        @NotNull
        public static final String HEALED = "healed";
        @NotNull
        public static final String HEALED_WAIT = "healed_wait";
        @NotNull
        public static final String HOME = "home";
        @NotNull
        public static final String HOME_WAIT = "home_wait";
        @NotNull
        public static final String ENDING = "ending";

        private Stages() {
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bR \u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\t8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/ruslan/growsseth/entity/researcher/ResearcherQuestComponent$StartStage;", "Lcom/ruslan/growsseth/quests/QuestStage;", "Lcom/ruslan/growsseth/entity/researcher/Researcher;", "<init>", "(Lcom/ruslan/growsseth/entity/researcher/ResearcherQuestComponent;)V", "entity", "", "onActivated", "(Lcom/ruslan/growsseth/entity/researcher/Researcher;)V", "Lcom/ruslan/growsseth/quests/QuestStageTrigger;", "trigger", "Lcom/ruslan/growsseth/quests/QuestStageTrigger;", "getTrigger", "()Lcom/ruslan/growsseth/quests/QuestStageTrigger;", "ruins-of-growsseth"})
    public final class StartStage
    implements QuestStage<Researcher> {
        @NotNull
        private final QuestStageTrigger<Researcher> trigger;

        public StartStage() {
            this.trigger = new ProgressTradesTrigger(ResearcherQuestComponent.this.getServer(), true).or(new ApiEventTrigger(ResearcherQuestComponent.this.finalQuestStartName));
        }

        @Override
        @NotNull
        public QuestStageTrigger<Researcher> getTrigger() {
            return this.trigger;
        }

        @Override
        public void onActivated(@NotNull Researcher entity) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                entity.setHealed(false);
                ResearcherDialoguesComponent researcherDialoguesComponent = entity.getDialogues();
                if (researcherDialoguesComponent == null) break block0;
                researcherDialoguesComponent.resetNearbyPlayers();
            }
        }

        @Override
        public void onStep(@NotNull Researcher entity) {
            QuestStage.DefaultImpls.onStep(this, (class_1309)entity);
        }

        @Override
        public void onUpdate(@NotNull Researcher entity) {
            QuestStage.DefaultImpls.onUpdate(this, (class_1309)entity);
        }

        @Override
        @NotNull
        public TriggerTreeNode getTriggerStatusTree(@NotNull Researcher entity, @NotNull QuestUpdateEvent event) {
            return QuestStage.DefaultImpls.getTriggerStatusTree(this, (class_1309)entity, event);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bR \u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\t8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/ruslan/growsseth/entity/researcher/ResearcherQuestComponent$WaitBeforeLeaveStage;", "Lcom/ruslan/growsseth/quests/QuestStage;", "Lcom/ruslan/growsseth/entity/researcher/Researcher;", "<init>", "()V", "entity", "", "onActivated", "(Lcom/ruslan/growsseth/entity/researcher/Researcher;)V", "Lcom/ruslan/growsseth/quests/DialogueGroupTrigger;", "trigger", "Lcom/ruslan/growsseth/quests/DialogueGroupTrigger;", "getTrigger", "()Lcom/ruslan/growsseth/quests/DialogueGroupTrigger;", "ruins-of-growsseth"})
    public static final class WaitBeforeLeaveStage
    implements QuestStage<Researcher> {
        @NotNull
        private final DialogueGroupTrigger<Researcher> trigger = new DialogueGroupTrigger("group-quest-last-dialogue");

        @Override
        @NotNull
        public DialogueGroupTrigger<Researcher> getTrigger() {
            return this.trigger;
        }

        @Override
        public void onActivated(@NotNull Researcher entity) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            entity.setHealed(true);
        }

        @Override
        public void onStep(@NotNull Researcher entity) {
            QuestStage.DefaultImpls.onStep(this, (class_1309)entity);
        }

        @Override
        public void onUpdate(@NotNull Researcher entity) {
            QuestStage.DefaultImpls.onUpdate(this, (class_1309)entity);
        }

        @Override
        @NotNull
        public TriggerTreeNode getTriggerStatusTree(@NotNull Researcher entity, @NotNull QuestUpdateEvent event) {
            return QuestStage.DefaultImpls.getTriggerStatusTree(this, (class_1309)entity, event);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\t\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\t\u0010\bJ\u001f\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001f\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011R \u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u00128\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/ruslan/growsseth/entity/researcher/ResearcherQuestComponent$ZombieStage;", "Lcom/ruslan/growsseth/quests/QuestStage;", "Lcom/ruslan/growsseth/entity/researcher/Researcher;", "<init>", "(Lcom/ruslan/growsseth/entity/researcher/ResearcherQuestComponent;)V", "entity", "", "onActivated", "(Lcom/ruslan/growsseth/entity/researcher/Researcher;)V", "onUpdate", "Lnet/minecraft/class_1309;", "Lcom/ruslan/growsseth/structure/pieces/ResearcherTent;", "tent", "createDiary", "(Lnet/minecraft/class_1309;Lcom/ruslan/growsseth/structure/pieces/ResearcherTent;)V", "Lnet/minecraft/class_1297;", "moveToJail", "(Lnet/minecraft/class_1297;Lcom/ruslan/growsseth/structure/pieces/ResearcherTent;)V", "Lcom/ruslan/growsseth/quests/QuestStageTrigger;", "trigger", "Lcom/ruslan/growsseth/quests/QuestStageTrigger;", "getTrigger", "()Lcom/ruslan/growsseth/quests/QuestStageTrigger;", "ruins-of-growsseth"})
    public final class ZombieStage
    implements QuestStage<Researcher> {
        @NotNull
        private final QuestStageTrigger<Researcher> trigger;

        public ZombieStage() {
            this.trigger = new ProgressTradesTrigger(ResearcherQuestComponent.this.getServer(), false).or(new ApiEventTrigger(ResearcherQuestComponent.this.finalQuestZombieName));
        }

        @Override
        @NotNull
        public QuestStageTrigger<Researcher> getTrigger() {
            return this.trigger;
        }

        @Override
        public void onActivated(@NotNull Researcher entity) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            entity.setHealed(false);
        }

        @Override
        public void onUpdate(@NotNull Researcher entity) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            EventUtil.INSTANCE.runAtServerTickEnd(arg_0 -> ZombieStage.onUpdate$lambda$2(entity, this, arg_0));
        }

        private final void createDiary(class_1309 entity, ResearcherTent tent) {
            String zombieDiaryTemplate = !playerSkippedQuest ? "quest_zombie" : "quest_zombie_skip";
            class_1799 diary = BookTemplates.createTemplatedBook$default(BookTemplates.INSTANCE, zombieDiaryTemplate, null, null, arg_0 -> ZombieStage.createDiary$lambda$3(entity, arg_0), 6, null);
            if (diary == null) {
                RuinsOfGrowsseth.LOGGER.error("No diary for quest_zombie!", new Object[0]);
                return;
            }
            Ref.ObjectRef lectern = new Ref.ObjectRef();
            Ref.ObjectRef chest = new Ref.ObjectRef();
            class_3341 class_33412 = tent.getCellarBoundingBox();
            if (class_33412 != null) {
                class_3341 class_33413 = class_33412;
                ResearcherQuestComponent researcherQuestComponent = ResearcherQuestComponent.this;
                class_3341 boundingBox = class_33413;
                boolean bl = false;
                UtilsKt.iterBlocks((class_3341)boundingBox, arg_0 -> ZombieStage.createDiary$lambda$6$lambda$5(researcherQuestComponent, lectern, chest, arg_0));
            }
            DiaryHelper.pushDiaryToContainers$default(DiaryHelper.INSTANCE, diary, ResearcherQuestComponent.this.getServerLevel(), entity, (class_3722)lectern.element, (class_2595)chest.element, false, 32, null);
            RuinsOfGrowsseth.LOGGER.info("Placed diary for quest", new Object[0]);
        }

        private final void moveToJail(class_1297 entity, ResearcherTent tent) {
            class_2338 pos = tent.getJailPos();
            if (com.ruslan.growsseth.utils.UtilsKt.notNull(pos)) {
                entity.method_5725(pos, entity.method_36454(), entity.method_36455());
            } else {
                RuinsOfGrowsseth.LOGGER.warn("Tent doesn't have a jail position set!", new Object[0]);
            }
        }

        @Override
        public void onStep(@NotNull Researcher entity) {
            QuestStage.DefaultImpls.onStep(this, (class_1309)entity);
        }

        @Override
        @NotNull
        public TriggerTreeNode getTriggerStatusTree(@NotNull Researcher entity, @NotNull QuestUpdateEvent event) {
            return QuestStage.DefaultImpls.getTriggerStatusTree(this, (class_1309)entity, event);
        }

        private static final Unit onUpdate$lambda$2$lambda$1(class_3218 $level, class_2338 $resStartingPos, Researcher $entity, ZombieStage this$0, ZombieResearcher $zombie, MinecraftServer minecraftServer) {
            ResearcherTent tent2;
            Intrinsics.checkNotNullParameter((Object)minecraftServer, (String)"<unused var>");
            Intrinsics.checkNotNull((Object)$resStartingPos);
            class_3449 tentStart2 = Researcher.Companion.findTent$default(Researcher.Companion, $level, $resStartingPos, null, 4, null);
            Object object = tentStart2;
            ResearcherTent researcherTent = tent2 = (ResearcherTent)(object != null && (object = object.method_14963()) != null ? (class_3443)object.get(0) : null);
            if (researcherTent != null) {
                ResearcherTent it = researcherTent;
                boolean bl = false;
                class_1937 class_19372 = $entity.method_37908();
                Intrinsics.checkNotNull((Object)class_19372, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                ResearcherTent.remove$default(it, (class_3218)class_19372, GrowssethTags.INSTANCE.getTENT_CLEAR_ZOMBIE_STAGE_WHITELIST(), false, 4, null);
                this$0.moveToJail((class_1297)$zombie, it);
                this$0.createDiary((class_1309)$zombie, it);
                RuinsOfGrowsseth.LOGGER.info("Success in moving at end of server tick", new Object[0]);
            } else {
                RuinsOfGrowsseth.LOGGER.warn("Cannot find tent to move zombie researcher to!", new Object[0]);
            }
            return Unit.INSTANCE;
        }

        private static final Unit onUpdate$lambda$2(Researcher $entity, ZombieStage this$0, MinecraftServer minecraftServer) {
            Intrinsics.checkNotNullParameter((Object)minecraftServer, (String)"<unused var>");
            Object object = $entity.getDialogues();
            boolean bl = object != null && (object = ((BasicDialoguesComponent)object).getTriggeredDialogues()) != null ? object.isEmpty() : false;
            if (bl) {
                playerSkippedQuest = true;
            }
            ResearcherTent tent = $entity.getTent();
            class_243 startingPos = $entity.method_19538();
            ResearcherDialoguesComponent researcherDialoguesComponent = $entity.getDialogues();
            if (researcherDialoguesComponent != null) {
                researcherDialoguesComponent.resetNearbyPlayers();
            }
            class_2487 data = $entity.saveResearcherData();
            boolean scheduleMoveRemoveLater = false;
            if (tent != null) {
                this$0.moveToJail((class_1297)$entity, tent);
                this$0.createDiary((class_1309)$entity, tent);
                class_1937 class_19372 = $entity.method_37908();
                Intrinsics.checkNotNull((Object)class_19372, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                ResearcherTent.remove$default(tent, (class_3218)class_19372, GrowssethTags.INSTANCE.getTENT_CLEAR_ZOMBIE_STAGE_WHITELIST(), false, 4, null);
            } else {
                scheduleMoveRemoveLater = true;
            }
            class_1937 class_19373 = $entity.method_37908();
            Intrinsics.checkNotNull((Object)class_19373, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            class_3218 level = (class_3218)class_19373;
            class_2338 class_23382 = $entity.getStartingPos();
            if (class_23382 == null) {
                class_23382 = $entity.method_24515();
            }
            class_2338 resStartingPos = class_23382;
            long spawnTime = $entity.getSpawnTime();
            ZombieResearcher zombie = (ZombieResearcher)$entity.method_29243(GrowssethEntities.INSTANCE.getZOMBIE_RESEARCHER(), false);
            if (com.ruslan.growsseth.utils.UtilsKt.isNull(zombie)) {
                RuinsOfGrowsseth.LOGGER.error("Couldn't zombify researcher in quest stage!", new Object[0]);
                $entity.method_29495(startingPos);
                return Unit.INSTANCE;
            }
            zombie.setResearcherData(data);
            zombie.setLastWorldDataTime($entity.getLastWorldDataTime());
            zombie.setSpawnTime(spawnTime);
            zombie.setResearcherOriginalPos(resStartingPos);
            zombie.method_7195(zombie.method_7231().method_16921(class_3852.field_17054).method_16920(5));
            Object[] objectArray = new Object[]{zombie};
            RuinsOfGrowsseth.LOGGER.info("Spawned researcher zombie {} from quest stage", objectArray);
            $entity.method_31472();
            if (scheduleMoveRemoveLater) {
                RuinsOfGrowsseth.LOGGER.info("Couldn't find tent, trying again at end of server tick...", new Object[0]);
                EventUtil.INSTANCE.runAtServerTickEnd(arg_0 -> ZombieStage.onUpdate$lambda$2$lambda$1(level, resStartingPos, $entity, this$0, zombie, arg_0));
            }
            return Unit.INSTANCE;
        }

        private static final BookData createDiary$lambda$3(class_1309 $entity, BookData $this$createTemplatedBook) {
            Intrinsics.checkNotNullParameter((Object)$this$createTemplatedBook, (String)"$this$createTemplatedBook");
            String string = $entity.method_5477().getString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            return $this$createTemplatedBook.withAuthor(string);
        }

        private static final Unit createDiary$lambda$6$lambda$5(ResearcherQuestComponent this$0, Ref.ObjectRef $lectern, Ref.ObjectRef $chest, class_2338 pos) {
            boolean found;
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            class_2586 class_25862 = this$0.getServerLevel().method_8321(pos);
            if (class_25862 != null) {
                class_2586 it = class_25862;
                boolean bl = false;
                if (it instanceof class_3722) {
                    $lectern.element = it;
                }
                if (it instanceof class_2595) {
                    $chest.element = it;
                }
                v1 = $chest.element != null && $lectern.element != null;
            } else {
                v1 = found = false;
            }
            if (found) {
                return Unit.INSTANCE;
            }
            return Unit.INSTANCE;
        }
    }
}

